MONITO ; #######################################################
 ; MINIATURE MACHINE-LANGUAGE MONITOR DISPLAYING HEX/ASCII
 ; #######################################################
 ;
 READY	EQU	06CCH		; RETURN TO READY INTACT
 BYTE	EQU	1D78H		; ROM READ KEY & TOKENIZE
 SYNERR	EQU	1997H		; ENTRY POINT TO SN ERROR
 ;
 ; #######################################################
 ; GET REST OF DATA AND CONVERT
 ; #######################################################
 ;
 OPENER	CALL	BYTE		; NEXT CHARACTER IN LINE
 	CP	22H		; IS IT A QUOTE MARK?
 	JP	NZ,SYNERR	; OUT TO ERROR IF NOT
 	PUSH	HL		; SAVE LINE POINTER
 	POP	IY		; STASH POINTER IN IY
 	CALL	XX99		; CONVERT CHARS TO HEX
 	CALL	01C9H		; CLEAR SCREEN (ROM CALL)
 	JR	NEXT99		; JUMP PAST SUBROUTINES
 ;
 ; #######################################################
 ; GET 16 SCREEN POSITIONS READY (10H)
 ; #######################################################
 ;
 CONTNT	LD	A,D		; GET ADDRESS LOW BYTE
 	LD	HL,3C40H	; GET SECOND SCREEN LINE
 	AND	0F0H		; MASK OUT LOW BITS
 	CALL	RRRRS		; ROTATE/DISPLAY ROUTINE
 	LD	A,D		; GET ADDRESS LOW BYTE
 	AND	0FH		; MASK OUT HIGH BITS
 	CALL	HEXASC		; CONVERT WORKS TO ASCII
 	LD	(HL),A		; DISPLAY THE CHARACTER
 	INC	HL		; NEXT SCREEN POSITION
 	LD	A,E		; GET HIGH BYTE
 	AND	0F0H		; MASK OUT LOW BITS
 	CALL	RRRRS		; ROTATE/DISPLAY ROUTINE
 	LD	A,E		; GET HIGH BYTE AGAIN
 	AND	0FH		; MASK OUT LOW BITS
 	CALL	HEXASC		; CONVERT HEX TO ASCII
 	LD	(HL),A		; DISPLAY THE CHARACTER
 	LD	HL,3C80H	; GET NEXT SCREEN ROW
 	LD	B,10H		; GET 16 VALUE INTO B
 ;
 ; #######################################################
 ; DISPLAY CONTENTS OF ADDRESS CHOSEN
 ; #######################################################
 ;
 CONT02	LD	A,(DE)		; GET VALUE AT ADDRESS
 	AND	0F0H		; MASK OUT HIGH BITS
 	CALL	RRRRS		; CONVERT/DISPLAY ROUTINE
 	LD	A,(DE)		; GET VALUE AT ADDRESS
 	AND	0FH		; MASK OUT LOW BITS
 	CALL	HEXASC		; CONVERT CHAR TO ASCII
 	LD	(HL),A		; DISPLAY THE CHARACTER
 	INC	HL		; GET NEXT SCREEN POSN.
 	INC	HL		; GO ONE PLACE MORE
 	INC	DE		; GET NEXT ADDRESS LOCN.
 	DJNZ	CONT02		; FULL 16 BYTES DISPLAYED
 ;
 ; #######################################################
 ; DISPLAY ASCII VALUES TOO
 ; #######################################################
 ;
 	LD	B,10H		; GET 16 TIMES IN B REG.
 	LD	C,B		; SAVE IT IN C FOR USE
 	DEC	DE		; GET NEXT LOWEST ADDRESS
 	DJNZ	$-1		; DECREMENT BACK TO START
 	LD	B,C		; GET 16 TIMES IN B AGAIN
 	LD	HL,3CC0H	; GET NEXT LINE OF SCREEN
 BBBA	LD	A,(DE)		; GET CONTENTS OF ADDRESS
 	LD	(HL),A		; DISPLAY EXACTLY AS IS
 	INC	HL		; GET NEXT SCREEN LOCN.
 	INC	HL		; GET NEXT AFTER THAT
 	INC	HL		; VISUALLY MATCHES HEX
 	INC	DE		; GET NEXT ADDRESS TO SEE
 	DJNZ	BBBA		; DO IT FOR 16 ADDRESSES
 	LD	B,C		; GET 16 INTO B AGAIN
 	DEC	DE		; GO BACK TO PREVIOUS
 	DJNZ	$-1		; AND BACK TO BEGINNING
 	RET			; DONE WITH DISPLAY ROUT.
 ;
 ; #######################################################
 ; SCAN KEYBOARD FOR EDIT SEQUENCE
 ; #######################################################
 ;
 NEXT99	CALL	CONTNT		; FIND WHICH KEYS PRESSED
 ;
 ; #######################################################
 ; SCAN KEYBOARD FOR BREAK, ARROWS
 ; #######################################################
 ;
 EDITOR	LD	A,(3840H)	; GET BREAK, ARROWS ROW
 	CP	4		; IS IT BREAK KEY?
 	JR	NZ,ARROW	; IF NOT TEST FOR ARROW
 	PUSH	IY		; ELSE RETRIEVE LINE PTR.
 	POP	HL		; SWITCH BACK INTO HL
 	JP	READY		; BACK TO BASIC READY
 ARROW	CP	10H		; BEGIN ARROW COMPARES
 	JR	NZ,AAAA		; GO IF NOT DOWN ARROW
 	LD	B,10H		; GET B READY WITH 16
 	DEC	DE		; GO BACK IN MEMORY
 	DJNZ	$-1		; DO IT FOR 16 TIMES
 	JR	STNDRD		; DONE NOW; GO OUT
 AAAA	CP	8		; CHECK IF UP ARROW
 	JR	NZ,AAAB		; GO OUT IF NOT UP ARROW
 	LD	B,10H		; GET 16 PLACES READY
 	INC	DE		; GET NEXT MEMORY LOCN.
 	DJNZ	$-1		; DO IT 16 TIMES IN ALL
 	JR	STNDRD		; DONE NOW; GO OUT
 AAAB	CP	20H		; CHECK IF LEFT ARROW
 	JR	NZ,AAAC		; GO OUT IF NOT LEFT
 	DEC	DE		; GET PREVIOUS MEM. LOCN.
 	JR	STNDRD		; DONE NOW; GO OUT
 AAAC	CP	40H		; CHECK IF RIGHT ARROW
 	JR	NZ,AAAD		; GO OUT IF NOT RIGHT
 	INC	DE		; GET NEXT MEMORY LOCN.
 	JR	STNDRD		; DONE NOW; GO OUT
 ;
 ; #######################################################
 ; GET FIFTH LINE OF SCREEN AND DISPLAY CHOSEN EDITING
 ; #######################################################
 ;
 AAAD	LD	HL,3D00H	; FIFTH LINE ON SCREEN
 	LD	(HL),5FH	; GET CURSOR CHARACTER
 	INC	HL		; NEXT SCREEN LOCATION
 	LD	(HL),5FH	; GET CURSOR CHARACTER
 	DEC	HL		; BACK TO FIRST LOCN.
 	LD	B,2		; GET 2 TRIES INTO B
 AAAE	PUSH	DE		; SAVE MEMORY LOCATION
 	PUSH	HL		; SAVE SCREEN LOCATION
 	CALL	0049H		; BASIC'S KEYBOARD SCAN
 	POP	HL		; RESTORE SCREEN LOCN.
 	POP	DE		; RESTORE MEMORY LOCN.
 	CP	47H		; CHECK IF ALPHA HEX
 	JR	NC,EDITOR	; GO OUT IF NOT ALPHA HEX
 	CP	30H		; CHECK IF NUMERIC HEX
 	JR	C,EDITOR	; OUT IF NOT NUMERIC HEX
 	CP	3AH		; CHECK IF OV NUMERIC
 	JR	C,AAAF		; CHECK NEXT IF IN RANGE
 	CP	40H		; CHECK IF OV ALPHAHEX
 	JR	C,EDITOR	; OUT IF OV ALPHA HEX
 AAAF	LD	(HL),A		; PLACE CHAR ON SCREEN
 	INC	HL		; GET NEXT SCREEN LOCN.
 	DJNZ	AAAE		; GO GET ANOTHER CHAR.
 ;
 ; #######################################################
 ; CONVERT CHOSEN DATA TO HEX
 ; #######################################################
 ;
 	DEC	HL		; GET RIGHT ASCII CHAR.
 	CALL	ASCHEX		; CONVERT ASCII TO HEX
 	LD	C,A		; SAVE VALUE IN C REG.
 	DEC	HL		; GET EARLIER ASCII CHAR.
 	CALL	LLLLS		; CALL LEFT ROTATE ROUT.
 	ADD	A,C		; ADD TO VALUE IN C REG.
 ;
 ; #######################################################
 ; PUT NEW BYTE IN PLACE
 ; #######################################################
 ;
 	LD	(DE),A		; PLACE BYTE INTO MEMORY
 	INC	DE		; GET NEXT MEM. LOCATION
 ;
 ; #######################################################
 ; DISPLAY REVISED LINE OF DATA
 ; #######################################################
 ;
 STNDRD	CALL	CONTNT		; GET SCREEN RE-DISPLAYED
 	CALL	DELAY		; SLIGHT DELAY IN ACTION
 	JR	EDITOR		; BACK TO MAIN MEM. EDIT.
 ;
 ; #######################################################
 ; ASCII TO HEXADECIMAL CONVERSION
 ; #######################################################
 ;
 ASCHEX	LD	A,(HL)		; GET VALUE HL POINTS TO
 	CP	40H		; CHECK IF ALPHABETIC
 	JR	NC,NEXT98	; GO OUT IF ALPHABETIC
 	SUB	30H		; ELSE NUMERIC - CONVERT
 	RET			; BACK TO CALLING ROUTINE
 NEXT98	SUB	37H		; ALPHABETIC - CONVERT
 	RET			; BACK TO CALLING ROUTINE
 ;
 ; #######################################################
 ; HEXADECIMAL TO ASCII CONVERSION
 ; #######################################################
 ;
 HEXASC	CP	0AH		; CHECK AGAINST 10 DEC.
 	JR	NC,NEXT96	; IF >10, OUT TO CONVERT
 	ADD	A,30H		; ELSE CONVERT TO NUMERIC
 	RET			; BACK TO CALLING ROUT.
 NEXT96	ADD	A,37H		; ALPHABETIC CONVERSION
 	RET			; BACK TO CALLING ROUT.
 ;
 ; #######################################################
 ; RIGHT ROTATES FOR CONVERSIONS
 ; #######################################################
 ;
 RRRRS	RRCA			; ROTATE NYBBLE TO RIGHT
 	RRCA			; ...AND TO RIGHT AGAIN
 	RRCA			; ...AND TO RIGHT AGAIN
 	RRCA			; ...AND TO RIGHT AT LAST
 	CALL	HEXASC		; GET HEX-ASCII CONV'S'N
 	LD	(HL),A		; SAVE BYTE IN HL REG.
 	INC	HL		; POINT TO NEXT BYTE
 	RET			; BACK TO CALLING SUBR.
 ;
 ; #######################################################
 ; LEFT ROTATES FOR CONVERSION
 ; #######################################################
 ;
 LLLLS	CALL	ASCHEX		; GET ASCII-HEX CONV'S'N
 	RLCA			; ROTATE NYBBLE ONCE LEFT
 	RLCA			; ...AND ONCE LEFT AGAIN
 	RLCA			; ...AND ONCE LEFT AGAIN
 	RLCA			; ...AND LAST OF ALL LEFT
 	RET			; BACK TO CALLING SUBR.
 ;
 ; #######################################################
 ; DELAY FOR SCREEN DISPLAYS
 ; #######################################################
 ;
 DELAY	LD	BC,2000H	; DELAY VALUE IN BC REG.
 	CALL	0060H		; ROM 14.68-MS DELAY
 	RET			; BACK TO CALLING ROUT.
 ;
 ; #######################################################
 ; GET/CONVERT ASCII FROM BUFFER TO HEXADECIMAL ADDRESS
 ; #######################################################
 ;
 XX99	LD	B,4		; FOUR CHARS. IN ADDRESS
 SSSS	CALL	BYTE		; ROM READ KEY & TOKENIZE
 	PUSH	AF		; SAVE VALUE IN AF REG.
 	DJNZ	SSSS		; AND DO IT FOR 4 CHARS.
 	POP	AF		; RESTORE VALUE TO REG.
 	LD	(HL),A		; VALUE INTO MEMORY
 	CALL	ASCHEX		; CONVERT ASCII TO HEX
 	LD	E,A		; SAVE HEX VALUE IN E
 	POP	AF		; GET NEXT VALUE BACK
 	LD	(HL),A		; VALUE INTO MEMORY
 	CALL	LLLLS		; LEFT ROTATE NYBBLE
 	ADD	A,E		; E HI-BYTE + E LO-BYTE
 	LD	E,A		; SAVE TOTAL IN E REG.
 	POP	AF		; NEXT VALUE BACK TO AF
 	LD	(HL),A		; VALUE INTO MEMORY
 	CALL	ASCHEX		; ASCII TO HEX CONV'S'N
 	LD	D,A		; SAVE VALUE IN D REG.
 	POP	AF		; LAST VALUE BACK TO AF
 	LD	(HL),A		; VALUE INTO MEMORY
 	CALL	LLLLS		; LEFT ROTATE NYBBLE
 	ADD	A,D		; D HI-BYTE + D LO-BYTE
 	LD	D,A		; SAVE VALUE IN D REG.
 	RET			; COMPLETE - RETURN
 ;
 ; #######################################################
 	END	READY
