DDDD   ; LPRINT WHILE 'A' REGISTER INPUTS TO SIMULATED FIFO
 	ORG	7D00H		;=32000 DECIMAL
 	CALL	01C9H		;CLS
 PRINT	DEFB	0		;LPRINT SIGNPOST 1=LPRINT
 CARRET	DEFB	0		;LPRINT CHAR/LINE COUNTER
 LINES	DEFB	0		;VIDEO LINES/PAGE COUNTER
 	LD	IY,15360	;VIDEO LOCATION COUNTER
 KYBD	CALL	002BH		;KEYBOARD SCAN ROUTINE
 	CP	25		;SUBTRACT 25=RIGHT ARROW
 	JR	Z,SET		;GOTO SET IF ZERO
 	CP	24		;SUBTRACT 24=LEFT ARROW
 	JR	Z,RESET		;GOTO RESET IF ZERO
 	CP	0		;0 = NO KYBD CHARACTER
 	JR	NZ,VIDEO	;GOTO VIDEO IF CHARACTER
 	LD	A,(PRINT)	;+1 = LPRINT OUTPUT
 	CP	1		;SUBTRACT 1
 	JR	Z,READY		;GOTO READY IF ZERO
 	JR	KYBD		;RETURN TO KEYBOARD
 VIDEO	CALL	033H		;OUTPUT 'A' TO VIDEO
 	JR	KYBD		;RETURN TO KEYBOARD
 SET	LD	A,1		;+1 TO 'A' REGISTER
 	LD	(PRINT),A	;LOAD LPRINT SIGNPOST
 READY	LD	A,(37E8H)	;LPRINT HANDSHAKE MEM
 	CP	63		;SUBTRACT 63
 	JR	NZ,KYBD		;GOTO KYBD IF NOT READY
 	LD	A,(IY)		;NEXT VIDEO CHARACTER
 	CALL	003BH		;LPRINT CHARACTER IN 'A'
 	INC	IY		;+1 TO VIDEO LOCATION
 	LD	A,(CARRET)	;LPRINT CHAR. COUNTER
 	INC	A		;+1 TO CHARACTER COUNTER
 	CP	64		;SUBTRACT 64
 	JR	Z,RETURN	;GOTO RETURN IF 64 CHARS.
 	LD	(CARRET),A	;STASH CHAR/LINE IN MEM
 	JR	KYBD		;RETURN TO KEYBOARD
 RESET	LD	A,0		;0 TO 'A' REGISTER
 	LD	(PRINT),A	;TO 'STOP' LPRINT
 	JR	KYBD		;RETURN TO KEYBOARD
 RETURN	LD	A,0		;ZERO TO 'A' REGISTER
 	LD	(CARRET),A	;RESET CHAR/LINE COUNTER
 	LD	A,(37E8H)	;LPRINT STATUS LOCATION
 	CP	63		;63 = LP READY HANDSHAKE
 	JR	NZ,RETURN	;TO RETURN IF NOT READY
 	LD	A,0DH		;0DH = CARRIAGE RETURN
 	CALL	003BH		;LP DRIVER MEM - DO IT
 	LD	A,(LINES)	;NUMBER LINES LPRINTED
 	INC	A		;ADD 1 TO 'A' REGISTER
 	CP	16		;SUBTRACT 16
 	JR	Z,CLS		;GOTO CLS IF ZERO
 	LD	(LINES),A	;UPDATE LINE COUNTER
 	JR	KYBD		;RETURN TO KEYBOARD
 CLS	LD	IY,15360	;RESET VIDEO MEM COUNTER
 	LD	A,0		;ZERO TO 'A' REGISTER
 	LD	(LINES),A	;RESET LINE COUNTER
 	LD	(PRINT),A	;TURN OFF LPRINTER
 	CALL	01C9H		;CLS FOR NEW PAGE VIDEO
 	JR	KYBD		;RETURN TO KYBD
 	END	7D00H		;EL FIN = EL BEGUINE
