;LPTODSK <Route LP output to Disk File>	v. 1.0-840524
	TITLE	'<LPTODSK v. 1.0>'
	SUBTTL	'<Route printer data stream to disk file>'
;Idea and most code from Northern Bytes v. 5 #1 pgs. 4-6.
;For use on TRS80 Mods 1 or 3 with NEWDOS80.  The cmds:
;		*PD
;		*PR
;are patched into NEWDOS cmd chain when LPTODSK is
;executed at start-up of session.  After that, any output
;destined for LP (thru std DCB) may be routed to a Disk
;File named "filespec" if desired.
;
;LPTODSK also illustrates method for dynamically adding
;extra DOS cmds to NEWDOS v 2.0 via the "NAME" rtn.
;The new cmds are available from DOS, MINIDOS, and, in
;BASIC, via the statement CMD "*PD filespec", etc.
;
;When ready to initiate- <DFG> to get to MINI-DOS.  In
;MINI-DOS, *PD filespec <ENTER>.  Then MDRET.
;At conclusion of Disk Write, <DFG>. Then *PR <ENTER>.
;Then MDRET to conclude loop. "Filespec" is now CLOSEd.
;Don't forget to CLOSE. It's vital!
;LPTODSK stays active in backrground during session.
;
	PAGE	OFF
;Equates:
B2DISK	EQU	001BH	;Send byte to disk ROM rtn.
CLOSE	EQU	4428H	;DOS CLOSE a file rtn.
DOS	EQU	402DH	;DOS no error exit.
DOSERR	EQU	4409H	;DOR ERROR exit.
HIMEM1	EQU	4049H	;Pgm self mods if Mod 3.
HIMEM3	EQU	4411H	;Mod3 HIMEM.
LPVECT	EQU	4026H	;Line Printer Driver Vector.
MSGRTN	EQU	4467H	;Display a mesg & return.
NAME	EQU	4461H	;NEWDOS v 2.0 "NAME" rtn addrss.
OPEN	EQU	4420H	;DOS OPEN a file rtn.
XFILES	EQU	441CH	;DOS extract a filespec rtn.
;
;Initialization & Relocation segment begins:
	ORG	7000H	;Nothing sacred about this ORG.
	COM	'<LPTODSK v. 1.0-840524 by VK2JK>'
INTLZE	LD	A,(54H)	;Is machine Mod1 or Mod3?
	DEC	A	;Now A=0 if Mod1.
	JR	Z,RELOC	;Branch if Mod1-
	LD	HL,HIMEM3;- else modify HIMEM for Mod3.
	LD	(GETMEM+2),HL
	LD	(STRMEM+1),HL
RELOC	LD	IL,END	;End of Unrelocatdd pgm.
GETMEM	LD	DE,(HIMEM1)	;Mod1 HIMEM (self mods).
	LD	BC,END-OFFSET+1	;LEN of main pgm.
	LDDR
	PUSH	DE
	INC	DE	;DE= Start relocated pgm.
	LD	HL,TABLE;:::> Start of Reloc Table.
NXTLOC	LD	A,(HL)	;Get 1st addrss byte-
	LD	B,A	;-& put in B.
	INC	HL	;:::> 2d addrss byte.
	OR	(HL)	;Do both bytes = 0?
	JR	NZ,REPLCE	;JP if no.
	PUSH	DE
	EX	DE,HL	;Put *PR entry adrss in HL.
	CALL	NAME	;NEWDOS80 *NAME rtn.
	JR	NZ,ERR	;If error, jp to Error Exit.
	POP	DE	;Restore entry addrss.
	LD	HL,PD-OFFSET	;Offset for *PD rtn.
	ADD	HL,DE	;HL= *PD entry addrss.
	CALL	NAME	;NEWDOS80 *NAME rtn.
	POP	HL	;Restore New Mem Size.
ERR	JP	NZ,DOSERR;Display any DOS error.
STRMEM	LD	(HIMEM1),HL	;Set new HIMEM.
	JP	DOS	;DOS No Error exit.
REPLCE	PUSH	HL	;Save Reloc Table ptr.
	LD	H,(HL)	;H= MSB of addrss from table.
	LD	L,B	;L= LSB of addrss from table.
	ADD	HL,DE	;Get addrss of label.
	LD	C,(HL)	;Get byte displacement-
	INC	HL	;-from pgm and-
	LD	B,(HL)	;-put in BC.
	DEC	HL	;HL= addrss of label.
	PUSH	DE	;Save new START addrss.
	EX	DE,HL	;HL = new START addrss.
	ADD	HL,BC	;HL = new addrss for label.
	EX	DE,HL
	LD	(HL),E	;New addrss calculated-
	INC	HL	;-so write it into-
	LD	(HL),D	;-label (addrss field).
	POP	DE	;Restore new START addrss.
	POP	HL	;Restore reloc table ptr.
	INC	HL	;Bump table ptr.
	JR	NXTLOC	;Process nxt table entry.
	PAGE	OFF
;
;		RELOCATION TABLE
;	Must be located before START label of Main pgm.
;
TABLE	DW	RELO1+1-OFFSET
	DW	RELO2+1-OFFSET
	DW	RELO3+1-OFFSET
	DW	RELO4+1-OFFSET
	DW	RELO5+1-OFFSET
	DW	RELO6+1-OFFSET
	DW	RELO7+1-OFFSET
	DW	RELO8+1-OFFSET
	DW	RELO9+1-OFFSET
	DW	RELO10+1-OFFSET
	DW	OUTBYT+1-OFFSET
	DW	0
;
;	MAIN PGM (to be relocated) begins:
OFFSET EQU	$
;*PR (Restore printer output to printer)
	DC	4,0	;4 byts needed by DOS.
	DB	'PR      '	;8-byt rtn name.
RELO1	LD	A,(FLAG-OFFSET) ;Is file open?
	OR	A		;NZ= Yes
	LD	A,26H	;"File Not Open" error.
	JR	Z,ERROR
RELO2	LD	DE,FCB-OFFSET	;Put DE @ DCB.
	CALL	CLOSE	;CLOSE the file.
	JR	NZ,ERROR
RELO3	LD	HL,(PDVR-OFFSET);Get orig DCB addrss.
	JR	CONT	;Store DCB and Flag.
;
;*PD filespec (Route printer output to disk file)
PD	DC	4,0	;4 byts needed by DOS.
	DB	'PD      '	;8-byt rtn name.
	EX	DE,HL	;Save filename ptr.
RELO4	LD	HL,MSG-OFFSET	;:::> msg.
RELO5	LD	A,(FLAG-OFFSET)	;Is file open?
	OR	A	;NZ= Yes.
	JP	NZ,MSGRTN;Display msg & return.
	EX	DE,HL	;Restore filename ptr.
RELO6	LD	DE,FCB-OFFSET	;Put DE @ DCB.
	CALL	XFILES	;Extract a filespec.
	JR	NZ,ERROR;Display any error.
RELO7	LD	HL,BUFFER-OFFSET	;HL:::> Buffer.
	LD	B,A	;LRL=256.
	CALL	OPEN	;OPEN.
	JR	NZ,ERROR;Display any error.
	DEC	A	;Now A= FF.
	LD	HL,(LPVECT)	;Get current DCB value &-
RELO8	LD	(PDVR-OFFSET),HL;-store it for CLOSE.
RELO9	LD	HL,OUTBYT-OFFSET;Get Output rtn addrss.
CONT	LD	(LPVECT),HL	;Put in Printer Driver.
RELO10	LD	(FLAG-OFFSET),A	;Flag file is open.
	JP	DOS	;DOS No Error exit.
OUTBYT	LD	DE,FCB-OFFSET	;DE:::> DCB
	LD	A,C		;Get byt to output.
	CALL	B2DISK		;Send byt to disk
	RET	Z	;If no error.
ERROR	JP	DOSERR	;DOS Error exit.
MSG	DB	'*PD File already open'
	DB	0DH
	PAGE	OFF
;Following locations used by both *PD and *PR rtns.
FLAG	DB	0	;File Opened/Closed Flag.
PDVR	DS	2	;Printer Driver addrss storage.
FCB	DS	32	;File Control Block.
BUFFER	DS	100H	;Output buffer.
END	EQU	$-1	;Used by relocator.
	END	INTLZE
                                                        