SPRUSR 	ORG	32001	;STARTING ADDRESS = 7D01H
 STROUT	EQU	28A7H	;ROM STRING-OUT ROUTINE
 GETVAL	EQU	0A7FH	;ROM GET-USR PARAM. VALUE ROUT.
 VARPTR	EQU	260DH	;ROM VARPTR ROUTINE
 COUT	EQU	033AH	;ROM CHARACTER-OUT ROUT.
 RETURN	EQU	0A9AH	;RETURN VALUE ROUTINE
 ;
 ;PROGRAM STARTS HERE
 ;
 START	CALL	GETVAL		;GET PARAMETER VALUE
 	LD	A,H		;CHECK FOR 0 IN HIGH BYTE
 	CP	0
 	JR	NZ,ERR		;IF NOT, ERROR
 	LD	A,L		;FIND DESIRED ROUTINE
 	CP	1		;L=1?
 	JR	Z,ROUT1		;IF YES, EXEC. ROUTINE 1
 	CP	2		;L=2?
 	JR	Z,ROUT2		;IF YES, ROUTINE 2
 	CP	3		;L=3?
 	JR	Z,ROUT3		;IF YES, ROUTINE 3
 	CP	4		;L=4?
 	JR	Z,ROUT4		;IF YES, ROUTINE 4
 	CP	5		;L=5?
 	JR	Z,ROUT5		;IF YES, ROUTINE 5
 ERR	LD	HL,ERRMSG	;IF NONE, PRINT ERR MESSG
 	JR	PRTRET		; AND RETURN
 ROUT1	LD	HL,MSG1		;PRINT MESSG FOR ROUTINE
 	JR	PRTRET
 ROUT2	LD	HL,MSG2
 	JR	PRTRET
 ROUT3	LD	HL,MSG3
 	JR	PRTRET
 ROUT4	LD	HL,MSG4
 PRTRET	PUSH	HL		;SAVE HL VALUES
 	LD	A,0DH		;SEND A RETURN
 	CALL	COUT
 	POP	HL		;RESTORE HL VALUES
 	CALL	STROUT		;PRINT STRING
 	LD	A,0DH		;SEND ANOTHER RETURN
 	CALL	COUT
 	JP	RETURN		;RETURN TO BASIC
 ROUT5	LD	HL,MSG5		;PRINT MESSAGE 5
 	CALL	STROUT
 	LD	HL,VARBLE	;PUT VAR. NAME ADDR IN HL
 	CALL	VARPTR		;GET DESCRIPT BLOCK IN DE
 ;
 ;PREPARE TO PRINT VALUE OF XX$
 ;
 	EX	DE,HL		;PLACE PTR VALUE IN HL
 	LD	B,(HL)		;USE B REG AS CHAR CNTR
 	INC	HL		;PT TO LOW ADDR. BYTE
 	LD	E,(HL)		;GET LOW ADDR. BYTE
 	INC	HL
 	LD	D,(HL)		;GET HIGH ADDR. BYTE
 	EX	DE,HL		;PT. TO STRING W/ HL
 	LD	A,0		;CHECK FOR 0 LENGTH STR
 	CP	B
 	JR	Z,DUN		;IF YES, DONE W/ PRINT
 LOOP	LD	A,(HL)		;GET CHARACTER
 	PUSH	HL		;SAVE HL PTR
 	PUSH	BC		;SAVE B CNTR
 	CALL	COUT		;PRINT CHARACTER
 	POP	BC		;RESTORE VALUES
 	POP	HL
 	INC	HL		;PT. TO NEXT CHAR.
 	DJNZ	LOOP		;LOOP UNTIL B=0
 DUN	LD	A,0DH		;SEND RETURN
 	CALL	COUT
 	JP	RETURN		;RETURN TO BASIC
 ;
 ;THESE ARE THE CONSTANTS AND MESSAGES
 ;
 ERRMSG	DEFM	'**** IMPROPER CODE ****'
 	DEFB	0
 MSG1	DEFM	'**** THIS IS ROUTINE 1 ****'
 	DEFB	0
 MSG2	DEFM	'**** THIS IS ROUTINE 2 ****'
 	DEFB	0
 MSG3	DEFM	'**** THIS IS ROUTINE 3 ****'
 	DEFB	0
 MSG4	DEFM	'**** THIS IS ROUTINE 4 ****'
 	DEFB	0
 MSG5	DEFB	0DH		;CARRIAGE RETURN
 	DEFM	'THE VARIABLE XX$ CONTAINS: '
 	DEFB	0DH
 	DEFB	0
 VARBLE	DEFM	'XX$'
 	DEFB	0
 	END
