MANNY2 ;  Keyboard line input routine by Kim Watt
 ;
 ;ENTRY:	HL => input string buffer of sufficient size
 ;	B  =  maximum characters allowed to be input
 ;	(CURSOR) = video address to begin input
 ;	flashing cursor input prompt
 ;	automatic lower case recognition each character
 ;	linefeed not performed when enter pressed
 ;	tabs and linefeeds not recognized
 ;	left arrow backspaces input
 ;	SH left arrow restarts input line
 ;	no outside display driver is used
 ;	outside key scan is used
 ;EXIT:	HL => input string buffer start
 ;	DE =  unchanged
 ;	B  =  actual input length
 ;	C  =  max length as specified in B on entry
 ;	A  =  first character that was input
 ;	Z  =  no characters were entered, A = 0D
 ;	NZ =  some characters were input
 ;
 STRING	DEFS	64		;internal buffer
 CURSOR	EQU	4020H		;current cursor position
 KEY	EQU	2BH		;keyboard scan routine
 ;  Use KEY routine from article last month
 ;	for repeating keyboard, and upper/lower case
 ;	or you may use the ROM key scan at 2BH
 ;
 ;  Call GET1 to use internal buffer & 63 char input
 ;  Call GET2 to use internal buffer & supply length in B
 ;  Call GET3 to supply HL buffer, and length B
 ;
 GET1	LD	B,63		;default max length
 GET2	LD	HL,STRING	;internal buffer
 GET3	LD	C,B		;c=requested length
 	PUSH	HL		;save start of string
 	PUSH	DE		;save this
 	EX	DE,HL		;DE => buffer
 	LD	HL,(CURSOR)	;get cursor posit
 	LD	B,0		;start with 0 length
 CURCUR	LD	A,95		;standard cursor
 	JR	CUROFF
 CURON	LD	A,0B0H		;cursor on char
 CUROFF	LD	(HL),A		;display it
 	LD	A,12		;1/4 second flash
 	LD	(FLCNT),A	;save the count
 SCAN	LD	A,0		;get counter
 FLCNT	EQU	$-1
 	DEC	A		;less one
 	LD	(FLCNT),A	;resave it
 	JR	NZ,SCAN2	;continue if not time
 	LD	A,(HL)		;get cursor char.
 	CP	95		;off?
 	JR	NZ,CURCUR	;display cursor/init cnt.
 	JR	CURON		;cursor on
 SCAN2	CALL	KEY		;scan keyboard
 	OR	A		;remove if not using 2BH
 	JR	Z,SCAN		;loop till have key
 	CP	13		;enter key?
 	JR	Z,SCDON
 	CP	8		;backspace?
 	JR	Z,BAKSPC
 	CP	18H		;shift back?
 	JR	Z,NEWST
 	CP	20H		;valid code?
 	JR	C,SCAN		;skip if not
 	LD	(ASVE),A	;save the key
 	LD	A,B		;get length
 	CP	C		;test for max
 	JR	NC,SCAN		;don't take it
 	LD	A,0
 ASVE	EQU	$-1		;get key back
 	LD	(HL),A		;display the byte
 	LD	(DE),A		;put in buffer
 	CP	(HL)		;lower case ?
 	JR	Z,CHAROK	;yes if Z
 	SUB	20H		;make it uppercase
 	LD	(HL),A		;put it back
 CHAROK	INC	DE		;bump buffer
 	INC	B		;bump length
 	INC	HL		;bump video pointer
 	JR	CURCUR		;resume
 SCDON	LD	(DE),A		;put into buffer
 	LD	(HL),20H	;cursor off
 	POP	DE		;restore old DE
 	LD	A,B		;set flags for length
 	OR	A
 	POP	HL		;hl => input string
 	LD	A,(HL)		;a has first char
 	RET			;done
 BAKSPC	LD	A,B		;any length?
 	OR	A
 	JR	Z,SCAN		;don't do it then
 	LD	(HL),20H	;put a space there
 	DEC	HL		;move it back
 	DEC	DE		;move buffer back
 	DEC	B		;char. count back
 	JR	CURCUR		;resume
 NEWST	LD	A,B		;any length?
 	OR	A
 	JR	Z,SCAN		;don't bother
 NEWSTL	LD	(HL),20H	;space to video
 	DEC	HL
 	DEC	DE		;move buffer back
 	DJNZ	NEWSTL		;go till length 0
 	JR	CURCUR		;cursor on
 	END
