MANNY1 ;   Keyboard scan routine by Kim Watt
 ;
 ;	call KEY to scan keyboard
 ;	returns with character in Accumulator
 ;	Z flag set if no character, else NZ
 ;	shift clear activates parallel screen printer
 ;	shift 0 toggles upper/lower case
 ;	repeating keys
 ;	all other registers preserved
 ;
 	ORG	$		;put it anywhere
 STRSPC	DEFW	0		;7 byte work area for key
 	DEFW	0
 	DEFW	0
 	DEFB	0
 KEY	PUSH	HL		;save all registers
 	PUSH	DE		;that we need to use
 	PUSH	BC
 	LD	HL,GET		;unstacker address
 	PUSH	HL		;to the stack
 	LD	A,(387FH)	;any keys on?
 	OR	A		;set flags
 	JR	NZ,ADDRPT	;countdown
 NEWKEY	LD	A,15		;first key delay
 	LD	(DLY1),A
 CONRPT	LD	A,2		;between key delay
 	LD	(DLY2),A
 	JR	KIGO		;go single key
 ADDRPT	CP	0		;same as last key?
 LSTKEY	EQU	$-1
 	LD	(LSTKEY),A	;put into mask byte
 	JR	NZ,NEWKEY	;go to new key
 	LD	A,0		;get first key count
 DLY1	EQU	$-1
 	OR	A		;down to 0 yet?
 	JR	Z,CKDLY2	;if yes, check delay2
 	DEC	A		;reduce it on this pass
 	LD	(DLY1),A	;put it back
 	JR	KIGO		;continue
 CKDLY2	LD	A,0		;get between key count
 DLY2	EQU	$-1
 	DEC	A		;less one
 	LD	(DLY2),A	;back
 	JR	NZ,KIGO		;go if not time
 	LD	HL,STRSPC	;work area
 	LD	DE,STRSPC+1	;7 byte last key mask
 	LD	BC,6
 	LD	(HL),0		;clear any last keys
 	LDIR
 	JR	CONRPT		;reset counter
 KIGO	LD	HL,STRSPC	;work area
 	LD	BC,3801H	;keyboard memory
 	LD	D,0		;row counter
 NEXROW	LD	A,(BC)		;get key byte
 	LD	E,A		;save it here
 	XOR	(HL)		;reverse with mask
 	LD	(HL),E		;save new key
 	AND	E		;same as last key?
 	JR	NZ,HAVEIT	;have a new one
 	INC	D		;bump row count
 	INC	L		;bump mask byte
 	RLC	C		;move key memory
 	JP	P,NEXROW	;go for 7 rows
 	RET			;done, return with Z
 HAVEIT	LD	E,A		;save masked byte
 	LD	A,D		;get row count
 	RLCA			;*2
 	RLCA			;*4
 	RLCA			;*8
 	LD	D,A		;row * 8
 	LD	C,1		;column mask bit
 MKT1	LD	A,C		;get mask
 	AND	E		;this the right key?
 	JR	NZ,MKT2		;yup
 	INC	D		;bump row * 8
 	RLC	C		;shift mask bit left
 	JR	MKT1		;continue
 MKT2	LD	C,0		;get key flag
 KIFLAG	EQU	$-1		;bit 0 = UL case
 	LD	HL,3880H	;point to shift key
 	LD	A,D		;get row * 8 + column
 	ADD	A,40H		;make it ascii
 	CP	60H		;a-z?
 	JR	NC,LXH3		;go if not
 	RRC	C		;reverse lower case?
 	JR	C,REVKEY	;works reverse if -1
 	RR	(HL)		;shift key pressed?
 	JR	NC,GOTKEY	;have the key
 	ADD	A,20H		;make it lower
 CKCTL	LD	D,A		;save char
 	LD	A,(3840H)	;get last row
 	AND	10H		;down arrow control key?
 	LD	A,D		;get char back
 	JR	Z,GOTKEY	;continue if not
 	CP	40H		;less than alpha?
 	JR	C,GOTKEY	;don't make a control key
 	AND	5FH		;make it lower
 	SUB	40H		;make it a control key
 	JR	GOTKEY
 REVKEY	RR	(HL)		;shift key on?
 	JR	C,CKCTL		;have the key
 	ADD	A,20H		;make it lower
 	JR	GOTKEY
 LXH3	SUB	70H		;check for last row
 	JR	NC,LXH5		;get byte from table
 	ADD	A,40H		;adjust ascii back
 	CP	3CH		;test for =*/
 	JR	C,LXH4		;don't adjust
 	XOR	10H		;works backwards
 LXH4	RR	(HL)		;shift key?
 	JR	NC,GOTKEY	;continue if not
 	XOR	10H		;reverse back
 	JR	GOTKEY
 LXH5	RLCA			;double it for table
 	RR	(HL)		;check for shift
 	JR	NC,LXH6		;go
 	INC	A		;add one for shift entry
 LXH6	PUSH	HL		;save shift key address
 	LD	HL,KEYTBL	;key look up table
 	LD	C,A
 	LD	B,0		;BC=displacement
 	ADD	HL,BC
 	LD	A,(HL)		;get the byte
 	POP	HL		;HL = shift key
 GOTKEY	CP	4		;sh clear?
 	JR	Z,SCRNPT	;screen printer
 	CP	20H		;check for sh 0
 	RET	NZ		;not that
 	RR	(HL)		;shift key
 	RET	NC		;nope
 	LD	A,(KIFLAG)	;get key flag
 	XOR	1		;reverse bit 0
 	LD	(KIFLAG),A	;put it back
 	XOR	A		;return with nill
 	RET
 ;
 ;	parallel screen printer routine
 ;	trailing spaces are removed from each line
 ;	and null lines are printer with a linefeed
 ;	for maximum speed and minimum printer head travel
 ;
 SCRNPT	LD	A,(37E8H)	;read lineprinter status
 	AND	0C0H		;ready?
 	JR	NZ,VIDBK	;skip if not
 	LD	B,16		;16 lines on video
 	LD	HL,3C00H	;start of video
 VIDE1	LD	C,64		;64 char/line
 	PUSH	HL		;save BOL
 	LD	A,L		;get lsb
 	ADD	A,3FH		;put at end of line
 	LD	E,A		;give to de
 	LD	D,H		;de = end of line
 VIDE3	LD	A,(DE)		;get a byte from screen
 	CP	20H		;space?
 	JR	NZ,VIDIT	;end of that line
 	DEC	DE		;go back
 	DEC	C		;reduce count
 	JR	NZ,VIDE3	;look for more chars
 	LD	A,10		;send a linefeed
 	JR	VIDNEX		;continue
 VIDIT	INC	DE		;bump for end
 VIDIT1	LD	A,0		;get printer flag
 PFLAG	EQU	$-1		;non-zero if graphics OK
 	OR	A		;set flags
 	LD	A,(HL)		;get screen byte
 	JR	NZ,VID4		;print the graphics
 	BIT	7,A		;graphics?
 	JR	Z,VID4		;continue if not
 	LD	A,'.'		;else make it a period
 VID4	CALL	POUT		;display it
 	INC	HL		;bump position
 	PUSH	HL		;test for end of line
 	OR	A		;clear carry flag
 	SBC	HL,DE		;at end yet?
 	POP	HL
 	JR	NZ,VIDIT1
 	LD	A,13		;send a carriage return
 VIDNEX	CALL	POUT		;give to printer
 	POP	HL		;restore hl
 	LD	DE,40H		;for next line
 	ADD	HL,DE		;go there
 	DJNZ	VIDE1		;continue for 16 lines
 VIDBK	XOR	A		;return with zero
 	RET			;done
 POUT	LD	C,A		;save it here
 VIDE9	LD	A,(37E8H)	;printer ready?
 	AND	0C0H		;mask status bits
 	JR	Z,VIDE00	;continue if yes
 	LD	A,(3840H)	;check clear key
 	AND	2
 	RET	NZ		;quit if yes
 	JR	VIDE9		;else wait
 VIDE00	LD	A,C		;get the byte back
 	LD	(37E8H),A	;give it to printer
 	RET
 GET	POP	BC		;unstacker routine
 	POP	DE
 	POP	HL
 	OR	A		;Z flag reflects Accum.
 	RET			;restore 'em all
 KEYTBL	DEFB	13		;enter
 	DEFB	14		;sh enter
 	DEFB	3		;clear
 	DEFB	4		;sh clear
 	DEFB	1		;break
 	DEFB	2		;sh break
 	DEFB	5BH		;u arr
 	DEFB	1BH		;sh u arr
 	DEFB	5CH		;d arr
 	DEFB	1AH		;sh d arr
 	DEFB	5DH		;l arr
 	DEFB	18H		;sh l arr
 	DEFB	5EH		;r arrow
 	DEFB	19H		;sh r arr
 	DEFB	20H		;space
 	DEFB	80H		;sh space
 DELAY	DEC	C		;decrement BC till 0
 	JR	NZ,DELAY
 	DJNZ	DELAY
 	RET
 	END

 	DEFB	5DH		;l arr
 	DEFB	18H		;sh l arr
 	DEFB	5EH		;r arrow
 	DEFB	19H		;sh r arr
2O@2Q@2O@#KڝY2Q@2O@#~ͤTR(LY2P@#KڝYҝY2Q@͌W:O@RS :Q@2Q@ͲZڝYaZͽUZrZ ZͲZڝYaZ ͽUZrZ Z#