KEYBOA ; #######################################################
 ; SIMPLE ACTIVE KEYBOARD DISPLAY ROUTINE TO SHOW THE USE
 ; AND PHANTOMING OF KEYS AS THEY ARE PRESSED BY THE USER
 ; 
 ;    DENNIS BATHORY KITSZ, ROXBURY, VERMONT  05669
 ; #######################################################
 ;
 	ORG	5000H
 ;
 ; #######################################################
 ; CLEAR SCREEN, DISABLE INTERRUPTS, CLEAR ACCUMULATOR,
 ; GET "0" CHARACTER, SCREEN POSITIONS, SCREEN OFFSET,
 ; AND BEGINNING OF KEYBOARD FOR TEST; ALL ARE SET UP ONCE
 ; #######################################################
 ;
 ENTER	CALL	01C9H		; CLEAR SCREEN TO START
 	DI			; KILL ALL THEM BOTHERS
 	XOR	A		; CLEAR ALL FLAGS
 START	LD	C,30H		; THIS IS THE "0" CHAR.
 	LD	HL,3D10H	; ADDRESS NEAR SCREEN CTR
 	LD	DE,0024H	; DISTANCE BETWEEN LINES
 	PUSH	DE		; SAVE LINE ADDER VALUE
 	LD	DE,3801H	; DEFINE FIRST KEYBOARD
 	LD	B,08H		; NUMBER OF LOOPS TO DO
 ;
 ; #######################################################
 ; TEST EACH ROW OF THE KEYBOARD, COLUMN BY COLUMN
 ; #######################################################
 ;
 LOOP	LD	A,(DE)		; FIRST ROW OF KEYBOARD
 	BIT	0,A		; CHECK FIRST KEY COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP1		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP1	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	1,A		; SECOND KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP2		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP2	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	2,A		; THIRD KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP3		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP3	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	3,A		; FOURTH KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP4		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP4	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	4,A		; FIFTH KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP5		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP5	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO 
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	5,A		; SIXTH KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP6		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP6	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	6,A		; SEVENTH KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP7		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP7	INC	HL		; NEXT SCREEN LOCATION
 	INC	HL		; ...PLUS TWO
 	INC	HL		; ...PLUS THREE
 	INC	HL		; ...PLUS FOUR
 	BIT	7,A		; EIGHTH KEYBOARD COLUMN
 	LD	(HL),C		; FIRST DISPLAY A "0"
 	JR	Z,JUMP8		; DON'T CHANGE IF NO KEY
 	INC	(HL)		; MAKE IT A "1" IF A KEY
 JUMP8	PUSH	DE		; SAVE THIS VALUE
 	POP	IX		; PUT IT IN IX FOR A BIT
 	POP	DE		; GET ORIGINAL DE VALUE
 	ADD	HL,DE		; NOW START NEXT LINE
 	PUSH	DE		; SAVE SAME VALUE AGAIN
 	PUSH	IX		; STASH IT BRIEFLY
 	POP	DE		; AND BACK INTO DE INTACT
 	RL	E		; DEFINE NEXT KEYBRD ROW
 	DJNZ	LOOP		; DO IT FOR EIGHT ROWS
 ;
 ; #######################################################
 ; CLEAR UP POINTERS AND DELAY SO SCREEN DOES NOT JITTER
 ; #######################################################
 ;
 	POP	DE		; CLEAR THE STACK
 	LD	BC,800H		; DELAY VALUE
 	CALL	0060H		; DELAY SUBROUTINE IN ROM
 	JR	START		; START THE ROUTINE AGAIN
 ;
 ; #######################################################
 	END	ENTER		; BEGIN IT ALL HERE
