       ;Routine to allow KEYBOARD MACRO'S for the
 ;TRS-80 Model III/IV. The Model III version
 ;uses the <SHIFT DOWN ARROW> and <LETTER> for
 ;control, the Model IV uses the <CTRL> and a
 ;<LETTER> for keywords.
 ;Note * * This program only runs in the Model 3 mode.
 ;Keywords may be DEFINED, SAVED, LOADED, and CLEARED
 ;from the keyboard. The following are the controls for
 ;these applications.
 ;Function	Model III	Model 4(in 3 Mode)
 ;Define		SHFT DWN .	SHFT CTRL .
 ;Displayed	SHFT DWN /	SHFT CTRL /
 ;Save		SHFT DWN ,	SHFT CTRL ,
 ;Load		SHFT DWN ,	SHFT CTRL ,
 ;Clear		SHFT DWN ,	SHFT CTRL ,
 ;Execute CMD	SHFT DWN Letter	CTRL Letter
 ;<c> 1984 by Mel Patrick
 	ORG	8000H
 MODEL3	DEFL	0		;Set 1=M3 0=Mod4
 MODEL4	DEFL	1-MODEL3	;conditional assmbly
 RELO	LD	A,(HL)		;test for no size
 	CP	0DH		;end of input?
 	JR	Z,RELO0		;go if yes
 	DEC	HL		;else check for ,
 	LD	A,(HL)		;get character
 	CP	','		;char must comma or spc
 	JR	Z,DOSZ		;go if comma
 	CP	' '		;else space?
 	JR	Z,DOSZ		;go if yes
 	LD	HL,SYNTAX	;else syntax error
 	CALL	DISPLY		;show it
 	JP	402DH		;don't install
 DOSZ	INC	HL		;point to size
 	LD	E,00H		;reset counter
 	LD	A,(HL)		;get ASCII char
 	SUB	30H		;make it digit 0-9
 	CALL	DOADD		;and do any addition
 	INC	HL		;point to next
 	LD	A,(HL)		;get next byte
 	CP	0DH		;end of line?
 	JR	NZ,NOTEND	;go if not
 	DEC	HL		;step back to units
 	LD	E,00H		;else only units wanted
 	LD	A,(HL)		;get number again
 	SUB	30H		;make digit 0-9
 	CALL	DOADD1		;and calculate it
 	JR	CHKZ		;and continue
 NOTEND	SUB	30H		;make it digit 0-9
 	CALL	DOADD1		;add units to total
 CHKZ	LD	A,E		;check limits
 	OR	A		;test for zero
 	JR	NZ,NOZE		;go if not zero
 	LD	HL,ZERR		;else zero error
 	CALL	DISPLY		;show it
 	JP	402DH		;back to dos
 NOZE	CP	60		;maximum allowed
 	JR	C,SZOK		;go if =<60
 	LD	A,60		;else its too high
 SZOK	LD	(WRDLEN),A	;reset word length
 	LD	E,A		;move for new total
 	LD	D,00H
 	LD	B,26		;for 26 entires
 	LD	HL,0000H	;find new length
 NEWLEN	ADD	HL,DE		;find new length
 	DJNZ	NEWLEN		;step for 26 times
 	LD	(LISTLN),HL	;store new length
 	LD	DE,ENDBIT	;find new prgrm end
 	ADD	HL,DE		;hl=end of program
 	LD	(END1+1),HL	;reset end in relo
 	LD	(END2+1),HL	;reset relo again
 	LD	(END3+1),HL	;last reset length
 	JR	RELO0		;continue now
 DOADD	OR	A		;look for 0
 	RET	Z		;back if found
 	LD	B,A		;else move to loop
 	LD	A,E		;get size
 ADD10	ADD	A,10		;step by ten's
 	DJNZ	ADD10		;loop for digits
 	LD	E,A		;store the answer
 	RET			;back to caller
 DOADD1	OR	A		;test for zero
 	RET	Z		;back if zero
 	LD	B,A		;else move to loop
 ADD1	INC	E		;step ahead 1
 	DJNZ	ADD1		;for count
 	INC	E		;add 1 for C/R
 	RET			;back to caller
 RELO0	LD	HL,RMSG		;point to message
 	CALL	DISPLY		;show it
 	CALL	CLEAR		;clear any table entries
 	LD	A,(3000H)	;test for 1 or 3
 	CP	0C3H		;C3=Model III
 	JR	Z,GETM3		;go if model III
 	LD	HL,(4049H)	;else get mem size M1
 	JR	RELO1		;continue now
 GETM3	LD	HL,(4411H)	;get M3 memory size
 RELO1	LD	(MEM),HL	;save memory size
 	LD	(OLDSZ),HL	;save in routine too
 	PUSH	HL		;save size
 END1	LD	HL,ENDBIT	;get end of program
 	LD	DE,OLDSZ	;get start of program
 	OR	A		;clear the carry
 	SBC	HL,DE		;HL=program length
 	INC	HL		;add 1 to count
 	LD	(SIZE),HL	;save program length
 	POP	HL		;HL=memory size
 END2	LD	DE,ENDBIT	;point to end of prgrm
 	OR	A		;clear the carry
 	SBC	HL,DE		;find the offset
 	LD	(OFFSET),HL	;save the offset
 	LD	IX,KEYMAC+1	;start changing addresses
 	CALL	CHANGE		;do it
 	LD	IX,R1+1
 	CALL	CHANGE
 	LD	IX,R2+1
 	CALL	CHANGE
 	LD	IX,NEWDVR+1
 	CALL	CHANGE
 	LD	IX,R4+1
 	CALL	CHANGE
 	LD	IX,R5+1
 	CALL	CHANGE
 	LD	IX,R6+1
 	CALL	CHANGE
 	LD	IX,R7+1
 	CALL	CHANGE
 	LD	IX,R8+2
 	CALL	CHANGE
 	LD	IX,R9+1
 	CALL	CHANGE
 	LD	IX,R10+1
 	CALL	CHANGE
 	LD	IX,R11+1
 	CALL	CHANGE
 	LD	IX,R12+1
 	CALL	CHANGE
 	LD	IX,R13+1
 	CALL	CHANGE
 	LD	IX,R14+1
 	CALL	CHANGE
 	LD	IX,R15+1
 	CALL	CHANGE
 	LD	IX,R16+1
 	CALL	CHANGE
 	LD	IX,R17+1
 	CALL	CHANGE
 	LD	IX,R18+1
 	CALL	CHANGE
 	LD	IX,R19+1
 	CALL	CHANGE
 	LD	IX,R20+2
 	CALL	CHANGE
 	LD	IX,R21+1
 	CALL	CHANGE
 	LD	IX,R22+1
 	CALL	CHANGE
 	LD	IX,R23+1
 	CALL	CHANGE
 	LD	IX,R24+1
 	CALL	CHANGE
 	LD	IX,R25+1
 	CALL	CHANGE
 	LD	IX,R26+1
 	CALL	CHANGE
 	LD	IX,R27+1
 	CALL	CHANGE
 	LD	IX,R28+1
 	CALL	CHANGE
 	LD	IX,R29+1
 	CALL	CHANGE
 	LD	IX,R30+1
 	CALL	CHANGE
 	LD	IX,R31+1
 	CALL	CHANGE
 	LD	IX,MORECL+1
 	CALL	CHANGE
 	LD	IX,GETCOL+1
 	CALL	CHANGE
 	LD	IX,R31A+1
 	CALL	CHANGE
 	LD	IX,R32+1
 	CALL	CHANGE
 	LD	IX,R33+1
 	CALL	CHANGE
 	LD	IX,R34+1
 	CALL	CHANGE
 	LD	IX,R35+1
 	CALL	CHANGE
 	LD	IX,R36+1
 	CALL	CHANGE
 	LD	IX,R37+1
 	CALL	CHANGE
 	LD	IX,R38+1
 	CALL	CHANGE
 	LD	IX,R39+1
 	CALL	CHANGE
 	LD	IX,R40+1
 	CALL	CHANGE
 	LD	IX,R41+1
 	CALL	CHANGE
 	LD	IX,R42+1
 	CALL	CHANGE
 	LD	IX,R43+1
 	CALL	CHANGE
 	LD	IX,R44+2
 	CALL	CHANGE
 	LD	IX,WRITE+1
 	CALL	CHANGE
 	LD	IX,R45+1
 	CALL	CHANGE
 	LD	IX,R46+1
 	CALL	CHANGE
 	LD	IX,R47+1
 	CALL	CHANGE
 	LD	IX,R48+1
 	CALL	CHANGE
 	LD	IX,R49+1
 	CALL	CHANGE
 	LD	IX,R50+1
 	CALL	CHANGE
 	LD	IX,R51+1
 	CALL	CHANGE
 	LD	IX,R52+1
 	CALL	CHANGE
 	LD	IX,R53+1
 	CALL	CHANGE
 	LD	IX,R54+1
 	CALL	CHANGE
 	LD	IX,R55+2
 	CALL	CHANGE
 	LD	IX,READ+1
 	CALL	CHANGE
 	LD	IX,R56+1
 	CALL	CHANGE
 	LD	IX,R56A+1
 	CALL	CHANGE
 	LD	IX,CLEAR+1
 	CALL	CHANGE
 	LD	IX,R57+2
 	CALL	CHANGE
 	LD	IX,R58+1
 	CALL	CHANGE
 	LD	IX,P1+1		;reset all print add
 	CALL	CHANGE
 	LD	IX,P2+1
 	CALL	CHANGE
 	LD	IX,P3+1
 	CALL	CHANGE
 	LD	IX,P4+1
 	CALL	CHANGE
 	LD	IX,P5+1
 	CALL	CHANGE
 	LD	IX,P6+1
 	CALL	CHANGE
 	LD	IX,P7+1
 	CALL	CHANGE
 	LD	IX,P8+1
 	CALL	CHANGE
 	LD	IX,P9+1
 	CALL	CHANGE
 	LD	IX,P11+1
 	CALL	CHANGE
 END3	LD	HL,ENDBIT	;point to last address
 	LD	DE,(MEM)	;get memory size
 	LD	BC,(SIZE)	;get program length
 	LDDR			;do a block move
 	LD	BC,0FFFFH	;do a time delay
 	CALL	60H		;do it
 	JR	KEYMAC		;and initialize
 CHANGE	LD	E,(IX)		;get LSB address
 	LD	D,(IX+01H)	;get MSB address
 	LD	HL,(OFFSET)	;get offset
 	ADD	HL,DE		;do the add
 	LD	(IX),L		;store new address
 	LD	(IX+01),H	;and MSB address
 	CALL	BLINK		;blink a splat*
 	RET			;back to caller
 KEYMAC	LD	HL,OLDSZ	;point to new routine
 	DEC	HL		;setup for MEM size
 	LD	A,(3000H)	;get model type
 	CP	0C3H		;JP=M3
 	JR	Z,M3		;go if model III
 	LD	(4049H),HL	;else its a M1
 	JR	CONT		;and continue
 M3	LD	(4411H),HL	;reset M3 size
 CONT	LD	HL,(4016H)	;get keyboard address
 R1	LD	(GETCHR+1),HL	;re-route vector
 R2	LD	HL,NEWDVR	;get new route
 	LD	(4016H),HL	;restore link
 	LD	HL,TEXT		;point to text
 	CALL	DISPLY		;show it
 	JP	402DH		;and reenter DOS
 TEXT	DEFW	0D0DH
 	DEFM	'Macro-Key Version 2.0 <INSTALLED>'
 	DEFW	0D0DH
 	DEFB	03H
 RMSG	DEFW	0D0DH
 	DEFM	'Macro-Key <c>1984 by Mel Patrick'
 	DEFB	0DH
 	DEFM	'Relocating Macro-Key to High Memory'
 	DEFW	0D0DH
 	DEFB	03H
 ZERR	DEFB	0DH
 	DEFM	'No Size Specified or SIZE=0'
 SYNTAX	DEFW	0D0DH
 	DEFM	'Command Entry Error'
 	DEFB	0DH
 	DEFM	'Use KEYMAC3,size or KEYMAC3 size'
 	DEFB	0DH
 	DEFM	'or KEYMAC4,size or KEYMAC4 size'
 	DEFB	0DH
 	DEFM	'I.E KEYMAC3,40 or KEYMAC3 40'
 	DEFB	0DH
 	DEFM	'or  KEYMAC4,25 or KEYMAC4 25'
 	DEFW	0D0DH
 	DEFM	'Macro-Key NOT INSTALLED'
 	DEFB	0DH
 	DEFB	03H
 MEM	DEFW	0000H
 SIZE	DEFW	0000H
 OFFSET	DEFW	0000H
 	ORG	9000H		;start of program
 OLDSZ	DEFW	0000H		;previous memory size
 NEWDVR	LD	A,(MODE)	;check for keyword
 	OR	A		;0=no NZ=yes
 	JR	NZ,PRTWRD	;go if ON
 GETCHR	CALL	$-$		;new vector here
 	OR	A		;test for a keypress
 	RET	Z		;back if none
 	CP	20H		;check for high limit
 	RET	NC		;back if too high
 	PUSH	AF		;else save char
 	IF	MODEL3		;conditional test
 	LD	A,(3880H)	;look a shift row
 	CP	1		;look for left shift
 	JR	NZ,NOCMD	;go if not pressed
 	LD	A,(3840H)	;check for down arrow
 	CP	16		;down pressed?
 	JR	NZ,NOCMD	;go if not
 	ENIF			;first end of conditonal
 	IF	MODEL4		;test for model 4
 	DEFW	0000H		;makes 3 and 4 version
 	DEFW	0000H		;same length in memory
 	DEFW	0000H		;there is a 7 byte dif.
 	DEFB	00H		;on the model 4 version
 	LD	A,(3880H)	;look for CNTRL
 	BIT	2,A		;0=no cntrl 1=pressed
 	JR	Z,NOCMD		;go if not
 	ENIF			;end of conditional
 	POP	AF		;else get back char value
 	CP	1EH		;define word?
 R4	JP	Z,DEFINE	;go if yes
 	CP	1CH		;want a save?
 R5	JP	Z,OPTION	;check for save or load
 	CP	1FH		;look for cntrl /
 R6	JP	Z,VIEW		;show cmds defined
 	JR	FNDWRD		;and continue
 NOCMD	POP	AF		;get back char
 	RET			;and go back with it
 FNDWRD	PUSH	HL		;save pointer
 	PUSH	DE		;save pointer
 	PUSH	BC		;save regs
 R7	LD	HL,WRDLST	;point to word list
 R8	LD	DE,(WRDLEN)	;get word lengths
 	LD	B,A		;move for counter
 	OR	A		;clear carry
 	SBC	HL,DE		;step back 1
 FNDLP	ADD	HL,DE		;point back to start
 	DJNZ	FNDLP		;loop for X count
 R9	LD	(WORD),HL	;save address of word
 	LD	A,1		;set mode to keyword
 R10	LD	(MODE),A	;do it
 	POP	BC		;restore regs
 	POP	DE		;fix reg
 	POP	HL		;hl=normal now
 PRTWRD	PUSH	HL		;save pointer
 R11	LD	HL,(WORD)	;get word address
 	LD	A,(HL)		;get a byte
 	INC	HL		;point to next
 R12	LD	(WORD),HL	;save it
 	POP	HL		;fix the register
 	OR	A		;0=no word defined
 	JR	Z,NOMORE	;go if not defined
 	CP	'/'		;want a C/R
 	JR	Z,DOCR		;go if yes
 	CP	0DH		;else end of word(s)
 	JR	Z,NOMORE	;go if no more
 	RET			;else return with letter
 DOCR	LD	A,0DH		;replace with C/R
 	RET			;return
 NOMORE	XOR	A		;remove byte
 R13	LD	(MODE),A	;reset mode
 	RET			;back with null
 DISPLY	LD	A,(HL)		;get a byte
 	CP	03H		;end of msg
 	RET	Z		;back if yes
 	CALL	33H		;else print it
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 DEFINE	PUSH	HL		;save pointer
 R14	LD	HL,PROMPT	;point to question
 R15	CALL	DISPLY		;show it
 	XOR	A		;remove any flags
 R16	LD	(MODE),A	;from routine
 DEF	CALL	49H		;wait for inkey
 	AND	5FH		;convert to UPPER
 	CP	'A'		;allowed A-Z
 	JR	C,DEF		;loop if to low
 	CP	5BH		;check high side
 	JR	NC,DEF		;go if too high
 	PUSH	AF		;save character
 	CALL	33H		;print the char.
 R17	LD	HL,QUEST	;point to message
 R18	CALL	DISPLY		;show it
 	POP	AF		;get back character
 	SUB	40H		;make it digit 1-25
 	LD	B,A		;move to loop
 	PUSH	DE		;save pointer
 R19	LD	HL,WRDLST	;point to word list
 R20	LD	DE,(WRDLEN)	;get length of input
 	OR	A		;clear the carry
 	SBC	HL,DE		;step back 1
 DEFLP	ADD	HL,DE		;step to find it
 	DJNZ	DEFLP		;loop til found
 R21	LD	A,(WRDLEN)	;get length of input
 	DEC	A		;minus 1 for C/R
 	LD	B,A		;move for input
 	CALL	40H		;get input
 	POP	DE		;restore regs
 	POP	HL		;again
 	LD	A,0DH		;just get a C/R
 	RET			;and return
 VIEW	PUSH	HL		;save reg
 	PUSH	DE		;"	"
 R22	LD	HL,HEAD		;point to heading
 R23	CALL	DISPLY		;show it
 R24	CALL	GETCOL		;get columns allowed
 	LD	A,'A'		;start with A
 	LD	B,26		;show all 26 cmds
 R25	LD	(WORD),A	;save first letter
 R26	LD	HL,WRDLST	;point to word list
 VLP	PUSH	BC		;save loop counter
 R27	LD	A,(WORD)	;get letter
 	CALL	33H		;show it
 P3	CALL	LPRINT		;check for LPRINT
 	INC	A		;add 1 to it
 R28	LD	(WORD),A	;store it again
 	LD	A,':'		;show :
 	CALL	33H		;show it
 P4	CALL	LPRINT		;check for LPRINT
 R29	LD	A,(WRDLEN)	;get length of input
 	LD	B,A		;move for printing
 VIEW1	LD	A,(HL)		;get a byte
 	OR	A		;look for 0
 	JR	NZ,NOTZER	;go if ASCII
 	LD	A,20H		;else replace with space
 NOTZER	CP	0DH		;look for C/R
 	JR	NZ,NOTCR	;go if no carriage ret
 LAST	LD	A,' '		;else replace with space
 	CALL	33H		;show it
 P5	CALL	LPRINT		;check for hardcopy
 	INC	HL		;point to next
 	DJNZ	LAST		;loop til end of line
 	JR	VIEW3		;and continue
 NOTCR	CALL	33H		;else display it
 P6	CALL	LPRINT		;check for hardcopy
 	INC	HL		;point to next
 	DJNZ	VIEW1		;loop for first word
 VIEW3	LD	A,' '		;insert space now
 	CALL	33H		;couple of them
 P7	CALL	LPRINT		;check for hardcopy
 	POP	BC		;get back counter
 R30	LD	A,(WORD+1)	;get column done
 	DEC	A		;minus 1 from it
 	OR	A		;0=do a C/R
 	JR	NZ,MORECL	;go if more needed
 	LD	A,0DH		;else do a C/R
 	CALL	33H		;on the video
 P8	CALL	LPRINT		;check for hardcopy
 R31	LD	A,(COLUMN)	;get columns used
 MORECL	LD	(WORD+1),A	;save new column
 VWAIT	LD	A,(3840H)	;look for space bar
 	CP	128		;found space bar?
 	JR	NZ,NOSPC	;go if not
 WAIT1	LD	A,(3840H)	;get byte again
 	CP	128		;still pressed
 	JR	Z,WAIT1		;loop if yes
 WAIT2	LD	A,(3840H)	;else look for space
 	CP	128		;pressed?
 	JR	Z,NOSPC		;go if single step
 	CP	01H		;else enter key?
 	JR	NZ,WAIT2	;loop if not
 NOSPC	DJNZ	VLP		;loop for 26
 	XOR	A		;zero out A
 P9	LD	(PFLAG),A	;reset printer flag
 	LD	A,0DH		;do a C/R
 	POP	DE		;restore regs
 	POP	HL		;again
 	RET			;and return
 LPRINT	PUSH	AF		;save character
 P11	LD	A,(PFLAG)	;test for print
 	OR	A		;0=no 1=yes
 	JR	NZ,LPRT		;go if wanted
 	POP	AF		;else get back char
 	RET			;and go back
 LPRT	POP	AF		;get back character
 	CALL	3BH		;lprint it
 	RET			;back to caller
 GETCOL	LD	A,(WRDLEN)	;get word length
 	ADD	A,3		;add 4 to it (A://)
 	CP	16		;screen field size MAX?
 	JR	NZ,GETCL1	;no, then continue
 	LD	A,3		;else default to 3
 	JR	R31A		;and save default col
 GETCL1	LD	E,A		;put in for subtract
 	LD	D,00H		;make D=0
 	LD	HL,64		;width of video
 	LD	A,0FFH		;set to minus 1
 DOCOL	OR	A		;clear any carry
 	SBC	HL,DE		;subtract DE from HL
 	INC	A		;add 1 to total
 	JR	NC,DOCOL	;loop til too far
 R31A	LD	(COLUMN),A	;save it
 R32	LD	(WORD+1),A	;save for down count
 	RET			;back to caller
 OPTION	PUSH	HL		;save reg
 R33	LD	HL,OPMSG	;point to message
 R34	CALL	DISPLY		;show it
 	POP	HL		;fix pointer now
 OP1	CALL	49H		;wait for a key
 	AND	5FH		;convert to UPPER
 	CALL	33H		;show key
 	CP	'R'		;read a macro?
 R35	JP	Z,LOAD		;go if yes
 	CP	'W'		;else write macro?
 	JR	Z,SAVE		;go if yes
 	CP	'C'		;else CLEAR table?
 	JR	Z,DOCLR		;go if yes
 	CP	'P'		;print table?
 	JR	Z,PRINT		;go if yes
 	LD	A,0DH		;else forget it
 	RET			;and go back
 PRINT	LD	A,1		;set print to on
 P1	LD	(PFLAG),A	;save it
 P2	JP	VIEW		;and continue
 DOCLR	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 R36	CALL	CLEAR
 	POP	BC
 	POP	DE
 	POP	HL
 	LD	A,0DH
 	RET			;simple clear routine
 SAVE	PUSH	HL		;save regs
 	PUSH	DE
 	PUSH	BC
 R37	LD	HL,SPEC		;point to prompt
 R38	CALL	DISPLY		;show it
 R39	LD	HL,BUFFER	;point to buffer
 	LD	B,20		;bytes to input
 	CALL	40H		;get input
 	JR	C,NOSAVE	;go if not wanted
 R40	LD	HL,DUMMY	;point to dummy buffer
 R41	LD	DE,BUFFER	;point to filespec
 	LD	B,00H		;set LRL=256
 	CALL	4420H		;open or create the file
 R42	JP	NZ,ERROR	;go if error
 R43	LD	HL,WRDLST	;else point to list
 R44	LD	BC,(LISTLN)	;get list length
 WRITE	LD	DE,BUFFER	;point to filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write a byte
 R45	JP	NZ,ERROR	;go if error
 	INC	HL		;point to next
 R46	CALL	BLINK		;show a *
 	DEC	BC		;minus 1 from count
 	LD	A,B		;test for 0
 	OR	C		;0=done
 	JR	NZ,WRITE	;loop til done
 R47	LD	DE,BUFFER	;point to buffer
 	CALL	4428H		;close the file
 NOSAVE	POP	BC		;fix all regs
 	POP	DE		;"	"
 	POP	HL		;"	"
 	LD	A,0DH		;do a C/R
 	RET			;and go back
 LOAD	PUSH	HL		;save regs
 	PUSH	DE
 	PUSH	BC
 R48	LD	HL,SPEC
 R49	CALL	DISPLY
 R50	LD	HL,BUFFER	;point to buffer
 	LD	B,20		;bytes to input
 	CALL	40H		;get input
 	JR	C,NOSAVE	;go if BREAK
 R51	LD	HL,DUMMY	;else point to file
 R52	LD	DE,BUFFER	;point to spec
 	LD	B,00H		;set LRL=256
 	CALL	4424H		;open don't create
 R53	JP	NZ,ERROR	;go if error
 R54	LD	HL,WRDLST	;else point to list
 R55	LD	BC,(LISTLN)	;get list length
 READ	LD	DE,BUFFER	;point to file
 	CALL	13H		;read a byte
 	LD	(HL),A		;store it
 R56	CALL	BLINK		;show a *
 	INC	HL		;point to next
 	DEC	BC		;minus 1 from count
 	LD	A,B		;test for done
 	OR	C		;0=all done
 	JR	NZ,READ		;loop for 728 bytes
 R56A	JP	NOSAVE		;and then return
 CLEAR	LD	HL,WRDLST	;point to word list
 	LD	(HL),00H	;remove any info
 	PUSH	HL		;make HL=DE
 	POP	DE		;DE=HL now
 	INC	DE		;de=destination
 R57	LD	BC,(LISTLN)	;get length of list
 	LDIR			;go for it
 	RET			;back to caller
 ERROR	PUSH	AF		;save error code
 	LD	A,0DH		
 	CALL	33H		;do a C/R
 	POP	AF		;get back error code
 	SET	7,A		;set for return
 	CALL	4409H		;display error
 R58	JP	NOSAVE		;and return
 BLINK	LD	A,(3C3FH)	;blink a *
 	XOR	0AH		;toggle a *
 	LD	(3C3FH),A	;save it again
 	RET			;and return
 HEAD	DEFB	0DH
 	DEFM	'Macro Key Definitions'
 	DEFB	0DH
 	DEFB	03H
 PROMPT	DEFB	0DH
 	DEFM	'Definition Letter (A-Z) : '
 	DEFB	03H
 QUEST	DEFB	0DH
 	DEFM	'Definition : '
 	DEFB	03H
 SPEC	DEFB	0DH
 	DEFM	'Filespec : '
 	DEFB	03H
 OPMSG	DEFB	0DH
 	DEFM	'Press : <R>ead / <W>rite / <C>lear / <P>rint : '
 	DEFB	03H
 BUFFER	DEFS	50		;bytes for name
 DUMMY	DEFS	256		;self contained
 LISTLN	DEFW	338		;word list length
 PFLAG	DEFB	00H		;0=no print 1=print
 COLUMN	DEFB	00H		;columns allowed
 MODE	DEFB	00H		;0=normal 1=keyword
 WORD	DEFW	0000H		;keyword address
 WRDLEN	DEFW	13		;input length allowed
 WRDLST	DEFS	338		;command strings
 ENDBIT	DEFB	00H
 	END	RELO

