KEEPIT ;
 ;SOURCE PROGRAM FOR "KEEPIT" 
 ;COPYRIGHT 1980 BY DENNIS BATHORY KITSZ
 ;
 ; COMMANDS:
 ;   *SAVE/RUN"XXXXXX"
 ;   *SAVE/OPEN"XXXXXX,NNNN,NNNN,NNNN"
 ;   *OPEN"NNNN"
 ;   *NEW
 ;   *MEM"NNNN"
 ;   *STEPNN
 ;   *LOC	FOR LATER IMPLEMENTATION
 ;   *SET"NNNN"	FOR LATER IMPLEMENTATION
 ;
 KYSCAN	EQU	03FBH	;KEYBOARD SCAN ROUTINE
 PORTFF	EQU	403DH	;CASSETTE OUTPUT PORT
 KPLACE	EQU	401AH	;1-BYTE KEYSTROKE STORE
 KEYBRD	EQU	4016H	;KEY SCAN PATCH POINT
 RESTRT	EQU	4004H	;BASIC INTERP PATCH POINT
 STGEND	EQU	40A0H	;END OF STRINGS POINTER
 VAREND	EQU	40FDH	;END OF VARIABLE POINTER
 READY	EQU	06CCH	;RETURN TO READY INTACT
 MEMTOP	EQU	40B1H	;TOP OF BASIC MEMORY
 SETPTS	EQU	4000H	;SETPOINT RESTART ADDRESS
 WRTBYT	EQU	0264H	;ROM BYTE WRITE ROUTINE
 BYTE	EQU	1D78H	;ROM READ KEYS & TOKENIZE
 VIDEO	EQU	3C00H	;FIRST SCREEN LOCATION
 STACKR	EQU	40E8H	;BASIC STACK POINTER POINT
 ;
 ;
 ;++++++++++++BYTE CHANGES+++++++++++++++
 ;+++++++CHANGE THESE VALUES TO++++++++++
 ;++++++++++RELOCATE PROGRAM+++++++++++++
 CHG1	EQU	07BBBH		; START ADDRESS
 CHG2	EQU	07BH		; START MSB
 CHG2A	EQU	0BBH		; START LSB
 CHG3	EQU	07FFFH		; NEW STACK
 CHG4	EQU	'1'		; ASCII MEM SIZE
 CHG5	EQU	'6'		; FOR LOADER
 CHG99	EQU	CHG1+099H	; OVERLAP JUMP
 ;+++++++++++BYTE CHANGES END+++++++++++
 ;
 ;
 ; PATCH IN PROGRAM UPON RETURN
 ; FOR AUTOSTART
 	ORG	KEYBRD
 	DEFB	CHG2A
 	DEFB	CHG2
 	ORG	VIDEO
 	DEFM	'**** LOADING KEEPIT 3.0 FOR '
 	DEFB	CHG4
 	DEFB	CHG5
 	DEFM	'K ****** DENNIS BATHORY KITSZ ****'
 	ORG	CHG1
 ;
 ; PATCH IN DEBOUNCE RETURN UPON START
 START	LD	HL,KBPFIX
 	LD	(KEYBRD),HL
 ;
 ; GET TOKEN CHECK PROGRAM SECTION
 	LD	HL,STEPPR
 ;
 ; GET CURRENT CONTENTS OF 4004H
 ; WHICH ARE NORMALLY 1D78H
 	LD	DE,(RESTRT)
 	LD	(CHG99),DE
 	LD	(RESTRT),HL
 ;
 ; CALL CLEAR ROUTINE AND RETURN
 ; TO BASIC COMMAND LEVEL
 	CALL	1B61H
 	JP	READY
 ;
 ;START KEYBOARD SCAN
 KBPFIX	LD	HL,4036H
 	LD	BC,3801H
 	LD	D,0
 ;
 ;CHECK EACH ROW OF KEYS
 KEYPRS	LD	A,(BC)
 	LD	E,A
 	AND	E
 	JR	NZ,STROKE
 	LD	(HL),A
 ;
 ;INC AND ROTATE TO CHECK NEXT ROW
 RECHEK	INC	D
 	INC	L
 	RLC	C
 	LD	A,C
 ;
 ;CHECK IF LAST ROW (NOT INCL. SHIFT)
 	SUB	80H
 	JR	NZ,KEYPRS
 ;
 ;CHECK IF KEYBOARD CLEAR
 	LD	B,7
 CLRMEM	DEC	L
 	ADD	A,(HL)
 	DJNZ	CLRMEM
 	CP	0
 	LD	A,0
 	RET	NZ
 ;
 ;RESET AUTOREPEAT DELAY TO 0
 	LD	(KPLACE),A
 	RET
 ;
 ;KEYSTROKE FOUND ROUTINE
 ;CHECK STATUS OF AUTOREPEAT DELAY LOOP
 STROKE	AND	(HL)
 	JR	Z,FOUND
 	LD	A,(KPLACE)
 	INC	A
 	LD	(KPLACE),A
 	CP	0FFH
 	JR	NZ,RECHEK
 	DEC	A
 	LD	(KPLACE),A
 ;
 ;GET AND SAVE FOUND KEYBOARD BYTE
 	LD	A,E
 FOUND	LD	(HL),E
 ;
 ;START DEBOUNCE ROUTINE
 	PUSH	BC
 	LD	BC,200H
 	CALL	0060H
 	POP	BC
 	LD	A,(BC)
 	AND	E
 	RET	Z
 ;
 ;BEEP ROUTINE ON FOUND KEYSTROKE
 	PUSH	BC
 	PUSH	HL
 	PUSH	AF
 	LD	B,40H
 	LD	A,(PORTFF)
 	AND	0FDH
 	LD	H,A
 	OR	2
 	LD	L,A
 BEEPER	LD	A,L
 	OUT	(0FFH),A
 	LD	A,H
 	OUT	(0FFH),A
 	PUSH	BC
 	LD	B,40H
 FREQCY	DJNZ	FREQCY
 	POP	BC
 	DJNZ	BEEPER
 	POP	AF
 	POP	HL
 	POP	BC
 	JP	KYSCAN
 ;
 ;CHECK FOR STATUS OF BASIC STACK
 BEGIN	EX	(SP),HL
 	LD	A,L
 	CP	5BH
 	JR	NZ,NOTRDY
 	LD	A,H
 	CP	1DH
 NOTRDY	EX	(SP),HL
 	JP	NZ,BYTE
 ;
 ;CHECK TO SEE IF SPECIAL STAR (*) COMMAND
 	CALL	BYTE
 	PUSH	AF
 	CP	0CFH
 	JR	Z,OKSTAR
 	POP	AF
 	DEC	HL
 	JP	1D78H
 OKSTAR	POP	AF
 	CALL	BYTE
 	JR	NZ,SAVE
 SYNERR	JP	1997H
 ;
 ;CHECK STATUS OF SAVE COMMAND
 SAVE	CP	0ADH
 	JR	Z,SAVER
 	CP	0BBH
 	JP	Z,RENEW
 	CP	0A2H
 	JP	Z,OPENER
 	CP	0CCH
 	JP	Z,STPSET
 	CP	0C8H
 	JP	Z,MEMSET
 	CP	0EAH
 ;------------------END OF LOAD SECTION ONE---------------
 ; --------------- BEGINNING OF LOAD SECTION TWO ---------
 	JP	Z,RELOC
 	JP	SYNERR
 SAVER	CALL	BYTE
 ;
 ;CHECK STATUS OF RUN COMMAND
 SLASH1	CP	0D0H
 	JR	NZ,SYNERR
 	CALL	BYTE
 	CP	8EH
 	JP	NZ,MACH
 ;
 ;CHECK FOR QUOTATION MARK DELIMITER
 	CALL	BYTE
 	CP	022H
 	JR	NZ,SYNERR
 ;
 ;CHECK TO SEE THAT NAME IS IN PLACE
 	CALL	BYTE
 	JP	Z,24A0H
 ;
 ;SAVE BASIC STACK POINTERS IN NEW STACK
 	PUSH	HL
 	POP	IY
 	LD	HL,0000
 	ADD	HL,SP
 	LD	SP,CHG3
 	PUSH	HL
 	PUSH	AF
 	PUSH	DE
 	PUSH	BC
 	PUSH	IY
 	POP	HL
 ;
 ;DEFINE TAPE DRIVE 0, TURN ON RECORDER
 	XOR	A
 	CALL	0212H
 ;
 ;WRITE LEADER AND SYNC BYTE TO TAPE
 	CALL	0287H
 ;
 ;WRITE MACHINE PROGRAM CODE 55H TO TAPE
 	LD	A,55H
 	CALL	WRTBYT
 ;
 ;WRITE PROGRAM NAME TO TAPE
 	LD	B,06
 	DEC	HL
 NAMES	CALL	BYTE
 	CP	22H
 	JR	Z,NEXTBT
 	CALL	WRTBYT
 	DJNZ	NAMES
 	JR	DUMP
 ;
 ;FILL OUT WITH 20H (ASCII BLANKS) IF NECESSARY
 NEXTBT	LD	A,20H
 	CALL	WRTBYT
 	DJNZ	NEXTBT
 ;
 ;DUMP FIRST TWO PAGES (4000 TO 41FF) TO TAPE
 DUMP	LD	HL,SETPTS
 	CALL	OUTSEQ
 	CALL	OUTSEQ
 ;
 ;DUMP REST OF POINTERS (4200 TO 42E9) TO TAPE
 	LD	B,0E9H
 	CALL	OUTSEQ
 ;
 ;FIND END OF PROGRAM VARIABLES AND ARRAYS
 	LD	DE,(VAREND)
 ;
 ;DUMP FIRST SEGMENT OF PROGRAM TO TAPE
 	LD	A,E
 	SUB	L
 	LD	B,A
 	CALL	OUTSEQ
 ;
 ;DUMP PROGRAM TO TAPE PAGE BY PAGE
 NXTPGE	LD	A,H
 	DEC	A
 	CP	D
 	JR	Z,FINSH1
 	CALL	OUTSEQ
 	JR	NXTPGE
 ;
 ;FIND BEGINNING OF STRING STORAGE AREA
 FINSH1	LD	HL,(STACKR)
 ;
 ;FIND TOP OF AVAILABLE MEMORY
 	LD	DE,(MEMTOP)
 ;
 ;DUMP FIRST SEGMENT OF STRING-TO-MEMORY END
 	INC	DE
 	LD	A,E
 	SUB	L
 	LD	B,A
 	CALL	OUTSEQ
 ;
 ;DUMP REMAINDER OF MEMORY PAGE BY PAGE
 NXTBCH	LD	A,H
 	DEC	A
 	CP	D
 	JR	Z,KEEPIT
 	CALL	OUTSEQ
 	JR	NXTBCH
 ;
 ;DUMP KEEPIT ROUTINE ITSELF
 KEEPIT	LD	HL,START
 	LD	B,5
 BCDE	PUSH	BC
 	CALL	PREOUT
 	POP	BC
 	DJNZ	BCDE
 ;
 ;DUMP COMPLETE VIDEO MEMORY
 	LD	HL,VIDEO
 	LD	B,4
 CDEF	PUSH	BC
 	CALL	PREOUT
 	POP	BC
 	DJNZ	CDEF
 ;
 ;WRITE END OF PROGRAM CODE (78)
 	LD	A,78H
 	CALL	WRTBYT
 ;WRITE START ADDRESS AFTER LOAD (06CCH)
 	LD	A,0CCH
 	CALL	WRTBYT
 	LD	A,06
 	CALL	WRTBYT
 ;
 ;RESTORE BASIC INFORMATION TO REGISTERS
 	POP	BC
 	POP	DE
 	POP	AF
 	POP	HL
 ;
 ;RESTORE ORIGINAL STACK POINTERS
 	LD	SP,HL
 	PUSH	IY
 	POP	HL
 ;
 ;RETURN TO BASIC PROGRAM IN PROGRESS
 	JR	PREP1
 ;
 ;OUTPUT SEQUENCE SUBROUTINE
 ;WRITE BLOCK HEADER CODE (3C)
 PREOUT	LD	B,0
 OUTSEQ	LD	A,3CH
 	CALL	WRTBYT
 ;
 ;GET NUMBER OF BYTES TO WRITE
 	LD	A,B
 	CALL	WRTBYT
 ;
 ;GET START ADDRESS LSB, SAVE IN C (CHECKSUM)
 	LD	A,L
 	LD	C,A
 	CALL	WRTBYT
 ;
 ;GET START ADDRESS MSB, SAVE IN C (CHECKSUM)
 	LD	A,C
 	ADD	A,H
 	LD	C,A
 	LD	A,H
 	CALL	WRTBYT
 ;
 ;GET BLOCK OF DATA, WRITE, AND SAVE IN C
 WRTPGE	LD	A,C
 	ADD	A,(HL)
 	LD	C,A
 	LD	A,(HL)
 	CALL	WRTBYT
 	INC	HL
 	DJNZ	WRTPGE
 ;
 ;GET CHECKSUM FROM C AND WRITE TO TAPE
 	LD	A,C
 	CALL	WRTBYT
 	RET
 ;THIS IS BEGIN OF RENEW SEQUENCE
 RENEW	LD	DE,(40A4H)
 	LD	A,0FFH
 	LD	(DE),A
 	CALL	1AFCH
 	INC	HL
 	LD	(40F9H),HL
 	LD	SP,(40E8H)
 	CALL	01C9H
 	CALL	1B61H
 PREP1	JP	READY
 ;
 ; GET REST OF DATA AND CONVERT
 OPENER	CALL	BYTE
 	CP	22H
 	JP	NZ,SYNERR
 	PUSH	HL
 	POP	IY
 	CALL	XX99
 	CALL	01C9H
 	JR	NEXT99
 ;
 ; GET 16 SCREEN POSITIONS READY (10H)
 CONTNT	LD	A,D
 	LD	HL,3C40H
 	AND	0F0H
 	CALL	RRRRS
 	LD	A,D
 	AND	0FH
 	CALL	HEXASC
 	LD	(HL),A
 	INC	HL
 	LD	A,E
 	AND	0F0H
 	CALL	RRRRS
 	LD	A,E
 	AND	0FH
 	CALL	HEXASC
 	LD	(HL),A
 	LD	HL,3C80H
 	LD	B,10H
 ;
 ; DISPLAY CONTENTS OF ADDRESS CHOSEN
 CONT02	LD	A,(DE)
 	AND	0F0H
 	CALL	RRRRS
 	LD	A,(DE)
 	AND	0FH
 	CALL	HEXASC
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	INC	DE
 ;
 ; REDO IT 16 TIMES FOR FULL LINE
 	DJNZ	CONT02
 ;
 ; DISPLAY ASCII VALUES TOO
 	LD	B,10H
 	DEC	DE
 	DJNZ	$-1
 	LD	B,10H
 	LD	HL,3CC0H
 BBBA	LD	A,(DE)
 	LD	(HL),A
 	INC	HL
 	INC	HL
 	INC	HL
 	INC	DE
 	DJNZ	BBBA
 	LD	B,10H
 	DEC	DE
 	DJNZ	$-1
 	RET
 ;
 ; SCAN KEYBOARD FOR EDIT SEQUENCE
 ; GET THIRD LINE OF SCREEN
 NEXT99	CALL	CONTNT
 ;
 ; SCAN KEYBOARD FOR BREAK, ARROWS
 EDITOR	LD	A,(3840H)
 	CP	4
 	JR	NZ,ARROW
 	PUSH	IY
 	POP	HL
 	JR	PREP1
 ARROW	CP	10H
 	JR	NZ,AAAA
 	LD	B,10H
 	DEC	DE
 	DJNZ	$-1
 	JR	STNDRD
 AAAA	CP	8
 	JR	NZ,AAAB
 	LD	B,10H
 	INC	DE
 	DJNZ	$-1
 	JR	STNDRD
 AAAB	CP	20H
 	JR	NZ,AAAC
 	DEC	DE
 	JR	STNDRD
 AAAC	CP	40H
 	JR	NZ,AAAD
 	INC	DE
 	JR	STNDRD
 ;
 ; GET FIFTH LINE OF SCREEN
 ; AND DISPLAY CHOSEN EDITING
 AAAD	LD	HL,3D00H
 	LD	(HL),5FH
 	INC	HL
 	LD	(HL),5FH
 	DEC	HL
 	LD	B,2
 AAAE	PUSH	DE
 	PUSH	HL
 	CALL	0049H
 	POP	HL
 	POP	DE
 	CP	47H
 	JR	NC,EDITOR
 	CP	30H
 	JR	C,EDITOR
 	CP	3AH
 	JR	C,AAAF
 	CP	40H
 	JR	C,EDITOR
 AAAF	LD	(HL),A
 	INC	HL
 	DJNZ	AAAE
 ;
 ; CONVERT CHOSEN DATA TO HEX
 	DEC	HL
 	CALL	ASCHEX
 	LD	C,A
 	DEC	HL
 	CALL	LLLLS
 	ADD	A,C
 ;
 ; PUT NEW BYTE IN PLACE
 	LD	(DE),A
 	INC	DE
 ;
 ; DISPLAY REVISED LINE OF DATA
 STNDRD	CALL	CONTNT
 	CALL	DELAY
 	JR	EDITOR
 ;
 ; ASCII TO HEXADECIMAL CONVERSION
 ASCHEX	LD	A,(HL)
 	CP	40H
 	JR	NC,NEXT98
 	SUB	30H
 	RET
 NEXT98	SUB	37H
 	RET
 ;
 ; HEXADECIMAL TO ASCII CONVERSION
 HEXASC	CP	0AH
 	JR	NC,NEXT96
 	ADD	A,30H
 	RET
 NEXT96	ADD	A,37H
 	RET
 ;
 ; RIGHT ROTATES FOR CONVERSIONS
 RRRRS	RRCA
 	RRCA
 	RRCA
 	RRCA
 	CALL	HEXASC
 	LD	(HL),A
 	INC	HL
 	RET
 ;
 ; LEFT ROTATES FOR CONVERSION
 LLLLS	CALL	ASCHEX
 	RLCA
 	RLCA
 	RLCA
 	RLCA
 	RET
 ;
 ; DELAY FOR SCREEN DISPLAYS
 DELAY	LD	BC,2000H
 	CALL	0060H
 	RET
 ;
 ; GET/CONVERT ASCII FROM BUFFER
 ; TO HEXADECIMAL ADDRESS
 XX99	LD	B,4
 SSSS	CALL	BYTE
 	PUSH	AF
 	DJNZ	SSSS
 	POP	AF
 	LD	(HL),A
 	CALL	ASCHEX
 	LD	E,A
 	POP	AF
 	LD	(HL),A
 	CALL	LLLLS
 	ADD	A,E
 	LD	E,A
 	POP	AF
 	LD	(HL),A
 	CALL	ASCHEX
 	LD	D,A
 	POP	AF
 	LD	(HL),A
 	CALL	LLLLS
 	ADD	A,D
 	LD	D,A
 	RET
 ; ABOVE RESULT PLACES ADDRESS
 ; FOR USE IN (DE) REGISTER
 ; --------------- END OF LOAD SECTION TWO --------------
 ; ------------ BEGINNING OF LOAD SECTION THREE ----------
 ;
 ; CHECK FOR "OPEN" COMMAND
 MACH	CP	0A2H
 	JR	NZ,SYN2
 ;
 ; CHECK FOR QUOTATION MARK DELIMITER
 	CALL	BYTE
 	CP	22H
 SYN2	JP	NZ,SYNERR
 ;
 ; TURN ON TAPE DRIVE, WRITE LEADER
 ; AND SYNC BYTE, MACHINE CODE HEADER
 	XOR	A
 	CALL	0212H
 	CALL	0287H
 	LD	A,55H
 	CALL	WRTBYT
 ;
 ; WRITE NAME TO TAPE UNTIL
 ; COMMA DELIMITER IS FOUND
 	LD	B,06
 NAME99	CALL	BYTE
 	CP	2CH
 	JR	Z,NXTB99
 	CALL	WRTBYT
 	DJNZ	NAME99
 	JR	DUMP99
 ;
 ; FILL OUT WITH BLANKS IN NAME
 ; LESS THAN 6 CHARACTERS
 NXTB99	LD	A,20H
 	CALL	WRTBYT
 	DJNZ	NXTB99
 ;
 ; CHECK FOR COMMA DELIMITER
 DUMP99	CALL	BYTE
 	CP	2CH
 	JR	NZ,SYN2
 ;
 ; GET START ADDRESS AND SAVE
 	CALL	XX99
 	PUSH	DE
 ;
 ; CHECK FOR NEXT COMMA DELIMITER
 	CALL	BYTE
 	CP	2CH
 	JR	Z,TTTT
 	POP	DE
 	XOR	A
 	JP	24A0H
 ;
 ; GET END ADDRESS AND SAVE
 TTTT	CALL	XX99
 	PUSH	DE
 ;
 ; CHECK FOR FINAL COMMA DELIMITER
 ; FOR EXECUTION ADDRESS
 	CALL	BYTE
 	CP	2CH
 	JR	Z,EXECU
 ;
 ; PLACE 06CC AS AUTOEXECUTE ADDRESS
 ; IF NONE SPECIFIED
 	LD	A,0CCH
 	LD	(407EH),A
 	LD	A,06
 	LD	(407FH),A
 	JR	WRIT99
 ;
 ; GET EXECUTION ADDRESS
 EXECU	CALL	XX99
 	LD	(407EH),DE
 ;
 ; 16-BIT SUBTRACTION GETS NUMBER
 ; OF BYTES TO WRITE
 ; FIRST GET START ADDRESS AND
 ; PERFORM COMPLEMENT
 WRIT99	POP	HL
 	POP	DE
 	PUSH	DE
 	LD	A,D
 	CPL
 	LD	D,A
 	LD	A,E
 	CPL
 	LD	E,A
 ;
 ; ADD COMPLEMENT TO END ADDRESS,
 ; TO GET NUMBER OF BYTES TO WRITE
 ; ADD 1 FOR SUB, 1 FOR INCLUSIVE
 	ADD	HL,DE
 	INC	HL
 	INC	HL
 ;
 ; TRANSFER BYTES TO WRITE TO DE
 	PUSH	HL
 	POP	DE
 ;
 ; RESTORE START ADDRESS TO HL
 	POP	HL
 	LD	B,E
 ;
 ; ZERO E REGISTER, INC D, TO GET
 ; TOTAL NUMBER OF PAGES TO WRITE
 ; AND SAVE IT
 	INC	B
 	INC	D
 LP99	PUSH	DE
 	CALL	OUTSEQ
 ;
 ; CHECK IF ALL PAGES WRITTEN
 	POP	DE
 	DEC	D
 	JR	NZ,LP99
 ;
 ; WRITE END OF PROGRAM CODE
 	LD	A,78H
 	CALL	WRTBYT
 ; WRITE START ADDRESS AFTER LOAD
 ; DEFAULT TO 06CC IF NOT SPECIFIED
 	LD	A,(407EH)
 	CALL	WRTBYT
 	LD	A,(407FH)
 	CALL	WRTBYT
 ;
 ; RETURN TO COMMAND LEVEL
 	JR	PREP2
 ;
 ; START SETUP OF STEPPER ROUTINE
 ; FIRST FIND IF ARGUMENT EXISTS
 STPSET	PUSH	AF
 	PUSH	HL
 	CALL	BYTE
 	OR	A
 ;
 ; ARGUMENT EXISTS - JUMP TO ROUTINE
 	JR	NZ,IIII
 ;
 ; OTHERWISE JUMP PAST SINGLE STEPPER
 	LD	HL,JMPVAL
 	LD	(HL),0CH
 	POP	HL
 	POP	AF
 	JR	PREP2
 ;
 ; GET VALUE FROM A REGISTER INTO D
 IIII	SUB	30H
 	RLA
 	RLA
 	RLA
 	RLA
 	LD	D,A
 ;
 ; GET NEXT VALUE FROM SCREEN -
 ; GO TO SN ERROR IF NO VALUE
 	CALL	BYTE
 	OR	A
 	JR	NZ,ABCD
 	POP	HL
 	POP	AF
 SYN3	JP	SYNERR
 ;
 ; GET NEXT VALUE FROM BUFFER INTO E
 ABCD	SUB	30H
 	ADD	A,D
 	LD	D,A
 ;
 ; PATCH STEPPER INTO PLACE
 	LD	HL,JMPVAL
 	LD	(HL),00H
 ;
 ; GET DELAY VALUE INTO REGISTER
 ; AND GO OUT TO READY PROMPT
 	LD	HL,HLDVAL
 	LD	(HL),D
 	POP	HL
 	POP	AF
 PREP2	JP	READY
 ;
 ; THIS IS THE STEPPER ROUTINE
 STEPPR	PUSH	AF
 	PUSH	BC
 	DEFB	18H
 JMPVAL	DEFB	0CH
 ;
 ; WAIT FOR SHIFT TO BE PRESSED
 LUPER	LD	A,(3880H)
 	AND	A
 	JR	Z,LUPER
 ;
 ; LOAD DELAY VALUE INTO BC
 	DEFB	01H
 	DEFB	00H
 HLDVAL	DEFB	01H
 ;
 ; CALL DELAY IN ROM
 	CALL	0060H
 ZBF88	POP	BC
 	POP	AF
 ;
 ; BACK TO REST OF TEST SEQUENCE
 	JP	BEGIN
 ;
 ; BEGIN MEMORY RESET SEQUENCE
 ; CHECK FOR QUOTE MARK DELIMITER
 MEMSET	CALL	BYTE
 	CP	22H
 	JR	NZ,SYN3
 ;
 ; SAVE REGISTERS AND CONVERT VALUE
 ; AFTER *MEM TO HEX VALUES
 	PUSH	HL
 	POP	IY
 	CALL	XX99
 ; CHECK FOR >4400H MEMORY ADDRESS
 ; GO TO OM ERROR IF NOT ENOUGH
 	LD	HL,4400H
 	OR	A
 	SBC	HL,DE
 	JP	NC,197AH
 ; TEST FOR MEMORY RESET <FBBBH
 ; OM ERROR IF TOO MUCH
 	LD	HL,0FBBBH
 	OR	A
 	SBC	HL,DE
 	JP	C,197AH
 ;
 ; PUT NEW MEMORY SIZE INTO PLACE
 	LD	(40B1H),DE
 ;
 ; MAKE FRE(A$) MEM SIZE - 50 DECIMAL
 	LD	B,32H
 STRING	DEC	DE
 	DJNZ	STRING
 ;
 ; PUT NEW STRING POINTER IN PLACE
 	LD	(40A0H),DE
 ;
 ; RESTORE REGISTERS, CLEAR SCREEN,
 ; CALL CLEAR, AND DISPLAY MESSAGE
 ; "RADIO SHACK LEVEL II BASIC" AND
 ; READY PROMPT
 	PUSH	IY
 	POP	HL
 	CALL	01C9H
 	CALL	1B61H
 	LD	HL,0111H
 	CALL	28A7H
 	JR	PREP2
 ;
 ;
 RELOC	JR	PREP2
 ;
 ;
 	ORG	VIDEO+40H
 	DEFM	'***** GOOD LOAD *****'
 	DEFM	'RETURN IS TO BASIC '
 	DEFM	'WITHOUT START "/" '
 	DEFM	'*****'
 	END	START
