EPSONJ ;****************************************
 ;*            JKLSYS/SRC                *
 ;*  a NEWDOS 80/2 System-Modification   *
 ;*      of JKL with Graphic-Blocks      *
 ;*         for EPSON-Printers           *
 ;* of Types MX80 II, III , RX80, FX80   *
 ;*                                      *
 ;*         Joachim Kelterbaum           *
 ;****************************************
 	ORG	4D00H	;start system overlay area
 START	EXX		;save registers
 	CALL	INIT	;initialize printer
 	LD	BC,200H	;delay loop
 	CALL	60H	;
 	LD	A,0DH
 	CALL	PRT
 	LD	A,0DH	;2 LF's
 	CALL	PRT	;
 	LD	HL,3C00H-64	;video-RAM linepointer
 	LD	(ZEIAD),HL
 	LD	BC,16	;16 lines
 ZEILE	PUSH	BC	;start of line loop
 	LD	BC,64
 	LD	HL,(ZEIAD)
 	ADD	HL,BC
 	LD	(ZEIAD),HL	;update linepointer
 	LD	DE,BUFTXT
 	LDIR		;transfer line to BUFTXT
 	LD	BC,64
 	LD	DE,BUFGRF
 	LD	HL,(ZEIAD)
 	LDIR		;transfer line to BUFGRF
 	LD	HL,BUFGRF
 	LD	B,64
 BERGRF	LD	A,(HL)	;load char from BUFGRF
 	CP	80H
 	JR	NC,SKIP
 N360	LD	A,80H	;if no graphics,so
 	LD	(HL),A	;replace by 80H
 SKIP	INC	HL	;OK - go on
 	DJNZ	BERGRF
 	LD	HL,BUFTXT
 	LD	B,64
 	LD	A,0
 	LD	(FLG),A	;FLG=0,if no graph. in line
 BERTXT	LD	A,(HL)	;load char from BUFTXT
 	CP	20H
 	JR	NC,NOCTL;intercept CNTL codes
 	ADD	A,40H	;replace by correspond. ASCII
 	JR	CTLSP
 GRFK	LD	A,20H
 CTLSP	LD	(HL),A
 OK	INC	HL
 	DJNZ	BERTXT
 	JR	WEITER
 NOCTL	CP	80H
 	JR	C,OK
 	LD	A,1	;if graphics,so set FLG
 	LD	(FLG),A
 	JR	GRFK	;replace by 20H in BUFTXT
 WEITER	CALL	TEST	;if no graphics,so print
 	JP	Z,FERTIG;and --> FERTIG
 	CALL	ESCS	;initialize graphics-mode
 	LD	B,60
 	LD	A,0
 INDENT	CALL	PRT
 	DJNZ	INDENT	;print 60 bytes of 00H (indent)
 	LD	B,64
 	LD	HL,BUFGRF
 Z1GR	LD	E,0	;clear E
 	LD	A,(HL)	;load char from BUFGRF
 	LD	D,A	;save to D
 	BIT	0,A	;bit 0 set ?
 	JR	Z,NO1	;no, so --> NO1
 	LD	A,E	;yes get E
 	OR	0F0H	;set top 4 bits
 	LD	E,A	;save E
 	LD	A,D	;get char
 NO1	BIT	2,A	;bit 2 set ?
 	JR	Z,NO2	;no, so --> NO2
 	LD	A,E	;yes get E
 	OR	0FH	;set lower 4 bits
 	LD	E,A	;save E
 NO2	LD	A,E	;get E
 	CALL	PR3	;print 3 mal (1/2 char width)
 	LD	E,0	;...
 	LD	A,D
 	BIT	1,A
 	JR	Z,NO13
 	LD	A,E
 	OR	0F0H
 	LD	E,A
 	LD	A,D
 NO13	BIT	3,A
 	JR	Z,NO33
 	LD	A,E
 	OR	0FH
 	LD	E,A
 NO33	LD	A,E
 	CALL	PR3	;like above but with bits 1 & 3
 	INC	HL
 	DJNZ	Z1GR
 	LD	A,27
 	CALL	PRT
 	LD	A,'A'
 	CALL	PRT
 	LD	A,1
 	CALL	PRT	;1 dot linefeed
 	LD	A,0DH
 	CALL	PRT	;LF
 	LD	B,10
 	LD	A,20H
 IND2	CALL	PRT
 	DJNZ	IND2	;10 blanks indent
 	LD	HL,BUFTXT
 	LD	B,64
 ZTXOUT	LD	A,(HL)
 	CALL	PRT
 	INC	HL
 	DJNZ	ZTXOUT	;print textline
 	LD	A,27
 	CALL	PRT
 	LD	A,'A'
 	CALL	PRT
 	LD	A,7
 	CALL	PRT	;7 dots linefeed
 	LD	A,0DH
 	CALL	PRT	;LF
 	CALL	ESCS	;initialize graphics-mode
 	LD	B,60	;lower 2 graphics-blocks
 	LD	A,0	;just like above
 INDG	CALL	PRT
 	DJNZ	INDG
 	LD	B,64
 	LD	HL,BUFGRF
 Z2GR	LD	A,0
 	LD	E,A
 	LD	A,(HL)
 	LD	D,A
 	BIT	4,A
 	JR	Z,NO11
 	LD	A,E
 	OR	0F0H
 	LD	E,A
 NO11	LD	A,E
 	CALL	PR3
 	LD	E,0
 	LD	A,D
 	BIT	5,A
 	JR	Z,NO15
 	LD	A,E
 	OR	0F0H
 	LD	E,A
 NO15	LD	A,E
 	CALL	PR3
 	INC	HL
 	DJNZ	Z2GR
 	LD	A,27
 	CALL	PRT
 	LD	A,'A'
 	CALL	PRT
 	LD	A,4
 	CALL	PRT	;4 dots linefeed
 	LD	A,0DH
 	CALL	PRT	;LF
 FERTIG	POP	BC
 	DEC	BC
 	LD	A,B
 	OR	C
 	JP	NZ,ZEILE	;end of line loop
 	CALL	INIT	;initialize printer
 	EXX		;restore registers
 	XOR	A	;set Z flag (no error cond)
 	RET		;back to system
 TEST	LD	A,(FLG)	;UP
 	CP	0	;if only text in line, so print
 	RET	NZ	;else return
 	LD	B,10
 	LD	A,20H
 LEER	CALL	PRT
 	DJNZ	LEER
 	LD	HL,BUFTXT
 	LD	B,64
 ZX	LD	A,(HL)
 	CALL	PRT
 	INC	HL
 	DJNZ	ZX
 	LD	A,27
 	CALL	PRT
 	LD	A,'2'
 	CALL	PRT	;12 dots linefeed
 	LD	A,0DH
 	CALL	PRT	;LF
 	XOR	A	;set Z flag
 	RET
 INIT	LD	A,27	;UP- initialize printer
 	CALL	PRT
 	LD	A,'R'
 	CALL	PRT
 	LD	A,0
 	CALL	PRT
 	LD	A,27
 	CALL	PRT
 	LD	A,'@'
 	CALL	PRT
 ;	LD      A,27    ;country selection GERMANY
 ;	CALL    PRT     ;leave out in American version
 ;	LD      A,'R'
 ;	CALL    PRT
 ;	LD      A,2
 ;	CALL    PRT
 	RET
 ESCS	LD	A,27	;UP- initialize graphics-mode
 	CALL	PRT
 	LD	A,'K'
 	CALL	PRT
 	LD	A,188
 	CALL	PRT
 	LD	A,1
 	CALL	PRT
 	RET
 PR3	PUSH	BC	;UP- print char 3 times
 	LD	B,3
 PTG	CALL	PRT
 	DJNZ	PTG
 	POP	BC
 	RET
 PRT	PUSH	HL	;print char
 	LD	HL,37E8H
 CHK	BIT	7,(HL)
 	JR	NZ,CHK
 	LD	(HL),A
 	POP	HL
 	RET
 FLG	DEFB	0
 ZEIAD	DEFW	0
 BUFTXT	DEFS	64
 BUFGRF	DEFS	64
 	END	START
