       ;Complete Hex and Decimal Calculator (+/-)
 ;<c> 1983 By Mel Patrick
 	ORG	0F319H		;top 48K systems
 START	CALL	2BH		;look for an M
 	AND	5FH		;convert to upper case
 	CP	'M'		;set memory size?
 	JR	NZ,HEXCAL	;go if not
 	LD	HL,HEXCAL	;get program address
 	DEC	HL		;minus one for set
 	LD	A,(3000H)	;else get a byte
 	CP	0C3H		;test for Model I or III
 	JR	Z,MOD3		;JUMP=Model III
 	XOR	A		;zero out a
 	LD	(4049H),HL	;set memory size Model I
 	JR	SHOWMS		;show message
 MOD3	LD	(4411H),HL	;else set Model III size
 	LD	A,1		;set flag byte
 SHOWMS	LD	(MODEL),A	;store model type
 	LD	HL,MEM		;point to message
 	CALL	DISPLY		;show it on video
 	CALL	49H		;wait for ack.
 HEXCAL	CALL	01C9H		;clear the video
 INIT	LD	HL,TITLE	;point to title
 	CALL	DISPLY		;show it and first prompt
 	CALL	VIDSV		;save video location
 	JP	SWAP		;set input mode
 DOADD	LD	HL,(VIDEO)	;get address
 	LD	(4020H),HL	;reset it now
 	LD	A,(MFLAG)	;test modify flag
 	OR	A		;0=off 1=on
 	JR	Z,NOMOD		;go if off
 	LD	HL,(ANSW1)	;else address to change
 	LD	DE,(ANSW2)	;get second answer
 	LD	(HL),D		;store MSB first
 	INC	HL		;point to next
 	LD	(HL),E		;store LSB second
 	XOR	A		;zero out A
 	LD	(MFLAG),A	;reset modify mode
 	LD	HL,3C40H	;print location
 	LD	DE,QUOFF	;erase string
 	CALL	PRINTM		;erase it
 NOMOD	LD	HL,(ANSW1)	;get first
 	LD	A,(QFLAG)	;query on or off
 	OR	A		;0=off 1=on
 	JR	Z,NOTON		;go if not on
 	LD	A,(HL)		;else get a byte
 	LD	D,A		;move to MSB
 	INC	HL		;point to next
 	LD	A,(HL)		;get next byte
 	LD	E,A		;store in LSB
 	LD	(ANSW2),DE	;store new answer
 NOTON	LD	DE,(ANSW2)	;get second
 	ADD	HL,DE		;get the answer in hl
 	LD	(ADDCAL),HL	;save the answer
 	LD	HL,(ANSW1)	;get first again
 	LD	DE,(ANSW2)	;get second
 	OR	A		;clear any flags
 	SBC	HL,DE		;and subtract them
 	LD	(SUBCAL),HL	;and save in buffer
 	LD	HL,(ANSW2)	;get second
 	LD	DE,(ANSW1)	;get first
 	OR	A		;clear the carry flag
 	SBC	HL,DE		;and calculate it
 	LD	(REVCAL),HL	;and save the answer
 CALC0	LD	HL,(ANSW1)	;get first answer
 	PUSH	HL		;save it
 	LD	DE,HEX1		;hex buffer
 	CALL	BINHEX		;convert to HEX
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,DEC1		;point to decimal buffer
 	CALL	BINASC		;convert to ASCII numbers
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,BIN1		;point to binary buffer
 	CALL	BINARY		;convery to ASCII binary
 	POP	HL		;restore it
 	LD	IX,ASC0		;point to ASCII buffer
 	CALL	ASCVER		;convert and store
 	LD	HL,(ANSW2)	;get B value now
 	PUSH	HL		;save it
 	LD	DE,HEX2		;point to hex buffer
 	CALL	BINHEX		;convert and store
 	POP	HL		;get back number
 	PUSH	HL		;save it again
 	LD	DE,DEC2		;point to decimal buffer
 	CALL	BINASC		;convert and store
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,BIN2		;point to binary buffer
 	CALL	BINARY		;convert and store
 	POP	HL		;get back number
 	LD	IX,ASC1		;point to ASCII buffer
 	CALL	ASCVER		;convert and store
 	LD	HL,(ADDCAL)	;get total of A + B
 	PUSH	HL		;save it
 	LD	DE,HEX3		;point to hex buffer
 	CALL	BINHEX		;convert and store
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,DEC3		;point to decimal buffer
 	CALL	BINASC		;convert and store
 	POP	HL		;restore number
 	LD	DE,BIN3		;point to binary buffer
 	CALL	BINARY		;convert and store
 	LD	HL,(SUBCAL)	;get A-B answer
 	PUSH	HL		;save it
 	LD	DE,HEX4		;point to hex buffer
 	CALL	BINHEX		;convert and store
 	POP	HL		;restore number
 	PUSH	HL		;and save it again
 	LD	DE,DEC4		;point to decimal buffer
 	CALL	BINASC		;convert and store
 	POP	HL		;restore number
 	LD	DE,BIN4		;point to binary buffer
 	CALL	BINARY		;convert and store
 	LD	HL,(REVCAL)	;get B - A answer now
 	PUSH	HL		;save it
 	LD	DE,HEX5		;point to hex buffer
 	CALL	BINHEX		;convert and store
 	POP	HL		;restore count
 	PUSH	HL		;and save it again
 	LD	DE,DEC5		;point to decimal buffer
 	CALL	BINASC		;convert and store
 	POP	HL		;get back number
 	LD	DE,BIN5		;point to binary buffer
 	CALL	BINARY		;convert and store
 MATH	LD	HL,(ANSW1)	;get 1st input
 	LD	DE,(ANSW2)	;get second input
 	LD	A,L		;get LSB byte
 	AND	E		;do logical AND
 	LD	L,A		;put back into L
 	LD	H,00H		;remove MSB byte
 	LD	IX,ASC2		;point to ASCII buffer
 	CALL	ASCS		;convert and store
 	PUSH	HL		;save answer
 	LD	DE,HEX6		;point to buffer
 	CALL	BINHEX		;convert and store
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,DEC6		;point to buffer
 	CALL	BINASC		;convert to decimal
 	POP	HL		;restore number
 	LD	DE,BIN6		;point to binary buff
 	CALL	BINARY		;convert and display
 	LD	HL,(ANSW1)	;get ist input
 	LD	DE,(ANSW2)	;get second input
 	LD	A,L		;get LSB
 	OR	E		;and do logical OR
 	LD	L,A		;replace L
 	LD	H,00H		;reset MSB to zero
 	LD	IX,ASC3		;point to buffer
 	CALL	ASCS		;convert and store
 	PUSH	HL		;save value
 	LD	DE,HEX7		;point to buffer
 	CALL	BINHEX		;convert to HEX
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,DEC7		;point to buffer
 	CALL	BINASC		;convert and store
 	POP	HL		;restore number
 	LD	DE,BIN7		;point to buffer
 	CALL	BINARY		;convert to binary
 	LD	HL,(ANSW1)	;get 1st answer
 	LD	DE,(ANSW2)	;get second input
 	LD	A,L		;get LSB byte
 	XOR	E		;do logical XOR
 	LD	H,00H		;reset MSB to zero
 	LD	L,A		;replace L
 	LD	IX,ASC4		;point to buffer
 	CALL	ASCS		;convert and store
 	PUSH	HL		;save value
 	LD	DE,HEX8		;point to buffer
 	CALL	BINHEX		;convert to hex
 	POP	HL		;restore number
 	PUSH	HL		;save it again
 	LD	DE,DEC8		;point to buffer
 	CALL	BINASC		;convert to decimal
 	POP	HL		;restore number
 	LD	DE,BIN8		;point to buffer
 	CALL	BINARY		;convert to binary
 	LD	HL,ANSWER	;point to screen answers
 	CALL	DISPLY		;show it on video
 INLP	CALL	49H		;wait for inkey
 	CP	5BH		;check for up arrow
 	JP	Z,ADDANS	;go if found
 	CP	0AH		;else down arrow?
 	JP	Z,SUBANS	;go if found
 	CP	09H		;else right arrow?
 	JP	Z,ADANS1	;go if found
 	CP	08H		;else left arrow?
 	JP	Z,SUANS1	;go if found
 	AND	5FH		;convert to upper case
 	CP	'J'		;jump to address
 	JP	Z,DOJMP		;go if yes
 	CP	'D'		;else D for DOS?
 	JP	Z,402DH		;go if yes
 	CP	'H'		;else H for HELP?
 	JP	Z,HELP		;go show help menu
 	CP	'A'		;Re-input A again
 	JP	Z,REINA		;go if yes
 	CP	'B'		;else re-input B?
 	JP	Z,REINA		;go if yes
 	CP	'X'		;swap Hex to Decimal
 	JP	Z,SWAP		;go do it
 	CP	'L'		;want Level II Basic?
 	JR	Z,L2		;go if yes
 	CP	'P'		;copy screen to printer
 	JP	Z,COPY		;go if yes
 	CP	'M'		;modify address A?
 	JP	Z,MODIFY	;go if yes
 	CP	'Q'		;want query of address A
 	JP	Z,QUERY		;go if yes
 	JR	INLP		;else wait for entry
 L2	JP	0A9AH		;return through USR
 MODIFY	LD	A,(QFLAG)	;make sure in query
 	OR	A		;0=no 1=yes
 	JR	Z,INLP		;bypass if not
 	LD	(MFLAG),A	;else set modify to on
 	LD	(EFLAG),A	;set entry to HEX mode
 	LD	HL,3C35H	;video address
 	LD	DE,HMSG		;point to hex
 	CALL	PRINTM		;print the message
 	LD	HL,3C40H	;point to video location
 	LD	DE,MODMSG	;point to modify message
 	CALL	PRINTM		;display it on the video
 MODLP1	LD	A,'B'		;set input to B
 	JP	REINA		;and get the bytes
 QUERY	LD	A,(QFLAG)	;get flag byte
 	OR	A		;0=off 1=on
 	JR	Z,SETON		;set on if off
 	DEC	A		;else turn it off
 	LD	DE,QUOFF	;point to off msg
 	LD	HL,0000H	;reset value B to zero
 	LD	(ANSW2),HL	;now
 SAVQ	LD	(QFLAG),A	;save new status
 	LD	HL,3C00H	;message location
 	CALL	PRINTM		;print the message
 	JP	DOADD		;and redo display
 SETON	INC	A		;turn on flag
 	LD	DE,QUON		;point to ON message
 	JR	SAVQ		;and save status
 ADDANS	LD	HL,(ANSW1)	;get first answer
 	INC	HL		;add one to it
 ANSV	LD	(ANSW1),HL	;save the answer
 BACK	JP	DOADD		;and recalculate
 SUBANS	LD	HL,(ANSW1)	;get first answer
 	DEC	HL		;minus one from it
 	JR	ANSV		;and redo display
 ADANS1	LD	HL,(ANSW2)	;get B input
 	INC	HL		;add one to it
 ADSV1	LD	(ANSW2),HL	;save the answer
 	JR	BACK		;and redo display
 SUANS1	LD	HL,(ANSW2)	;get second input
 	DEC	HL		;minus one from it
 	JR	ADSV1		;and redo display
 SWAP	LD	A,(EFLAG)	;test for hex or decimal
 	OR	A		;0=decimal 1=hex
 	JR	Z,SETHEX	;go if decimal now
 	DEC	A		;else its hex
 	JR	SHOWMD		;go show change
 SETHEX	INC	A		;make it hex
 SHOWMD	LD	(EFLAG),A	;set mode to opposite
 	LD	HL,3C35H	;point to video
 	OR	A		;0=decimal 1=hex
 	JR	Z,SHDEC		;go if decimal
 	LD	DE,HMSG		;else point to HEX
 DODIS	CALL	PRINTM		;print the message
 	JP	DOADD		;and redo video
 SHDEC	LD	DE,DMSG		;point to decimal message
 	JR	DODIS		;and display it
 PRINTM	LD	A,(DE)		;get a byte
 	CP	03H		;end of line?
 	RET	Z		;back if done
 	LD	(HL),A		;else move to screen
 	INC	HL		;point to next
 	INC	DE		;and in message
 	JR	PRINTM		;loop til done
 DOJMP	LD	HL,JPADD	;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,BUFF1	;point to buffer
 	LD	B,4		;hex input only
 	CALL	40H		;get input
 	JP	C,HEXCAL	;restart on BREAK
 	CALL	HEXBIN		;convert to binary
 	JP	(HL)		;and go to address
 VIDSV	LD	HL,(4020H)	;get video address
 	LD	(VIDEO),HL	;save it for now
 	RET			;back to caller
 REINA	SUB	40H		;A=1 B=2
 	DEC	A		;make 0=A , 1=B
 	LD	(AFLAG),A	;store it
 	INC	A		;back to original
 	CP	01H		;1=A for now
 	JR	NZ,BINP		;go if b input
 	LD	A,(EFLAG)	;get entry type
 	OR	A		;0=decimal 1=hex
 	JR	NZ,HTYPE	;go if hex input
 	LD	B,2		;else decimal type
 	JR	FNDPOS		;go now
 HTYPE	LD	B,1		;find first hex type
 	JR	FNDPOS		;and do it
 BINP	LD	A,(EFLAG)	;get entry type
 	OR	A		;0=decimal 1=hex
 	JR	NZ,HTYPE1	;go if hex input
 	LD	B,4		;else its decimal
 	JR	FNDPOS		;and do it
 HTYPE1	LD	B,3		;find hex B input
 FNDPOS	LD	HL,3C00H	;point to start video
 RELP	LD	A,(HL)		;get a byte
 	INC	HL		;point to next
 	CP	80H		;look for space
 	JR	NZ,RELP		;loop til found
 	DJNZ	RELP		;loop for 1 or 2
 	LD	(4020H),HL	;reset video address
 	LD	A,(EFLAG)	;get input type 0=D 1=H
 	LD	B,A		;move to loop
 	LD	A,5		;set limits
 	SUB	B		;subtract to get size
 	LD	B,A		;move to loop
 	LD	(LENGTH),A	;save it
 	LD	A,'.'		;get a period
 	PUSH	HL		;save start position
 SHPER	CALL	33H		;display periods
 	DJNZ	SHPER		;loop for length
 	POP	HL		;restore start point
 	LD	(4020H),HL	;reset cursor
 	LD	IX,BUFF1	;point to buffer
 INPLP0	CALL	49H		;wait for inkey
 	CP	0DH		;enter key?
 	JR	Z,COMPL		;go if done input
 	CP	08H		;backspace key?
 	JR	Z,BCKSPC	;go if yes
 	CP	20H		;check lower limits
 	JR	C,INPLP0	;loop if too low
 	CP	60H		;look for upper case
 	JR	C,LOWER		;go if lower
 	AND	5FH		;convert to upper case
 LOWER	PUSH	AF		;save character
 	LD	A,(LENGTH)	;get length of input
 	OR	A		;test for zero
 	JR	Z,ENOUGH	;go if full size input
 	DEC	A		;else minus 1
 	LD	(LENGTH),A	;and save new value
 	POP	AF		;restore character
 	LD	(HL),A		;show on video
 	LD	(IX),A		;and store in buffer
 	INC	HL		;point to next
 	INC	IX		;point to next
 	JR	INPLP0		;loop for more
 ENOUGH	POP	AF		;restore character
 	JR	INPLP0		;loop back
 BCKSPC	LD	A,(LENGTH)	;get length of input
 	OR	A		;line full?
 	JR	Z,FULINE	;go if yes
 	LD	(HL),'.'	;else put in a period
 FULINE	DEC	HL		;backup one
 	DEC	IX		;back in buffer too
 	LD	A,(HL)		;get a byte
 	CP	80H		;start of input?
 	JR	Z,ATST		;go if yes
 	LD	(HL),'.'	;else replace with .
 	LD	A,(LENGTH)	;get length
 	INC	A		;add one to it
 	LD	(LENGTH),A	;store answer
 	JR	INPLP0		;and loop back for more
 ATST	INC	HL		;point back to same
 	INC	IX		;here too
 	JR	INPLP0		;and loop back
 COMPL	LD	(IX),0DH	;store a C/R in buffer
 	LD	HL,BUFF1	;point to buffer
 	LD	A,(EFLAG)	;get input type
 	OR	A		;0=decimal 1=hex
 	JR	Z,DINP		;go if decimal input
 	CALL	HEXBIN		;else convert to binary
 COMPL1	LD	A,(AFLAG)	;get answer to replace
 	OR	A		;0=A 1=B
 	JR	Z,REPA		;go if A
 	LD	(ANSW2),HL	;else replace B answer
 DOAGIN	JP	DOADD		;and redo video display
 REPA	LD	(ANSW1),HL	;replace answer1
 	JR	DOAGIN		;and redo display
 DINP	CALL	ASCBIN		;convert input to binary
 	JR	COMPL1		;and continue
 HELP	LD	HL,INST1	;point to first set
 	CALL	DHLP		;show the command
 	CALL	49H		;wait for inkey
 	CP	01H		;look for BREAK
 	JR	Z,ENDHLP	;go if all done
 BACK1	LD	HL,INST2	;point to next set
 	CALL	DHLP		;wait for key
 	CALL	49H		;wait for inkey$
 	CP	01H		;BREAK pressed
 	JR	Z,ENDHLP	;go if pressed
 	CP	5BH		;else up arrow
 	JR	Z,HELP		;go if yes
 	LD	HL,INST3	;point to third set
 	CALL	DHLP		;show them
 	CALL	49H		;wait for a key
 	CP	5BH		;reverse one menu?
 	JR	Z,BACK1		;go if yes
 ENDHLP	JP	DOADD		;else restore display
 DHLP	PUSH	HL		;save text location
 	LD	HL,(VIDEO)	;get video address
 	LD	(4020H),HL	;reset cursor address
 	LD	HL,INST		;point to heading
 	CALL	DISPLY		;show it
 	POP	HL		;point to instruction
 	CALL	DISPLY		;show them too
 	LD	HL,CLOSE	;point to closing
 	CALL	DISPLY		;show them
 	RET			;back to caller
 COPY	LD	A,(MODEL)	;get system type
 	OR	A		;0=M1 1=M3
 	JR	Z,COPY1		;go if a Model 1
 BACK0	JP	INLP		;and back to loop
 COPY1	CALL	05D1H		;test for printer
 	JR	NZ,BACK0	;back if not ready
 	LD	HL,3C00H	;else point to video
 CPLP	LD	B,64		;characters per line
 CPLP1	LD	A,(HL)		;get a byte
 	INC	HL		;point to next
 	CP	7FH		;look for graphics
 	JR	C,ALPHA		;go if letters
 	LD	A,20H		;else make it a space
 ALPHA	LD	C,A		;move for print
 LPRT	CALL	3BH		;send it to printer
 	DJNZ	CPLP1		;loop til done
 	LD	A,0DH		;load C/R
 	LD	C,A		;move for LPRINT
 LPRTCR	CALL	3BH		;lprint it
 	LD	A,H		;get MSB address
 	CP	40H		;done?
 	JR	NZ,CPLP		;loop til done
 	JP	INLP		;back to menu select
 DISPLY	LD	A,(HL)		;get a byte
 	CP	03H		;end of message
 	RET	Z		;back if yes
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 HEXBIN	LD	HL,BUFF1	;point to input buffer
 SCAN1	LD	A,(HL)		;get a byte
 	CP	0DH		;look for end of input
 	JR	Z,ENDINP	;go if found
 	CP	':'		;look for letters
 	JR	C,NUMB		;go if a number
 	AND	5FH		;convert to UPPER case
 	LD	(HL),A		;and put it back
 	OR	A		;clear any flags set
 NUMB	INC	HL		;point to next
 	JR	SCAN1		;loop til found
 ENDINP	DEC	HL		;point to last char
 	LD	IX,0000H	;set counter to zero
 	LD	DE,1		;setup 1 count
 	CALL	ADD		;and add
 	LD	DE,16		;setup for 16's
 	CALL	ADD		;and add
 	LD	DE,256		;setup for 256's
 	CALL	ADD		;and add them
 	LD	DE,4096		;last digit place
 	CALL	ADD		;and add them
 END1	PUSH	IX		;move answer to
 	POP	HL		;hl and then
 	RET			;back to caller
 ADD	LD	A,(HL)		;get a byte
 	CP	'0'		;is it a zero
 	JR	Z,NEXT		;go if yes
 	CP	0FFH		;else at start of buffer
 	JR	Z,DONE		;fix call and return
 	CP	'1'		;look for number
 	JR	C,DONE		;go if too low
 	CP	':'		;look for top limit
 	JR	NC,LETTER	;high must be letter
 	SUB	30H		;else make it 0-9
 CALC	LD	B,A		;move loop to B
 ADDIT	ADD	IX,DE		;and add count
 	DJNZ	ADDIT		;loop for count
 NEXT	DEC	HL		;back up one
 	RET			;and back for next
 LETTER	CP	'A'		;look for lower limit
 	JR	C,DONE		;go if too low
 	CP	'G'		;else check high limit
 	JR	NC,DONE		;go if too high
 	SUB	37H		;make it 10-15
 	JR	CALC		;and figure it out
 DONE	POP	IY		;dummy pop
 	JR	END1		;and back with answer
 BINARY	LD	A,H		;get MSB to do
 	CALL	BINER		;and go do it
 	LD	A,20H		;leave a space
 	LD	(DE),A		;put in the buffer
 	INC	DE		;point to next
 	LD	A,L		;get LSB to do
 BINER	LD	B,8		;bits in a word
 BINA	OR	A		;clear any flags
 	RLA			;shift for testing bits
 	PUSH	AF		;save after shift
 	JR	C,SETBIT	;go if 1 digit
 	LD	A,'0'		;else its a zero
 	JR	CONTB		;and continue
 SETBIT	LD	A,'1'		;show its a 1
 CONTB	LD	(DE),A		;store in buffer
 	INC	DE		;point to next
 	POP	AF		;restore previous value
 	DJNZ	BINA		;loop for 8 bits
 	RET			;back to caller
 ASCBIN	LD	HL,BUFF1	;point to input buffer
 ASCA	LD	A,(HL)		;get a byte
 	CP	0DH		;end of input
 	JR	Z,ASCEND	;go if yes
 	INC	HL		;else point to next
 	JR	ASCA		;loop til found
 ASCEND	DEC	HL		;minus one
 	LD	IX,0000H	;reset counter to 0
 	LD	DE,1		;count units
 	CALL	ASCADD		;and count them
 	LD	DE,10		;count 10's
 	CALL	ASCADD		;count them
 	LD	DE,100		;count 100's
 	CALL	ASCADD		;count them
 	LD	DE,1000		;count 1000's
 	CALL	ASCADD		;count them
 	LD	DE,10000	;count 10000'S
 	CALL	ASCADD		;and count them
 ASCFIN	PUSH	IX		;move answer to
 	POP	HL		;hl and then
 	RET			;back to caller
 ASCADD	LD	A,(HL)		;get the number
 	CP	'0'		;look for zero
 	JR	Z,ASCNXT	;go if a zero
 	CP	0FFH		;end of routine
 	JR	Z,ASCDN		;go if done
 	CP	'0'		;now check limits
 	JR	C,ASCDN		;go if out of range
 	CP	':'		;check for too high
 	JR	NC,ASCDN	;go if too high
 	SUB	30H		;else make it a digit
 	LD	B,A		;1 - 9
 ADDASC	ADD	IX,DE		;do an add
 	DJNZ	ADDASC		;loop for count
 ASCNXT	DEC	HL		;back up another
 	RET			;back to routine
 ASCDN	POP	IY		;fix the stack
 	JR	ASCFIN		;and back to caller
 BINHEX	LD	BC,-4096	;count the 4th
 	CALL	BINADD		;count them
 	LD	BC,-256		;count the 3rd
 	CALL	BINADD		;count them
 	LD	BC,-16		;count the 2nd's
 	CALL	BINADD		;count them
 	LD	BC,-1		;count the units
 	CALL	BINADD		;count them
 	RET			;and back to caller
 BINADD	LD	A,0FFH		;set to -1
 BINLP	INC	A		;add one to it
 	ADD	HL,BC		;do a subtract
 	JR	C,BINLP		;loop til out of range
 	OR	A		;clear the flags
 	SBC	HL,BC		;step back one number
 	CP	0AH		;test number or letter
 	JR	NC,BINLET	;must be letter then
 	ADD	A,30H		;else make a digit
 BINSV	LD	(DE),A		;and save it
 	INC	DE		;point to next
 	RET			;back to caller
 BINLET	ADD	A,37H		;make it a letter
 	JR	BINSV		;and save it
 BINASC	LD	BC,-10000	;count 10000's
 	CALL	BINSUB		;count them
 	LD	BC,-1000	;count 1000's
 	CALL	BINSUB		;count them
 	LD	BC,-100		;count 100's
 	CALL	BINSUB		;count them
 	LD	BC,-10		;count 10's
 	CALL	BINSUB		;count them
 	LD	BC,-1		;count units
 	CALL	BINSUB		;count them
 	RET			;back to caller
 BINSUB	LD	A,0FFH		;set to -1
 BSUB	INC	A		;add one to it
 	ADD	HL,BC		;subtract add
 	JR	C,BSUB		;loop til too small
 	OR	A		;clear the flags
 	SBC	HL,BC		;get previous value
 	ADD	A,30H		;make it a digit
 	LD	(DE),A		;store in buffer
 	INC	DE		;point to next
 	RET			;back to subroutine
 ASCVER	LD	A,H		;get MSB
 	CALL	CONVER		;and convert byte
 	LD	(IX),A		;store in buffer
 ASCS	LD	A,L		;get LSB now
 	CALL	CONVER		;convert it
 	LD	(IX+02H),A	;store in buffer
 	RET			;back to caller
 CONVER	CP	' '		;check lower limit
 	JR	C,TOOLOW	;go if too low
 	CP	0C0H		;check high limit
 	JR	NC,TOOLOW	;go if too high
 	RET			;else its ok
 TOOLOW	LD	A,'.'		;replace with period
 	RET			;back to caller
 MODEL	DEFB	00H		;Model I or III type
 EFLAG	DEFB	00H		;0=decimal 1=hex inputs
 MFLAG	DEFB	00H		;modify flag byte
 AFLAG	DEFB	00H		;0=A 1=B replacement
 QFLAG	DEFB	00H		;query on off byte
 LENGTH	DEFB	00H		;input length for rplc
 VIDEO	DEFW	0000H		;address storage
 ANSW1	DEFW	0000H		;first number
 ANSW2	DEFW	0000H		;second number
 ADDCAL	DEFW	0000H		;for A+B calculation
 SUBCAL	DEFW	0000H		;for A-B "	"
 REVCAL	DEFW	0000H		;for B-A "	"
 	DEFB	0FFH		;start input buffer
 BUFF1	DEFS	06H		;maximum of 6 bytes
 TITLE	DEFM	'           Hex/Decimal Calculator Version 3.1'
 	DEFB	0DH
 	DEFM	'               <c> 1983 By Mel Patrick'
 	DEFW	0D0DH
 	DEFB	0FH		;turn off cursor
 	DEFB	03H
 QUON	DEFM	'Query'
 	DEFB	03H
 QUOFF	DEFM	'      '
 	DEFB	03H
 MODMSG	DEFM	'Modify'
 	DEFB	03H
 INST	DEFB	31		;erase til end of frame
 	DEFM	'                 Hexcal Command Functions'
 	DEFB	0DH
 	DEFM	'--------------------------------------------------------------'
 	DEFB	0DH
 	DEFB	03H
 INST1	DEFM	'<D> - will return to Dos Ready Mode.'
 	DEFB	0DH
 	DEFM	'<L> - if program is entered from Level II Basic use this exit.'
 	DEFB	0DH
 	DEFM	'<X> - swap input mode from Hex to Decimal or vice-versa.'
 	DEFB	0DH
 	DEFM	'<J> - jump to any Hex input address.'
 	DEFB	0DH
 	DEFM	'<P> - copy the video display to the line printer.'
 	DEFB	0DH
 	DEFM	'<A> - input a value for A in either Hex or Decimal'
 	DEFB	0DH
 	DEFM	'<B> - input a value for B in either Hex or Decimal'
 	DEFB	0DH
 	DEFB	03H
 INST2	DEFM	'<'
 	DEFB	5BH		;up arrow
 	DEFM	'> - add 1 to value A.
 	DEFB	0DH
 	DEFM	'<'
 	DEFB	5CH		;down arrow
 	DEFM	'> - minus 1 from value A.
 	DEFB	0DH
 	DEFM	'<'
 	DEFB	5EH		;right arrow
 	DEFM	'> - add 1 to value B.
 	DEFB	0DH
 	DEFM	'<'
 	DEFB	5DH		;left arrow
 	DEFM	'> - minus 1 from value B.
 	DEFB	0DH
 	DEFM	'<H> - display this HELP file.'
 	DEFB	0DH
 	DEFB	03H
 INST3	DEFM	'<Q> - will display the contents of memory location A, at value'
 	DEFB	0DH
 	DEFM	'      B. Two bytes will be shown for the memory location and'
 	DEFB	0DH
 	DEFM	'      the memory location plus 1. The bytes will be as they are'
 	DEFB	0DH
 	DEFM	'      in memory, not the usual LSB/MSB format.'
 	DEFB	0DH
 	DEFM	'<M> - will allow a two byte input to replace the normal bytes'
 	DEFB	0DH
 	DEFM	'      at location A. If only 1 byte is input, the other will'
 	DEFB	0DH
 	DEFM	'      default to 0. Bytes are to be input as they are to'
 	DEFB	0DH
 	DEFM	'      appear in memory, not LSB,MSB format.'
 	DEFB	0DH
 	DEFB	03H
 CLOSE	DEFM	'--------------------------------------------------------------'
 	DEFB	0DH
 	DEFM	'                  Press any key to continue'
 	DEFB	03H
 MEM	DEFM	'Memory Size is set, press any key to continue...'
 	DEFB	03H
 JPADD	DEFB	0DH
 	DEFM	'Enter HEX address : '
 	DEFB	03H
 HMSG	DEFM	'Hex    '
 	DEFB	03H
 DMSG	DEFM	'Decimal'
 	DEFB	03H
 ANSWER	DEFM	'  Operation    Hex    Decimal      MSB  Binary  LSB   MSB LSB'
 	DEFB	0DH
 	DEFM	'       A      '
 	DEFB	80H		;graphics space
 HEX1	DEFS	04H		;hex first number
 	DEFM	'   '
 	DEFB	80H		;marker for routine
 DEC1	DEFS	05H		;decimal first number
 	DEFM	'       '
 BIN1	DEFS	17		;binary first number
 	DEFM	'    '
 ASC0	DEFB	00H
 	DEFM	'  '
 	DEFB	0DH
 	DEFM	'       B      '
 	DEFB	80H		;second graphics space
 HEX2	DEFS	04H		;hex second number
 	DEFM	'   '
 	DEFB	80H		;marker for routine
 DEC2	DEFS	05H		;decimal second number
 	DEFM	'       '
 BIN2	DEFS	17		;binary second number
 	DEFM	'    '
 ASC1	DEFB	00H
 	DEFM	'  '
 	DEFB	0DH
 	DEFM	'   A + B       '
 HEX3	DEFS	04H		;hex answer
 	DEFM	'    '
 DEC3	DEFS	05H		;decimal answer
 	DEFM	'       '
 BIN3	DEFS	17		;binary answer
 	DEFB	0DH
 	DEFM	'   A - B       '
 HEX4	DEFS	04H		;hex answer
 	DEFM	'    '
 DEC4	DEFS	05H		;decimal answer
 	DEFM	'       '
 BIN4	DEFS	17		;binary answer
 	DEFB	0DH
 	DEFM	'   B - A       '
 HEX5	DEFS	04H
 	DEFM	'    '
 DEC5	DEFS	05H		;decimal answer
 	DEFM	'       '
 BIN5	DEFS	17		;binary answer
 	DEFW 0D0DH
 	DEFM	'          <A B> Logical Operations (LSB only)'
 	DEFB	0DH
 	DEFM	'   <AND>       '
 HEX6	DEFS	04H		;hex answer
 	DEFM	'    '
 DEC6	DEFS	05H		;decimal answer
 	DEFM	'       '
 BIN6	DEFS	17
 	DEFM	'    '
 ASC2	DEFM	'   '
 	DEFB	0DH
 	DEFM	'   <OR >       '
 HEX7	DEFS	04H		;hex answer
 	DEFM	'    '
 DEC7	DEFS	05H		;decimal answer
 	DEFM	'       '
 BIN7	DEFS	17		;binary answer
 	DEFM	'    '
 ASC3	DEFM	'   '
 	DEFB	0DH
 	DEFM	'   <XOR>       '
 HEX8	DEFS	04H		;hex answer
 	DEFM	'    '
 DEC8	DEFS	05H		;decimal answer
 	DEFM	'       '
 BIN8	DEFS	17		;binary answer
 	DEFM	'    '
 ASC4	DEFM	'   '
 	DEFW	0D0DH
 	DEFM	'Commands :D,L,J,X,Q,M,A,B,P, <Arrow Keys>, Help'
 	DEFB	03H
 	END	START
