;   ****************************
;   *                          *
;   *          HEXDUMP2        *
;   *   (C)2001 Michael Monck  *
;   *                          *
;   ****************************

*GET	DOSSVC/ASM		;Get service macros

	ORG	5000H		;Start address

NPL	EQU	16D		;Def Num of bytes per line
MAXBPL	EQU	18D		;Maximum allowed BPL+1
DEFWL	EQU	23D		;Default wait lines

START	PUSH 	HL		;Save commandline
;Display welcome message
	LD	HL,SMSGL1	;Line 1
	DOSSVC	@DSPLY		;Display line 1
	LD	HL,SMSGL2	;LINE 2
	DOSSVC	@DSPLY		;DISPLAY LINE 2

	POP	HL		;GET COMMANDLINE
	LD	DE,FCB		;GET FCB
	DOSSVC	@FSPEC		;DO IT
	JP	Z,PPMS		;Everythings OK
;There was a filename error, so display usage
	LD	HL,USAGE1	;Usage line 1
	DOSSVC	@DSPLY
	LD	HL,USAGE2	;Usage line 2
	DOSSVC	@DSPLY
	LD	HL,USAGE3	;Usage line 3
	DOSSVC	@DSPLY
	LD	HL,USAGE4	;Usage line 4
	DOSSVC	@DSPLY
	LD	A,19D		;BAD FILE ERROR
	JP	DERROR		;GO IF ERROR (19)
; Process params
PPMS	LD	DE,PRMTBL$	;Get param table
	DOSSVC	@PARAM		;Process params
	JP	NZ,DERROR	;Error processing params

;Initialization stuff (changed by param routine)
;BPL Bytes Per Line (Must be >0 <=18 def 16)
PMBPL	LD	BC,NPL		;Default
	LD	A,C		;Ignore MSB
	CP	1		;Is > 0?
	JP	M,ERBPL		;No - error
	CP	MAXBPL		;Is > MAXBPL?
	JP	P,ERBPL		;No - error
	LD	(NBPL),A	;Store for later
;WAIT Causes enter to continue per screen
PMWAIT	LD	BC,0		;Default
	LD	A,C		;LSB
	LD	(WAIT),A	;Store it (Booleen)
;WLINES Causes wait to occure at this point
PMWLIN	LD	BC,DEFWL	;Load default WL 
	LD	A,C		;LSB only
	LD	(WLDEF),A	;Store for later

; Open the file for reading
	LD	HL,DBUFF	;GET DISK BUFFER
	LD	DE,FCB		;GET FILE CONTROL BLOCK
	LD	B,0		;LOGICAL RECORD LENGTH 0=256
	DOSSVC	@OPEN		;OPEN FILE
	JP	Z,ST01		;No error
	CP	42D		;LRL fault?
	JP	NZ,DERROR	;No, then error

; Force CR and print initial heading
ST01	LD	HL,CR		;Get CR
	DOSSVC	@DSPLY		;Output it
	CALL	POSET   	;Print initial offset
	LD	HL,BREAK	;Get break vector
	DOSSVC	@BREAK		;Set it
	CALL	RSTSTR		;Reset char string

; Main character loop
HD00	LD	DE,FCB
	DOSSVC	@GET		;Get char
	JP	NZ,HD99		;Error or EOF
; Got a byte from file.
; Convert byte to hex8 ascii
	LD	HL,BBUF		;Get buffer address
	LD	(HL),A		;Store byte
	LD	C,(HL)		;Get byte into C
	LD	HL,H8BUF	;Get H8 buffer
	DOSSVC	@HEX8		;Convert to ascii

; Output HEX8 at current cursor position
	LD	HL,H8BUF	;Get H8 buffer
	DOSSVC	@DSPLY		;Output H8

; Update print string
	LD	A,(BBUF)	;Get char
	CALL	PLSTR		;Place char in string

; Update counters
	LD	HL,(CBYTE)	;Get current byte count
	LD	A,(CLINE)	;Get line byte count
	LD	B,A		;Transfer to B
	INC	B		;Increase B
	INC	L		;Increase L
	LD	A,L		;Transfer L
	CP	0		;Has L overflowed?
	JR	NZ,HD10		;No, do nothing
	INC	H		;Yes, adjust high bit
HD10	LD	A,(NBPL)	;Get BPL
	LD	C,A		;Transfer to C
	LD	A,B		;Transfer B
	CP	C		;Finished line?
	JR	NZ,HD20		;No, place counters back
	LD	B,0		;Reset B to 0
HD20	LD	(CBYTE),HL	;Store HL
	LD	A,B		;Transfer B
	LD	(CLINE),A	;Store it
; Do any offset line output, and continue loop
	LD	A,B
	CP	0		;Has A been reset?
	JP	NZ,HD00		;No, go on to next byte
; Must correct char position here
	CALL	PRTSTR		;Print char string
	CALL	RSTSTR		;Reset output string
	CALL	SWAIT		;Do wait if needed
	CALL	POSET		;Output offset
	JP	HD00		;Move on

; OK, If error is not EOF, call DERROR, otherwise CR and finish
HD99	PUSH	AF		;SAVE A
	LD	HL,0H		;Reset break vector
	DOSSVC	@BREAK		;Reset it now
	LD	DE,FCB		;Get FCB
	DOSSVC	@CLOSE		;Close file
	POP	AF		;Restore A
	CP	28D		;Check for EOF error
	JP	NZ,DERROR	;Not EOF, so error
	CALL	PSTRP   	;Position to end
	CALL	PRTSTR		;Output last char string
	CALL	RSTSTR		;Reset char string
	LD	HL,CR		;Get CR address
	DOSSVC	@DSPLY		;OUTPUT IT
	RET			;All Done

; POSET - Print Offset (held in HL)
POSET	LD	DE,(CBYTE)	;Get word to convert
	LD	HL,H16BUF	;Get buffer
	DOSSVC	@HEX16		;Convert to ascii
	LD	HL,H16BUF	;Get output buffer
	DOSSVC	@DSPLY		;Output buffer
	RET			;Done 

; Places char (in A) into string
PLSTR	PUSH	AF		;Preserve A
	LD	A,(CLINE)	;Get current byte pos
	LD	E,A		;Transfer to E
	POP	AF		;Restore A
	LD	D,0		;Ready DE
	CP	31D		;Is char >31
	JP	M,PL99		;Yes, do nothing
	CP	127D		;Is char <128
	JP	M,PL10		;Yes, printable char
	JP	PL99		;No, do nothing
PL10	PUSH 	DE		;Prep xfer de -> ix
	POP	IX		;DE->IX
	LD	DE,STRBUF	;Get strbuf address
	ADD	IX,DE		;Add to IX
	LD	(IX),A		;Store char
PL99	RET			;Done

; Output string
PRTSTR	LD	HL,PRESTR	;Get Pre-String output
	DOSSVC	@DSPLY		;Print it
	LD	HL,STRBUF	;Get string buffer
	DOSSVC	@DSPLY		;Print it
	RET			;Done

; Resets string output
RSTSTR	LD	IX,STRBUF	;Get string buffer
	LD	B,'.'		;Get filler char
	LD	A,(NBPL)	;Get BPL
	LD	C,A		;Trabsfer to C
	LD	A,0		;Number of chars
RST10	INC	A		;Increase counter
	INC	IX		;Increase buffer pos
	CP	C		;Done?
	JP	Z,RST99		;Yes
	LD	(IX),B		;Place char
	JP	RST10		;More.
RST99	NOP			;Ready for end char
	LD	A,(CR)		;CR
	LD	(IX),A		;Store CR at end char
	RET			;Done

PSTRP	LD	A,(NBPL)	;Get BPL
	LD	C,A		;Trabsfer to C
	LD	E,NCPL		;Num of chars per line
	DOSSVC	@MUL8		;Multiply
	PUSH	AF		;save result
	LD	A,(CLINE)	;Get current line
	LD	C,A		;Transfer to C
	LD	E,NCPL		;Load num chars per line
	DOSSVC	@MUL8		;Multiply
	LD	B,A		;Transfer to B
	POP	AF		;Retrieve A
	SUB	B		;Take B off
	LD	H,A		;Trabsfer to H
; H now holds the number of spaces to output
	LD	C,' '		;Space char
	LD	L,0		;Use as counter
TRP10	DOSSVC	@DSP		;Output it
	INC	L		;Increase counter
	LD	A,H		;Trabsfer MAX to A
	CP	L		;Finished?
	JP	Z,TRP99		;Yes
	JP	TRP10		;No, do it again
TRP99	RET			;Done

ERBPL	LD	HL,EBPLS	;Get BPL error string
	DOSSVC	@DSPLY		;Display error
	RET			;Exit program

; Handles screen waiting
SWAIT	LD	A,(WAIT)	;Get wait flag
	CP	0		;Is it set?
	RET	Z		;No, return
	LD	A,(WLDEF)	;Get wait line def
	LD	B,A		;Transfer to B
	LD	HL,WLCNT	;Get line count add
	INC	(HL)		;Increase line count
	LD	A,(HL)		;Get line count
	CP	B		;Have we reached it yet?
	RET	NZ		;No, return
; Reached wait line count, so reset it first
	LD	A,0		;Load 0
	LD	(HL),A		;Store it back
; Display 'press enter' text, and get key
	LD	HL,WTXT		;Get address of wait text
	DOSSVC	@DSPLY		;Display it
	DOSSVC	@KEY		;Wait for a key
	LD	HL,CR		;Get line feed
	DOSSVC	@DSPLY		;Line feed
	RET			;Done

; Handles break key
BREAK	LD	B,80H		;Debounce Break key
	DOSSVC	@PAUSE		;Do it
	LD	HL,0H		;Clear Break vector
	DOSSVC	@BREAK		;Do it
	LD	HL,FCB		;Get FCB
	DOSSVC	@CLOSE		;Close file
	LD	HL,CR		;CR
	DOSSVC	@DSPLY		;Newline
	LD	HL,BRKM		;Break message
	DOSSVC	@DSPLY		;Display message
	LD	A,0		;Get ready to exit
	DOSSVC	@EXIT		;Quit program

*GET	DERROR/ASM		;DERROR subroutine

SMSGL1	DB	'HEXDUMP - 2.0.0 - Copyright April, 2001 by Michael Monck.',13D
SMSGL2	DB	'All rights reserved.  Release into freeware.',13D
BRKM	DB	'Break.',13D
EBPLS	DB	'Bytes per line (BPL) must be between 1 and 17 inclusive.',13D
WTXT	DB	'Press any key to continue',03D
USAGE1	DB	'Usage:hexdump filespec (BPL=n,WAIT=ON,WLINES=x)',13D
USAGE2	DB	'Param:BPL - Bytes on each line (1-18) (default=16)',13D
USAGE3	DB	'      WAIT - Turn on screen pause (default=off)',13D
USAGE4	DB	'      WLINES - Waits every x lines (default=23)',13D
NBPL	DB	0		;Number of bytes per line
WAIT	DB	0		;Wait flag
WLCNT	DB	0		;Wait line count
WLDEF	DB	0		;Line# to wait on
CBYTE	DW	0		;Current byte counter
CLINE	DB	0		;Line counter
BBUF	DB	0		;Byte buffer
H8BUF	DS	2		;2 Byte HEX8 buffer
	DB	' '		;Space
	DB	03H		;ETX termination
NCPL	EQU	3		;Num chars per output
H16BUF	DS	4		;4 Byte HEX16 buffer
	DB	' - '		;
	DB	03H		;ETX termination
PRESTR	DB	'  ',03H	;Pre string output
CR	DB	13D		;CR
STRBUF	DS	32		;String buffer
FCB	DS	32		;File Control Block
DBUFF	DS	256		;Disk file buffer

;PARAM table
PRMTBL$	DB	'BPL   '	;BPL paramater
	DW	PMBPL+1		;Past LD instruction
	DB	'WAIT  '	;WAIT paramater
	DW	PMWAIT+1	;Past LD instruction
	DB	'WLINES'	;WAIT lines
	DW	PMWLIN+1	;Past LD instruction
	DB	0		;End param table

	END	START
                                                                                