        ORG     5200H
ENTRY   CALL    TITLE         ;print heading
CHECK   LD      A,(HL)        ;get byte from string
        INC     HL            ;point to next
        CP      20H           ;parse space
        JR      Z,CHECK
        CP      ','           ;parse commas
        JR      Z,CHECK
        CP      13            ;null ?
        JR      Z,LIST        ;display list of params
        DEC     HL            ;point to first character
        CALL    PARSE         ;check if in table
        JP      NZ,SHOWIT     ;display the text
        CALL    NOTHERE       ;display "not found" msg
LIST    LD      HL,TABLE1     ;point to table of words
LOOP1   LD      C,0           ;length counter
LOOP2   LD      A,(HL)        ;get a byte
        AND     7FH           ;turn off high bit
        CALL    33H           ;display a byte
        INC     HL            ;point to next one
        INC     C             ;bump counter
        LD      A,(HL)        ;get next byte
        BIT     7,A           ;end of word ?
        JR      Z,LOOP2+3     ;continue if not
NEXTONE AND     7FH           ;check for terminator
        RET     Z             ;back to DOS
        LD      A,8           ;8 chars / word
        SUB     C             ;remove length
        LD      B,A           ;give to counter
        LD      A,20H         ;print spaces
SPACES  CALL    33H           ;print it
        DJNZ    SPACES
        JR      LOOP1         ;print next word
TITLE   PUSH    HL            ;save string pointer
LOOP3   LD      A,(HL)        ;get a byte
        CP      13
        JR      Z,LOOPD       ;done with adjust
        CALL    UCASE         ;make it upper case
        LD      (HL),A        ;put it back
        INC     HL            ;point to next one
        JR      LOOP3         ;input string in upper now
LOOPD   LD      HL,MSG0       ;title message
        CALL    PRINT         ;display it
        POP     HL            ;restore string pointer
        RET                   ;length now in C
PRINT   LD      A,(HL)        ;get a byte
        CP      8             ;<8 terminator
        RET     C
        CALL    33H           ;display the byte
        CP      13            ;13 terminator
        RET     Z
        INC     HL            ;point to next
        JR      PRINT
NOTHERE LD      HL,MSG1       ;"not found" message
        JR      PRINT         ;display and return
SHOWIT  EX      DE,HL         ;DE => help text
        JR      PRINT         ;display and return
PARSE   LD      DE,TABLE1     ;table of words
        LD      C,0           ;counter register
LOOP4   LD      A,(DE)        ;get table byte
        CALL    UCASE         ;make it upper
        CP      (HL)          ;same as input ?
        JR      NZ,NEXTWORD   ;do next one
        INC     DE            ;bump table
        INC     HL            ;bump string
        LD      A,(HL)        ;that all ?
        CP      'A'           ;alphabetic ?
        JR      C,FOUND       ;have a match
        LD      A,(DE)        ;get next table byte
        BIT     7,A           ;start of next word ?
        JR      Z,LOOP4       ;continue this word
        DEC     DE            ;adjust for nextword
NEXTWORD INC    DE            ;look at next byte
        LD      A,(DE)        ;get it
        BIT     7,A           ;start of word ?
        JR      Z,NEXTWORD    ;continue
        AND     7FH           ;terminator ?
        RET     Z             ;word not found
        INC     C             ;else bump counter
        JR      LOOP4         ;do the next one
FOUND   LD      B,0           ;set MSB to 0
        SLA     C             ;double C counter for table
        LD      HL,TABLE2     ;table of words
        ADD     HL,BC         ;point to text address
        LD      E,(HL)        ;get lsb
        INC     HL
        LD      D,(HL)        ;get msb
        OR      1             ;set NZ flag
        RET
UCASE   CP      60H           ;already uppercase ?
        RET     C
        AND     5FH           ;remove high bit and LC
        RET
TABLE1  DB      'A'+80H,'uto'
        DB      'A'+80H,'ttrib'
        DB      'D'+80H,'ir'
        DB      'F'+80H,'ree'
        DB      80H         ;terminator
TABLE2  DW      AUTO
        DW      ATTRIB
        DW      DIR
        DW      FREE
MSG0    DB      1CH,1FH     ;clear screen
        DB      '* LDOS HELP UTILITY * by Skip Taylor',10
        DB      '(c)(p) 1981 Skip Taylor Inc.',10,13
MSG1    DB      'I don',27H,'t recognize that command',10
        DB      'Words I know are ...',10,13
AUTO    DB      'This is the auto command.',13
ATTRIB  DB      'Attrib description.',13
DIR     DB      'Directory command.',13
FREE    DB      'Free space text.',13
	END	ENTRY
