       ;Routine to Format EDTASM text to the printer.
 ;Program name <EDTFMT/CMD> <c>1983 by Mel Patrick
 	ORG	0C000H		;start of graphics
 GETDAT	EQU	4470H		;NewDos, Dos+
 GETTM	EQU	446DH		;"	    "
 	ORG	6000H		;start of program
 EDTFMT	LD	HL,BUFFER	;point to buffer
 	LD	(POINT),HL	;set eof in buffer
 CMD	CALL	01C9H		;clear screen
 	XOR	A		;remove chain flag
 	LD	(CHFLAG),A	;from memory
 	CALL	GTSIZE		;get program length
 	LD	HL,MENU		;point to selections
 	CALL	DISPLY		;go show them
 CMDLP	CALL	49H		;wait for INKEY
 	AND	5FH		;convert to upper case
 	PUSH	AF		;save the character
 	CALL	33H		;display it
 	POP	AF		;get character back
 	CP	'L'		;Load a file?
 	JP	Z,LOAD		;go if yes
 	CP	'V'		;View a file?
 	JP	Z,VIEW		;go if yes
 	CP	'F'		;Format a FILE?
 	JP	Z,PRINT		;go if yes
 	CP	'E'		;Exit to Dos?
 	JP	Z,402DH		;back to Dos
 	CP	'R'		;remove all remarks?
 	JP	Z,KILREM	;yes then kill rems
 	CP	'D'		;want a directory?
 	JP	Z,DODIR		;yes then display it
 	CP	'W'		;write ASCII file?
 	JP	Z,WRASC		;go if yes
 	CP	'C'		;chain files?
 	JP	Z,DOCHN		;go if yes
 	LD	A,08H		;do a backspace
 	CALL	33H		;display it
 	JR	CMDLP		;back if not valid
 DOCHN	XOR	A		;remove totals
 	LD	(CHNTOT),A	;make it zero
 	LD	HL,CHFILE	;point to text buffer
 	LD	(TEMP),HL	;save buffer start
 	CALL	01C9H		;clear video
 	LD	HL,TITLE	;point to title
 	CALL	DISPLY		;show it
 	LD	B,09H		;maximum inputs
 INPLP	PUSH	BC		;do input loop
 INPLP0	LD	HL,SPEC		;point to prompt
 	CALL	DISPLY		;show it
 	LD	A,(CHNTOT)	;get total
 	ADD	A,31H		;make it ASCII number
 	CALL	33H		;display it
 	LD	A,':'		;get a colon
 	CALL	33H		;display it
 	LD	A,20H		;space
 	CALL	33H		;display it
 	LD	HL,(TEMP)	;get input address
 	LD	B,20H		;maximum input bytes
 	CALL	40H		;get input line
 	JR	C,COMPL		;go if BREAK for end
 	LD	A,B		;check for input
 	OR	A		;test for zero
 	JR	Z,INPLP0	;repeat if no input
 	LD	D,00H		;setup for add
 	LD	E,A		;E=total characters
 	INC	E		;add 1 to it
 	LD	HL,(TEMP)	;get buffer address
 	ADD	HL,DE		;find new address
 	LD	(TEMP),HL	;save it
 	LD	A,(CHNTOT)	;get total chained
 	INC	A		;add 1 to it
 	LD	(CHNTOT),A	;save it again
 	POP	BC		;get back count
 	DJNZ	INPLP		;loop for 10 max.
 COMPL	LD	A,(CHNTOT)	;get chain total
 	OR	A		;anything?
 	JP	Z,CMD		;go back if not
 	LD	(CHFLAG),A	;else set chain flag
 	LD	HL,CHFILE	;point to chain files
 	LD	(TEMP),HL	;point to first to get
 	CALL	CHAIN		;read in first file
 	LD	A,(CHNTOT)	;get total
 	INC	A		;add 1 for mode
 	LD	(CHNTOT),A	;save new total
 	JP	PRINT		;and start routine
 WRASC	LD	HL,LTEXT	;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,FCB		;point to filespec
 	LD	B,20		;length of input
 	CALL	40H		;get input
 	JP	C,CMD		;back if break
 	XOR	A		;else zero out A
 	OR	B		;check for entry
 	JR	Z,WRASC		;redo if none
 	LD	DE,FCB		;point to filespec
 	LD	HL,EXTEN2	;point to TXT
 	CALL	4473H		;and append it
 	LD	HL,IO		;point to dummy
 	LD	DE,FCB		;point to filespec
 	LD	B,00H		;set LRL=256
 	CALL	4420H		;open or create
 	JP	NZ,ERROR	;go if error
 	LD	A,01H		;set flag byte
 	LD	(DISK),A	;store for now
 	JP	VIEW1		;and goto routine
 PRINT	LD	A,01H		;set print flag
 	LD	(PFLAG),A	;set for hardcopy
 	LD	HL,0001H	;reset to page 1
 	LD	(PNUM),HL	;save value
 	LD	HL,CMSG		;point to message
 	CALL	DISPLY		;show it
 	LD	HL,COMMEN	;point to buffer
 	LD	B,40		;maximum input
 	CALL	40H		;wait for input
 	JP	C,CMD		;back on break
 	JP	VIEW		;go for print copy now
 DISPLY	LD	A,(HL)		;get a byte
 	CP	03H		;end of msg
 	RET	Z		;back if yes
 	CALL	33H		;else show it
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 LOAD	LD	HL,BUFFER	;point to buffer
 	LD	DE,(POINT)	;check end address
 	RST	18H		;compare end to start
 	JR	Z,LOAD1		;go if no file in memory
 	LD	HL,PMSG		;else point to msg
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for input
 	PUSH	AF		;save character
 	CALL	33H		;display it
 	POP	AF		;restore the character
 	CP	'Y'		;Y= yes to append
 	JR	NZ,LOAD1	;go if straight load
 	LD	A,01H		;set append flag
 	LD	(AFLAG),A	;save the byte
 	JR	ALOAD		;go append to file
 LOAD1	LD	HL,BUFFER	;zero out end
 	LD	(POINT),HL	;end =start now
 ALOAD	LD	HL,0000H	;reset sector number
 	LD	(NUM),HL	;zero it out
 	LD	HL,LTEXT	;point to message
 	CALL	DISPLY		;show it
 	LD	HL,FCB		;point 32 byte fcb
 	LD	B,20H		;maximum input len
 	CALL	40H		;go get input
 	JP	C,CMD		;back if break
 ALOAD1	LD	DE,FCB		;point to file block
 	LD	HL,EXTEN1	;point to ASM
 	CALL	4473H		;append file extent
 	LD	HL,IO		;256 byte buffer
 	LD	DE,FCB		;point to filespec
 	LD	B,00H		;256 bytes LRL
 	CALL	4424H		;open but not create
 	JR	Z,READ		;go if filename accepted
 	SET	7,A		;return to caller
 	RES	6,A		;emphasized message
 	CALL	4409H		;display it
 	CALL	49H		;wait for inkey
 	LD	A,(CHFLAG)	;test for chain
 	OR	A		;0=no chain
 	JP	Z,CMD		;go if normal load
 	POP	HL		;else fix stack
 	POP	HL		;again
 	JP	CMD		;and back to menu
 READ	LD	HL,(POINT)	;get buffer address
 RDLP	LD	DE,FCB		;point to file
 	CALL	13H		;get a byte
 	CP	0D3H		;proper file
 	JP	NZ,ERR		;go if different
 	PUSH	AF		;save the character
 	LD	A,(AFLAG)	;append on or off
 	OR	A		;0=off 1=on
 	JR	Z,RDLP0		;continue if off
 	POP	AF		;else want to append
 	LD	B,6		;bytes to skip past
 APLP	LD	DE,FCB		;point to control
 	CALL	13H		;read a byte
 	JP	NZ,ERROR	;go if error
 	DJNZ	APLP		;loop through filename
 	JR	RDLP1		;continue and append
 RDLP0	POP	AF		;get back character
 	LD	(HL),A		;else store it
 	INC	HL		;point to next
 RDLP1	LD	DE,FCB		;point to file
 	CALL	13H		;read in a byte
 	LD	(HL),A		;store in the buffer
 	CP	1AH		;end of file
 	JR	Z,ENDFIL	;go if done
 	INC	HL		;else point to next
 	CALL	BLINK		;blink a *
 	XOR	A		;zero out A
 	LD	(HL),A		;put it in memory
 	CP	(HL)		;and test to see if stays
 	JR	Z,RDLP1		;continue if ok
 	DEC	HL		;else back up 1
 	LD	(HL),1AH	;set eof marker
 	PUSH	HL		;save it
 	LD	HL,ERR3		;point to error msg
 	CALL	DISPLY		;show it
 	POP	HL		;get back end address
 ENDFIL	LD	(POINT),HL	;store ending address
 	LD	HL,CMSG		;point to message
 	CALL	DISPLY		;show it
 	XOR	A		;reset append flag
 	LD	(AFLAG),A	;save it
 	INC	A		;set convert flag to ON
 	LD	(CFLAG),A	;set in buffer
 	LD	HL,BUFFER	;point to buffer
 CON	LD	A,(HL)		;get a byte
 	CP	';'		;look for semicolon
 	CALL	Z,TOGGLE	;turn off convert
 	CP	0DH		;end of line?
 	JR	Z,NEWLN		;go if yes
 	CP	1AH		;end of file
 	JR	NZ,CON0		;continue if not done
 	LD	A,(CHFLAG)	;test for chaining
 	OR	A		;0=no, 1=yes
 	JP	Z,CMD		;back if not
 	RET			;else return to caller
 CON0	CP	27H		;look for shift 7 too
 	CALL	Z,TOGGLE	;turn off convert
 	PUSH	AF		;save byte
 	LD	A,(CFLAG)	;convert 0=off 1=yes
 	OR	A		;yes or no
 	JR	Z,CONOFF	;go if off
 	POP	AF		;else convert is on
 	CP	'a'		;check lower case a
 	JR	C,CON1		;go if lower
 	CP	7BH		;else lower case z+1
 	JR	NC,CON1		;go if too high
 	AND	5FH		;else make it upper
 	LD	(HL),A		;and store it back
 CON1	INC	HL		;point to next
 	JR	CON		;loop til done
 CONOFF	POP	AF		;restore character
 	JR	CON1		;and continue
 NEWLN	LD	A,1		;turn on covert mode
 	LD	(CFLAG),A	;set convert flag
 	JR	CON1		;and continue
 TOGGLE	PUSH	AF		;save character
 	XOR	A		;turn off convert mode
 	LD	(CFLAG),A	;save byte
 	POP	AF		;get back character
 	RET			;back to caller
 BLINK	LD	A,(3C3EH)	;get character
 	XOR	0AH		;blink a spact
 	LD	(3C3EH),A	;show it now
 	RET			;back to caller
 DODIR	LD	HL,DMSG		;point to dir message
 	CALL	DISPLY		;show it
 DIRLP	CALL	49H		;wait for inkey
 	CP	01H		;BREAK key?
 	JP	Z,CMD		;back to menu then
 	CALL	33H		;display the number
 	CP	'0'		;else check lower limit
 	JP	C,DIRLP		;back if too low
 	CP	':'		;check top limits
 	JR	NC,DIRLP	;go if too high
 	LD	(DRIVE),A	;else set drive number
 	LD	HL,DIR		;point to ASCII cmd
 ;This call must be changed for your Dos. The CALL is
 ;for : TRSDOS 1.3 429CH : NEWDOS 80 4419H : DOS + 4405H
 ;TRSDOS 2.3 4405H : LDOS 5.1 (MI) 4405H : LDOS (M3)????
 	CALL	4405H		;execute DOS command
 	JR	DODIR		;and do it til break
 CHAIN	LD	HL,BUFFER	;point to buffer
 	LD	(POINT),HL	;reset end of it
 	LD	A,(CHNTOT)	;get total to chain
 	DEC	A		;minus 1
 	LD	(CHNTOT),A	;save it
 	OR	A		;test for ZERO
 	JR	NZ,MORE		;go if more needed
 	LD	HL,RMSG		;point to reloading
 	CALL	DISPLY		;show it
 	LD	HL,CHFILE	;else point to first name
 	LD	(TEMP),HL	;reset to load first one
 	JR	MORE1		;read back first file
 MORE	LD	HL,CHMSG	;point to chaining msg
 	CALL	DISPLY		;show it
 MORE1	LD	HL,(TEMP)	;get ASCII address
 	LD	IX,FCB		;point to block
 CHCP	LD	A,(HL)		;get a byte
 	LD	(IX),A		;move to buffer
 	CALL	33H		;print the filespec
 	CP	0DH		;look for C/R
 	JR	Z,COPYDN	;go if found
 	INC	IX		;else point to next
 	INC	HL		;"	"
 	JR	CHCP		;loop til file copied
 COPYDN	INC	HL		;point to next name
 	LD	(TEMP),HL	;save address of it
 	CALL	ALOAD1		;and read in file
 	LD	A,(CHNTOT)	;get number left
 	OR	A		;0=none left
 	RET	NZ		;back if still more
 	POP	HL		;else fix the stack
 	JP	END0A		;and show all done
 VIEW	LD	HL,BUFFER	;point to buffer
 	LD	DE,(POINT)	;check end address
 	RST	18H		;same?
 	JP	Z,CMD		;back if yes
 	CALL	01C9H		;else clear the screen
 	LD	A,01H		;first character
 	LD	(LEN),A		;add one for first
 	LD	(CHAR),A	;setup for first char
 	LD	A,(PFLAG)	;want a hardcopy?
 	CP	00H		;0=no, 1=yes
 	CALL	NZ,HEAD		;go if yes
 	LD	HL,FMSG		;point to message
 	CALL	DISPLY		;show it
 VIEW1	LD	HL,BUFFER	;point to buffer
 	INC	HL		;point to filename
 SHLP	LD	A,(HL)		;get character
 	CP	80H		;loop for numbers
 	JR	NC,SHLP1	;go if done
 	CALL	33H		;display it
 	INC	HL		;point to next
 	JR	SHLP		;loop til done
 SHLP1	LD	A,0DH		;now do a C/R
 	CALL	33H		;on the screen
 LOOP	LD	A,(HL)		;get a byte
 	CP	80H		;check for line numbers
 	JR	NC,NUMBER	;go if numbers
 	CP	1AH		;end of file?
 	JR	Z,END		;go if end of file
 	CP	0DH		;else end of line
 	JR	Z,ENDLN		;go if yes
 	CP	09H		;else tab character
 	JR	Z,TAB		;go if tab
 	CALL	LPRINT		;check for hardcopy
 	CALL	DISKIO		;check for disk and Vid
 	LD	A,(LEN)		;get number printed
 	INC	A		;add one to it
 	CP	09H		;next field?
 	JR	NZ,BACK1	;go if not
 RESET	LD	A,01H		;set to first
 BACK1	LD	(LEN),A		;and save value
 BACK	INC	HL		;point to next
 	JR	LOOP		;loop til done
 NUMBER	LD	A,(HL)		;get character
 	CP	' '		;space for end number?
 	JR	Z,LOOP		;back if yes
 	RES	7,A		;make it ASCII again
 	CALL	LPRINT		;check for lprint too
 	CALL	DISKIO		;check vid and disk
 	INC	HL		;point to next
 	JR	NUMBER		;point to next
 TAB	LD	A,(LEN)		;get length
 	LD	B,A		;move for subtract
 	LD	A,9		;maximum
 	SBC	A,B		;find answer
 	LD	B,A		;move to loop
 TABIT	LD	A,20H		;space character
 	CALL	LPRINT		;check for hardcopy
 	CALL	DISKIO		;check for disk or video
 	DJNZ	TABIT		;move it over
 SET	JR	RESET		;reset to char
 ENDLN	CALL	LPRINT		;check for hardcopy
 	CALL	DISKIO		;disk or video?
 	INC	HL		;point to next
 	LD	A,(HL)		;get a byte
 	CP	1AH		;end of file?
 	JR	Z,END		;go if yes
 	DEC	HL		;else backup one
 WAIT	LD	A,(3840H)	;look at keyboard
 	CP	04H		;break?
 	JR	Z,EXIT		;go if yes
 	PUSH	AF		;save character
 	LD	A,(PFLAG)	;hardcopy
 	CP	01H		;1=on 0=off
 	JR	Z,BYPASS	;yes then go
 	LD	A,(DISK)	;get disk status
 	OR	A		;0=off 1=on
 	JR	NZ,BYPASS	;go if off
 	POP	AF		;else restore character
 	CALL	49H		;wait for inkey
 	CP	5BH		;up arrow?
 	JR	NZ,WAIT		;no, then loop
 	JR	SET		;back to set
 BYPASS	POP	AF		;fix the stack
 	JR	SET		;and back we go
 END	LD	A,(DISK)	;check disk file
 	OR	A		;any write done?
 	JR	Z,END0		;go if not
 	LD	DE,FCB		;else close the
 	CALL	4428H		;file now
 END0	LD	A,(CHFLAG)	;check for chain flag
 	OR	A		;any there?
 	JR	Z,END0A		;continue if not
 	CALL	CHAIN		;else read in next file
 	JP	VIEW1		;and continue routine
 END0A	LD	HL,ENDMSG	;point to end message
 	CALL	DISPLY		;show it
 END1	CALL	49H		;wait for inkey
 	CP	5BH		;up arrow?
 	JR	Z,END1		;wait for another key
 EXIT	XOR	A		;zero out a
 	LD	(PFLAG),A	;reset printer routine
 	LD	(DISK),A	;reset disk IO
 	JP	CMD		;back to menu
 DISKIO	PUSH	AF		;save character
 	LD	A,(DISK)	;get disk status
 	OR	A		;0=disk off
 	JR	Z,DSKOFF	;go if off
 	LD	DE,FCB		;else point to file
 	POP	AF		;get back character
 	CALL	1BH		;write it to disk
 	JP	NZ,ERROR	;go if error
 	JR	DISK1		;and continue
 DSKOFF	POP	AF		;get back character
 DISK1	CALL	33H		;show it on video
 	RET			;back to caller
 HEAD	PUSH	HL		;save pointer
    	LD	A,07H		;show we're at line 7
 	LD	(LINE),A	;save the value
 	LD	A,' '		;get a space
 	CALL	3BH		;print it
 	LD	A,0DH		;one line done
 	CALL	3BH		;lprint it
 	LD	B,80		;number characters
 SHDH	LD	A,'-'		;character to print
 	CALL	3BH		;lprint it
 	DJNZ	SHDH		;loop for 80 of them
 	LD	A,0DH		;now get a C/R
 	CALL	3BH		;do it
 	LD	HL,BUFFER	;point to buffer
 	INC	HL		;point past first byte
 	LD	B,6		;bytes to print
 PNAME	LD	A,(HL)		;get the character
 	CALL	3BH		;lprint it
 	INC	HL		;point to next
 	DJNZ	PNAME		;6 char filename
 	LD	A,' '		;get a space
 	CALL	3BH		;lprint it
 	LD	A,' '		;get another
 	CALL	3BH		;lprint it
 	LD	HL,DATE		;point to date buffer
 	CALL	GETDAT		;put date in buffer
 	LD	HL,TIME		;point to time buffer
 	CALL	GETTM		;put time in buffer
 	LD	HL,DATE		;point to date
 	LD	B,20		;characters to lprint
 	CALL	PCOM		;and print it
 	LD	HL,COMMEN	;point to comment line
 	LD	B,40D		;characters to lprint
 	CALL	PCOM		;print them
 	LD	HL,(PNUM)	;point to page number
 	LD	DE,PBUFF	;point to buffer for it
 	CALL	BINASC		;convert page to number
 CONT	LD	HL,(PNUM)	;get page number
 	INC	HL		;add one to it
 	LD	(PNUM),HL	;save it again
 	LD	HL,PAGE		;point to page msg
 	LD	B,13		;length to print
 SUB1	LD	A,(HL)		;get character
 	CALL	3BH		;lprint it
 	INC	HL		;point to next
 	DJNZ	SUB1		;loop til done
 	LD	B,80		;bytes to lprint
 SHDH1	LD	A,'-'		;character to lprint
 	CALL	3BH		;lprint it
 	DJNZ	SHDH1		;loop til shown
 	LD	A,0DH		;get a C/R
 	CALL	3BH		;lprint it
 	LD	A,' '		;get a space
 	CALL	3BH		;print it
 	LD	A,0DH		;and another
 	CALL	3BH		;lprint it
 	CALL	TABIN		;tab in now
 	POP	HL		;restore pointer
 	RET			;back to caller
 PCOM	LD	A,(HL)		;get a character
 	CP	0DH		;end of line?
 	JR	Z,PSPACE	;go skip if yes
 	CALL	3BH		;else lprint it
 	INC	HL		;point to next
 	DJNZ	PCOM		;loop til done
 	RET			;and back to caller
 PSPACE	LD	(HL),20H	;replace with space
 	LD	A,(HL)		;and get the character
 	CALL	3BH		;lprint it
 	INC	HL		;remove rest of stuff
 	DJNZ	PSPACE		;loop til all done
 	RET			;back to caller
 LPRINT	PUSH	AF		;save character
 	LD	A,(PFLAG)	;want a hardcopy?
 	OR	A		;0=no, 1=yes
 	JR	NZ,SEND		;go if yes
 CONT1	POP	AF		;else restore character
 	RET			;and go back
 SEND	POP	AF		;get back character
 	PUSH	AF		;and save it again
 	CALL	3BH		;lprint it
 	POP	AF		;get character
 	PUSH	AF		;and save it again
 	CP	0DH		;C/R?
 	CALL	Z,GOTCR		;go if carriage return
 	LD	A,(CHAR)	;else increase counter
 	INC	A		;add one to it
 	CP	81		;next line?
 	CALL	Z,GOTCR		;go for long line
 	LD	(CHAR),A	;else save the value
 	JR	CONT1		;and continue
 GOTCR	XOR	A		;zero out a
 	LD	(CHAR),A	;save the value
 	CALL	TABIN		;set in the tab
 	LD	A,(LINE)	;get current line
 	INC	A		;add one to it
 	CP	66		;66 lines per page
 	JR	Z,FORM		;go if form feed
 	LD	(LINE),A	;and save it
 	RET			;back to caller
 FORM	LD	A,(LINE)	;get line
 	LD	B,A		;move for subtract
 	LD	A,67		;lines to next page
 	SBC	A,B		;find the difference
 	LD	B,A		;move to loop
 FEED	LD	A,' '		;get a space
 	CALL	3BH		;print it
 	LD	A,0DH		;get a C/R
 	CALL	3BH		;lprint it
 	DJNZ	FEED		;loop til up
 	CALL	HEAD		;reprint heading
 	RET			;back to caller
 TABIN	LD	A,10		;bytes to tab in
 	LD	(CHAR),A	;set length
 	LD	B,A		;move to loop
 TB	LD	A,20H		;get a space byte
 	CALL	3BH		;lprint it
 	DJNZ	TB		;loop til done
 	RET			;back to caller
 BINASC	LD	BC,-10000	;10 to 4th
 	CALL	CAL		;figure it
 	LD	BC,-1000	;10 to 3rd
 	CALL	CAL		;figure it
 	LD	BC,-100		;10 to 2nd
 	CALL	CAL		;figure it
 	LD	BC,-10		;10's
 	CALL	CAL		;figure it
 	LD	BC,-1		;units digit
 	CALL	CAL		;figure it
 	LD	A,0DH		;get a C/R
 	LD	(DE),A		;move in the buffer
 	RET			;back to routine
 CAL	LD	A,0FFH		;set a to -1
 CAL1	INC	A		;add one to it
 	ADD	HL,BC		;do a subtract to 10's
 	JR	C,CAL1		;loop til too small
 	OR	A		;clear the carry flag
 	SBC	HL,BC		;step back one number
 	ADD	A,30H		;make it a digit
 	LD	(DE),A		;store in the buffer
 	INC	DE		;point to next
 	RET			;back to routine
 GTSIZE	PUSH	HL		;save pointer
 	PUSH	DE		;and DE as well
 	LD	DE,BUFFER	;point to start buffer
 	LD	HL,(POINT)	;get end of buffer
 	SBC	HL,DE		;get the size in HL
 	LD	DE,PRGSZ	;point to buffer
 	CALL	BINASC		;figure it out
 	POP	DE		;restore DE
 	POP	HL		;and HL
 	RET			;back to caller
 KILREM	LD	HL,BUFFER	;point to buffer
 	LD	DE,(POINT)	;get end address
 	RST	18H		;program in memory
 	JP	Z,CMD		;back if none in memory
 	LD	HL,LTEXT	;point to filename prompt
 	CALL	DISPLY		;show it
 	LD	HL,FCB		;point to control block
 	LD	B,20H		;32 characters max
 	CALL	40H		;do a rom input
 	JP	C,CMD		;back if BREAK key
 	LD	DE,FCB		;point to filespec
 	LD	HL,EXTEN1	;point to ASM
 	CALL	4473H		;append extension
 	LD	HL,IO		;point to IO buffer
 	LD	DE,FCB		;point control block
 	LD	B,00H		;lrl=256
 	CALL	4420H		;create or overwrite
 	JR	NZ,ERROR	;go if error
 	LD	HL,BUFFER	;else point to buffer
 SAVE	LD	DE,FCB		;point to control block
 	LD	A,(HL)		;get a character
 	CP	09H		;tab byte?
 	CALL	Z,FNDTAB	;go if tab byte found
 	CALL	1BH		;else write it to disk
 	JR	NZ,ERROR	;go if error
 	CALL	BLINK		;blink a *
 	INC	HL		;point to next
 	LD	DE,(POINT)	;get end address
 	RST	18H		;check for eof
 	JR	NZ,SAVE		;loop til all done
 	LD	DE,FCB		;point to block
 	LD	A,1AH		;mark end of file
 	CALL	1BH		;write it
 	LD	DE,FCB		;point to block again
 	CALL	4428H		;and close the file
 	JR	NZ,ERROR	;go if error
 	JP	CMD		;else back to program
 FNDTAB	PUSH	HL		;save the address
 MORE	INC	HL		;point to next character
 	LD	A,(HL)		;get it
 	CP	09H		;another tab
 	JR	Z,MORE		;go if another one found
 	CP	';'		;else semicolon there?
 	JR	Z,DELETE	;go and skip by it then
 	POP	HL		;restore the position
 	LD	A,(HL)		;get back original byte
 	RET			;back to caller
 DELETE	POP	HL		;point to first tab
 DEL1	INC	HL		;skip all remarks now
 	LD	A,(HL)		;get a byte
 	CP	0DH		;end of line?
 	RET	Z		;back if yes
 	JR	DEL1		;else loop til found
 ERROR	SET	7,A		;set error bit
 	CALL	4409H		;display the error
 ERROR1	CALL	49H		;wait for a key
 	LD	A,(CFLAG)	;test for chaining
 	OR	A		;0=no chain
 	JP	Z,CMD		;back if normal
 	POP	HL		;else fix the stack
 	POP	HL		;again
 	JP	CMD		;and back to loop
 ERR	LD	HL,ERR2		;point to wrong file msg
 	CALL	DISPLY		;show it
 	JR	ERROR1		;and continue
 LEN	DEFB	00H		;length storage
 MENU	DEFM	'             Editor Assember File Utility'
 	DEFM	'          Mem:'
 PRGSZ	DEFM	'00000'
 	DEFB	0DH
 	DEFM	'             <c> 1983 by Mel Patrick'
 	DEFB	0DH
 	DEFM	'                    Version 3.0'
 	DEFB	0DH
 	DEFM	'<L>oad /ASM File                  <D>isplay Directory'
 	DEFB	0DH
 	DEFM	'<V>iew File in Memory             <F>ormat File (Printer)'
 	DEFB	0DH
 	DEFM	'<R>emove REM & Save               <W>rite File in ASCII'
 	DEFB	0DH
 	DEFM	'<E>xit to Dos Ready               <C>hain Files'
 	DEFW	0D0DH
 	DEFM	'          Selection :'
 	DEFB	03H
 DMSG	DEFB	0DH
 	DEFM	'BREAK to EXIT or Drive #:'
 	DEFB	03H
 DIR	DEFM	'CAT :'		;Maybe DIR if needed
 DRIVE	DEFB	30H		;for drive zero
 	DEFB	0DH		;end of cmd terminator
 ENDMSG	DEFB	0DH
 	DEFM	'--------------------- End of File, Press <ENTER> --------------'
 	DEFB	03H
 ERR2	DEFB	0DH
 	DEFM	'* File Not in EDTASM FORMAT *'
 	DEFB	03H
 ERR3	DEFB	0DH
 	DEFM	'* Out Of Memory *'
 	DEFB	03H
 CMSG	DEFB	0DH
 	DEFM	'Converting Labels and Op Codes..'
 	DEFB	03H
 LTEXT	DEFW	0D0DH
 	DEFM	'FileSpec > '
 	DEFB	03H
 FMSG	DEFM	'Assembler Filename --> '
 	DEFB	03H
 PMSG	DEFB	0DH
 	DEFM	'Append to Current File (Y/N) : '
 	DEFB	03H
 TITLE	DEFM	'     Chain Files Option Mode'
 	DEFW	0D0DH
 	DEFM	'Enter in up to 9 VALID filenames to chain for printing'
 	DEFB	0DH
 	DEFM	'mode.'
 	DEFW	0D0DH
 	DEFB	03H
 SPEC	DEFM	'Filespec #'
 	DEFB	03H
 RMSG	DEFM	'-----> Reloading Filespec : '
 	DEFB	03H
 CHMSG	DEFM	'-----> Chaining Filespec : '
 	DEFB	03H
 COMMEN	DEFS	45		;comment buffer
 LINE	DEFB	00H		;line per page counter
 CHAR	DEFB	00H		;character counter
 DATE	DEFS	08H		;length of date
 	DEFW	2020H		;2 spaces
 TIME	DEFS	08H		;length of time
 	DEFW	2020H		;2 spaces
 PAGE	DEFM	'  Page '		;page text
 PBUFF	DEFS	06H		;for ASCII number
 PNUM	DEFW	0000H		;starting page number
 CMSG	DEFW	0D0DH
 	DEFM	'Header Comments --> '
 	DEFB	03H
 CHFILE	DEFS	350		;maximum 10 files
 CHNTOT	DEFB	00H		;total to chain
 TEMP	DEFW	0000H		;variable storage
 CHFLAG	DEFB	00H		;chain flag
 EXTEN1	DEFM	'ASM'		;default extension
 EXTEN2	DEFM	'TXT'		;default extension
 AFLAG	DEFB	00H		;0=append off 1=on
 PFLAG	DEFB	00H		;1=hardcopy 0=off
 CFLAG	DEFB	01H		;case convert flag
 NUM	DEFW	0000H		;record number
 POINT	DEFW	0000H		;end buffer pointer
 DISK	DEFB	00H		;write ASCII source file
 FCB	DEFS	20H		;file control block
 IO	DEFS	256		;input/output buffer
 BUFFER	DEFB	00H		;start of hold buffer
 	END	EDTFMT

