       ;Complete Character Font Writer for any Epson Printer
 ;<c> 1984 by Mel Patrick
 	ORG	0C000H		;origin
 CRFONT	CALL	01C9H		;erase video
 	LD	HL,TOTAL	;point to char table
 	LD	BC,3976D	;bytes to zero out
 CLRTAB	LD	(HL),00H	;erase all entries
 	INC	HL		;point to next
 	DEC	BC		;count minus 1
 	LD	A,B		;test for end of loop
 	OR	C		;end?
 	JR	NZ,CLRTAB	;loop til done
 	LD	HL,CHRTAB	;point to char table
 	LD	(TEMP1),HL	;save it
 	LD	HL,BITTAB	;point to bit table
 	LD	(TEMP2),HL	;and save it
 	LD	HL,MENU		;point to menu
 	CALL	DISPLY		;show it
 	LD	HL,(4020H)	;get cursor address
 	LD	(VIDEO),HL	;save it
 CMDLP	CALL	SHMN		;show main
 	CALL	49H		;wait for inkey
 	PUSH	AF		;save character
 	CALL	ERMN		;erase it
 	POP	AF		;restore character
 	AND	5FH		;convert to upper case
 	CP	'R'		;return to DOS
 	JP	Z,DOS		;back if yes
 	CP	'C'		;want to draw
 	JP	Z,GRAPH		;go if yes
 	CP	'D'		;define matrix?
 	JP	Z,DEFINE	;go if yes
 	CP	'Q'		;who?
 	JR	Z,SHOWCP	;show it then
 	CP	'E'		;edit font character?
 	JP	Z,EDIT		;go if yes
 	CP	'W'		;write font file?
 	JP	Z,WRITE		;go if yes
 	CP	'L'		;else load a font?
 	JP	Z,LOAD		;go if yes
 	CP	'H'		;hardcopy all characters
 	JP	Z,HARD		;go if yes
 	JR	CMDLP		;else loop back
 SHOWCP	LD	HL,COPY		;point to message
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for any key
 	CALL	CLRSCR		;erase it
 	JP	CMDLP		;and back
 HARD	LD	A,(TOTAL)	;get total
 	OR	A		;test for any
 	JP	Z,CMDLP		;back if none
 	LD	B,A		;else store in loop
 	LD	IX,BITTAB	;point to table
 	LD	IY,CHRTAB	;point to characters
 HARD0	PUSH	BC		;save counter
 	LD	L,(IY)		;get LSB character
 	LD	H,00H		;set MSB to zero
 	LD	DE,BUFF		;point to buffer
 	CALL	BINASC		;convert to decimal
 	LD	A,' '		;remove last byte
 	LD	(DE),A		;in buffer
 	LD	HL,BUFF		;point to buffer
 	LD	B,3		;bytes to print
 	INC	HL		;point to second
 	INC	HL		;next
 HARD1	LD	A,(HL)		;get a byte
 	CALL	3BH		;lprint it
 	INC	HL		;point to next
 	DJNZ	HARD1		;loop for three
 	LD	A,' '		;space routine
 	CALL	3BH		;do it
 	LD	A,'='
 	CALL	3BH
 	LD	A,' '
 	CALL	3BH
 	LD	A,(IY)		;check for ASCII
 	CP	' '		;check for <space
 	JR	C,HARD5		;go if too low
 	CP	7BH		;check high end
 	JR	NC,HARD5	;go if too high
 	CALL	3BH		;else lprint it
 	LD	A,' '
 	CALL	3BH
 	LD	A,'='
 	CALL	3BH
 	LD	A,' '
 	CALL	3BH
 HARD5	LD	HL,PRTCMD	;point to graphic cmd
 	LD	B,4		;bytes to lprint
 	CALL	PRINT		;lprint it
 	LD	A,(COL)		;get columns
 	LD	B,A		;move for list
 HARD2	LD	A,(IX)		;get bit
 	PUSH	AF		;save character
 HARD3	LD	A,(37E8H)	;test for ready
 	AND	0F0H		;mask it
 	CP	30H		;ready?
 	JR	NZ,HARD3	;loop if not
 	LD	A,(3000H)	;else get model type
 	CP	0C3H		;JP=M3
 	JR	Z,M3P		;go if model III
 	POP	AF		;else get character
 	LD	(37E8H),A	;send it out
 	JR	HARD4		;and continue
 M3P	POP	AF		;get back character
 	OUT	(248),A		;send it out
 HARD4	INC	IX		;point to next
 	DJNZ	HARD2		;loop til done
 	LD	A,0DH		;do a C/R
 	CALL	3BH		;now
 	INC	IY		;point to next
 	POP	BC		;get back master counter
 	DJNZ	HARD0		;loop til done
 	JP	CMDLP		;back to loop
 DEFINE	LD	A,(COLUMN)	;test for defined
 	OR	A		;anything there
 	JP	NZ,CMDLP	;back if yes
 	LD	HL,MENU0	;show paramters
 	CALL	DISPLY		;show them
 DEF1	CALL	49H		;wait for selection
 	AND	5FH		;convert
 	CP	'A'		;A=standard 8x12
 	JR	Z,STAND		;go if standard
 	CP	'B'		;else double width?
 	JR	Z,DOUB		;go if yes
 	JR	DEF1		;must select
 STAND	LD	A,(STRTY)	;get starting point Y
 	ADD	A,07H		;height of letter -1
 	LD	(MAXY),A	;save bottom
 	LD	A,(STRTX)	;get starting point X
 	ADD	A,11D		;new width value -1
 	LD	(MAXX),A	;save it
 	CALL	CLRSCR		;erase prompt
 	LD	A,12		;bytes to print
 	LD	(COL),A		;store in cmd
 	LD	(COLUMN),A	;save for write
 BACKA	JP	CMDLP		;and back to loop
 DOUB	LD	A,(STRTY)	;get start Y axis
 	LD	B,A		;save it
 	LD	A,7		;same height
 	ADD	A,B		;find height
 	LD	(MAXY),A	;save it
 	LD	A,(STRTX)	;get start X axis
 	LD	B,A		;save it
 	LD	A,23D		;double width
 	ADD	A,B		;find new side
 	LD	(MAXX),A	;save it
 	CALL	CLRSCR		;erase prompt
 	LD	A,24		;bytes to print
 	LD	(COL),A		;store in cmd
 	LD	(COLUMN),A	;save for write
 	JR	BACKA		;back now
 GRAPH	LD	A,(TOTAL)	;get total
 	CP	159D		;at limit
 	JP	Z,LIMIT		;go if yes
 	LD	A,(MAXX)	;test for entry
 	OR	A		;any thing there?
 	JP	Z,DEFINE	;go if nothing
 	CALL	GETCHR		;go get character
 	LD	A,(STRTX)	;get starting pos
 	LD	(X),A		;save it
 	LD	A,(STRTY)	;get Y axis start
 	LD	(Y),A		;save it
 	CALL	CLRBX		;erase last box
 	CALL	DRWBX		;draw the box now
 	JP	DOERA		;show erase mode
 KEYLP	LD	BC,(TIME)	;get delay time
 	CALL	60H		;do it
 	CALL	SET		;else show point
 	LD	A,(MODE)	;get mode
 	OR	A		;0=both 1=draw only
 	JP	NZ,KEYLP0	;back if draw only
 	LD	BC,(TIME)	;delay loop
 	CALL	60H		;do it
 	CALL	RSET		;else reset point
 KEYLP1	LD	A,(3840H)	;now do scan
 	CP	08H		;up arrow?
 	JP	Z,MOVEUP	;go if yes
 	CP	10H		;else down arrow
 	JP	Z,MOVEDN	;go if yes
 	CP	20H		;else left arrow
 	JP	Z,BCKSPC	;go if yes
 	CP	40H		;else right arrow
 	JP	Z,TAB		;go if yes
 	CP	80H		;else reverse image?
 	JP	Z,REVIM		;reverse image then
 	CP	02H		;CLEAR key pressed
 	JR	Z,ERFRM		;yes then erase image
 	CP	01H		;add to table?
 	JP	Z,ADDTAB	;go if yes
 	LD	A,(3801H)	;else look at cmd keys
 	CP	16D		;want to DRAW?
 	JP	Z,DODRW		;go if yes
 	CP	32D		;else erase?
 	JP	Z,DOERA		;go if yes
 	CP	80H		;else reverse image?
 	JP	Z,TESTPT	;test point on/off
 	LD	A,(3804H)	;look for a P(rint)
 	CP	01H		;1=P
 	JR	Z,DOPRT		;go if pressed
 	JR	KEYLP		;and loop
 REVIM	XOR	A		;0=reverse only
 SUBENT	LD	(SELECT),A	;save it
 	JP	TESTPT		;and do routine
 ERFRM	LD	A,1		;1=clr image
 	JR	SUBENT		;and do it
 ADDTAB	LD	A,2		;start at print
 	CALL	SUBENT		;find bits
 	LD	A,(TEMP3)	;get character
 	LD	HL,(TEMP1)	;get character table
 	LD	(HL),A		;store it
 	INC	HL		;point to next
 	LD	(TEMP1),HL	;save it
 	LD	HL,BUFF		;copy bits now
 	LD	DE,(TEMP2)	;get bit table
 	LD	A,(COL)		;get columns
 	LD	C,A		;move for copy
 	LD	B,00H		;set MSB to 0
 	LDIR			;and copy it
 	LD	(TEMP2),DE	;save next address
 	LD	A,(SFLAG)	;test for edit
 	OR	A		;0=not 1=yes
 	RET	NZ		;back if on
 	LD	A,(TOTAL)	;get total
 	INC	A		;add 1 to it
 	LD	(TOTAL),A	;save it
 	CP	159D		;at limit?
 	JR	Z,LIMIT		;go if yes
 	CALL	CLRSCR		;erase screen
 	JP	GRAPH		;and continue
 LIMIT	CALL	CLRSCR		;erase prompt
 	LD	HL,LMSG		;point to full
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for a key
 	JP	CMDLP		;and back to main
 DOPRT	LD	A,2		;2=print
 	CALL	SUBENT		;find values
 	LD	HL,PRTCMD	;point to print cmd
 	LD	B,4		;cmd length
 	CALL	PRINT		;and do it
 	LD	HL,BUFF		;point to bits
 	LD	A,(COL)		;get columns to print
 	LD	B,A		;move to loop
 	CALL	PRINT		;do it
 	LD	A,0DH		;and a C/R
 	CALL	3BH		;and a line feed
 	JP	KEYLP		;and back to routine
 PRINT	LD	A,(HL)		;get a byte
 	INC	HL		;point to next
 	PUSH	AF		;save it
 READY	LD	A,(37E8H)	;test for ready
 	AND	0F0H		;mask bits
 	CP	30H		;ready?
 	JR	NZ,READY	;no then wait
 	LD	A,(3000H)	;test for Model I or III
 	CP	0C3H		;JP=III
 	JR	Z,MOD3		;go if model III
 	POP	AF		;else it M1
 	LD	(37E8H),A	;direct out the port
 	DJNZ	PRINT		;loop til done
 	RET			;and go back
 MOD3	POP	AF		;get back character
 	OUT	(248),A		;send out character
 	DJNZ	PRINT		;loop til done
 	RET			;back to caller
 KEYLP0	CALL	RSET		;reset block
 	LD	BC,(TIME)	;get delay
 	CALL	60H		;do it
 	CALL	SET		;show block again
 	JP	KEYLP1		;and continue
 DODRW	LD	A,1		;set flag to on
 	LD	(MODE),A	;save it
 	LD	HL,1500H	;set delay slower
 	LD	(TIME),HL	;and save it
 	CALL	CLRSCR		;erase last command
 	LD	HL,DMSG		;point to mode message
 	CALL	DISPLY		;show it
 	JP	KEYLP		;and return
 DOERA	XOR	A		;A=0
 	LD	(MODE),A	;set modes to on
 	LD	HL,1000H	;return to fast mode
 	LD	(TIME),HL	;and save it
 	CALL	CLRSCR		;erase last command
 	LD	HL,EMSG		;point to erase mode
 	CALL	DISPLY		;show it
 	JP	KEYLP		;and return
 MOVEUP	LD	A,(STRTY)	;get minimum pos
 	LD	B,A		;save it
 	LD	A,(Y)		;get position
 	DEC	A		;minus 1 from it
 	CP	B		;B=minimum A=position
 	JR	C,BACK1		;back if B>A
 BACK	LD	(Y),A		;store new location
 BACK1	JP	KEYLP		;and back to loop
 MOVEDN	LD	A,(Y)		;get y value
 	INC	A		;add 1 to it
 	LD	B,A		;save value
 	LD	A,(MAXY)	;get maximum value
 	CP	B		;check limits
 	JR	C,BACK1		;back if too high
 	LD	A,B		;else get value
 	JR	BACK		;else save it and return
 BCKSPC	LD	A,(STRTX)	;get minimum X pos
 	LD	B,A		;save it
 	LD	A,(X)		;get x position
 	DEC	A		;back up 1
 	CP	B		;check for limits
 	JR	C,BACK1		;go if B>A
 BCK1	LD	(X),A		;save it
 	JR	BACK1		;and go back
 TAB	LD	A,(X)		;get X axis
 	INC	A		;add 1 to it
 	LD	B,A		;move for compare
 	LD	A,(MAXX)	;get max X axis
 	CP	B		;check limits
 	JR	C,BACK1		;back if too far
 	LD	A,B		;else get value
 	JR	BCK1		;else save it and return
 DELAY	PUSH	AF		;save character
 	LD	BC,(TIME)	;get time constant
 	CALL	60H		;do it
 	POP	AF		;get back character
 	RET			;back to caller
 SET	LD	A,80H		;SET flag on
 	JP	GRSUB1		;and do it
 RSET	LD	A,01H		;RESET flag on
 	JP	GRSUB1		;and do it
 GRSUB	CALL	GRSUB1		;and do graphic routine
 	JP	KEYLP		;back to routine
 TESTPT	LD	A,(X)		;get x axis
 	LD	(SVX),A		;save it
 	LD	A,(Y)		;get present Y
 	LD	(SVY),A		;save it
 	LD	A,(STRTX)	;get starting module
 	LD	(X),A		;save for our routine
 	LD	A,(STRTY)	;get y axix
 	LD	(Y),A		;save it for us
 	LD	A,(STRTX)	;get starting X
 	LD	B,A		;move for subtract
 	LD	A,(MAXX)	;get maximum
 	SUB	B		;do a subtract
 	LD	B,A		;save the counter
 	INC	B		;add 1 for total
 	LD	A,(SELECT)	;get mode
 	CP	02H		;want a print?
 	JR	NZ,TEST		;bypass if not
 	LD	IX,TABLE	;else point to table
 	LD	IY,BUFF		;and point to buffer
 	XOR	A		;remove any bits
 	LD	(TEMP),A	;for totals
 TEST	PUSH	BC		;save # columns
 	LD	B,8		;bits per column
 TEST0	PUSH	BC		;save bits per column
 	XOR	A		;flag for POINT
 	CALL	GRSUB1		;see if on/off
 	LD	A,(SELECT)	;get mode 0=rev
 	OR	A		;0=reverse
 	JR	Z,DOREV		;do reverse if selected
 	CP	01H		;else is it 1
 	JR	Z,DOCLR		;1=clr frame
 	CP	02H		;want a print?
 	JR	Z,PRT		;go if yes
 	JR	TEST1		;else bypass
 PRT	LD	A,(BIT)		;get point bit
 	OR	A		;0=off -1=on
 	JR	Z,PRT1		;bypass if off
 	LD	A,(TEMP)	;get last bit
 	ADD	A,(IX)		;else add bit to total
 	LD	(TEMP),A	;save it
 PRT1	INC	IX		;point to next bit
 	JR	TEST1		;and continue
 DOREV	LD	A,(BIT)		;get set byte
 	OR	A		;test for on/off
 	JR	Z,BITOFF	;go if its off
 DOCLR	CALL	RSET		;else turn it off
 	JR	TEST1		;and continue
 BITOFF	CALL	SET		;its off, turn it on
 TEST1	LD	A,(Y)		;get Y value
 	INC	A		;add 1 to it
 	LD	(Y),A		;store it back
 	POP	BC		;get back bit count
 	DJNZ	TEST0		;loop for 8 bits
 	LD	A,(SELECT)	;get mode
 	CP	02H		;want print?
 	JR	NZ,TEST1A	;bypass if not
 	LD	IX,TABLE	;else reset table pointer
 	LD	A,(TEMP)	;get value
 	LD	(IY),A		;store bits in buffer
 	INC	IY		;point to next
 	XOR	A		;zero out A
 	LD	(TEMP),A	;and store result
 TEST1A	LD	A,(STRTY)	;get same start
 	LD	(Y),A		;save it
 	LD	A,(X)		;get x position
 	INC	A		;step to next column
 	LD	(X),A		;save it
 	POP	BC		;get back column counter
 	DJNZ	TEST		;loop for x columns
 	LD	A,(SVX)		;get last x
 	LD	(X),A		;restore it
 	LD	A,(SVY)		;get last Y
 	LD	(Y),A		;restore it
 	LD	A,(SELECT)	;get mode
 	CP	02H		;want print
 	RET	Z		;back if yes
 	JP	KEYLP		;and back to loop
 GRSUB1	PUSH	AF		;save flag byte
 	LD	A,(X)		;get x value
 	CP	80H		;check limits
 	JP	NC,KEYLP	;back if out of range
 	PUSH	AF		;else save it
 	LD	A,(Y)		;get Y value
 	CP	30H		;check limits
 	JP	NC,KEYLP	;back if out of range
 	LD	D,0FFH		;else set for divide
 GRDIV	INC	D		;find location
 	SUB	03H		;in blocks of three
 	JR	NC,GRDIV	;go if not done
 	ADD	A,03H		;make remainder positive
 	LD	C,A		;and save it
 	POP	AF		;get X value back
 	ADD	A,A		;times two
 	LD	E,A		;e=2xa
 	LD	B,02H		;for shift position
 GRSHFT	LD	A,D		;find column were in
 	RRA
 	LD	D,A
 	LD	A,E
 	RRA
 	LD	E,A
 	DJNZ	GRSHFT		;loop for 2 bits
 	LD	A,C		;find pos of point
 	ADC	A,A
 	INC	A
 	LD	B,A
 	XOR	A		;clear the carry
 	SCF			;and force carry flag
 GRPOS	ADC	A,A		;set 1 position over
 	DJNZ	GRPOS		;loop for count
 	LD	C,A		;find video address now
 	LD	A,D
 	OR	3CH
 	LD	D,A		;DE=address of box
 	LD	A,(DE)		;get it from video
 	OR	A		;get status flag
 	JP	M,GRWRD		;go if graphics now
 	LD	A,80H		;else make it one
 GRWRD	LD	B,A		;B=bits for display
 	POP	AF		;get entry point flag
 	OR	A		;test it for POINT
 	LD	A,B		;get back bits
 	JR	Z,DOPNT		;go if point wanted
 	LD	(DE),A		;else store the box
 	JP	M,DOSET		;go if set wanted
 	LD	A,C		;else its RESET
 	CPL
 	LD	C,A
 	LD	A,(DE)		;get box from video
 	AND	C		;turn off bit
 GRBCK	LD	(DE),A		;save new value
 	RET			;and back to caller
 DOSET	OR	C		;turn bit on
 	JR	GRBCK		;and return
 DOPNT	AND	C		;isolate bit
 	ADD	A,0FFH		;check for on/off
 	SBC	A,A		;0=off, 1=on
 	LD	(BIT),A		;save value
 	RET			;and back to caller
 CLRSCR	LD	HL,(VIDEO)	;get video address
 	LD	(4020H),HL	;reset it
 	LD	A,31D		;clear til eof
 	CALL	33H		;on the screen
 	RET			;back to caller
 CLRBX	LD	HL,3C84H	;start of box
 	LD	DE,64D		;offset per line
 	LD	B,5		;clear five lines
 CLRBX0	PUSH	BC		;save counter
 	PUSH	HL		;save address
 	LD	B,16D		;bytes to erase
 CLRBX1	LD	(HL),' '	;space out graphics
 	INC	HL		;point to next
 	DJNZ	CLRBX1		;loop til done
 	POP	HL		;point to start
 	ADD	HL,DE		;find next line
 	POP	BC		;get back counter
 	DJNZ	CLRBX0		;loop til done
 	RET			;back to caller
 DRWBX	LD	HL,3C84H	;start of video box
 	LD	(HL),0B0H	;set block
 	LD	DE,64D		;offset to next
 	PUSH	HL		;save address
 	LD	B,4		;blocks to set
 DRWBX0	ADD	HL,DE		;find next address
 	LD	(HL),0BFH	;set block
 	DJNZ	DRWBX0		;loop til done
 	LD	(HL),8FH	;set last block
 	POP	HL		;get back start
 	INC	HL		;point to 1 past
 	LD	A,(STRTX)	;get start block
 	LD	B,A		;move for subtract
 	LD	A,(MAXX)	;get maximum
 	SUB	B		;minus it
 	CP	11D		;small of large font?
 	JR	NZ,LARGE	;go if big one
 	LD	B,7		;setup loop counter
 	JR	DRWBXA		;and continue
 LARGE	LD	B,13D		;else set to large box
 DRWBXA	PUSH	BC		;save it
 DRWBX1	LD	(HL),0B0H	;set block
 	INC	HL		;point to next
 	DJNZ	DRWBX1		;loop til done
 	POP	BC		;get back count
 	LD	HL,3D84H	;start of bottom
 	INC	HL		;point to 1 past
 DRWBX2	LD	(HL),8CH	;show block
 	INC	HL		;point to next
 	DJNZ	DRWBX2		;loop til done
 	LD	(HL),8FH	;set block
 	LD	B,4		;bytes to set
 DRWBX3	OR	A		;clear the carry
 	SBC	HL,DE		;subtract
 	LD	(HL),0BFH	;set blocks
 	DJNZ	DRWBX3		;loop til done
 	LD	(HL),0B0H	;last block
 	RET			;and back to caller
 GETCHR	LD	HL,MENU1	;point to select
 	CALL	DISPLY		;show it
 GETCH	CALL	49H		;wait for inkey
 	CP	01H		;break key?
 	JR	Z,ABORT		;go if yes
 	AND	5FH		;convert it
 	CP	'A'		;ASCII input?
 	JR	Z,ASCIN		;go if yes
 	CP	'D'		;else decimal input?
 	JR	NZ,GETCH	;must be A,D
 	CALL	CLRSCR		;erase message
 	LD	HL,MENU2	;point to message
 	CALL	DISPLY		;show it
 	LD	HL,BUFF		;point to buffer
 	LD	A,3		;max input 3 char
 	CALL	INPUT		;get input
 	PUSH	IX		;move to HL
 	POP	HL		;HL=end of number
 	CALL	ASCBIN		;convert it now
 	LD	A,L		;only LSB used
 GETCH1	LD	(TEMP3),A	;save it
 	LD	A,(SFLAG)	;get byte
 	OR	A		;1=return
 	RET	NZ		;back if set
 	CALL	CLRSCR		;erase message
 	LD	A,(TOTAL)	;get total characters
 	OR	A		;any there?
 	RET	Z		;back if none
 	LD	C,A		;move for loop
 	LD	B,00H
 	LD	HL,CHRTAB	;point to table
 	LD	A,(TEMP3)
 	CPIR			;block compare
 	RET	NZ		;back if not there
 	LD	HL,MENU4	;else abort
 	CALL	DISPLY		;show it
 GETCH2	CALL	49H		;wait for inkey
 	POP	AF		;fix the stack
 	CALL	CLRSCR		;erase prompts
 	JP	GRAPH		;and redo input
 ABORT	POP	AF		;fix the stack
 	CALL	CLRSCR		;erase prompt
 	JP	CMDLP		;and return
 ASCIN	CALL	CLRSCR		;erase prompt
 	LD	HL,MENU3	;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,BUFF		;point to buffer
 	LD	A,1		;1 byte only
 	CALL	INPUT		;get it
 	LD	A,(BUFF)	;get character
 	JR	GETCH1		;save it and return
 INPUT	LD	(LEN),A		;save length
 	LD	(LEN1),A	;moving length
 	PUSH	HL		;move buffer to	IX
 	POP	IX		;IX=input buffer
 	LD	HL,(4020H)	;get field start
 	LD	B,A		;move for blocks
 IN0	LD	(HL),144	;set a block
 	INC	HL		;point to next
 	DJNZ	IN0		;loop til done
 IN1	CALL	49H		;get input
 	CP	0DH		;enter?
 	RET	Z		;back if yes
 	CP	08H		;backspace?
 	JR	Z,IN4		;go if yes
 	CP	20H		;less than a space
 	JR	C,IN1		;back if yes
 	PUSH	AF		;save the character
 	LD	A,(LEN1)	;get length
 	OR	A		;test for zero
 	JR	Z,IN5		;back if full
 	DEC	A		;else minus 1
 	JR	IN2		;go if ok to use
 IN5	POP	AF		;else fix the stack
 	JR	IN1		;and loop back
 IN2	LD	(LEN1),A	;save new total
 	POP	AF		;get back char.
 	PUSH	AF		;save char
 	LD	A,(CAP)		;UPPER case only?
 	OR	A		;0=no 1=yes
 	JR	Z,BOTH		;go if both
 	POP	AF		;else get char
 	AND	5FH		;convert to upper
 	JR	IN2A		;and continue
 BOTH	POP	AF		;get back char
 IN2A	LD	(IX),A		;store it
 	INC	IX		;point to next
 	CALL	33H		;print it
 	JR	IN1		;loop til done
 IN4	LD	A,(LEN1)	;get input length
 	LD	B,A		;move for compare
 	LD	A,(LEN)		;get max
 	SUB	B		;maximum compare
 	JR	Z,IN1		;back if full
 	LD	A,(LEN1)	;get input length
 	INC	A		;else add 1
 	LD	(LEN1),A	;save new total
 	LD	HL,(4020H)	;get address
 	LD	A,08H		;back space
 	CALL	33H		;do it
 	LD	A,(LEN1)	;get input length
 	CP	01H		;1 charcater only
 	JR	Z,SKIP		;go if full
 	LD	(HL),144	;reset block
 SKIP	DEC	HL		;minus 1
 	LD	(HL),144	;set it too
 	DEC	IX		;backup in buffer
 	LD	(IX),' '	;remove char
 	JP	IN1		;back now
 ASCBIN	DEC	HL		;minus 1
 ASCB1	LD	IX,0000H	;set counter to zero
 	LD	DE,1		;count units
 	CALL	ASC		;count them
 	LD	DE,10		;10's count
 	CALL	ASC		;count them
 	LD	DE,100		;100's
 	CALL	ASC		;count them
 	LD	DE,1000		;1000's
 	CALL	ASC		;count them
 	LD	DE,10000	;10000's
 	CALL	ASC		;count them
 FINISH	PUSH	IX		;move answer
 	POP	HL		;to HL
 	RET			;return now
 ASC	LD	A,(HL)		;get a byte
 	CP	'0'		;zero byte
 	JR	Z,NEXT		;go if yes
 	CP	' '		;else end of number?
 	JR	Z,DONE		;go if yes
 	CP	'0'		;check limits
 	JR	C,DONE		;go if too low
 	CP	':'		;check high limit
 	JR	NC,DONE		;go if too high
 	SUB	30H		;convert to 1-9
 	LD	B,A		;move for counting
 ADDIT	ADD	IX,DE		;count them
 	DJNZ	ADDIT		;loop for count
 NEXT	DEC	HL		;back up another
 	RET			;back to loop
 DONE	POP	IY		;fix stack
 	JR	FINISH		;go back now
 BINASC	LD	BC,-10000	;10 to 4th
 	CALL	SUB		;count them
 	LD	BC,-1000	;10 to 3rd
 	CALL	SUB		;count them
 	LD	BC,-100		;10 to the 2nd
 	CALL	SUB		;count them
 	LD	BC,-10		;10 to the 1st
 	CALL	SUB		;count them
 	LD	BC,-1		;digits
 	CALL	SUB		;count them
 	LD	A,03H		;set end byte
 	LD	(DE),A		;store it
 	RET			;back to caller
 SUB	LD	A,0FFH		;set to -1 for count
 SUB1	INC	A		;setup for count
 	ADD	HL,BC		;count the powers
 	JR	C,SUB1		;loop til too big
 	OR	A		;clear the flags
 	SBC	HL,BC		;get back last value
 	ADD	A,30H		;make it a ASCII digit
 	LD	(DE),A		;save it in buffer
 	INC	DE		;point to next
 	RET			;and back to caller
 EDIT	LD	A,1		;set flag to on
 	LD	(SFLAG),A	;save it
 	CALL	GETCHR		;get character
 	CALL	CLRSCR		;erase prompts
 	XOR	A		;zero out A
 	LD	(SFLAG),A	;and remove flag
 	LD	A,(TOTAL)	;get length
 	LD	B,A		;move it
 	LD	HL,CHRTAB	;point to table
 	LD	IX,BITTAB	;point to bit info
 EDLP	PUSH	BC		;save counter
 	LD	A,(TEMP3)	;get character
 	CP	(HL)		;look for match
 	JR	Z,FOUND		;go if same
 	INC	HL		;else point to next
 	LD	A,(COL)		;get column size
 	LD	B,A		;step value
 EDLP1	INC	IX		;step ahead
 	DJNZ	EDLP1		;step through bit info
 	POP	BC		;get back count
 	DJNZ	EDLP		;loop til end or found
 	CALL	CLRSCR		;else erase video
 	LD	HL,NMSG		;point to not there
 	CALL	DISPLY		;show it
 	CALL	49H		;wait for a key
 	CALL	CLRSCR		;erase message
 	JP	CMDLP		;and back to menu
 FOUND	POP	BC		;fix the stack
 	PUSH	HL		;save chrtab loc
 	LD	HL,(TEMP1)	;get normal 1
 	LD	(TEMP4),HL	;move it
 	LD	HL,(TEMP2)	;get bittab location
 	LD	(TEMP5),HL	;save it
 	POP	HL		;get back our pos
 	LD	(TEMP1),HL	;save it
 	PUSH	IX		;ix=bit info
 	POP	HL		;HL=bit info
 	LD	(TEMP2),HL	;save it
 	CALL	CLRBX		;erase last box
 	CALL	DRWBX		;and redo it
 	LD	A,(COL)		;get columns
 	LD	B,A		;B=number of columns
 	LD	A,(STRTX)	;get start
 	LD	(X),A
 	LD	A,(STRTY)
 	LD	(Y),A
 EDLP2	PUSH	BC		;save columns
 	LD	B,8		;height of character
 	LD	A,(IX)		;get first bit
 EDLP3	PUSH	BC		;save counter
 	RLA			;shift through carry
 	PUSH	AF		;save character
 	CALL	C,SET		;set it if bit is on
 	LD	A,(Y)		;get y value
 	INC	A		;add 1
 	LD	(Y),A		;save it
 	POP	AF		;get back character
 	POP	BC		;get back count
 	DJNZ	EDLP3		;loop for 8 bits
 	POP	BC		;get back columns
 	LD	A,(X)		;get x
 	INC	A		;add 1
 	LD	(X),A		;save it
 	LD	A,(STRTY)	;get start
 	LD	(Y),A		;reset it
 	INC	IX		;point to next
 	DJNZ	EDLP2		;loop til done
 	LD	A,(STRTX)
 	LD	(X),A
 	LD	A,(STRTY)
 	LD	(Y),A
 	LD	A,1
 	LD	(SFLAG),A
 	CALL	DOERA		;and start edit mode
 	XOR	A		;remove flag
 	LD	(SFLAG),A
 	LD	HL,(TEMP4)	;swap back pointers
 	LD	(TEMP1),HL
 	LD	HL,(TEMP5)
 	LD	(TEMP2),HL
 	CALL	CLRSCR		;erase prompt
 	JP	CMDLP		;and back for now
 WRITE	LD	HL,PROMPT	;point to filespec
 	CALL	DISPLY		;show it
 	LD	HL,BUFF		;point to buffer
 	LD	A,20		;maximum for file
 	CALL	INPUT		;get input
 	LD	(IX),0DH	;set end marker
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,BUFF		;point to buffer
 	LD	B,00H		;set LRL=256
 	CALL	4420H		;open or create
 	JP	NZ,ERROR	;go if error
 	JR	C,FIRST		;go if doesn't exsist
 	CALL	CLRSCR		;else erase prompt
 	LD	HL,PROMP1	;point to overwrite
 	CALL	DISPLY		;show it
 PRMP	CALL	49H		;wait for inkey
 	AND	5FH		;convert
 	CALL	33H		;print it
 	CP	'N'		;no?
 	JR	NZ,FIRST	;go if overwrite
 	CALL	CLRSCR		;else erase it
 	JP	CMDLP		;and go back
 FIRST	LD	HL,COLUMN	;point to total
 	LD	BC,3977D	;file length
 WRTLP	LD	DE,BUFF		;point to buffer
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write a byte
 	JP	NZ,ERROR	;go if error
 	LD	A,(3C3EH)	;get a byte
 	XOR	0AH		;toggle a *
 	LD	(3C3EH),A	;show it
 	INC	HL		;point to next
 	DEC	BC		;minus 1
 	LD	A,B		;get MSB
 	OR	C		;0=done
 	JR	NZ,WRTLP	;loop til done
 	LD	DE,BUFF		;now close the file
 	CALL	4428H		;do it
 	CALL	CLRSCR		;erase all prompts
 	JP	CMDLP		;and return
 LOAD	CALL	CLRSCR		;erase anything
 	LD	HL,PROMPT	;point to prompt
 	CALL	DISPLY		;show it
 	LD	HL,BUFF		;point to buffer
 	LD	A,20		;bytes for input
 	CALL	INPUT		;wait for it
 	LD	(IX),0DH	;set C/R
 	LD	HL,DUMMY	;point to dummy
 	LD	DE,BUFF		;point to file
 	LD	B,00H		;set LRL=256
 	CALL	4424H		;open don't create
 	JP	NZ,ERROR	;go if error
 	LD	HL,COLUMN	;else point to buffer
 	LD	BC,3977D	;bytes to load
 LOADLP	LD	DE,BUFF		;point to buffer
 	CALL	13H		;read a byte
 	JP	NZ,ERROR	;go if error
 	LD	(HL),A		;else store
 	INC	HL		;point to next
 	DEC	BC		;minus 1
 	LD	A,(3C3EH)
 	XOR	0AH
 	LD	(3C3EH),A
 	LD	A,B
 	OR	C
 	JR	NZ,LOADLP	;loop til done
 	LD	A,(COLUMN)	;get font
 	LD	(COL),A		;and move it
 	LD	A,(TOTAL)	;get total
 	LD	B,A		;set in loop
 	LD	HL,CHRTAB	;point to table
 	LD	DE,BITTAB	;point to table 2
 WRT1	PUSH	BC		;save it
 	LD	A,(COLUMN)	;get columns
 	LD	B,A		;step loop
 	INC	HL		;point to next char
 WRT2	INC	DE		;point to next bit
 	DJNZ	WRT2		;loop for 8
 	POP	BC		;get back count
 	DJNZ	WRT1		;loop til done
 	LD	(TEMP1),HL	;store address
 	LD	(TEMP2),DE	;"	"
 	CALL	CLRSCR		;erase prompts
 	LD	A,(COLUMN)	;get column size
 	CP	12D		;standard?
 	JP	Z,STAND		;go if yes
 	JP	DOUB		;else its double
 ERROR	PUSH	AF		;save error
 	CALL	CLRSCR		;erase prompts
 	POP	AF		;get back prompt
 	SET	7,A		;set for return
 	CALL	4409H		;display error
 	CALL	49H		;wait for key press
 	CALL	CLRSCR		;erase it
 	JP	CMDLP		;back to menu
 SHMN	LD	HL,MMSG		;place to show it
 	LD	DE,3C38H	;point to message
 	LD	BC,7		;length
 	LDIR			;block move it
 	RET			;and return
 ERMN	LD	HL,AMSG		;point to other message
 	LD	DE,3C38H	;location
 	LD	BC,7		;bytes to copy
 	LDIR			;block move them
 	RET			;back to caller
 DOS	CALL	CLRSCR		;erase any prompt
 	LD	HL,SMSG		;point to message
 	CALL	DISPLY		;show it
 DOS1	CALL	49H		;wait for any key
 	AND	5FH		;convert to upper
 	CALL	33H		;display it
 	PUSH	AF		;save char
 	LD	A,0DH
 	CALL	33H
 	POP	AF		;get back after C/R
 	CP	'Y'		;MUST BE YES
 	JP	Z,402DH		;go if YES
 	CALL	CLRSCR		;else erase message
 	JP	CMDLP		;and go back
 DISPLY	LD	A,(HL)		;get a byte
 	CP	03H		;end of msg
 	RET	Z		;back if yes
 	CALL	33H		;else print it
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 MENU	DEFM	'      Font Writer - Version 2.0   <c> 1984       Menu :      '
 	DEFW	0D0DH
 	DEFM	'                              <L>oad Font'
 	DEFB	0DH
 	DEFM	'                              <W>rite Font to Disk'
 	DEFB	0DH
 	DEFM	'                              <E>dit Font Character'
 	DEFB	0DH
 	DEFM	'                              <H>ardcopy Font Characters'
 	DEFB	0DH
 	DEFM	'                              <D>efine Matrix of Font'
 	DEFB	0DH
 	DEFM	'                              <C>reate Font Character'
 	DEFB	0DH
 	DEFM	'                              <R>eturn to DOS'
 	DEFW	0D0DH
 	DEFM	'Draw Commands : <D>raw / <E>rase / <P>rint / < >Reverse'
 	DEFB	0DH
 	DEFM	'<CLEAR> - Erase Image / <ENTER> - Add Image'
 	DEFW	0D0DH
 	DEFB	03H
 MENU0	DEFM	'Select Matrix Wanted :	'
 	DEFB	0DH
 	DEFM	'                         A> Standard 8 x 12'
 	DEFB	0DH
 	DEFM	'                         B> Double 8 x 24'
 	DEFB	03H
 MENU1	DEFM	'Enter <A>SCII / <D>ecimal / or <BREAK to exit> : '
 	DEFB	03H
 MENU2	DEFM	'Enter Decimal Value : '
 	DEFB	03H
 MENU3	DEFM	'Enter ASCII Character : '
 	DEFB	03H
 MENU4	DEFM	'Character ALREADY Defined...any key to exit'
 	DEFB	03H
 COPY	DEFM	'Font Writer & Font Driver, Copyright 1984 by Mel Patrick'
 	DEFB	03H
 DMSG	DEFM	'Mode = Draw '
 	DEFB	03H
 EMSG	DEFM	'Mode = Erase'
 	DEFB	03H
 NMSG	DEFM	'Character NOT contained in Table..'
 	DEFB	03H
 PROMPT	DEFM	'Filename : '
 	DEFB	03H
 PROMP1	DEFM	'File Already Exsists....Overwrite (Y/N) : '
 	DEFB	03H
 MMSG	DEFM	'Main   '	;for menu selection
 AMSG	DEFM	'Alt.   '	;for alternate
 LMSG	DEFM	' * * Character Definition Buffer FULL * *'
 	DEFB	03H
 SMSG	DEFM	'--> Return to DOS (Y/N) : '
 	DEFB	03H
 PRTCMD	DEFB	27		;escape mode
 	DEFM	'L'		;standard size
 COL	DEFB	12		;number of columns
 	DEFB	8		;modulo of 1
 STRTY	DEFB	10		;starting point Y axis
 STRTX	DEFB	11D		;starting point X axis
 LEN	DEFB	00H
 LEN1	DEFB	00
 CAP	DEFB	00H
 SVX	DEFB	00H		;byte storage
 SVY	DEFB	00H		;"	"
 MAXY	DEFB	00H		;max Y axis
 MAXX	DEFB	00H		;max X axis
 X	DEFB	00H		;x position
 Y	DEFB	00H		;y position
 BIT	DEFB	00H		;0=off 1 =on
 MODE	DEFB	00H		;0=erase 1=draw only
 SELECT	DEFB	00H		;mode select
 SFLAG	DEFB	00H		;return flag
 VIDEO	DEFW	0000H		;cursor address
 TIME	DEFW	1000H
 TEMP	DEFB	00H		;storage
 TEMP1	DEFW	0000H		;"	"
 TEMP2	DEFW	0000H		;"	"
 TEMP3	DEFB	00H		;"	"
 TEMP4	DEFW	0000H
 TEMP5	DEFW	0000H
 MAXCHR	DEFB	159D		;maximum # char.
 TABLE	DEFB	128,64,32,16	;for bit calc
 	DEFB	8,4,2,1		;"	"
 DUMMY	DEFS	256		;dummy I/O block
 DUM	DEFB	00H
 BUFF	DEFS	50D		;buffer storage
 COLUMN	DEFB	00H		;number of columns
 TOTAL	DEFB	00H		;total characters
 CHRTAB	DEFS	159D		;maximum characters
 BITTAB	DEFS	3816D		;maximum bits (159 char)
 LENGTH	DEFW	$-CRFONT	;program length
 	END	CRFONT

