       ;Font Driver Version 1.0 for use with Font Writer
 ;Requires EPSON printer with GRAFTRAX options.
 ;<c> 1983 by Mel Patrick
 	ORG	0ED20H		;temp origin
 FONTDV	LD	A,(HL)		;get character
 	CP	0DH		;end of command?
 	JR	NZ,CONT		;no then continue
 FONT1	LD	HL,ERRMSG	;else point to error
 	CALL	4467H		;show it
 	JP	402DH		;back to Dos Ready
 CONT	CP	'A'		;look for Dot Spaces
 	JR	NC,NODOT	;go if no dot spaces set
 	SUB	30H		;else make it digit 0-9
 	LD	(DOTSP),A	;and save it
 NODOT	INC	HL		;point to next
 	LD	A,(HL)		;get a byte
 	CP	','		;look for a comma
 	JR	Z,GOTCOM	;go if found
 	CP	' '		;else space?
 	JR	Z,GOTCOM	;go if yes
 	CP	0DH		;else end of line?
 	JR	Z,FONT1		;go if no file spec
 	JR	NODOT		;loop til something found
 GOTCOM	LD	DE,BUFF		;point to buffer
 GOT1	INC	HL		;point to next
 	LD	A,(HL)		;get a byte
 	LD	(DE),A		;move it
 	CP	0DH		;end of line?
 	JR	Z,DOLOAD	;go if yes
 	INC	DE		;else point to next
 	JR	GOT1		;loop til read in
 DOLOAD	LD	HL,DUMMY	;point to dummy I/O
 	LD	DE,BUFF		;point to buffer
 	LD	B,00H		;set LRL=256
 	CALL	4424H		;open not create
 	JP	NZ,ERROR	;go if error
 	LD	HL,COLUMN	;point to data
 	LD	BC,3977D	;bytes to load
 LOADLP	LD	DE,BUFF		;point to file
 	CALL	13H		;read a byte
 	JP	NZ,ERROR	;go if error
 	LD	(HL),A		;else store byte
 	LD	A,(3C3FH)	;get byte
 	XOR	0AH		;toggle a *
 	LD	(3C3FH),A	;show it on video
 	INC	HL		;point to next
 	DEC	BC		;minus 1
 	LD	A,B		;test
 	OR	C		;for 0
 	JR	NZ,LOADLP	;loop til done
 	LD	A,(COLUMN)	;get number of columns
 	LD	(COL),A		;move to command
 	LD	HL,INIT		;point to message
 	CALL	4467H		;show it
 	JP	ARROW		;and continue
 ERROR	SET	7,A		;set return
 	CALL	4409H		;display it
 	JP	402DH		;back to dos
 INIT	DEFM	'---> Font Driver 1.0 Initialized <---'
 	DEFW	0A0AH
 	DEFB	03H
 ERRMSG	DEFM	'* * Parameter Specification Error * *'
 	DEFW	0A0AH
 	DEFM	'Enter in FONTDVR,d,filespec <ENTER>'
 	DEFB	0AH
 	DEFM	'd - dot spaces to use between letters (optional)'
 	DEFB	0AH
 	DEFM	'filespec - font file to use'
 	DEFW	0A0AH
 	DEFB	03H
 DUMMY	DEFS	256		;dummy I/O block
 BUFF	DEFS	50		;file control block
 ARROW	LD	HL,PRTDVR	;point to routine
 	DEC	HL		;back up 1
 	DEC	HL		;and another for memory
 	LD	A,(3000H)	;test Model I or III
 	CP	0C3H		;JP=Model III
 	JR	Z,MOD3		;go if Model III
 	LD	(4049H),HL	;else reset Model I
 	JR	ARR1		;and continue
 MOD3	LD	(MODEL),A	;reset Model type
 	LD	(4411H),HL	;and memory size
 ARR1	LD	HL,(4026H)	;get normal address
 	LD	(ROUTE+1),HL	;put in our driver
 	LD	HL,PRTDVR	;point to ours
 	LD	(4026H),HL	;replace vector
 	JP	402DH		;and back to DOS
 PRTDVR	LD	HL,KEYS		;point to defined keys
 	LD	A,(TOTAL)	;get number of keys
 	LD	B,A		;move to scan
 	LD	A,C		;get letter to print
 	CP	0EFH		;toggle driver on/off
 	JR	Z,BYPASS	;go if yes
 	LD	A,(BYFLAG)	;get status
 	OR	A		;0=off 1=on
 	JP	Z,ROUTE		;leave if off
 	LD	A,C		;else get back character
 	CP	0FFH		;change font size?
 	JR	Z,FONTSZ	;go if not
 	CP	0F0H		;change dot spacing?
 	JR	NC,CDSPC	;go if yes
 	JR	SCAN		;else look in table
 CDSPC	SUB	0F0H		;change dot spacing
 	LD	(DOTSP),A	;save it
 	RET			;back to caller
 FONTSZ	LD	A,(SIZE)	;get dots per line
 	XOR	07H		;toggle K&L
 	LD	(SIZE),A	;save result
 	RET			;and go back
 BYPASS	LD	A,(BYFLAG)	;do routine or not
 	XOR	01H		;toggle a bit
 	LD	(BYFLAG),A	;save it
 	RET			;and back to caller
 SCAN	CP	(HL)		;check for match
 	JR	Z,MATCH		;go if found
 	INC	HL		;else point to next
 	DJNZ	SCAN		;loop for count
 ROUTE	JP	0000H		;go if not found
 MATCH	LD	HL,DATA		;point to data
 	LD	A,(TOTAL)	;get # defined
 	SUB	B		;get step value
 	OR	A		;test for first 1
 	JR	Z,MSTEP1	;go if first 1
 	LD	B,A		;move it back
 	PUSH	DE		;save pointer
 	LD	A,(COLUMN)	;get column size
 	LD	E,A		;move for table step
 	LD	D,00H		;set MSB to zero
 MSTEP	ADD	HL,DE		;find data
 	DJNZ	MSTEP		;loop til HL=DATA
 	POP	DE		;restore register
 MSTEP1	PUSH	HL		;save the address
 	LD	HL,CMD		;point to command
 	LD	B,4		;bytes to turn it on
 LP	LD	A,(HL)		;get character
 	CALL	SEND		;send it out
 	INC	HL		;point to next
 	DJNZ	LP		;loop til bit plot on
 	POP	HL		;get data address now
 	LD	A,(COLUMN)	;get columns
 	LD	B,A		;move to loop
 LP0	LD	A,(HL)		;get character
 	CALL	SEND		;write to printer
 	INC	HL		;point to next
 	DJNZ	LP0		;loop til done
 	LD	A,(DOTSP)	;check dot spacing
 	OR	A		;0=none
 	RET	Z		;back if none set
 	LD	HL,CMD		;else point to cmd
 	LD	A,(DOTSP)	;get dot spacing
 	LD	(COL),A		;change cmd
 	LD	B,4		;bytes to send
 DOTLP	LD	A,(HL)		;get a char
 	CALL	SEND		;send it out
 	INC	HL		;point to next
 	DJNZ	DOTLP		;loop til done
 	LD	A,(COL)		;get dot spaces
 	LD	B,A		;move to loop
 DOTLP1	LD	A,00H		;send out spaces
 	CALL	SEND		;send it
 	DJNZ	DOTLP1		;loop til done
 	LD	A,(COLUMN)	;get normal size
 	LD	(COL),A		;reset cmd
 	RET			;back to caller
 SEND	PUSH	AF		;save character
 SENDLP	LD	A,(37E8H)	;get printer status
 	AND	0F0H		;mask to check
 	CP	30H		;test bit 7
 	JR	NZ,SENDLP	;no then wait
 	LD	A,(MODEL)	;get model type
 	OR	A		;0=Model I
 	JR	NZ,M3PRT	;go if Model III
 	POP	AF		;else get back character
 	LD	(37E8H),A	;send it out
 	RET			;back to caller
 M3PRT	POP	AF		;get character
 	OUT	(248),A		;send to printer
 	RET			;and back to caller
 BYFLAG	DEFB	01H		;set to on initially
 DOTSP	DEFB	00H		;dot spaces for letters
 MODEL	DEFB	00H		;0=model I else Mod III
 CMD	DEFB	27
 SIZE	DEFM	'L'		;K will be double size
 COL	DEFB	12		;number of columns
 	DEFB	8		;command bit plot
 COLUMN	DEFB	00H		;columns used
 TOTAL	DEFB	00H		;total defined
 KEYS	DEFS	159D		;holds 159 characters
 DATA	DEFS	3816D		;bit info
 LENGTH	DEFW	$-FONTDV	;program length
 	END	FONTDV

