;------------------------------------------------------
;  NOTEPAD/ASM -- Program to create a window on screen
;  for writing small notes (Max 250 char).  It will be
;  resident in memory.  Filter the *ki for the trigger
;  key (<CTL><N>), when pressed, the filter will save
;  the current regs, cursor position, and screen data.
;  Then it will open a window of 25 char. by 13 lines
;  in the upper right hand corner of the screen.  It
;  will allow input of chars., CR, and arrow keys. It
;  will save the note in memory and to disk (<CTL><S>.
;  BRK will clear the note screen (as will save).
;------------------------------------------------------
;  Get macro library
*LIST OFF
*GET MACLIB/ASM
*LIST ON
;------------------------------------------------------
;  Define constants
CR	EQU	0DH
LF	EQU	0AH
EXT	EQU	03H
BRK	EQU	80H
UPARR	EQU	0BH
DNARR	EQU	0AH
LFTARR	EQU	08H
RHTARR	EQU	09H
STTKEY	EQU	0EH		;<CTL><N>
SAVKEY	EQU	13H		;<CTL><S>
ENDKEY	EQU	05H		;<CTL><E>
TROW	EQU	0
TCOL	EQU	55
NROW	EQU	12
NCOL	EQU	25
TXTTOP	EQU	3
TXTBOT	EQU	11
WINWID	EQU	TCOL+NCOL
W_STRT	EQU	0<8+55
;------------------------------------------------------
	ORG	3000H
;------------------------------------------------------
;	TRSDOS Memory Header
;------------------------------------------------------
BEGIN	JR	START		;Jump around header
OLDHI	DW	$-$		;Word for old HIGH$
	DB	2		;Length of module name
MODNAM	DB	'NP'
MODDCB	DW	$-$		;Word for DCB address
	DW	0		;Reserved for TRSDOS
;
;------------------------------------------------------
;	Link to *KI chain
;------------------------------------------------------
CHAIN	PUSH	IX		;Save the old value
	LD	IX,(MODDCB)	;Get our DCB address
RL01	EQU	$-2
	@@CHNIO			;Move down the *KI chain
	POP	IX		;Recover orig. pointer
	RET
;
;------------------------------------------------------
;	Start of Filter Code
;------------------------------------------------------
START	JR	NC,CHAIN	;Go if not GET request
	CALL	CHAIN		;Else get keystroke
RL02	EQU	$-2
	RET	NZ		;Return if no key
	CP	STTKEY		;Our trigger key?
	JR	NZ,NOSTART	;No--leave quickly
	LD	A,(ACTIVE)	;Get current program status
RL03	EQU	$-2
	OR	A		;Already active?
	JR	Z,START10	;No--get started
	LD	A,STTKEY	;Else replace keystroke
NOSTART	CP	A		;Set Z-flag
	RET			;and leave
;
;------------------------------------------------------
;	Save registers before processing
;------------------------------------------------------
START10	DEC	A		;A=-1
	LD	(ACTIVE),A	;Show program active
RL04	EQU	$-2
	RPUSH	BC,DE,HL,IX,IY	;Save everything
;
;------------------------------------------------------
;  Start of notepad program
;------------------------------------------------------
STARTN	LD	BC,NROW<8+NCOL	;BC=>number of rows & cols
	LD	DE,SCRNBUF	;pointer to save area
RL05	EQU	$-2
	LD	HL,TROW<8+TCOL	;HL=>window start
				;H=row, L=col
	CALL	SAVSCRN		;Save screen contents
RL06	EQU	$-2
	LD	HL,(W_CUR$)	;Get orig cur pos
RL07	EQU	$-2
	LD	(S_CUR$),HL	;Save it
RL08	EQU	$-2
	LD	BC,NROW<8+NCOL
	LD	DE,NOTEBUF
RL09	EQU	$-2
	LD	HL,TROW<8+TCOL
	CALL	DSPSCRN		;Print note buffer to screen
RL10	EQU	$-2
;
;------------------------------------------------------
; Position cursor at top of note text
;------------------------------------------------------
CURPOS	LD	HL,W_STRT	;Point at beginning
				;of window
	INC	H		;Advance two rows
	INC	H
	@@VDCTL	3		;Position cursor there
	LD	(W_CUR$),HL	;Save new cursor position
RL11	EQU	$-2
;
;------------------------------------------------------
;  Input routine--Record note on screen
;------------------------------------------------------
RDKBD	@@KEY			;Get key stroke
	LD	C,A		;Save char. and prepare display
	CP	' '  		;Was is less than ' '?
				;I.e. was it a control?
	JR	C,CONTRL	;Yes, scan keyboard again
	CP	BRK		;Was it break?
	JP	Z,ERASE		;Yes, erase notepad
RL12	EQU	$-2
	CP	128  		;Is it greater than ASCII
	JR	NC,RDKBD	;Yes, get another key
	@@DSP			;Put char on screen & adv curs
	LD	HL,(W_CUR$)	;Get curs pos, H=row, L=col
RL13	EQU	$-2
	INC	L		;Increase curs col count
	LD	A,WINWID-1	;Ck for end of window-move curs
				;to right if it is
	CP	L
	CALL	C,MOVDWN	;Move down and to right col
RL14	EQU	$-2
	LD	(W_CUR$),HL	;Save new curs. position
RL15	EQU	$-2
	JR	RDKBD		;Keeplooping
;
;------------------------------------------------------
;  CONTRL --process a control key
;------------------------------------------------------
CONTRL	CP	CR		;Was it return?
	CALL	Z,MOVDWN	;Yes, advance cursor
RL16	EQU	$-2
	CP	UPARR		;Was it up arrow?
	JR	Z,CURUP		;Yes, move cursor
	CP	DNARR		;Was it down arrow?
	JR	Z,CURDWN	;Yes, move cursor
	CP	LFTARR		;Was it left arrow?
	JR	Z,CURLFT	;Yes, move cursor
	CP	RHTARR		;Was it right arrow?
	JR	Z,CURRHT	;Yes, move cursor
	CP	ENDKEY		;Was it <CTRL><N>?
	JP 	Z,CLOSE		;Yes, close and return
RL17	EQU	$-2
	CP	SAVKEY		;Was it save key?
	JR	Z,SAVE		;Yes, save note
CTLEND	LD	(W_CUR$),HL	;Save new curs. pos
RL18	EQU	$-2
	@@VDCTL	3		;Move cursor
	JR	RDKBD
;
;------------------------------------------------------
;  CURUP -- Move cursor up a line in the window
;------------------------------------------------------
CURUP   LD	C,A
	LD	A,TXTTOP-1
	CP	H
	JR	NC,CTLEND
	DEC	H		;H=>one row up
	JR	CTLEND
;------------------------------------------------------
;  CURDWN -- Move cursor up a line in the window
;------------------------------------------------------
CURDWN  LD	C,A
	LD	A,TXTBOT-1
	CP	H
	JR	C,CTLEND
	INC	H		;H=>one row up
	JR	CTLEND
;------------------------------------------------------
;  CURLFT -- Backspace with out erase
;------------------------------------------------------
CURLFT	LD	A,TCOL		;Is there one space?
	CP	L		;L=current cur col
	JR	NC,CTLEND	;No room, go back
	DEC	L		;L=>one col back
	JR	CTLEND
;------------------------------------------------------
;  CURRHT -- Move cursor forward without erase
;------------------------------------------------------
CURRHT	LD	A,WINWID-1	;One space before end?
	CP	L
	JR	C,CTLEND	;No room
	INC	L		;L=>one col right
	JR	CTLEND
;
;------------------------------------------------------
; SAVE -- Save current note, clear buffer, move cursor
; to top of text window
;------------------------------------------------------
SAVE	RPUSH	BC,DE,HL
	LD	BC,NROW<8+NCOL
	LD	DE,NOTEBUF
RL19	EQU	$-2
	LD	HL,W_STRT
	CALL	SAVSCRN
	LD	HL,NOTETXT
RL20	EQU	$-2
	LD	B,0		;;LRL = 256
	LD	DE,FCB1
RL21	EQU	$-2
	DEFINE	@INIT,3AH
	SVC	@INIT,CHECK	;Open file or create it
	DEFINE	@PEOF,41H
	SVC	@PEOF
	CP	1CH
	JR	Z,$1?
	@@ERROR	A		;Error exit
$1?	@@VER
	@@CLOSE
	RPOP	HL,DE,BC
;
;------------------------------------------------------
;  ERASE -- will clear the window and the notepad buffer
;  then display a blank note pad with cursor in upper left
;  corner
;------------------------------------------------------
ERASE	RPUSH	BC,DE,HL	;Save regs
	LD	HL,NOTEBUF	;Point at buffer start
RL22	EQU	$-2
	LD	DE,NCOL		;Number of cols per row
	ADD	HL,DE		;Skip first two rows
	ADD	HL,DE
	LD	C,10		;Number of rows in note
BLKROW	LD	B,25		;Number of cols in note
BLKCOL	LD	(HL),' '	;Put a space
	INC	HL		;Point next char
	DJNZ	BLKCOL		;loop for row
	DEC	C		;Next row?
	JR	NZ,BLKROW	;Yes
	LD	BC,NROW<8+NCOL
	LD	DE,NOTEBUF
RL23	EQU	$-2
	LD	HL,TROW<8+TCOL
	CALL	DSPSCRN		;Put empty note on screen
RL24	EQU	$-2
        RPOP	HL,DE,BC	;Restore regs
	JP	CURPOS
RL25	EQU	$-2
;
;------------------------------------------------------
;  Move cursor down to next line if available
;  H=Current row number, A=last key pressed
;  Return with HL set to start of next row
;------------------------------------------------------
MOVDWN	LD	A,TXTBOT-1	;Maximum no rows
        LD	L,TCOL          ;L=first column of window
	CP	H		;Is cursor on last row?
	JR	C,OUTCR		;Yes, ignore key
	INC	H		;Now H is one row down
OUTCR	LD	(W_CUR$),HL	;Save new curs. position
RL26	EQU	$-2
	@@VDCTL	3		;Do it
	LD	A,00H		;Clear char
	RET			;Return
;
;------------------------------------------------------
;  Close window, save note, and return
;------------------------------------------------------
CLOSE	LD	BC,NROW<8+NCOL	;Save note to buffer
	LD	DE,NOTEBUF
RL27	EQU	$-2
	LD	HL,TROW<8+TCOL
	CALL	SAVSCRN
RL28	EQU	$-2
	LD	BC,NROW<8+NCOL	;Put screen back
	LD	DE,SCRNBUF
RL29	EQU	$-2
	LD	HL,TROW<8+TCOL
	CALL	DSPSCRN
RL30	EQU	$-2
	LD	HL,(S_CUR$)	;Get original cursor pos
RL31	EQU	$-2
	@@VDCTL	3		;Put it back
;
;------------------------------------------------------
;	Get ready to leave
;------------------------------------------------------
DONE	RPOP	IY,IX,HL,DE,BC	;Recover all registers
	OR	1		;Set NZ flag
	LD	A,0		;Return no character
	LD	(ACTIVE),A	;show program done
RL32	EQU	$-2
	RET			;Back to calling program
;
;------------------------------------------------------
; DSPSCRN -- will print a buffer to screen one character
; at a time.
; HL==>starting R & C
; DE==>Buffer to display
; BC==>Row and col count
;------------------------------------------------------
DSPSCRN	RPUSH	BC,DE,HL	;Save regs
	@@VDCTL	3		;Move cursor start of window
	RPOP	HL,DE,BC	;Restore regs
	EX	DE,HL		;Save pointer in DE
				;HL=>Buffer, DE=>R & C
NXTROW	PUSH	BC		;Save row & col count
	LD	B,C		;Number of chars. per row
NXTCHR	LD	A,(HL)		;Get buffer char.
	PUSH	BC		;Save reg
	LD	C,A		;Prepare to display
	@@DSP
	POP	BC		;Restore reg
	INC	HL		;Point at next char
	DJNZ	NXTCHR		;Loop for entire row
	POP	BC		;Recover row, col count
	EX	DE,HL		;Save pointer to buffer
				;HL=>row & col
	INC	H		;Go to next row
	RPUSH	DE,HL		;Save effected regs
	@@VDCTL	3		;Put cursor there
	RPOP	HL,DE		;Get regs back
	EX	DE,HL		;Save new cursor pos
				;HL=>note buffer pos
	DEC	B		;Reduce row count
	JR	NZ,NXTROW	;Do it again
	RET
;
;------------------------------------------------------
; SAVSCRN -- will save a screen to buffer one character
; at a time.
; HL==>starting R & C
; DE==>Buffer to save to
; BC==>Row and col count
;------------------------------------------------------
SAVSCRN	RPUSH	BC,DE,HL	;Save regs
	@@VDCTL	4		;get cursor position
	LD	(W_CUR$),HL	;Save cursor position
RL33	EQU	$-2
	LD	HL,W_STRT	;Move cursor to start of window                 	@@VDCTL	3
	RPOP	HL,DE,BC	;Restore regs
ROWLP	RPUSH	BC,HL		;Save BC&HL again
     	LD	B,C             ;Put col count in B
COLLP	RPUSH	DE,HL		;Save regs
	@@VDCTL	1		;Get char.
	RPOP	HL,DE		;Restore Regs
	EX	DE,HL		;HL=>buffer
	LD	(HL),A		;Save char
	INC	HL		;Bump buffer pntr
	EX	DE,HL		;HL=>row and col screen
	INC	L		;bump col
	DJNZ	COLLP		;Do for entire col
	RPOP	HL,BC		;Get original row/col count
	INC	H		;Move cur down row
	DEC	B		;Sub 1 row
	JR	NZ,ROWLP
	RET
;
;------------------------------------------------------
;	Data area
;------------------------------------------------------
ACTIVE	DB	0		;flag to prevent reentry
FCB1	DB	'NOTEPAD/DAT                     '
NOTEBUF DB	'NOTEPAD -- <CTL><S>=SAVE,'
        DB	'<BRK>=ERASE, <CTL><E>=END'
NOTETXT	DC	256,32		;Beginning of note text
SCRNBUF	DS	300		;Working buffer
W_CUR$	DW	$-$		;Row/col of window cursor
S_CUR$	DW	$-$		;Row/col of screen cursor
;
;------------------------------------------------------
FLTEND	EQU	$-1
FLTLEN	EQU	$-BEGIN
;
;===========================================================
;	Initialization
;===========================================================
INIT	PUSH	DE		;Save DCB pointer
	LD	(MODDCB),DE	;Stuff into filter
	PRINT	SIGNON		;Announce program
	LD	DE,MODNAME	;DE==>Our module name
	@@GTMOD			;Already installed?
	JR	NZ,VIASET	;No--go
	LD	HL,INSTLD	;Else HL==> error message
ERR_OUT	@@DSPLY			;Show error message
	LD	HL,-1		;Report error to TRSDOS
	@@EXIT			;and leave
;------------------------------------------------------
;	Installed with SET?
;------------------------------------------------------
VIASET	@@FLAGS			;Get flag pointer in IY
	BIT	3,(IY+2)	;Test SET bit
	JR	NZ,SETHI	;SET used--go
	LD	HL,NOSET	;Else HL==> error message
	JR	ERR_OUT		;Report message and leave
;------------------------------------------------------
;	Get current HIGH$ address
;------------------------------------------------------
SETHI	LD	HL,0		;function: get value
	LD	B,L		;B=0 ==> work with HIGH$
	@@HIGH$			;Get HIGH$ value
	LD	(OLDHI),HL	;Save in filter header
	JR	Z,RELOC		;no error--go
	LD	HL,MEMERR	;HL==> error message
	JR	ERR_OUT		;Report error and leave
;------------------------------------------------------
;	Move filter to high memory & protect
;------------------------------------------------------
RELOC	LD	IY,RELTAB	;IY==>list of relocation addrs.
	LD	DE,FLTEND	;DE==>end of the filter
	OR	A		;Reset the carry flag
	SBC	HL,DE		;Calculate the reloc. distance
	PUSH	HL		;Move distance
	POP	BC		;  To BC
RELOC1	LD	L,(IY+0)	;Get LSB of address to change
	LD	H,(IY+1)	;Get MSB of address to change
	LD	A,H		;Copy MSB
	OR	L		;Is it 0?
	JR	Z,MOVE		;Yes--go
	LD	E,(HL)		;Else pick up value
	INC	HL		;HL==> MSB
	LD	D,(HL)		;DE has old value
	EX	DE,HL		;Value to HL
	ADD	HL,BC		;add the offset
	EX	DE,HL		;Put value back in DE
	LD	(HL),D		;And put back
	DEC	HL		;  into
	LD	(HL),E		;  the filter
	INC	IY		;Bump twice
	INC	IY		;  to point to next addr.
	JR	RELOC1		;Repeat for all
;------------------------------------------------------
;	Move and protect
;------------------------------------------------------
MOVE	LD	DE,(OLDHI)	;DE==>destination
	LD	HL,FLTEND	;HL==>end of filter
	LD	BC,FLTLEN	;BC = bytes to move
	LDDR			;Move it all
	EX	DE,HL		;New HIGH$ in HL
	LD	B,0		;function: use HIGH$
	SVC	@HIGH$		;Have TRSDOS adjust HIGH$
	INC	HL		;HL==>entry point
;------------------------------------------------------
;	Set type and address in filter's DCB
;------------------------------------------------------
	POP	IX		;Get DCB address from stack
	LD	(IX),01000101B	;Set as @GET/@CTL filter
	LD	(IX+1),L	;Get LSB of address in DCB
	LD	(IX+2),H	;  and MSB
	PRINT	SUCCESS		;Report successful installation
	LD	HL,0		;Show 'no error'
	@@EXIT			;and return to TRSDOS
;------------------------------------------------------
;	Installation messages
;------------------------------------------------------
MODNAME	DB	'NP',CR
SIGNON	DB	LF,'NOTEPAD -- Memory resident note pad',LF,CR
INSTLD	DB	'Program already installed--installation aborted.',CR
NOSET	DB	'Program must be installed with SET.',CR
MEMERR	DB	'High memory not available for installation.',CR
SUCCESS DB	'Installation successfully completed.',LF
	DB	'Use FILTER command to connect to *KI',LF
	DB	'CTRL-N to activate.',CR
;------------------------------------------------------
;	Relocation table
;------------------------------------------------------
RELTAB	DW	RL01,RL02,RL03,RL04,RL05,RL06,RL07,RL08
	DW	RL09,RL10,RL11,RL12,RL13,RL14,RL15,RL16
	DW	RL17,RL18,RL19,RL20,RL21,RL22,RL23,RL24
	DW	RL25,RL26,RL27,RL28,RL29,RL30,RL31,RL32
	DW	RL33,0
;------------------------------------------------------
	END	INIT
