;------------------------------------------------------
;	Macro commans required for listings 1, 2, and 3
;	Add the necessary macros to your own library or
;	save this file as MACLIB/ASM
;------------------------------------------------------
;
;------------------------------------------------------
;	@@CHNIO -- Passes control to the next module
;	in a device chain
;------------------------------------------------------
@@CHNIO	MACRO	#DIR,#CHR,#DCB
	DEFINE	@CHNIO,14H
	IFEQ	%%,3
	PUSH	BC
	LD	B,#DIR
	LD	C,#CHR
	LD	IX,#DCB
	ENDIF
	SVC	@CHNIO
	IFEQ	%%,3
	POP	BC
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@CKBRKC -- Check & clear <Break> bit
;------------------------------------------------------
@@CKBRKC MACRO
	DEFINE	@CKBRKC,6AH
	SVC	@CKBRKC
	ENDM
;
;------------------------------------------------------
;	@@CLOSE -- close a file or device
;	#FCB defaults to value in DE
;	AF is altered
;------------------------------------------------------
@@CLOSE	MACRO	#FCB
	DEFINE	@CLOSE,3CH
	IFEQ	%%,1
	PUSH	DE
	LD	DE,#FCB
	ENDIF
	SVC	@CLOSE,CHECK
	IFEQ	%%,1
	POP	DE
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@CLS -- Clears the screen
;------------------------------------------------------
@@CLS	MACRO
	DEFINE	@CLS,69H
	SVC	@CLS,CHECK
	ENDM
;
;------------------------------------------------------
;	@@CMNDR --Execute DOs command and return to
;	calling program
;	all registers are used
;------------------------------------------------------
@@CMNDR	MACRO	#BUFFER
	DEFINE	@CMNDR,19H
	IFEQ	%%,1
	LD	HL,#BUFFER
	ENDIF
	SVC	@CMNDR
	ENDM
;
;------------------------------------------------------
;	CURSLOC -- Return current cursor location in HL
;------------------------------------------------------
CURSLOC	MACRO
	DEFINE	@VDCTL,0FH
	PUSH	BC
	LD	B,4
	SVC	@VDCTL
	POP	BC
	ENDM
;
;------------------------------------------------------
;	DASHLINE -- Displays line of dashes or
;	specified character.  Assumes cursor is
;	at beginning of line
;------------------------------------------------------
DASHLINE MACRO	#CHAR
	DEFINE	@DSP,02H
	RPUSH	BC,DE
	IFEQ	%%,1
	LD	C,#CHAR
	ENDIF
	LD	B,80		;;80 characters per line
$1?	SVC	@DSP,CHECK
	DJNZ	$1?
	RPOP	DE,BC
	ENDM
;
;------------------------------------------------------
;  @@DEBUG -- calls debug monitor if the point is set
;  on the command line
;------------------------------------------------------
@@DEBUG	MACRO	#POINT,#TITLE
	DEFINE	@DEBUG,1BH
	IF	#POINT
	SVC	@DEBUG                                                          	JR	$1?
	DB	#TITLE
$1?	EQU	$
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@DIRRD -- Reads directory sector to SYSBUF
;	and points HL to entry.  If #DRIVE and #DEC
;	aren't specified, defaults to current values
;	in BC
;------------------------------------------------------
@@DIRRD	MACRO	#DRIVE,#DEC
	DEFINE	@DIRRD,57H
	IFEQ	%%,2
	PUSH	BC
	LD	A,#DRIVE
	LD	B,A
	LD	A,#DEC
	LD	C,A
	ELSE
	IFNE	%%,0
	  ERR	'Illegal number of args for @@DIRRD'
	ENDIF
	ENDIF
	SVC	@DIRRD,CHECK
	IFEQ	%%,2
	POP	BC
	ENDIF
	ENDM
;
;------------------------------------------------------
;	DEFINE	-- Define a lable unless it
;	is already defined.
;------------------------------------------------------
DEFINE	MACRO	#LABEL,#VALUE
	IFNDEF	#LABEL
#LABEL	EQU	#VALUE
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@DSP -- Display one character on the screen
;	#char defaults to value in C register
;------------------------------------------------------
@@DSP	MACRO	#CHAR
	DEFINE	@DSP,02H
	PUSH	DE
	IFEQ	%%,1
	LD	A,#CHAR
	LD	C,A
	ENDIF
	SVC	@DSP,CHECK
	POP	DE
	ENDM
;
;------------------------------------------------------
;	@@DSPLY -- Displays line of text
;	Line defaults to value in HL
;------------------------------------------------------
@@DSPLY	MACRO	#LINE
	DEFINE	@DSPLY,0AH
	IFEQ	%%,1
	  RPUSH	DE,HL
	  LD	HL,#LINE
	  SVC	@DSPLY,CHECK
	  RPOP	HL,DE
	ELSE
	  PUSH	DE
	  SVC	@DSPLY,CHECK
	  POP	DE
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@ERROR -- Reports an error.  Depends on CFLAG$
;	and SFLAG$ for options.  Exits program via ABORT
;	Requires #ERRNO
;------------------------------------------------------
@@ERROR	MACRO	#ERRNO
	DEFINE	@ERROR,1AH
	LD	C,#ERRNO
	SVC	@ERROR
	ENDM
;
;------------------------------------------------------
;	@@EXIT -- Exits program.  #RETCOD defaults to 0
;	(no error)
;------------------------------------------------------
@@EXIT	MACRO	#RETCOD
	DEFINE	@EXIT,16H
	IFEQ	%%,1
	  LD	HL,#RETCOD
	ELSE
	  LD	HL,0
	ENDIF
	SVC	@EXIT
	ENDM
;
;------------------------------------------------------
;	@@FLAGS -- Point IY to system flag table
;	Always succeeds
;------------------------------------------------------
@@FLAGS	MACRO
	DEFINE	@FLAGS,65H
	SVC	@FLAGS
	ENDM
;
;------------------------------------------------------
;	@@FSPEC -- move filespec or devspec to an FCB
;	or DCB.  Test Z / NZ after using!  #FNAME and
;	#FCB are both required.  If #FNAME is already in
;	HL, use HL as filename.  DE is set to #FCB
;	AF is altered
;------------------------------------------------------
@@FSPEC	MACRO	#FNAME,#FCB
	DEFINE	@FSPEC,4EH
	RPUSH	BC,HL
	IFNE$	#FNAME,HL
	LD	HL,#FNAME
	ENDIF
	LD	DE,#FCB
	SVC	@FSPEC
	RPOP	HL,BC
	ENDM
;
;------------------------------------------------------
;  @@GET -- Get one byte from file or device
;  No error checking included
;  #FCB defaults to current value of DE
;  AF is altered
;------------------------------------------------------
@@GET	MACRO	#FCB
	DEFINE	@GET,03H
	IFEQ	%%,1
	  PUSH	DE
	  LD	DE,#FCB
	ENDIF
	SVC	@GET
	IFEQ	%%,1
	  POP	DE
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@GTDCT -- Loads IY with address of drive's DCT
;	#DRIVE defaults to value in C
;------------------------------------------------------
@@GTDCT	MACRO	#DRIVE
	DEFINE	@GTDCT,51H
	IFEQ	%%,1
	PUSH	BC
	LD	A,#DRIVE
	LD	C,A
	ENDIF
	SVC	@GTDCT
	IFEQ	%%,1
	POP	BC
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@GTMOD -- Locates a memory module in memory
;	returns HL=first byte of memory header
;	DE=first byte after module name
;	#NAME defaults to DE
;	Uses AF, HL, and DE
;------------------------------------------------------
@@GTMOD	MACRO	#NAME
	DEFINE	@GTMOD,53H
	IFEQ	%%,1
	PUSH	DE
	ENDIF
	SVC	@GTMOD
	IFEQ	%%,1
	POP	DE
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@HEXDEC -- #VALUE to ASCII & stores at #Buffer
;	if #VALUE is not specified, defaults to present
;	value of HL.  If no args, #BUFFER defaults to
;	present value of DE
;------------------------------------------------------
@@HEXDEC MACRO	#ARG1,#ARG2
	DEFINE	@HEXDEC,61H
	PUSH	BC
	IFEQ	%%,2
	RPUSH	DE,HL
	LD	HL,#ARG1
	LD	DE,#ARG2
	ENDIF
	IFEQ	%%,1
	PUSH	DE
	LD	DE,#ARG1
	ENDIF
	SVC	@HEXDEC
	IFEQ	%%,1
	POP	DE
	ENDIF
	IFEQ	%%,2
	RPOP	HL,DE
	ENDIF
	POP	BC
	ENDM
;
;------------------------------------------------------
;	@@HIGH$ -- Alter or read HIGH$ and LOW$ values
;	B=0 for high, B<>0 low
;	HL=0 for high/low addr, HL<>0 set high/low limit
;------------------------------------------------------
@@HIGH$	MACRO	#HORL,#VALUE
	DEFINE	@HIGH$,64H
	IFEQ	%%,2
	PUSH	BC
	PUSH	HL
	ENDIF
	SVC	@HIGH$,CHECK
	IFEQ	%%,2
	POP	HL
	POP	BC
	ENDIF
	ENDM
;
;------------------------------------------------------
;	IFEQ_JR -- Performs a JR if A=#VALUE
;------------------------------------------------------
;
IFEQ_JR	MACRO	#VALUE,#JUMP
	CP	#VALUE
	JR	Z,#JUMP
	ENDM
;
;------------------------------------------------------
;	IFLT_JR -- Performs a JR if A < #VALUE
;------------------------------------------------------
;
IFLT_JR	MACRO	#VALUE,#JUMP
	CP	#VALUE
	JR	C,#JUMP
	ENDM
;
;------------------------------------------------------
;	IFNE_JR -- Performs a JR if A <> #VALUE
;------------------------------------------------------
;
IFNE_JR	MACRO	#VALUE,#JUMP
	CP	#VALUE
	JR	NZ,#JUMP
	ENDM
;
;------------------------------------------------------
;	@@INIT -- opens an existing file or device
;	or creates it if not found
;	aborts on all errors except changed LRL
;	#BUFFER is required.
;	#LRL defaults to 0 (256)
;	#FCB defaults to current value in DE
;	AF is altered.
;------------------------------------------------------
@@INIT	MACRO	#BUFFER,#LRL=0,#FCB
	DEFINE	@OPEN,3BH
	RPUSH	BC,HL
	LD	HL,#BUFFER
	LD	B,#LRL
	IFEQ	%%,3
	LD	DE,#FCB
	ENDIF
	SVC	@OPEN,CHECK
	RPOP	HL,BC
	ENDM
;
;
;------------------------------------------------------
;	@@INSTR -- Macro to set up call to INSTR subroutine
;	Will use four paramaters and pass those paramaters
;	in the registers.
;------------------------------------------------------
@@INSTR	MACRO	#STRING,#LENSTRING,#SUBSTRING,#LENSUBSTR
	RPUSH	BC,DE,HL
	LD	HL,#LENSTRING
	LD	B,(HL)
	LD	HL,#LENSUBSTR
	LD	C,(HL)
	LD	HL,#SUBSTRING
	EX	DE,HL
	LD	HL,#STRING
	IFNEXT	INSTR
	EXT	INSTR
	ENDIF
	CALL	INSTR
	RPOP	HL,DE,BC
	ENDM
;;------------------------------------------------------
;	@@KEY -- Waits for key at *KI device.  Keystroke
;	returned in A
;------------------------------------------------------
@@KEY	MACRO
	DEFINE	@KEY,01H
	PUSH	DE
	SVC	@KEY,CHECK
	POP	DE
	ENDM
;
;------------------------------------------------------
;	@@MUL16 -- Multiplies 16-bit by 8-bit value.
;	If values aren't specified, defaults to values
;	in HL and C.  Results in HL and A.
;------------------------------------------------------
@@MUL16	MACRO	#VAL16,#VAL8
	DEFINE	@MUL16,5BH
	PUSH	DE
	IFEQ	%%,2
	  LD	HL,#VAL16
	  LD	A,#VAL8
	  LD	C,A
	ENDIF
	SVC	@MUL16
	POP	DE
	ENDM
;
;------------------------------------------------------
;	@@OPEN -- opens an existing file or device
;	aborts on all errors except changed LRL
;	#BUFFER is required.
;	#LRL defaults to 0 (256)
;	#FCB defaults to current value in DE
;	AF is altered.
;------------------------------------------------------
@@OPEN	MACRO	#BUFFER,#LRL=0,#FCB
	DEFINE	@OPEN,3BH
	RPUSH	BC,HL
	LD	HL,#BUFFER
	LD	B,#LRL
	IFEQ	%%,3
	LD	DE,#FCB
	ENDIF
	SVC	@OPEN
	RPOP	HL,BC
	JR	Z,$1?
	CP	2AH		;;check for LRL change
	JR	Z,$1?
	LD	C,A		;;else error code to C
	LD	A,1AH		;;@ERROR SVC number
	RST	28H
$1?	EQU	$
	ENDM
;
;------------------------------------------------------
;  @@PEOF -- Position to end of open file
;  Default to FCB in DE
;------------------------------------------------------
@@PEOF	MACRO	#FCB
	DEFINE	@PEOF,41H
	IFEQ	%%,1
	PUSH	DE
	LD	DE,#FCB
	ENDIF
	SVC	@PEOF
	CP	1CH		;;Ck for eof error
	JR	Z,$1?		;;Yes, go else error
	LD	C,A
	LD	A,1AH		;;@ERROR SVC number
	RST	28H
$1?	EQU	$
	IFEQ	%%,1
	POP	DE
	ENDIF
	ENDM
;
;------------------------------------------------------
;  PRINT -- prints a line terminated with either CR
;  or LF to the screen
;------------------------------------------------------
PRINT	MACRO	#ADDR
	LD	HL,#ADDR
	@@DSPLY
	ENDM
;
;------------------------------------------------------
;	RPOP -- Pops 0 to 6 registers from the stack.
;	Example:  RPOP BC,DE,HL,IX
;------------------------------------------------------
RPOP	MACRO	#R1,#R2,#R3,#R4,#R5,#R6
	IFGT	%%,0
	  POP	#R1
	ENDIF
	IFGT	%%,1
	  POP	#R2
	ENDIF
	IFGT	%%,2
	  POP	#R3
	ENDIF
	IFGT	%%,3
	  POP	#R4
	ENDIF
	IFGT	%%,4
	  POP	#R5
	ENDIF
	IFGT	%%,5
	  POP	#R6
	ENDIF
	ENDM
;
;------------------------------------------------------
;	RPUSH -- Pushes 0 to 6 registers onto the stack.
;	Example:  RPUSH BC,DE,HL,IX
;------------------------------------------------------
RPUSH	MACRO	#R1,#R2,#R3,#R4,#R5,#R6
	IFGT	%%,0
	  PUSH	#R1
	ENDIF
	IFGT	%%,1
	  PUSH	#R2
	ENDIF
	IFGT	%%,2
	  PUSH	#R3
	ENDIF
	IFGT	%%,3
	  PUSH	#R4
	ENDIF
	IFGT	%%,4
	  PUSH	#R5
	ENDIF
	IFGT	%%,5
	  PUSH	#R6
	ENDIF
	ENDM
;
;------------------------------------------------------
;	Invoke a TRSDOS 6 SVC.  If "CHECK" is specified,
;	exit through @ERROR if NZ flag is returned from
;	TRSDOS
;------------------------------------------------------
SVC	MACRO	#NUM,#CHECK
	LD	A,#NUM		;;A = SVC number
	RST	28H		;;Perform SVC
	IFGT	%%,1		;;More than one argument?
	  JR	Z,$1?		;;Go if no error
	  LD	C,A		;;Put error code in C
	  LD	A,1AH		;;@ERROR SVC number
	  RST	28H		;;Exit through @ERROR
$1?	  EQU	$		;;Here if no error
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@WRITE -- write a record to an open file
;	Defaults to values in DE and HL
;------------------------------------------------------
@@WRITE	MACRO	#FCB,#UREC
	DEFINE	@WRITE,4BH
	IFEQ	%%,2
	RPUSH	DE,HL
	LD	DE,#FCB
	LD	HL,#UREC
	ENDIF
	IFEQ	%%,1
	PUSH	DE
	LD	DE,#FCB
	ENDIF
	SVC	@WRITE,CHECK
	IFEQ	%%,2
	RPOP	HL,DE
	ENDIF
	IFEQ	%%,1
	POP	DE
	ENDIF
	ENDM
;
;------------------------------------------------------
;	@@VDCTL -- Calls one of the @VDCTL functions.
;	#FNC is required.
;------------------------------------------------------
@@VDCTL	MACRO	#FNC
	DEFINE	@VDCTL,0FH
	IFEQ	%%,0
	  ERR	"Missing parameter"
	ENDIF
	PUSH	BC
	LD	B,#FNC
	SVC	@VDCTL
	POP	BC
	ENDM
;
;------------------------------------------------------
;	@@VER -- Performs a write operation followed
;	by a test read of the sector to verify that it
;	is readable.
;	Defaults to values in DE and HL
;	uses AF
;------------------------------------------------------
@@VER	MACRO	#FCB
	DEFINE	@VER,49H
	IFEQ	%%,1
	PUSH	DE
	LD	DE,#FCB
	ENDIF
	PUSH	HL
	SVC	@VER,CHECK
	POP	HL
	IFEQ	%%,1
	POP	DE
	ENDIF
	ENDM
;
