;KBLOCK -- A key board locking filter
;-----------------------------------------------------
       ORG   3000H
BEGIN  JR    START1
OLDHI  DEFW  $-$
       DEFB  2            ;Number of bytes in mod name
MODNAM DEFB  'LK'
MODDCB DEFW  $-$
       DEFW  $-$
CHAIN  PUSH  IX
       LD    IX,(MODDCB)
REL01  EQU   $-2
       LD    A,14H		;@CHNIO
       RST   28H
       POP   IX
       RET
START1 JR    NC,CHAIN
       CALL  CHAIN
REL02  EQU   $-2
       RET   NZ
       CP    0CH		;CTRL-L
       JR    NZ,NOSTART
       LD    A,(ACTIVE)
REL03  EQU   $-2
       OR    A
       JR    Z,START2
       LD    A,0CH		;RETUREN CTRL-L
NOSTART CP    A
       RET
START2 DEC   A
       LD    (ACTIVE),A
REL04  EQU   $-2
       PUSH  BC
       PUSH  DE
       PUSH  HL
       PUSH  IX
       PUSH  IY
LOCK   LD    HL,PSSWRD	;HL=>password
REL05  EQU   $-2
       LD    A,(PSSLEN)	;A= len password
REL06  EQU   $-2
       LD    B,A	;Save len in B
RDKBD  PUSH  DE
       LD    A,01H	;Get key
       RST   28H
       JR    Z,CONT6	;No error continue
       LD    C,A
       LD    A,1AH
       RST   28H
CONT6  POP   DE
       CP    20H	;Is key lower than space?
       JR    C,RDKBD	;No, keep looking
       CP    80H	;Is it higher than ASCII?
       JR    NC,RDKBD	;Yes, keep looking
       CP    (HL)	;Is it the next char. in password?
       JR    NZ,LOCK	;No, keep looking
       INC   HL		;Point to next letter
       DJNZ  RDKBD	;Loop for all chars
       POP   IY		;Restore regs and leave
       POP   IX
       POP   HL
       POP   DE
       POP   BC
       OR    01H	;Set NZ flag
       LD    A,00H	;Return no key stroke
       LD    (ACTIVE),A	;Show not active
REL07  EQU   $-2
       RET
PSSWRD DEFB  'PASSWORD'
PSSLEN DEFB  8
ACTIVE DEFB  0
;------------------------------------------------------
FLTEND	EQU	$
FLTLEN	EQU	$-BEGIN
;------------------------------------------------------
INIT1  PUSH  AF		;Save all regs
       PUSH  BC
       PUSH  DE
       PUSH  HL
       PUSH  IX
       PUSH  IY
SKPSP  LD    A,(HL)	;HL=>CMD line
       INC   HL
       CP    0DH	;End of line?
       JR    Z,INIT2
       CP    20H	;Still space?
       JR    Z,SKPSP	;Yes, skip it
       DEC   HL		;Adj cmd line ptr
       EX    DE,HL	;Save in DE
       LD    HL,PSSWRD	;HL=>password
       LD    B,08H	;Maximum 8 chrs
       LD    C,00H	;Zero count
PSLP   LD    (HL),A	;Save char
       INC   HL		;bump ptrs
       INC   DE
       INC   C		;Increase count
       EX    DE,HL	;HL=>cmd line
       LD    A,(HL)	;Get next char
       CP    0DH	;end of line?
       JR    Z,PSEND	;Yes, go
       EX    DE,HL	;HL=>storage
       DJNZ  PSLP	;Loop for eight char
PSEND  LD    A,C	;Save len of new password
       LD    HL,PSSLEN
       LD    (HL),A
INIT2  POP   IY		;Restore regs
       POP   IX
       POP   HL
       POP   DE
       POP   BC
       POP   AF
       PUSH  DE		;Save DCB pointer
       LD    (MODDCB),DE
       LD    A,69H	;CLS
       RST   28H
       JR    Z,SIGNON	;No error continue
       LD    C,A	;display error and quit
       LD    A,1AH
       RST   28H
SIGNON LD    HL,MESS1	;Display signon message
       PUSH  DE		;Save effected reg
       LD    A,0AH	;Display line
       RST   28H
       JR    Z,ISINST	;no error continue
       LD    C,A
       LD    A,1AH
       RST   28H
ISINST POP   DE
       LD    DE,MODNM
       LD    A,53H	;Is module in memory?
       RST   28H
       JR    NZ,VIASET	;No, contiue
       LD    HL,MESS2	;Already installed message
ERREXT PUSH  DE		;Save effected reg
       LD    A,0AH	;Display line
       RST   28H
       JR    Z,CONT1	;Continue, no error
       LD    C,A
       LD    A,1AH
       RST   28H
CONT1  POP   DE
       LD    HL,0FFFFH	;Show error exit
       LD    A,16H	;Error exit
       RST   28H
VIASET LD    A,65H	;Get system flags
       RST   28H
       BIT   3,(IY+02H)	;Set used?
       JR    NZ,SETHI	;Yes, continue
       LD    HL,MESS3
       JR    ERREXT
SETHI  LD    HL,0000H
       LD    B,L
       LD    A,64H	;Get current HIGH$
       RST   28H
       JR    Z,CONT2	;No error, contiue
       LD    C,A
       LD    A,1AH
       RST   28H
CONT2  LD    (OLDHI),HL
       JR    Z,RELOC
       LD    HL,MESS4	;Hi memory not available mess
       JR    ERREXT
RELOC  LD    IY,RELTAB
       LD    DE,FLTEND
       OR    A
       SBC   HL,DE
       PUSH  HL
       POP   BC
RELLP  LD    L,(IY+00H)
       LD    H,(IY+01H)
       LD    A,H
       OR    L
       JR    Z,MOVE
       LD    E,(HL)
       INC   HL
       LD    D,(HL)
       EX    DE,HL
       ADD   HL,BC
       EX    DE,HL
       LD    (HL),D
       DEC   HL
       LD    (HL),E
       INC   IY
       INC   IY
       JR    RELLP
MOVE   LD    DE,(OLDHI)
       LD    HL,FLTEND
       LD    BC,FLTLEN
       LDDR
       EX    DE,HL
       LD    B,00H
       LD    A,64H		;Set HIGH$
       RST   28H
       INC   HL
       POP   IX
       LD    (IX),01000101B	;Set as @GET/@CTL filter
       LD    (IX+01H),L		;Addr. of DCB
       LD    (IX+02H),H
       LD    HL,MESS5		;Display success message
       PUSH  DE
       LD    A,0AH
       RST   28H
       JR    Z,CONT4
       LD    C,A
       LD    A,1AH
       RST   28H
CONT4  POP   DE
       LD    HL,0000H		;No error exit
       LD    A,16H
       RST   28H
MODNM  DEFB  'LK',0DH
MESS1  DEFB  LF,'LOCK -- Memory resident keyboard lock'
       DEFB  0AH
       DEFB  0DH
MESS2  DEFB  'Program already installed--installation aborted.'
       DEFB  0DH
MESS3  DEFB 'Program must be installed with SET.'
       DEFB  0DH
MESS4  DEFB  'High memory not available for installation.'
       DEFB  0DH
MESS5  DEFB  'Installation successfully completed.'
       DEFB  0AH
       DEFB  'Use FILTER command to connect to *KI'
       DEFB  0AH
       DEFM  'CTRL-L to activate.'
       DEFB  0DH
;------------------------------------------------------
;	Relocation table
;------------------------------------------------------
RELTAB	DW	RL01,RL02,RL03,RL04,RL05,RL06,RL07
	DW	0
;------------------------------------------------------
	END	INIT
