;XLATE/ASM - Translate filter - 12/18/81
;*=*=*
ETX	EQU	3
LF	EQU	10
CR	EQU	13
KDCB$	EQU	4015H
@ABORT	EQU	04030H
@CLOSE	EQU	04428H
@DSPLY	EQU	04467H
@ERROR	EQU	4409H
@EXIT	EQU	0402DH
@FEXT1	EQU	04473H
@FEXT3	EQU	444BH
@FSPEC	EQU	0441CH
@GET	EQU	00013H
@INIT	EQU	4420H
@LOGOT1	EQU	0447BH
@LOGOT3	EQU	428AH
@OPEN	EQU	04424H
@PARAM1	EQU	04476H
@PARAM3	EQU	4454H
@POSN	EQU	04442H
@PUT	EQU	0001BH
@REW	EQU	0443FH
@WRITE	EQU	04439H
HIGH$1	EQU	4049H
HIGH$3	EQU	4411H
KIJCL$1	EQU	43BEH
KIJCL$3	EQU	42BEH
SFLAG$1	EQU	0430FH
SFLAG$3	EQU	442BH
	COM '<Copyright (C) 1981 by Logical Systems, Incorporated>'
	ORG	5200H
XLATE	PUSH	DE		;Hang on to DCB
	POP	IX
	PUSH	HL
	LD	A,(125H)	;Model I or III
	CP	'I'
	JR	NZ,BEGIN	;Go if Model I
	LD	HL,@FEXT3
	LD	(FEXT+1),HL
	LD	HL,@PARAM3
	LD	(PARAM+1),HL
	LD	HL,@LOGOT3
	LD	(LOGOT+1),HL
	LD	HL,SFLAG$3
	LD	(SFLAG+1),HL
	LD	HL,HIGH$3
	LD	(ENDDAT0+1),HL
	LD	(HIGH+1),HL
	LD	HL,KIJCL$3
	LD	(KIJCLA+1),HL
	LD	(KIJCLB+1),HL
BEGIN	LD	HL,CPYMSG	;issue copyright message
	CALL	@DSPLY
	POP	HL
	LD	DE,FCB1		;fetch target filespec
	CALL	@FSPEC
	JP	NZ,SPCREQ	;jump on error
	PUSH	HL
	LD	HL,XLTEXT	;default ext to XLT
	CALL	FEXT
	POP	HL
	LD	DE,PRMTBL$	;Check on user parms
PARAM	CALL	@PARAM1
	JP	NZ,PRMERR
	PUSH	IX		;If the DCB is for *KI,
	POP	DE		; then use KIJCL saved
	LD	HL,KDCB$	; vector for hooks
	XOR	A
	SBC	HL,DE		;Zero if *KI
	LD	L,(IX+1)	;P/u DCB vector address
	LD	H,(IX+2)
	JR	NZ,XLATE1
SFLAG	LD	A,(SFLAG$1)	;Is DO in effect?
	AND	20H
	JR	Z,XLATE1	;Not KIJCL if no DO
KIJCLA	LD	HL,(KIJCL$1)	;P/u JCL saved vector
	LD	(WASKI+1),A	;Note for later
XLATE1	LD	(INPUT+1),HL	;Stuff into filter
	LD	(OUT1+1),HL	; Ditto
;*=*=*
;	Test for INPUT vs OUTPUT
;*=*=*
	LD	A,(IX)		;P/u type byte
	AND	3		;Test if either in or out
	JP	Z,NOTIO		;Error if neither
	BIT	0,(IX)		;If not an input device
	JR	Z,OPARM1	; then force output only
IPARM	LD	BC,0		;User want INPUT only?
	LD	A,B
	OR	C
	JR	Z,OPARM		;Go if no INPUT parm
	BIT	0,(IX)		;Test if INPUT device
	JP	Z,NOTINP	;Error if not
	LD	A,(OPARM+1)	;Cannot specify both
	OR	A		; INPUT & OUTPUT restrict
	JP	NZ,PRMERR
IPARM1	LD	A,18H		;Make OUTPUT transparent
	LD	(XLTFL1),A	; by changing to JR
	LD	(SHORTEN+1),A	;Set flag for reduction
	JR	PPARM
OPARM	LD	BC,0		;P/u user OUTPUT parm
	LD	A,B
	OR	C
	JR	NZ,OPARM0	;Go if entered
	BIT	1,(IX)		;If not an output device,
	JR	Z,IPARM1	; then force INPUT only
	JR	PPARM		;Else start the process
;*=*=*
;	If OUTPUT specified, then must be OUTPUT device
;*=*=*
OPARM0	BIT	1,(IX)		;Test if OUTPUT device
	JP	Z,NOTOUT	;Error if not
;*=*=*
;	Make INPUT translation transparent
;*=*=*
OPARM1	LD	A,0C3H		;Make INPUT transparent
	LD	(INPUT),A	; by changing to JP
	LD	(SHORTEN+1),A	;Set flag for reduction
	LD	(OPARM+1),A	; Then make the INP table
;				; the one for OUT to
	LD	HL,(ENDDAT1+1)	; reduce driver by 256
	LD	(ENDDAT2+1),HL	; bytes to conserve space
;*=*=*
;	Initialize translate tables
;*=*=*
PPARM	LD	BC,0FF00H	;P/u PRIME parameter
	INC	B		;Test if user entry
	JR	Z,INITLP	;Go if PRIME not entered
	DEC	B		;Check on P="c"
	LD	A,C		;P/u assumed hex or dec
	JR	Z,PPARM1	;Go if no string entry
	LD	A,(BC)		;P/u the string char
PPARM1	LD	HL,INPTBL	;Preinitialize the tables
	LD	DE,INPTBL+1	; to the PRIME entry so
	LD	BC,511		; all codes not found in
	LD	(HL),A		; the data table will be
	LDIR			; set to the PRIME code
	JR	START		;Bypass one-to-one
;*=*=*
;	Initialize tables to one-to-one translation
;*=*=*
INITLP	LD	HL,INPTBL+255
	LD	DE,OUTTBL+255
	LD	B,-1
INITLP1	LD	A,B		;Init INP & OUT tables
	LD	(HL),A		; tp one-to-one xlate
	LD	(DE),A		; so all codes NOT
	DEC	HL		; entered in the data
	DEC	DE		; table will remain
	DJNZ	INITLP1		; unaffected
	LD	A,B
	LD	(HL),A
	LD	(DE),A
START	LD	HL,IOBUF	;Pt to buffer
	LD	DE,FCB1		;Pt to fcb
	LD	B,0
	CALL	@OPEN		;Init the file
	JP	NZ,IOERR	;Jump on error
	LD	HL,RDING$	;Inform user
	CALL	@DSPLY
	LD	HL,256*12	;Don't read more
	LD	BC,XLTDATA
	LD	DE,FCB1
RDFIX1	CALL	@GET
	JR	NZ,RDFIX2
	AND	7FH		;strip bit 7
	JR	Z,RDFIX3
	LD	(BC),A
	DEC	HL
	LD	A,H
	OR	L
	JP	Z,TOOBIG
	INC	BC
	JR	RDFIX1
RDFIX2	CP	1CH		;end of file?
	JP	NZ,IOERR
RDFIX3	LD	A,ETX
	LD	(BC),A		;Stuff end with etx
	LD	HL,XLTDATA
;*=*=*
;	Process the xlate data
;*=*=*
RDLOOP	LD	A,(HL)		;Get input char
	INC	HL
	CP	' '		;Ignore spaces
	JR	Z,RDLOOP
	CP	ETX
	JR	Z,ENDDATA
	CP	CR		;Ignore <ENTER> at front
	JR	Z,RDLOOP	; end of digit pair
	CP	'.'		;Comment to ignore?
	JR	Z,RDCMNT
	CALL	HP1		;Get the digit pair
	LD	E,A		;Save for now
	LD	A,(HL)		;Check on syntax
	INC	HL
	CP	'='
	JP	NZ,SYNERR
RDLP1	LD	A,(HL)		;P/u next digit
	INC	HL
	CP	3		;Is it ETX?
	JP	Z,MISINF	;If so, missing info
	CALL	HP1		;get digit pair into regA
	PUSH	HL
RDLP2	LD	HL,OUTTBL	;Stuff this digit into
	LD	D,0		; offset based on first
	ADD	HL,DE		; character retrieved
	LD	(HL),A
NPARM	LD	BC,0		;P/u NULL parameter
	LD	A,C		;If NULL, then translate
	OR	B		; this output image to
	LD	C,(HL)		;
	JR	Z,RDLP3		; NULL to keep rcvd char
	LD	HL,INPTBL	; from passing through to
	ADD	HL,DE		; to this code
	LD	(HL),0		;Null the 1 to 1
RDLP3	LD	B,D		;Now offset input table
	LD	HL,INPTBL	; by this char and then
	ADD	HL,BC		; stuff the input digit
	LD	(HL),E		; translation
	POP	HL
	JR	RDLOOP
;*=*=*
;	Read & ignore a comment
;*=*=*
RDCMNT	LD	A,(HL)		;P/u data char
	INC	HL		;Bump pointer
	CP	CR		;End of comment?
	JR	NZ,RDCMNT	;Loop until <ENTER>
	JR	RDLOOP		;Else exit back to RDLOOP
;*=*=*
;	Finished parsing input, relocate filter
;*=*=*
ENDDATA	LD	A,(OPARM+1)	;If OUTPUT only, then
	OR	A		; shift OUTTBL to
	JR	Z,ENDDAT0	; INPTBL position
	LD	HL,OUTTBL
	LD	DE,INPTBL
	LD	BC,256
	LDIR
ENDDAT0	LD	HL,(HIGH$1)	;P/u current high
	LD	BC,XLTEND-XLTFLT
SHORTEN	LD	A,0		;Shorten the filter
	OR	A		; by 256 bytes?
	JR	Z,$+3
	DEC	B		;Reduce by 256 bytes
	XOR	A
	SBC	HL,BC		;New HIGH$
HIGH	LD	(HIGH$1),HL
	INC	HL		;Bump to start of filter
	PUSH	HL
ENDDAT1	LD	DE,INPTBL-XLTFLT
	ADD	HL,DE		;Relocate INP table
	LD	(INP1+1),HL
	POP	HL
	PUSH	HL
ENDDAT2	LD	DE,OUTTBL-XLTFLT
	ADD	HL,DE		;Relocate OUT table
	LD	(OUTPUT+1),HL
	POP	DE		;Where filter is moved
	PUSH	DE
	LD	HL,XLTFLT
	LDIR
	POP	HL
	DI			;Off while DCB update
WASKI	LD	A,0		;If DCB was for KI &
	OR	A		; DO was in effect,
	JR	Z,WASKI1	; then update KIJCL
KIJCLB	LD	(KIJCL$1),HL
	JR	WASKI2
WASKI1	LD	(IX+1),L
	LD	(IX+2),H
WASKI2	LD	A,0		;Patchable in case a	*
	OR	(IX)		; FILTER bit is used	*
	LD	(IX),A		; in the TYPE flag	*
	EI
	LD	HL,XLTDUN$
	CALL	LOGOT
	JP	@EXIT
;*=*=*
;	Routine to parse & convert hex pair
;*=*=*
HP1	CP	'"'		;Alpha char?
	JR	NZ,HP2
	LD	C,(HL)		;P/u character
	INC	HL
	LD	A,(HL)		;Closing quote?
	CP	'"'
	JR	NZ,$+3		;Don't bump if not quote
	INC	HL		;Bump past quote
	LD	A,C		;Xfer char
	RET
HP2	CALL	CVRTHEX
	JR	Z,ODDIGS
	RLCA			;shift to hi-order nybble
	RLCA
	RLCA
	RLCA
	LD	C,A
	LD	A,(HL)
	INC	HL
	CALL	CVRTHEX
	OR	C
	RET
CVRTHEX	SUB	30H
	JR	C,BADIGS	;can't be < '0'
	CP	10
	RET	C		;ret if 0-9
	RES	5,A		;adj to U/C
	SUB	7		;cvrt A-F
	CP	16
	RET	C
	JR	BADIGS
FEXT	JP	@FEXT1
LOGOT	JP	@LOGOT1
IOERR	OR	40H
	JP	@ERROR
NOTIO	LD	HL,NOTIO$
	DB	0DDH
NOTINP	LD	HL,NOTINP$
	DB	0DDH
NOTOUT	LD	HL,NOTOUT$
	DB	0DDH
PRMERR	LD	HL,PRMERR$
	DB	0DDH
TOOBIG	LD	HL,TOOBIG$
	DB	0DDH
BADIGS	LD	HL,BADIGS$
	DB	0DDH
ODDIGS	LD	HL,ODDIGS$
	DB	0DDH
SPCREQ	LD	HL,SPCREQ$
	DB	0DDH
SYNERR	LD	HL,SYNERR$
	DB	0DDH
MISINF	LD	HL,MISINF$
	CALL	LOGOT
	JP	@ABORT
NOTIO$	DB	'Device has no I/O capabilities!',CR
NOTINP$	DB	'Device has no INPUT capabilities!',CR
NOTOUT$	DB	'Device has no OUTPUT capabilities!',CR
PRMERR$	DB 'Parameter Error - Translation aborted!',CR
SYNERR$	DB	'Translate data syntax error '
	DB	'- Missing "="!',CR
ODDIGS$	DB	'Odd # of hex digits!',CR
BADIGS$	DB	'Bad hex digit encountered!',CR
MISINF$	DB	'Missing translate data hex pair!',CR
SPCREQ$	DB	'File spec required!',CR
TOOBIG$	DB	'Translate data file too big!',CR
RDING$	DB	'Reading translate table data',CR
XLTDUN$	DB	'Translation filter operational',CR
CPYMSG	DB	'XLATE - LDOS translation filter'
	DB	' - Version 5.1',LF,'Copyright (C) 1981'
	DB	' Logical Systems, Incorporated',LF,CR
XLTEXT	DB	'XLT'
PRMTBL$	DB	'NULL  '
	DW	NPARM+1
	DB	'N     '
	DW	NPARM+1
	DB	'INPUT '
	DW	IPARM+1
	DB	'I     '
	DW	IPARM+1
	DB	'OUTPUT'
	DW	OPARM+1
	DB	'O     '
	DW	OPARM+1
	DB	'PRIME '
	DW	PPARM+1
	DB	'P     '
	DW	PPARM+1
	NOP
	DS	16		;Reserved for expansion
FCB1	DS	32
;*****
;	XLATE filter relocated to high memory
;*****
XLTFLT	JR	C,INPUT		;jump on input
XLTFL1	JR	NZ,OUT1		;Pass @CTL calls
;*****
;	routine to output character
;*****
OUTPUT	LD	HL,OUTTBL	;Pt to output table
	LD	B,0
	ADD	HL,BC		;Index the table
	LD	C,(HL)		;P/u the xlated char
OUT1	JP	$-$		;Output it
;*****
;	routine to input
;*****
INPUT	CALL	$-$		;Fetch the input char
	LD	C,A
	LD	B,0
INP1	LD	HL,INPTBL	;index the table
	ADD	HL,BC
	LD	A,(HL)
	RET
INPTBL	DS	256
OUTTBL	DS	256
XLTEND	EQU	$
	ORG	$<-8+1<+8
IOBUF	DEFS	256
XLTDATA	EQU	$
	END	XLATE
