;****	TITLE/FLT	Version 5.1
;
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
@KBD	EQU	002BH
@PRINT	EQU	446AH
@PUT	EQU	001BH
@PRT	EQU	003BH
;
	ORG 5200H
	PUSH	DE		;save DCB
	PUSH	HL		;save parameters
	LD	A,(DE)		;type byte
	PUSH	AF
	LD	HL,SIGNON
	CALL	@DSPLY
;
;****	Mod I or III determination
	LD	A,(125H)	;Mod I or III?
	CP	49H		;III=49h
	JR	Z,M3
	LD	HL,MOD1EQU
	JR	LDHIGH
M3	LD	HL,MOD3EQU
LDHIGH	LD	IX,PARMREL
CKREL	LD	D,(IX+1)
	LD	E,(IX)
	LD	A,(HL)
	OR	A
	JR	Z,DUNREL
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(HL)
	LD	(DE),A
	INC	IX
	INC	IX
	INC	HL
	JR	CKREL
;
DUNREL	POP	AF		;device type byte
	BIT	3,A		;device set NIL?
	JP	NZ,DEVNIL
	BIT	4,A		;Routed?
	JP	NZ,DEVROUT
	BIT	1,A		;Output device?
	JP	Z,NOTOUT
;
;****	Pick up parameters
	POP	HL		;recover command line
	LD	DE,PARMTBL
PARM	CALL	0000H		;@param call
	JP	NZ,PERROR
TPARM	LD	HL,0000H	;title parm
	LD	A,H
	OR	L		;see if title
	JP	Z,PERROR	;must have title
	LD	DE,TIMSG	;store title in filter
	LD	B,20		;max chars
TIMOV	LD	A,(HL)		;char
	CP	0DH		;see if end of title
	JR	Z,TIEND
	CP	'"'
	JR	Z,TIEND
	CP	','
	JR	Z,TIEND
	LD	(DE),A
	INC	DE
	INC	HL
	DJNZ	TIMOV
	JR	TICR
TIEND	LD	A,' '		;blank out remaining
TIMOV2	LD	(DE),A
	INC	DE
	DJNZ	TIMOV2
TICR	LD	A,0DH
	LD	(DE),A
DPARM	LD	BC,0FFFFH	;assume DATE=Y
	LD	A,C
	OR	B		;see if date=n
	JR	Z,NODAT
	EX	DE,HL		;point HL to title buffer
	LD	A,' '
	LD	(HL),A		;remove CR
	INC	HL
CTIME	CALL	0000H		;call @time
	LD	A,' '
	LD	(HL),A
	INC	HL
CDATE	CALL	0000H		;call @date
	LD	A,0DH
	LD	(HL),A		;ending CR
;
;****	ok to filter device
NODAT	POP	IX		;get dcb
	LD	(OLDDCB+1),IX	;DCB address for @PUT
	LD	L,(IX+1)
	LD	H,(IX+2)	;get old address
	LD	(OUTP2+1),HL	;  ''
	LD	(OUTP1+1),HL
	PUSH	IX
;
;****	install new HIGH$ and move filter code
MHI	LD	HL,(0000H)	;get current HIGH$
	LD	(OLDHI),HL	;put in filter header
	LD	BC,LENGTH	;len of filter
	XOR	A
	SBC	HL,BC		;figure new HIGH$
SHI	LD	(0000H),HL	;store HIGH$
	INC	HL		;filter relo address
	PUSH	HL
	PUSH	BC		;save filter byte count
	LD	BC,TSTRT	;reloc. code start
	OR	A
	SBC	HL,BC		;calc. offset for reloc.
	LD	C,L
	LD	B,H		;offset into BC
	LD	IX,RELTBL	;table of labels to adj.
RELP	LD	L,(IX)		;pre-move address
	LD	H,(IX+1)
	LD	A,H		;msb
	OR	A
	JR	Z,DUNTBL	;end of reloc.
	PUSH	HL		;save loc. of address
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC		;get move offset
	EX	DE,HL		;new address into DE
	POP	HL		;loc of address
	LD	(HL),E
	INC	HL
	LD	(HL),D		;install new addr
	INC	IX		;next loc in table
	INC	IX
	JR	RELP		;reloc. next label
;
DUNTBL	POP	BC		;restore byte count
	POP	HL		;restore relo address
	POP	IX
	LD	(IX+1),L
	LD	(IX+2),H	;install addr into dcb
	EX	DE,HL		;DE to new address
	LD	HL,TSTRT	;HL to filter code
	LDIR			;relocate filter
	LD	A,0CH		;init tof and title
	CALL	@PRT
	JP	@EXIT		;all done
;
PERROR	LD	HL,PARMSG
	JR	ERROR
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
	JR	ERROR
NOTOUT	LD	HL,OUTMSG
ERROR	CALL	0000H		;call @LOGOT
	JP	@ABORT
;
SIGNON	DB	31,'TITLE - Line Printer Title Filter - Version 5.1',0AH
	DB	'Copyright (c) 1981 by Logical Systems',2CH,' Inc.',0AH,0DH
;
PARMSG	DB	'Parameter error',0DH
NILMSG	DB	'Device not active',0DH
ROUTMSG	DB	'Device is routed',0DH
OUTMSG	DB	'Not an output device',0DH
;
PARMTBL	DB	'TITLE '
	DW	TPARM+1
	DB	'T     '
	DW	TPARM+1
	DB	'DATE  '
	DW	DPARM+1
	DB	'D     '
	DW	DPARM+1
	DW	0000H		;end of table
;
;HIGH$,HIGH$,@LOGOT,@PARAM,@DATE,@TIME
;
MOD1EQU	DW	4049H,4049H,447BH,4476H,4470H,446DH,0000H
MOD3EQU	DW	4411H,4411H,428AH,4454H,3033H,3036H,0000H
PARMREL	DW	MHI+1,SHI+1,ERROR+1,PARM+1,CDATE+1,CTIME+1
RELTBL	DW	REL1+1,REL2+1,0000H
;
TSTRT	JR	START
OLDHI	DW	0000H		;HIGH$ before filtering
	DB	START-FNAME
FNAME	DB	'TITLE'
;
START	JR	C,OUTP2
	PUSH	AF
	LD	A,C
	CP	0CH		;title only after tof
	JR	Z,OUTCF
	POP	AF
OUTP2	JP	0000H		;else send char,not tof
OUTCF	XOR	A
OUTP1	CALL	0000H		;send tof
OLDDCB	LD	DE,0000H	;DCB before filtering
REL1	LD	HL,TIMSG	;title and date string
PLOOP	LD	A,(HL)
	OR	A
	JR	Z,ENDIT		;see if end of print
	PUSH	AF
	CALL	@PUT		;put char.
	POP	AF
	CP	0DH		;see if end of title
	JR	NZ,NOTCR
REL2	LD	HL,LIMSG-1	;blank line display
NOTCR	INC	HL
	JR	PLOOP
ENDIT	LD	C,0DH
	POP	AF
	JR	OUTP2
;
TIMSG	DS	40		;title
LIMSG	DW	0020H		;blank line & end
;
LENGTH	EQU	$-TSTRT
	END	5200H
