;****	MONITOR/FLT	Version 5.1
;
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
;
	ORG 5200H
	PUSH	DE
	LD	A,(DE)		;type byte
	PUSH	AF
	LD	HL,SIGNON
	CALL	@DSPLY
;
;****	Mod I or III determination
	LD	A,(125H)	;Mod I or III?
	CP	49H		;III=49h
	JR	Z,M3
	LD	HL,4049H	;Mod I HIGH$
	LD	DE,447BH	;@logot
	JR	LDHIGH
M3	LD	HL,4411H	;Mod III HIGH$
	LD	DE,428AH	;@logot
LDHIGH	LD	(MHI+1),HL	;install HIGH$
	LD	(SHI+1),HL
	LD	(ERROR+1),DE	;install @logot
;
	POP	AF		;device type byte
	BIT	3,A		;device set NIL?
	JR	NZ,DEVNIL
	BIT	4,A		;Routed?
	JR	NZ,DEVROUT
	BIT	1,A		;Output device?
	JR	Z,NOTOUT
;
;****	ok to filter device
	POP	IX		;get dcb
	LD	L,(IX+1)
	LD	H,(IX+2)	;get old address
	LD	(OUTP1+1),HL
	LD	(OUTP2+1),HL
	LD	(OUTP3+1),HL
	PUSH	IX
;
;****	install new HIGH$ and move filter code
MHI	LD	HL,(0000H)	;get current HIGH$
	LD	(OLDHI),HL	;put in filter header
	LD	BC,LENGTH	;len of filter
	XOR	A
	SBC	HL,BC		;figure new HIGH$
SHI	LD	(0000H),HL	;store HIGH$
	INC	HL
	PUSH	HL
	PUSH	BC
	LD	BC,MON
	OR	A
	SBC	HL,BC
	LD	C,L
	LD	B,H
	LD	IX,RELTBL	;table of labels to adj.
RELP	LD	L,(IX)		;pre-move address
	LD	H,(IX+1)
	LD	A,H		;msb
	OR	A
	JR	Z,DUNTBL	;end of reloc.
	PUSH	HL		;save loc. of address
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC		;get move offset
	EX	DE,HL		;new address into DE
	POP	HL		;loc of address
	LD	(HL),E
	INC	HL
	LD	(HL),D		;install new addr
	INC	IX		;next loc in table
	INC	IX
	JR	RELP		;reloc. next label
;
DUNTBL	POP	BC		;restore byte count
	POP	HL		;restore relo address
	POP	IX
	LD	(IX+1),L
	LD	(IX+2),H	;install addr into dcb
	EX	DE,HL		;DE to new address
	LD	HL,MON	;HL to filter code
	LDIR			;relocate filter
	JP	@EXIT		;all done
;
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
	JR	ERROR
NOTOUT	LD	HL,OUTMSG
ERROR	CALL	0000H		;call @LOGOT
	JP	@ABORT
;
SIGNON	DB	31,'MONITOR - Control character filter - Version 5.1',0AH
	DB	'Copyright (c) 1981 by Logical Systems',2CH,' Inc.',0AH,0DH
NILMSG	DB	'Device not active',0DH
ROUTMSG	DB	'Device is routed',0DH
OUTMSG	DB	'Not an output device',0DH
;
RELTBL	DW	REL1+1,0000H
;
MON	JR	START
OLDHI	DW	0000H		;HIGH$ before filter
	DB	START-FNAME
FNAME	DB	'MONITOR'
;
START	JR	C,OUTP1		;go if input
	PUSH	AF
	LD	A,C
	CP	' '		;less than space?
	JR	C,REL1
	CP	7FH		;greater than ascii?
	JR	C,MON1		;leave if less
	LD	C,5BH		;uparrow
MON1	POP	AF
OUTP1	JP	0000H		;original driver
REL1	LD	(STOR+1),A	;else save char
	LD	C,' '
	XOR	A
OUTP3	CALL	0000H
	LD	C,'%'
	XOR	A
OUTP2	CALL	0000H		;send @ char
STOR	LD	A,0
	ADD	A,41H		;convert to +41H
	LD	C,A
	JR	MON1		;and display
LENGTH	EQU	$-MON
	END	5200H
