;****	DOSPEED/FLT     Version 1.0
;
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
@KBD	EQU	002BH
@PAUSE	EQU	0060H
;
	ORG 5200H
	PUSH	DE
	LD	A,(DE)		;type byte
	PUSH	AF
	LD	HL,SIGNON
	CALL	@DSPLY
;
;****	Mod I or III determination
	LD	A,(125H)	;Mod I or III?
	CP	49H		;III=49h
	JR	Z,M3
	LD	HL,4049H	;Mod I HIGH$
	LD	DE,447BH	;@logot
	JR	LDHIGH
M3	LD	HL,RELMULT+1
	LD	(HL),4EH
	LD	HL,4411H	;Mod III HIGH$
	LD	DE,428AH	;@logot
LDHIGH	LD	(MHI+1),HL	;install HIGH$
	LD	(SHI+1),HL
	LD	(ERROR+1),DE	;install @logot
;
	POP	AF		;device type byte
	BIT	3,A		;device set NIL?
	JR	NZ,DEVNIL
	BIT	4,A		;Routed?
	JR	NZ,DEVROUT
	BIT	1,A		;Output device?
	JR	Z,NOTOUT
;
;****	ok to filter device
	POP	IX		;get dcb
	LD	L,(IX+1)
	LD	H,(IX+2)	;get old address
	LD	(OUTP1+1),HL	;install in filter code
;
;****	install new HIGH$ and move filter code
MHI	LD	HL,(0000H)	;get current HIGH$
	LD	(OLDHI),HL	;put in filter header
	LD	BC,LENGTH	;len of filter
	XOR	A
	SBC	HL,BC		;figure new HIGH$
SHI	LD	(0000H),HL	;store HIGH$
	INC	HL
	DI
	LD	(IX+1),L
	LD	(IX+2),H	;install addr into dcb
	PUSH	HL
	PUSH	DE
	LD	DE,USEOLD-LOWER+1
	ADD	HL,DE
	LD	(STORE+1),HL
	POP	DE
	POP	HL
	EX	DE,HL		;DE to new address
	LD	HL,LOWER	;HL to filter code
	LDIR			;relocate filter
	EI
	JP	@EXIT		;all done
;
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
	JR	ERROR
NOTOUT	LD	HL,OUTMSG
ERROR	CALL	0000H		;call @LOGOT
	JP	@ABORT
;
SIGNON	DB	31,'DOSPEED - Video diplay rate Filter - Version 1.0 ',0AH
	DB	'Copyright (c) 1981 by Logical Systems',2CH,' Inc.',0AH,0DH
NILMSG	DB	'Device not active',0DH
ROUTMSG	DB	'Device is routed',0DH
OUTMSG	DB	'Not an output device',0DH
;
LOWER	JR	START
OLDHI	DW	0000H		;HIGH$ before filtering
	DB	START-FNAME
FNAME	DB	'DOSPEED'
START	JR	C,OUTP1		;go if input
	PUSH	AF
	PUSH	BC
	PUSH	HL
	PUSH	DE
	CALL	@KBD		;check for a KEY
	JR 	Z,USEOLD	;use old delay value
	CP	3AH		;check for 0 or more
	JR	NC,USEOLD
	CP	30H		;check for more then 9
	JR	C,USEOLD
	SUB	30H		;normalize to 0 to 65
	LD	HL,500		;multiply times 1000
RELMULT	CALL	44C1H		;call 16 bit multiply
	LD	H,L
	LD	L,01
STORE	LD	(USEOLD+1),HL
USEOLD	LD	BC,0001H
	CALL	@PAUSE
	POP	DE
	POP	HL
	POP	BC
	POP	AF
OUTP1	JP	0000H
LENGTH	EQU	$-LOWER
	END	5200H
