;Communications filter for LDOS RS232 drivers to provide
;Testing for modem carrier, delay between characters,
;And linefeeds and nulls after carriage returns.
; Enter with parameters:
; CARRIER = ON or Y  /default is OFF
;       Setting ON will cause all input or output requests
;       to be ignored unless the modem is receiving a
;       carrier signal
; ADDLF = ON or Y   /default is OFF
;       Setting ON will add a linefeed after each carriage
;       return. 
; NULLS = 0 to 256  /default is 0
;       Number of nulls to send after each carriage return
; DELAY = 0 to X'FFFF' /default is 0
;       Variable timing delay between output characters to
;       allow sending to systems that cannot accept full
;       speed transmission.
; MASK = ON or OFF /default is OFF
;       Setting ON will strip the high bit from received
;       characters, removing parity bits that may have been
;       added by the sender.  Use only for transmissions in
;       the ASCII character range, not for 8-bit binary data.
; All parameters may be abbreviated with the first letter
;
; Hardware dependant EQUates.
HIGH1	EQU	4049H
HIGH$	EQU	4411H
PARAM1	EQU	4476H
@PARAM	EQU	4454H
LOGOT1	EQU	447BH
@LOGOT	EQU	428AH
LX80ROM	EQU	3000H
;
; General EQUates...
@EXIT	EQU	402DH
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@DELAY	EQU	60H
LF	EQU	10		;Linefeed character
CR	EQU	13		;Carriage return
;
; LDOS 'FILTER' command handler
;
	ORG	5200H	
ENTRY:	PUSH	DE		;Save DCB pointer
	POP	IX		;Into IX register
	PUSH	HL		;Save cmd line pointer
	LD	A,(DE)		;Pick up DCB type byte
	PUSH	AF		;Save
	LD	HL,125H		;Test machine
	LD	B,(HL)
	LD	A,B		;Is there RAM
	CPL			;In low memory?
	LD	(HL),A
	CP	(HL)
	LD	(HL),B
	CALL	Z,SETSIO	;Then it is a MAX80
	LD	A,B
	CP	'I'		;Mod 3 system?
	JR	Z,MOD3		;Go if mod 3
	LD	HL,PARAM1	;Then set mod 1 addresses
	LD	(PARAM),HL
	LD	HL,HIGH1
	LD	(HIGHA),HL
	LD	(HIGHB),HL
	LD	HL,LOGOT1
	LD	(LOGOT),HL
	LD	A,(LX80ROM)
	CP	0F3H		; a DI at 3000H?
	CALL	Z,SETSIO	;Then must be LX80
MOD3	LD	HL,SIGNON	;=>Signon message
	CALL	@DSPLY		;Print it
	POP	AF		;Restore type byte
	BIT	3,A		;Device routed to NIL?
	JP	NZ,ISNIL	;Go if so
	BIT	4,A		;Routed?
	JP	NZ,ROUTED	;Go if so (error)
	AND	7		;Does driver handle I/O
	CP	7		; and @CTRL?
	JP	NZ,DEVERR	;Go if not
	POP	HL		;Restore cmd line pointer
	LD	DE,PRMTBL	;Scan parameters
	CALL	@PARAM
PARAM	EQU	$-2
	JP	NZ,PRMERR	;Quit if error
;
;Test parameter values and initialize filter
	LD	BC,$-$		;Value set by @PARAM call
ADDLF	EQU	$-2		;<=here
	LD	A,C
	OR	B		;Set flag
	LD	A,LF		;Load a line feed
	JR	Z,NXTST		;Go if not specified
	LD	(LFFLG),A	;Stuff byte if wanted
;
NXTST:	LD	BC,$-$
CARRY	EQU	$-2		;<=setting for CARRIER
	LD	A,B
	OR	C
	JR	Z,CKMSK		;No checking if zero
	LD	A,0FFH		;Stuff FFH if check wanted
	LD	(CFLAG),A	;For input request
;
CKMSK:	LD	BC,$-$		;MASK param
MASK	EQU	$-2		;Set by @PARAM
	LD	A,B
	OR	C		;Zero?
	JR	Z,GETDVR	; no masking wanted
	XOR	A		; set zero
	LD	(MSK),A		; set NOP instd of RET
;
GETDVR:	LD	H,(IX+2)	;Pull driver address from
	LD	L,(IX+1)	;DCB of device
	LD	(DVRADD),HL	;Put where needed in filter
	LD	(DVR2),HL
	LD	(DVR3),HL
	LD	(DVR4),HL
	LD	HL,(HIGH$)	;Find top of available memory
HIGHA	EQU	$-2
	LD	(OLDMEM),HL	;Save in filter header
	PUSH	HL		;Save
	LD	BC,LAST		;End of relocated code
	PUSH	BC		;Save
	XOR	A		;Clear carry
	SBC	HL,BC		;Find offset of move
	EX	DE,HL		;Put into DE
	LD	HL,(REL1)	;Relocate absolute memory
	ADD	HL,DE		; references used in the
	LD	(REL1),HL	;Moved code...
	LD	HL,(REL2)	;By..
	ADD	HL,DE		;Adding offset of move
	LD	(REL2),HL
	LD	HL,(REL3)
	ADD	HL,DE
	LD	(REL3),HL
	LD	HL,(REL4)
	ADD	HL,DE
	LD	(REL4),HL
	LD	HL,(REL5)
	ADD	HL,DE
	LD	(REL5),HL
	POP	HL		;End of filter (now)
	POP	DE		;Old HIGH$
	LD	BC,LAST-FENTRY+1	;Length of relocated code
	LDDR			;Move it
	LD	(HIGH$),DE	;Set new HIGH$
HIGHB	EQU	$-2
	INC	DE		;Point to filter entry point
	LD	(IX+1),E	;Shove it in the DCB
	LD	(IX+2),D	
;*=*=*
EXIT:	JP	@EXIT		;Done
;*=*=*
;       Error handling
;*=*=*
ISNIL:	LD	HL,ISNIL$
	JR	ERROUT
DEVERR:	LD	HL,DEVER$
	JR	ERROUT
ROUTED:	LD	HL,ROUTD$
	JR	ERROUT
PRMERR:	LD	HL,PRMER$	;'Parameter error'
ERROUT:	CALL	@LOGOT		;Display and log
LOGOT	EQU	$-2
	JP	@ABORT		;Quit
;
SETSIO	XOR	A		;A zero
	LD	(SIO1),A	;Change to correct
	LD	A,5FH		;Bit test for
	LD	(SIO2),A	;SIO if LX80 or MAX
	RET
;*=*=*
;       Data area
;*=*=*
SIGNON:	DB	'CL/FLT - LDOS communications Filter'
	DB	LF,CR
PRMER$:	DB	'Parameter error!',CR
ISNIL$:	DB	'Device not active!',CR
DEVER$:	DB	'Incorrect device type!',CR
ROUTD$:	DB	'Device is routed!',CR
;
PRMTBL:	DB	'ADDLF '
	DW	ADDLF
	DB	'A     '
	DW	ADDLF
	DB	'CARRIE'
	DW	CARRY
	DB	'C     '
	DW	CARRY
	DB	'DELAY '
	DW	DELAY
	DB	'D     '
	DW	DELAY
	DB	'NULLS '
	DW	NULLS
	DB	'N     '
	DW	NULLS
	DB	'MASK  '
	DW	MASK
	DB	'M     '
	DW	MASK
	DW	0		;End of list
;
;*=*=*
;       Actual filter moved to high memory
;       LDOS style header...
;*=*=*
FENTRY:	JR	START		;Branch around linkage
	DW	$-$		;Last byte used
OLDMEM	EQU	$-2		;<=previous HIGH$ value
;
	DB	5,'CLFLT'
;
; actual filter routine
; the initialization code sets the flag byte to FFH if
; the test for carrier is wanted, 0 if not
START:	LD	A,$-$		;Get flag for carrier test
CFLAG	EQU	$-1		;Set according to params
	JR	C,INPUT		;An input request
	JR	Z,OUTPUT	;Output request from program
;  fall through if program called @CTRL
GSTAT:	OR	0FFH		;Reset C and Z so filter can...
	;Call driver for status
DRIVER:	JP	$-$		;Go to old driver 
DVRADD	EQU	$-2		;Stuff driver address here
;
;
; use a test that will set NZ if going directly to the driver
INPUT:	INC	A		;Set Z if flag was FF for carrier
;
	CALL	Z,STAT		;Check for carrier if wanted
REL1	EQU	$-2		;Call address is relocated
	JR	Z,IGNORE	; no carrier, skip it
	SCF			; input wanted
	CALL	$-$		;Driver address
DVR2	EQU	$-2		;Stuffed by loader
MSK:	RET			;Replaced w/NOP if MASK specified
	AND	7FH		;Strip parity bit
	RET
;
;  no carrier, so call driver to clear UART and buffer
;  then ignore any received characters
;
IGNORE:	OR	0FFH		;Be sure Z flag is off
	SCF			;Carry flag on
	CALL	$-$		;Get input from driver
DVR3	EQU	$-2		;Driver address
	XOR	A		;Throw character away
	RET
;
OUTPUT:	PUSH	BC		;Save @PUT character
	INC	A		;Test flag (zero to skip)
	CALL	Z,STAT		;Test carrier if flag was FF
REL2	EQU	$-2
	POP	BC		;Restore character
	JR	Z,FAKEIT	;No carrier, dump output character
;
	PUSH	BC		;Save character
	CALL	SLOW		;Delay/send
REL3	EQU	$-2		;Address is relocated
	POP	BC
	LD	A,CR		;Check for carriage return
	CP	C		;Being output
	JR	NZ,FAKEIT	;Done if not
;
	LD	A,$-$		;A 0 or LF (set when loaded)
LFFLG	EQU	$-1		;Stuff byte according to parameter
	LD	DE,$-$		;Pick up NULL count
NULLS	EQU	$-2		;Set by @PARAM
	PUSH	DE		;Save count
	LD	C,A		;The @PUT char (0 or LF)
	OR	A		;LF needed?
	JR	NZ,SEND		;Output if so
;
	POP	DE		;Else restore NULL count
NLOOP:	LD	A,D
	OR	E		;Test if done
	JR	Z,FINAL		;Go if finished
	DEC	DE		;Else count down nulls
	PUSH	DE		;Save count
SEND:	CALL	SLOW		;Pause/send character
REL4	EQU	$-2		;Address goes here
	LD	C,0		;Load null to send
	POP	DE		;Restore count of nulls wanted
	JR	NLOOP		;Send until done
;
SLOW:	PUSH	BC		;Save @PUT char 
	LD	BC,$-$		;Get DELAY value (loaded by @PARAM)
DELAY	EQU	$-2		;Value stuffed by @PARAM
	LD	A,B
	OR	C		;Check for zero (default)
	CALL	NZ,@DELAY	;(always sets Z flag)
	POP	BC		;Restore character
	CALL	$-$		;Driver, to output character
DVR4	EQU	$-2
;
FINAL:	LD	A,CR		;Load the original @PUT char
	LD	C,A		;Into C and A in case other 
	;Filters are active
FAKEIT:	CP	A		;Set Z flag for good return
	RET			;Done with output
;
;
STAT:	LD	C,0		;For status check
	CALL	GSTAT		;Call driver for status
REL5	EQU	$-2		;Relocated when loaded
;
;The status call returns the modem status byte from the UART
;Or SIO chip in register A, as well as the output status
;In the Z flag, but the bit values depend on the hardware
;
	CPL			; 0=ON in UART, so flip bits
SIO1	EQU	$-1
	BIT	5,A		;Check for carrier signal bit
SIO2	EQU	$-1
;
;If running in a MAX80 or LX80, this becomes:
;       NOP            ;1=on in SIO
;       BIT     3,A    ;carrier bit from SIO
; Z=no carrier, NZ=carrier on...
;
	RET
LAST	EQU	$-1		;Used for length calculation
;
	END	ENTRY
