SYS3/A 	ORG	4E00H
 ;SYS3/ASM
 SELECT	EQU	43DCH
 INPUT	EQU	43DFH
 POSHL	EQU	43E5H
 POUT	EQU	3BH
 READ	EQU	43EEH
 WRITE	EQU	43F1H
 DREAD	EQU	43F4H
 DWRITE	EQU	43F7H
 GETTKS	EQU	43FAH
 GETTYPE	EQU	43FDH
 GETDIR	EQU	43C9H
 	DB	'FD'		;system identifier
 	DW	AUTO,RET,RET,CONFIG,DEVICE
 	DW	RET,RET,RET,RET,RET,RET,RET,RET,RET,RET
 AUTO	LD	A,30H		;default drive 0
 	CALL	SETDRV
 	CALL	POSHL		;any more input ?
 	JR	C,NOAUTO	;no auto command
 	JR	Z,NOAUTO
 	LD	A,(HL)
 	CP	'?'		;inquiry ?
 	JP	Z,SHOAUTO	;disp
 	CP	':'		;drive spec ?
 	JR	Z,NEWDRV	;get new drive
 GETDRV	CALL	SETDRV		;setup drive
 	JP	C,PUTAUTO	;not a drive, put auto
 	JR	NXTAUTO		;scan next command
 NEWDRV	INC	HL
 	LD	A,(HL)
 	CALL	SETDRV
 	JR	C,PARERR
 NXTAUTO	INC	HL
 	JR	AUTO+5
 PARERR	PUSH	HL		;save pointer
 	LD	HL,SYNTAX
 	CALL	4467H
 	POP	HL
 PARLP	LD	A,(HL)
 	CP	';'		;terminator
 	JR	Z,PARTM
 	CP	0DH
 	JR	Z,PARTM
 	CALL	VOUT
 	INC	HL
 	JR	PARLP
 PARTM	LD	A,0DH
 	JP	VOUT
 NOAUTO	CALL	READAUTO	;read auto command
 	CALL	ZAUTO		;clear it out
 SAVEAUTO	CALL	STAT	;drive ready?
 	LD	A,(37ECH)	;write protect ?
 	BIT	6,A
 	LD	A,15		;message
 	JP	NZ,4409H	;display & term
 	LD	A,0
 WHRSAV	EQU	$-1
 	OR	A
 	LD	BC,4200H	;buffer
 	LD	DE,0
 	JR	NZ,PUTOTHER
 	CALL	WRITE		;write it back
 SAVGO	JP	Z,402DH		;don't continue parse
 	JP	4409H		;display error/no return
 PUTOTHER	CALL	DWRITE
 	JR	SAVGO
 READAUTO	LD	DE,0
 	LD	BC,4200H
 	CALL	STAT		;is drive ready ?
 	PUSH	HL		;save pointer
 	CALL	READ
 	JP	NZ,4409H	;terminate in error
 	LD	A,(42AFH)	;see if it's ours
 	POP	HL
 	OR	A
 	LD	(WHRSAV),A
 	RET	Z
 	LD	A,(4202H)	;get directory track
 	SCF			;carry = put in table
 	CALL	GETDIR		;save it
 	LD	E,0		;directory sector 0
 	LD	BC,4200H	;buffer
 	PUSH	HL
 	CALL	DREAD		;directory read
 	POP	HL
 	RET	Z
 	JP	4409H
 SHOAUTO	CALL	READAUTO	;read the sector
 	LD	HL,42E0H	;point to it
 	LD	A,(HL)		;see if anything there
 	CP	0DH
 	JP	NZ,4467H	;display it
 	LD	HL,NOTHIN	;else nill command
 	JP	4467H
 SETDRV	SUB	30H		;remove ascii
 	RET	C		;bad
 	CP	8		;allow 8 drives
 	CCF			;reverse carry flag
 	RET	C
 	LD	(4308H),A	;save binary drive
 	LD	B,1		;now set the right bit
 SETDLP	OR	A		;0 ?
 	JR	Z,HAVDRV
 	SLA	B
 	DEC	A
 	JR	SETDLP
 HAVDRV	LD	A,B
 	LD	(4309H),A	;save bit set for drive
 RET	RET
 STAT	PUSH	HL		;save all registers
 	PUSH	DE
 	PUSH	BC
 	CALL	SELECT		;turn drive on
 	LD	A,(37ECH)
 	RLCA
 	LD	A,1
 	JR	C,HOLDER
 	LD	BC,00CDH	;count for sector holes
 	LD	A,2		;no diskette in drive
 	EX	AF,AF'		;save it here
 TT1	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER-1
 	LD	A,(37ECH)
 	AND	2
 	JR	NZ,TT1
 	LD	BC,199DH
 	LD	A,3		;door not closed
 	EX	AF,AF'
 TT2	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER-1
 	LD	A,(37ECH)
 	AND	2
 	JR	Z,TT2
 	LD	BC,00BAH
 	LD	A,2		;no disk
 	EX	AF,AF'
 TT3	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER-1
 	LD	A,(37ECH)
 	AND	2
 	JR	NZ,TT3
 	POP	BC
 	POP	DE
 	POP	HL
 	RET			;done
 	EX	AF,AF'
 HOLDER	CALL	ERRSHO		;display error code
 	LD	B,0
 	CALL	INPUT		;wait for key
 	JP	STAT+3		;check again
 ERRSHO	LD	HL,TABLE-1
 	OR	80H		;set high bit
 ERRLP	INC	HL
 	BIT	7,(HL)
 	JR	Z,ERRLP
 	CP	(HL)		;right one ?
 	JR	NZ,ERRLP
 	INC	HL
 	JP	4467H		;display and return
 TABLE	DB	1+80H,'Not in System! ',3
 	DB	2+80H,'No Diskette! ',3
 	DB	3+80H,'Door not closed! ',3
 DIR	EQU	$
 FREE	EQU	$
 CONFIG	EQU	$
 	LD	HL,NOTDONE
 	JP	4467H
 NOTDONE	DB	'Routine not completed!',13
 PUTAUTO	CALL	READAUTO	;read whats there
 	CALL	ZAUTO		;clear the area
 	LD	DE,42E0H	;point to it
 	LD	B,31		;allow 31 chars
 PUTALP	LD	A,(HL)		;get a byte
 	LD	(DE),A		;save it
 	CP	0DH
 	JP	Z,SAVEAUTO	;write it back
 	INC	HL
 	INC	DE
 	DJNZ	PUTALP		;go till 31 done
 	LD	A,0DH		;force terminate
 	LD	(DE),A
 	JP	SAVEAUTO
 NOTHIN	DB	'Nill auto command.',13
 ZAUTO	PUSH	HL		;save pointer
 	LD	HL,42E0H
 	LD	DE,42E1H
 	LD	BC,31
 	LD	(HL),20H
 	PUSH	HL
 	LDIR
 	POP	HL
 	LD	(HL),0DH
 	POP	HL
 	RET
 SYNTAX	DB	'Syntax Error!  ?',3
 DEVICE	LD	A,30H		;start drive table
 	LD	(TDRIV),A	;temp drive count
 DEVLP1	LD	A,0		;get drive #
 TDRIV	EQU	$-1
 	LD	(M1),A
 	CALL	SETDRV		;set bits for tables
 	OR	A		;clear carry
 	CALL	GETTKS		;get track count
 	CALL	ASCII
 	LD	(M2),A
 	LD	(M2+1),BC
 	OR	A
 	CALL	GETTYPE		;get drive type
 	PUSH	AF		;save on stack
 	LD	HL,HARD		;hard text
 	LD	DE,M6		;point to string
 	BIT	7,A
 	JR	NZ,HM6
 	LD	HL,FLOP
 HM6	LD	BC,4
 	LDIR
 	POP	AF		;get type back
 	PUSH	AF
 	BIT	6,A
 	LD	A,'8'
 	JR	NZ,HM5
 	LD	A,'5'
 HM5	LD	(M5),A
 	POP	AF
 	PUSH	AF
 	BIT	5,A		;density
 	LD	A,'D'
 	JR	NZ,HM3
 	LD	A,'S'
 HM3	LD	(M3),A
 	POP	AF
 	PUSH	AF
 	BIT	4,A		;sided
 	LD	A,'D'
 	JR	Z,HM4
 	LD	A,'S'
 HM4	LD	(M4),A
 	POP	AF
 	PUSH	AF
 	AND	0CH		;bits 2,3
 	RRCA
 	RRCA
 	ADD	A,30H
 	LD	(M8),A		;drive delay
 	POP	AF
 	AND	3
 	ADD	A,30H
 	LD	(M7),A
 	LD	HL,DEVSTR	;point to message
 	CALL	4467H		;print it
 	CALL	PAUSE
 	LD	A,(TDRIV)	;get count
 	INC	A
 	LD	(TDRIV),A
 	CP	38H		;end ?
 	JP	C,DEVLP1	;go loop1
 	XOR	A
 	LD	(TDRIV),A	;device table pointer
 DEVLP2	LD	HL,436FH	;device table
 	RLCA
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	A,(HL)		;get direction
 	OR	A		;active ?
 	JR	Z,NEXDEV	;next device
 	INC	HL		;point to dcb addr
 	LD	A,(HL)
 	LD	E,A
 	CALL	HEXCV
 	LD	(D3+2),BC
 	INC	HL
 	LD	A,(HL)
 	LD	D,A
 	CALL	HEXCV
 	LD	(D3),BC
 	PUSH	DE
 	POP	IY
 LINKBAK	LD	A,(IY)		;check for link
 	CP	10H		;link code
 	JR	Z,GETLINK	;get the code
 	LD	HL,D5
 	BIT	0,(IY)		;input ?
 	LD	B,' '
 	JR	Z,HD5
 	LD	B,'<'
 HD5	LD	(HL),B
 	BIT	1,(IY)		;output
 	LD	B,' '
 	INC	HL
 	INC	HL
 	JR	Z,HD6
 	LD	B,'>'
 HD6	LD	(HL),B
 	LD	A,(IY+6)	;get driver name
 	LD	(D1),A
 	LD	A,(IY+7)
 	LD	(D2),A
 	LD	A,(IY+1)	;lsb address
 	CALL	HEXCV
 	LD	(D4+2),BC
 	LD	A,(IY+2)	;msb address
 	CALL	HEXCV
 	LD	(D4),BC
 	LD	HL,STRDEV
 	CALL	4467H		;print string
 	CALL	PAUSE
 NEXDEV	LD	A,(TDRIV)
 	INC	A
 	LD	(TDRIV),A	;bump pointer
 	CP	10		;end of table
 	JP	C,DEVLP2
 	RET			;done
 GETLINK	LD	E,(IY+1)	;get new dcb
 	LD	D,(IY+2)
 	PUSH	DE
 	POP	IY
 	JR	LINKBAK		;resume
 ASCII	PUSH	HL
 	CALL	ASCI
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI
 	LD	A,C
 	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET
 ASCI	LD	C,30H
 ASCII1	SUB	0AH
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 DEVSTR	DB	'Drive '
 M1	DB	'x, Tracks='
 M2	DB	'xxx, '
 M3	DB	'xD, '
 M4	DB	'xS, '
 M5	DB	'x", '
 M6	DB	'xxxx, Speed='
 M7	DB	'x, Delay='
 M8	DB	'x.',13
 HARD	DB	'Hard'
 FLOP	DB	'Flop'
 STRDEV	DB	'*'
 D1	DB	'x'
 D2	DB	'x  '
 D5	DB	'x='
 D6	DB	'x  DCB = '
 D3	DB	'xxxxH, Driver = '
 D4	DB	'xxxxH.',13
 HEXCV	LD	(HEXSAV),A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	C,A
 	LD	A,0
 HEXSAV	EQU	$-1
 	AND	0FH
 	CALL	HEXTST
 	LD	B,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 PAUSE	LD	A,(3801H)
 	BIT	0,A
 	JR	NZ,PAUSE
 	RET
 VOUT	PUSH	DE
 	CALL	33H
 	POP	DE
 	RET
 	END	4E00H
HEXTST
 	LD	B,A
 	RET
 HEX,A
 	JR	NZ,PAUSE
 	RET
 	END
C,A
 	LD	A,0
 HEXSAV	EQU	$-1
 	AND	0FH
 	CALL	HEXTST
 	LD	B,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 