STAT/A STAT	PUSH	HL		;check disk status
 	PUSH	DE		;save registers
 	PUSH	BC
 	CALL	SELECT		;turn motor on
 	LD	A,(37ECH)	;available ?
 	RLCA			;check bit 7
 	LD	A,1		;drive not ready
 	JP	C,HOLDER	;go error
 	LD	BC,00CDH	;count for sector holes
 	LD	A,29		;no diskette in drive
 	EX	AF,AF'		;save it here
 TT1	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1	;wait till fixed
 	LD	A,(37ECH)	;check for hole
 	AND	2
 	JR	NZ,TT1
 	LD	BC,199DH	;no sector hole now
 	LD	A,28		;door not closed
 	EX	AF,AF'		;save here
 TT2	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1
 	LD	A,(37ECH)
 	AND	2
 	JR	Z,TT2		;wait till hole comes
 	LD	DE,0		;init count
 	LD	BC,00BAH	;another count
 	LD	A,29		;no disk in drive
 	EX	AF,AF'
 TT3	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1
 	INC	DE		;bump counter
 	LD	A,(37ECH)
 	AND	2
 	JR	NZ,TT3		;de = count
 	LD	BC,1720H
 	LD	A,28		;door not closed
 	EX	AF,AF'
 TST4	DEC	BC
 	LD	A,B
 	OR	C
 	JP	Z,HOLDER-1
 	INC	DE
 	LD	A,(37ECH)
 	AND	2
 	JR	Z,TST4		;wait for next hole
 	LD	HL,0EACBH
 	ADD	HL,DE
 	LD	A,26		;hard sectored disk
 	JR	NC,HOLDER
 	POP	BC
 	POP	DE
 	POP	HL		;restore registers
 	RET
 	EX	AF,AF'
 HOLDER	CALL	ERRSHO		;print the message
 	LD	HL,HMESG
 	CALL	PRINT
 	LD	B,1
 	CALL	INP
 	JP	STAT+3
 HMESG	DB	'<ENTER> to continue, <SH><BREAK> to abort. ',3
 ERRSHO	LD	HL,TABLE
 	INC	HL
 	BIT	7,(HL)
 	JR	Z,ERRSHO+3
 	CP	(HL)
 	JR	NZ,ERRSHO+3
 	JP	PRINT
 ETBLE	DB	1+80H,'Door not closed!',13
 	DB	2+80H,'No Diskette!',13
 	DB	3+80H,'Not in System!',13
 	DB	4+80H,'Hard Sectored!',13
 	INC	HL
 	BIT	7,(HL)
 	JR	Z,ERRSHO+3
 	CP	(HL)
 	JR	NZ,ERRSHO+3
 	JP	PRINT
 ETBLE	DB	1+80H,'Door not closed!',13
 	DB	Z,SKPRPT	;SKIP IF NOT KEY
 	CP	(HL)		;TEST WITH MASK
 	LD	(HL),A		;SAVE NEW KEY
 