OVERLA 	ORG	$
 ; overlay/asm
 OVERLAY	PUSH	HL
 	PUSH	DE
 	PUSH	BC		;SAVE REGISTERS
 	PUSH	AF
 	AND	0F0H
 	JR	Z,EXECOV	;non-valid command
 	LD	HL,LAST		;last overlay
 	CP	(HL)		;same ?
 	LD	(OVLDON+1),A	;save new overlay
 	JR	Z,OVLDON	;already in memory
 	LD	HL,SYSTBL	;point to table
 	RRCA			;move to low bits
 	RRCA
 	RRCA
 	RRCA
 	DEC	A		;less one for table
 	SLA	A		;double for table
 	LD	E,A		;give to de for add
 	LD	D,0
 	ADD	HL,DE		;point to sys entry
 	LD	A,(HL)		;get active byte
 	OR	A
 	JR	Z,NOSYS		;non-active system
 	LD	D,A
 	INC	HL
 	LD	E,(HL)		;get start sector
 	CALL	SETSYS		;setup driv/drive bytes
 	LD	A,5		;sector count
 	CALL	MREAD		;multiple sector read
 OVLDON	LD	A,0
 	LD	(LAST),A
 	LD	HL,4E00H
 	LD	A,(HL)
 	CP	'F'
 	JR	NZ,BADSYS
 	INC	HL
 	LD	A,(HL)
 	CP	'D'
 	JR	NZ,BADSYS
 	POP	AF
 	POP	BC
 	POP	DE
 	POP	HL
 	AND	0FH		;get command number
 	RET	Z		;0 = bring in only
 	EX	(SP),HL
 	LD	H,4EH		;point to jump table
 	DEC	A		;less one for table
 	RLA
 	LD	L,A
 	INC	HL
 	INC	HL
 	JP	GOHL		;go jump table
 EXECOV	POP	AF		;restore registers
 	JP	KEYGONE		;pop the stack
 BADSYS	LD	HL,NSYSMSG	;not a system
 	XOR	A
 	LD	(LAST),A
 	JR	NOSYS+3
 NOSYS	LD	HL,SYSERR
 	CALL	4467H		;display it
 	JP	NXTCMD
 MREAD	LD	BC,4E00H	;where to load it
 	PUSH	AF		;save count
 	CALL	READ		;read the sector
 	CALL	NZ,BADRD
 	CALL	NEXSEC		;advance sector
 	POP	AF
 	DEC	A
 	RET	Z
 	JR	MREAD+3		;continue
 SYSERR	DB	'System Program NOT ACTIVE!',13
 NSYSMSG	DB	'Non-Valid System file read!',13
 SYSTBL	DB	0,0		;SYS1 TRACK/SECTOR
 	DB	0,0		;SYS2
 	DB	0,0		;SYS3
 	DB	0,0		;SYS4
 	DB	0,0		;SYS5
 	DB	0,0		;SYS6
 	DB	0,0		;SYS7
 	DB	0,0		;SYS8
 	DB	0,0		;SYS9
 	DB	0,0		;SYS10
 	DB	0,0		;SYS11
 	DB	0,0		;SYS12
 	DB	0,0		;SYS13
 	DB	0,0		;SYS14
 	DB	0,0		;SYS15
 BADRD	RET
 NEXSEC	INC	E
 	LD	A,E
 	SUB	0AH
 	RET	NZ
 	LD	E,A
 	INC	D
 	RET
 SETSYS	PUSH	BC
 	LD	B,0
 	LD	A,(SYSDRV)
 	LD	(DRIV),A
 SYCK	RRCA
 	JR	C,HAVSYK
 	INC	B
 	JR	SYCK
 HAVSYK	LD	A,B
 	LD	(DRIVE),A
 	POP	BC
 	RET
 	END
NZ
 	LD	E,	POP	HL		;RESTORE POINTER
 	JR	NZ,VIDIT1	;CONTINUE IF NOT AT END
 	JR	VIDLIN		;OUTPUT CARRIAGE RETURN
 	END
INC	HL		;BUMP VIDEO POINTER
 	PUSH	HL		;SAVE FOR TEST
 	OR	A		;CLEAR CARRY FLAG
 	SBC	HL,DE		;TEST EN