INT/AS 	ORG	$
 ; int/asm
 TASK	PUSH	AF		;save af & hl
 	PUSH	HL
 	LD	A,(37E0H)	;check interrupt status
 	BIT	6,A		;if FDC making roster ?
 	JR	NZ,FDCROS	;controller interrupted
 	BIT	7,A		;is this a valid int ?
 	JR	Z,TASKDN	;finished if not set
 	LD	A,-1		;start B4 table
 	LD	(TSKPOS),A	;save it
 TSKLP	LD	A,0		;get position
 TSKPOS	EQU	$-1
 	INC	A		;bump counter
 	LD	(TSKPOS),A	;save new count
 	CP	10		;end of routine ?
 	JR	NC,TASKDN	;finished
 	LD	HL,TSKLP	;point to loop
 	PUSH	HL		;for return address
 	LD	HL,TSKTBL	;point to table
 	RLCA			;double for table
 	ADD	A,L		;point to byte
 	LD	L,A
 	LD	A,(HL)		;get lsb
 	INC	HL		;point to msb
 	LD	H,(HL)		;get it
 	LD	L,A
 	LD	A,H		;check if any address
 	OR	L		;there to jump to
 	RET	Z		;z=inactive interrupt
 	JP	(HL)		;go routine
 TASKDN	LD	A,(37E0H)	;clear latch
 	POP	HL		;restore hl & af
 	POP	AF
 	EI
 	RET
 FDCROS	LD	A,(37ECH)	;clear FDC latch
 	JR	TASKDN
 CLOCK	LD	HL,TICKS	;point to ticks
 	INC	(HL)		;bump it
 	LD	A,(HL)		;check for 40
 	CP	41		;time yet ?
 	RET	C		;nope
 	LD	(HL),0		;else zero it out
 	INC	HL		;point to seconds
 	INC	(HL)		;test for end
 	LD	A,(HL)
 	CP	61
 	RET	C
 	LD	(HL),0
 	INC	HL		;point to minutes
 	INC	(HL)		;bump it
 	LD	A,(HL)
 	CP	61
 	RET	C
 	LD	(HL),0
 	INC	HL		;point to hours
 	INC	(HL)
 	LD	A,(HL)
 	CP	25		;24 hour clock
 	RET	C
 	LD	(HL),0
 	RET			;skip calendar update ?
 CHECKKEY	XOR	A	;zero for now
 	CALL	IGET		;any keys pressed ?
 	RET	Z		;nope
 	PUSH	AF		;save it
 	LD	A,(NEXT)	;point to next byte
 	PUSH	AF
 	LD	HL,KESAVE	;point to buffer
 	ADD	A,L
 	LD	L,A
 	POP	AF		;get next back
 	INC	A		;bump it
 	LD	(NEXT),A	;save it
 	POP	AF
 	LD	(HL),A		;put in table
 	RET
 DRIVEON	JP	SELECT		;keep motor running
 TSKTBL	DW	CLOCK,CHECKKEY,0,0,0
 	DW	0,0,0,0,0
 	END
L,A
 	POP	AF		;get next back
 	INC	A		;bump it
 	LD	(NEXT),A	;save it
 	POP	AF
 	LD	(HL),A		; flag
 	XOR	1		;reverse bit
 ADJCON	LD	(KIFLAG),A	;put it back
 	XOR	A		;zero for input char.
 	RET			;done
 RPT