BOOT/A 	ORG	4200H
 ; boot/asm
 	NOP
 	CP	20
 	LD	HL,CLEAR	;use as stack
 	CALL	PRINT		;clear screen
 	LD	SP,CLEAR+10	;10 byte stack
 	LD	DE,1		;sector 1
 	LD	BC,4000H
 	LD	L,2		;2 sectors
 	CALL	READ		;read it
 	LD	DE,3
 	LD	BC,4300H
 	LD	L,14		;14 sectors
 	CALL	READ
 	JP	4E00H		;initialize
 READ	PUSH	HL		;save count
 	CALL	READ1		;read 1 sector
 	POP	HL
 	DEC	L
 	RET	Z		;done
 	INC	E
 	LD	A,E
 	SUB	0AH
 	JR	NZ,READ
 	LD	E,A
 	INC	D
 	JR	READ
 READ1	LD	A,1		;select drive
 	LD	(37E1H),A	;turn it one
 	LD	(37EEH),DE	;track/sector
 	LD	HL,37ECH	;FDC address
 	LD	(HL),1BH	;seek
 	CALL	DSKSLO		;wait
 SEEK	BIT	0,(HL)		;found yet ?
 	JR	NZ,SEEK
 	LD	(HL),88H	;read command
 	PUSH	DE
 	LD	DE,37EFH
 	CALL	DSKSLO		;wait
 	JR	CKSTAT		;transfer bytes
 PUTEM	LD	A,(DE)		;get byte from FDC
 	LD	(BC),A		;put in buffer
 	INC	BC
 CKSTAT	BIT	1,(HL)		;next byte ready ?
 	JR	NZ,PUTEM
 	BIT	1,(HL)		;doing this for double
 	JR	NZ,PUTEM	;density load
 	BIT	1,(HL)
 	JR	NZ,PUTEM
 	BIT	0,(HL)
 	JR	NZ,CKSTAT
 	POP	DE		;restore track/sector
 	LD	A,(HL)		;get result of operation
 	AND	0FCH		;ok ?
 	RET	Z
 	LD	HL,BADRD	;bad read message
 	CALL	PRINT
 	LD	HL,3840H
 WAIT	BIT	0,(HL)		;wait for enter key
 	JR	Z,WAIT
 	HALT			;re-boot
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 PRINT	PUSH	HL		;save data pointer
 	LD	HL,3C00H
 	PUSH	HL
 	LD	DE,3C01H
 	LD	BC,1023
 	LD	(HL),20H
 	LDIR
 	POP	DE
 	POP	HL
 	LD	BC,10
 	LDIR
 	RET			;done
 BADRD	DB	'DISK ERROR'
 CLEAR	DB	'          '	;USE AS STACK TOO
 	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 NAME	DB	'Fast Dos02/18/81'
 AUTO	DB	13,'                              '
 	DB	20H
 	END	4200H
'DISK ERROR'
 CLEAR	DB	'          '	;USE AS STACK TOO
 	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 NAME	DB	'Fast Dos02/18/81'
 AUTO	DB	13,'     O	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX