0100 ; Use on Model I, Version 5.0.3 Only!
00110 ; FASTSPL - Fast despooling 5.0 Utility
00120 ;
00130 TCB$    EQU     4500H
00140 HIGH$   EQU     4049H
00150 @EXIT   EQU     402DH
00160 @KITSK  EQU     4300H
00170 ;
00180         ORG     5200H
00190 START   LD      HL,(HIGH$)      ;Get current HIGH$
00200         LD      BC,LENGTH       ;Length of new code
00210         OR      A
00220         SBC     HL,BC           ;Sub needed space
00230         LD      (HIGH$),HL      ;Store new HIGH$
00240         INC     HL              ;Loc. new code
00250         PUSH    HL
00260         LD      HL,(TCB$+18)    ;SPOOL TCB addr.
00270         LD      (NWTCB1),HL     ;Insert TCB in new code
00280         INC     HL
00290         INC     HL              ;P/U despool addr
00300         LD      (NWTCB2),HL     ;Insert despool in new code
00310         POP     DE              ;Where new code goes
00320         PUSH    DE              ;Save for later
00330         LD      HL,NEWCOD       ;Actual new code start
00340         LDIR                    ;Move to High Mem.
00350         LD      HL,@KITSK+2     ;Put new despool into KITSK
00360         POP     DE              ; vector, so get entry point
00370         LD      A,0C3H          ;C3 = JUMP opcode
00380 ; Now install the new KITSK vector Backwards to avoid system crash
00390         LD      (HL),D          ;MSB of entry pt
00400         DEC     HL
00410         LD      (HL),E          ;LSB of entry pt
00420         DEC     HL
00430         LD      (HL),A          ;Insert JP vs. RET
00440         JP      @EXIT           ;All done!
00450 ;
00460 ; New Code to be moved into high memory
00470 ;
00480 NEWCOD  DI
00490         LD      IX,$-$          ;This will be new TCB
00500 NWTCB1  EQU     $-2             ;Stuff TCB into opcode
00510         CALL    $-$             ;Call despool
00520 NWTCB2  EQU     $-2             ;Stuff despool task addr.
00530         EI
00540         RET
00550 LENGTH  EQU     $-NEWCOD
00560         END     START
                                          