       ;Program to display diskette catalogues and
 ;sort them into alphabetical order on the
 ;video display.
 ;Syntax ACAT,d,p d=drive, p=printer
 ;<c>1983 by Mel Patrick
 	ORG	6000H		;temp origin
 ACAT	LD	A,(HL)		;get info
 	CP	0DH		;end of input
 	JR	Z,ACAT1		;go if yes
 	CP	'0'		;else check limits
 	JR	C,ACAT1		;go if too low
 	CP	'4'		;check upper limit
 	JR	NC,ACAT1	;go if too high
 	LD	(DRIVE),A	;else reset drive#
 ACAT0	INC	HL		;point to next
 	LD	A,(HL)		;get a byte
 	CP	0DH		;end of input?
 	JR	Z,ACAT1		;go if yes
 	AND	5FH		;else convert to upper
 	CP	'P'		;look for printer
 	JR	NZ,ACAT0	;go if not
 	LD	(PFLAG),A	;else set printer dump
 ACAT1	CALL	01C9H		;clear the video
 	LD	HL,CMD		;point to command
 ;Change this call to your Operating system.
 ;4405H for most others. NewDos uses 4419H.
 	CALL	4419H		;for NewDos 80
 	LD	HL,3C40H	;point to second line
 RDLP	LD	A,(HL)		;get a byte
 	CP	' '		;is it a space
 	JR	NZ,NOSP		;go if not
 	INC	HL		;else point to next
 	LD	A,H		;get screen value
 	CP	40H		;done?
 	JR	NZ,RDLP		;no then loop back
 	CP	C		;any filenames?
 	JP	NZ,402DH	;dos ready if not
 	JR	SORT		;else sort them
 NOSP	LD	(LAST),HL	;save start of name
 	LD	C,40H		;set file flag
 NOSP1	LD	A,(HL)		;get a byte
 	CP	' '		;look for a space
 	JR	Z,RDLP		;back if space found
 	INC	HL		;else point to next
 	JR	NOSP1		;loop til found
 SORT	LD	HL,(LAST)	;get last filename
 	LD	DE,16		;find end of list
 	ADD	HL,DE		;get the address
 	LD	(LAST),HL	;save it
 	LD	(HL),80H	;set graphic block
 	LD	HL,3C80H	;start of sort
 	PUSH	HL		;save pointer
 	LD	DE,14		;not quite to next
 	ADD	HL,DE		;place to start looking
 	PUSH	HL		;move answer to DE
 	POP	DE		;DE points past first
 	POP	HL		;HL=first filename
 STEP	LD	A,(DE)		;get a character
 	CP	' '		;look for ASCII
 	JR	NZ,SORT0	;go if found
 	INC	DE		;else point to next
 	JR	STEP		;step til found
 SORT0	LD	A,(DE)		;get a byte
 	CP	80H		;end of filename list?
 	JR	Z,ATTOP		;go if yes
 	PUSH	DE		;else save second
 	PUSH	HL		;save first
 	LD	B,12		;bytes to compare
 SORT1	LD	A,(DE)		;get second name
 	CP	(HL)		;check against first
 	JR	Z,SORT5		;continue if equal
 	JR	C,SWAP		;else swap them
 	JR	SORT3		;else skip to next
 SORT5	INC	HL		;point to next
 	INC	DE		;"		"
 	DJNZ	SORT1		;loop for 12 char.
 SORT4	INC	DE		;point to next
 	LD	A,(DE)		;get a byte
 	CP	' '		;look for ASCII
 	JR	Z,SORT4		;loop til ASCII found
 	POP	HL		;point to first
 	POP	IY		;dummy pop for stack
 	JR	SORT0		;and continue
 ATTOP	LD	DE,14		;slight offset
 	ADD	HL,DE		;point almost
 ATTOP1	LD	A,(HL)		;get a byte
 	CP	' '		;space still?
 	JR	NZ,FNDNX	;go if next found
 	INC	HL		;else point to next
 	JR	ATTOP1		;loop til next name
 FNDNX	LD	A,(HL)		;check byte now
 	CP	80H		;end of list
 	JR	Z,DONE		;go if done
 	PUSH	HL		;else save position
 	ADD	HL,DE		;and find next name
 	PUSH	HL		;move answer to DE
 	POP	DE		;DE=1 past
 	POP	HL		;hl=first again
 ATTOP2	LD	A,(DE)		;get a byte
 	CP	' '		;space byte?
 	JR	NZ,SORT0	;back if not
 	INC	DE		;else step to name
 	JR	ATTOP2		;loop til found
 SORT3	INC	DE		;step past name
 	DJNZ	SORT3		;now
 	JR	SORT4		;and continue to next
 SWAP	POP	HL		;point to first
 	POP	DE		;point to second
 	PUSH	HL		;save start again
 	LD	B,12		;bytes to swap
 SWAP1	LD	A,(HL)		;get a byte
 	PUSH	AF		;save it on stack
 	LD	A,(DE)		;get a byte
 	LD	(HL),A		;move it
 	POP	AF		;get back character
 	LD	(DE),A		;move it
 	INC	DE		;point to next
 	INC	HL		;point to next
 	DJNZ	SWAP1		;loop til moved
 	POP	HL		;point to first
 	JR	STEP		;and step DE to next
 DONE	LD	A,(PFLAG)	;test for print copy
 	OR	A		;0=none NZ=yes
 	JR	Z,DONE1		;go if not required
 	LD	HL,3C00H	;else setup for dump
 LPRINT	LD	B,8		;bytes to tab in
 TAB	LD	A,' '		;get a space byte
 	CALL	3BH		;LPRINT it
 	DJNZ	TAB		;loop for tab
 	LD	B,64		;bytes per line
 PRINT	LD	A,(HL)		;get a byte
 	CP	80H		;end of routine
 	JR	Z,ENDPRT	;go if yes
 	CALL	3BH		;else LPRINT it
 	INC	HL		;point to next
 	DJNZ	PRINT		;loop for 1 line
 	LD	A,0DH		;get a C/R
 	CALL	3BH		;LPRINT it
 	JR	LPRINT		;loop til done
 ENDPRT	LD	A,0DH		;get a C/R
 	CALL	3BH		;LPRINT it
 DONE1	LD	HL,(LAST)	;get last address
 	LD	(HL),' '	;replace graphic
 	JP	402DH		;back to Dos Ready
 ;Change the ASCII word here to your DOS command.
 ;Use CAT for DOSPLUS, DIR for NewDos etc.
 CMD	DEFM	'DIR'		;test drive 0 (NewDos CMD)
 	DEFM	' :'		;delimiter
 DRIVE	DEFM	'0'		;default to zero
 	DEFB	0DH		;terminator
 LAST	DEFW	0000H		;last address
 PFLAG	DEFB	00H		;0=no dump NZ=dump
 	END	ACAT		;start adress

