DLZAP  ;********************************************************
 ; This program loads DISKLBL/CMD, changes it to replace
 ; the printer driver routine, and then executes it.
 ;
 ; The new printer driver assumes standard TRS-80 model I
 ; printer port addressing. It suppresses the sequence
 ; <ESC> E , to enable the disk labels to be printed on an
 ; EN-P1091 printer.
 ;				Richard Levingston
 ;				(no copyright claimed)
 ;
 ;********************************************************
 	ORG	0FFC2H	; If you change this ORG, change 
 			; the HIMEM CMD also
 ; Simple printer driver
 ; which suppress the ESC E sequence
 ESC	EQU	1BH
 PADD	EQU	37E8H	; Printer register address
 ;
 PRINT	EQU	$
 	LD	A,(FLAG)
 	OR	A
 	JR	NZ,FLGSET
 	LD	A,C
 	CP	ESC
 	JR	NZ,CHROUT	; Not ESC, so print it
 	LD	(FLAG),A	; Set flag for next time
 	RET
 ;----
 FLGSET	EQU	$	; Last char was ESC
 	XOR	A
 	LD	(FLAG),A	; Reset flag
 	LD	A,C
 	CP	'E'	; Suppress ESC E
 	RET	Z
 	PUSH	BC
 	LD	C,ESC
 	CALL	NOTRDY	; Output ESC
 	POP	BC
 ;-- Routine to send character to the printer
 CHROUT	EQU	$
 NOTRDY	CALL	STATUS	; See if printer is ready
 	JR	NZ,NOTRDY	; If not, try again
 	LD	A,C		; Char to print
 	LD	(PADD),A	; Print it
 	RET
 ;-- Routine to get printer status (copy Model I ROM 05D1)
 STATUS	LD	A,(PADD)
 	AND	0F0H	; Isolate status bits
 	CP	30H	; Check for online and ready
 	RET
 FLAG	DEFB	0
 ZZZZZ	EQU	$
 ;-----------------------------
 ; Start routine: processing as follows:
 ;	(1) set HIMEM to protect the driver
 ;	(2) load DISKLBL/CMD
 ;	(3) ZAP the code
 ;	(4) Jump to the entry point to execute it
 ;--------------------------------------------------
 	ORG	0C000H
 START	EQU	$
 ; Set HIMEM
 	LD	HL,CMD
 	CALL	4419H
 	JP	NZ,4409H
 ; Load the program
 	LD	DE,FCB
 	CALL	4430H	; Load the program
 	JP	NZ,4409H
 	PUSH	HL	; Remember the entry address
 ; ZAP the program
 	LD	HL,ZAP
 	LD	DE,5824H
 	LD	BC,ZAPL
 	LDIR		; ZAP the code
 ; Now go execute it
 	POP	HL	; Retreive the entry address
 	JP	(HL)	; Jump to the program entry point
 ;
 ; Code to put into the program
 ;
 ZAP	EQU	$
 	LD	C,A
 	JP	PRINT
 ZAPL	EQU	$-ZAP	; Length of new code
 ;
 ; Data
 ;
 CMD	DEFM	'HIMEM FFC0H'
 	DEFB	0DH
 FCB	DEFM	'DISKLBL/CMD'
 	DEFB	03H
 	DEFS	32
 	END	START
