PCOPY  	ORG	5500H
 ;LABELS/ASM
 SECTOR	DB	0		;track/sector save area
 TRAK	DB	0
 CURSOR	EQU	4020H
 TOPMEM	DW	0
 RESULT	DB	0		;result of disk I/O
 TEMP0	DW	0		;temporary storage
 TEMP1	DW	0
 TEMP2	DW	0
 TEMP3	DW	0
 TEMP4	DW	0
 TEMP8	DW	0
 TEMP9	DW	0
 LASTB	DB	0		;byte to find in modify
 DRVTBL	DB	0,0,0,0
 TRACKS	DB	35
 TYPES	DB	3,3,3,3
 TRACK	DB	0,0,0,0
 SDRIVE	DB	0		;source drive
 DDRIVE	DB	0		;destination drive
 KEYBRD	DB	0,0,0,0,0,0,0
 MFLAG	DB	0		;mount yes/no flag
 COUNT	DW	0
 	DB	'String'
 STRING	DB	'String String String String String '
 	DB	'String String String String String '
 ;FORMAT/ASM
 FORMAT	CALL	BUILDTRK
 	CALL	SHOFMT
 	RET	NZ
 	LD	DE,(TRACKS)
 	LD	A,(37EDH)
 	INC	A
 	CP	E
 	RET	Z
 	CALL	STEPIN		;move head in
 	JR	FORMAT
 BUILDTRK	OR	A
 	CALL	GETTYPE
 	LD	HL,ORDER
 	BIT	5,A
 	JR	Z,GOTORD
 	LD	A,(37EDH)
 	OR	A
 	LD	HL,DORDER
 	JR	NZ,GOTORD
 	LD	HL,ORDER
 GOTORD	LD	C,(HL)		;get sectors/track
 	INC	HL
 	LD	E,(HL)		;get sector order table
 	INC	HL
 	LD	D,(HL)
 	INC	HL
 	CALL	ORDNEW		;3 rotations
 	PUSH	DE		;save it
 	LD	DE,BUFFER
 	EX	DE,HL		;hl => buffer, de =>table
 	CALL	MOVEIN		;move the bytes in
 	LD	(DESVE),DE	;save DE position
 SECLP	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FEH
 	INC	HL
 	LD	A,(37EDH)	;get track
 	LD	(HL),A
 	INC	HL
 	LD	(HL),0		;head
 	INC	HL
 	EX	(SP),HL		;get sector order
 	LD	A,(HL)		;get sector number
 	INC	HL
 	EX	(SP),HL		;put it back
 	LD	(HL),A		;put in buffer
 	INC	HL
 	LD	(HL),1		;length of sector
 	INC	HL
 	LD	(HL),0F7H	;generate CRC
 	INC	HL
 	CALL	MOVEIN
 	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FBH	;Data address mark
 	INC	HL
 	LD	A,0		;fill byte
 	CALL	FILL		;fill for 256 bytes
 	LD	(HL),0F7H	;CRC for data
 	INC	HL
 	CALL	MOVEIN
 	LD	DE,0
 DESVE	EQU	$-2
 	DEC	C		;sector count -1
 	JR	NZ,SECLP	;sector loop
 	INC	SP		;adjust stack
 	INC	SP
 	DEC	DE
 	LD	A,(DE)
 	CALL	FILL		;fill to end byte
 	LD	BC,BUFFER	;point to the buffer
 RET	RET			;done
 MOVEIN	LD	A,(DE)		;get table byte
 	LD	B,A		;# bytes to go
 	INC	DE
 	LD	A,(DE)		;byte to fill with
 	INC	DE		;point to next one
 FILL	LD	(HL),A		;put in buffer
 	INC	HL
 	DJNZ	FILL
 	RET
 ORDER	DB	10		;sectors/track
 	DW	ORDERS		;single sector order
 	DB	1FH,0FFH	;count,byte
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH	;gaps
 DORDER	DB	18		;sectors/track
 	DW	ORDERD		;double sector order
 	DB	3EH,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 ORDERS	DB	0,5,1,6,2,7,3,8,4,9
 ORDERD	DB	0,6,12,1,7,13,2,8,14
 	DB	3,9,15,4,10,16,5,11,17
 ORDNEW	PUSH	BC		;save these
 	PUSH	DE
 	PUSH	HL		;save everything
 	EX	DE,HL		;HL = order table
 	LD	B,3		;3 shifts
 	DEC	C		;one less than # sectors
 	OR	A
 	CALL	GETTYPE
 	BIT	5,A
 	JR	Z,ORDNEW1
 	LD	B,4		;4 shifts double den
 ORDNEW1	PUSH	BC		;save counters
 	LD	A,(HL)		;get table byte
 	PUSH	HL		;save table start
 	INC	HL		;look at 2nd one
 ORDNEW2	LD	E,(HL)		;get 2nd byte
 	LD	(HL),A		;put 1st one there
 	LD	A,E		;get 2nd one
 	INC	HL		;go to next table byte
 	DEC	C		;continue through table
 	JR	NZ,ORDNEW2
 	POP	HL		;restore table pointer
 	LD	(HL),A		;put last byte in 1st
 	POP	BC		;get counters back
 	DJNZ	ORDNEW1		;go again
 	POP	HL
 	POP	DE		;restore these
 	POP	BC
 	RET
 SETDEN	LD	A,(37EDH)	;get track from FDC
 	JR	SETDENC
 SETDEND	LD	A,D		;from DE
 SETDENC	EX	AF,AF'		;save it here
 	LD	(SETDHL),HL	;save HL
 	OR	A		;clear carry
 	CALL	GETTYPE		;get drive type
 	POP	HL		;return address
 	SCF			;set to put in table
 	PUSH	AF		;save here
 	PUSH	HL		;put return address back
 	EX	AF,AF'		;get track back
 	OR	A		;set flags
 	JR	NZ,SETDRT	;return if not 0
 	EX	AF,AF'		;get table value back
 	RES	5,A		;make it single density
 	SCF
 	CALL	GETTYPE
 SETDRT	LD	HL,0		;get HL back
 SETDHL	EQU	$-2
 	RET			;done
 ;START/ASM
 ENTRY	LD	HL,(4049H)
 	LD	L,0
 	DEC	H
 	LD	(TOPMEM),HL
 	CALL	DISPLY
 	DB	1CH,1FH,'**  POSTMAN Data Disk Backup Program  **  by Kim Watt',10
 	DB	'Written for POSTMAN DATA HANDLER version 1.6',10
 	DB	'(C)(P) 1981 Soft Sector Marketing Inc.',10
 	DB	'Enter X at any input line to terminate.',10,0
 	CALL	COPY
 	CALL	DISPLY
 	DB	10,'** ROUTINE COMPLETED **',10
 	DB	0
 	JR	DOSWAIT
 ABORT	CALL	DISPLY
 	DB	10,'** ABORTED **',0
 	JR	DOSWAIT
 TERMINATE	CALL	DISPLY
 	DB	10,10,'CANNOT CONTINUE because of Source ERROR ! ',0
 DOSWAIT	LD	A,(SDRIVE)
 	OR	A
 	JR	Z,MUSTWAIT
 	LD	A,(DRVTBL)
 	DEC	A
 	JR	Z,MUSTWAIT
 	JP	402DH
 MUSTWAIT	CALL	DISPLY
 	DB	10,'Mount SYSTEM disk, key <ENTER>. ',0
 	CALL	ONEKEY
 	JP	402DH
 ;DISK2/ASM
 SHOREAD	CALL	DISPLY
 	DB	1DH,'Reading    ',0
 	LD	HL,READ
 	PUSH	HL
 	LD	HL,BADRD
 	PUSH	HL
 	LD	HL,SHOREAD	;where source from
 	JR	SHORWCOM	;go common
 SHOWRITE	CALL	DISPLY
 	DB	1DH,'Writing    ',0
 	LD	HL,WRITE
 	PUSH	HL
 	LD	HL,BADWRT
 	PUSH	HL
 	LD	HL,SHOWRITE
 	JR	SHORWCOM
 SHOVERIFY	CALL	SHOVERF
 	LD	HL,READ
 	PUSH	HL
 	LD	HL,BADRD
 	PUSH	HL
 	LD	HL,SHOVERIFY
 SHORWCOM	LD	(SHO003),HL
 	POP	HL
 	LD	(SHO002),HL
 	POP	HL
 	LD	(SHO001),HL
 	CALL	SHOWWH		;display drive,track,sec
 	CALL	SETDEND		;setup density
 	CALL	0		;set from above
 SHO001	EQU	$-2
 	POP	HL		;restore density
 	PUSH	AF
 	PUSH	HL		;HL=>AF
 	POP	AF
 	CALL	GETTYPE		;replace density
 	POP	AF		;get result back
 	RET	Z		;successful
 	CALL	0		;error type
 SHO002	EQU	$-2
 	RET	Z
 	CALL	DSTAT		;check status again
 	RET	NZ		;skip
 	JP	0		;try again
 SHO003	EQU	$-2
 SHOVERF	CALL	DISPLY
 	DB	1DH,'Verifying  ',0
 	RET
 SHOFMT	LD	A,(37EDH)	;get track
 	PUSH	BC		;save buffer
 	CALL	ASCII
 	LD	(FTR),A
 	LD	(FTR+1),BC
 	CALL	DRVASC
 	LD	(FDR),A		;put in string
 	POP	BC
 	CALL	DISPLY
 	DB	1DH,'Formatting Drive '
 FDR	DB	'x, Track '
 FTR	DB	'xxx.                ',0
 	CALL	WRITETR		;write the track
 	RET	Z		;successful
 	LD	HL,MEG0
 	BIT	6,A		;write protected?
 	JR	NZ,FMTER
 	LD	HL,MEG1
 	BIT	5,A		;write fault?
 	JR	NZ,FMTER
 	LD	HL,MEG2
 	BIT	2,A		;lost data?
 	RET	Z
 FMTER	PUSH	HL
 	JP	DISPLY		;print error
 MEG0	DB	10,'Diskette WRITE PROTECTED !',0
 	OR	1
 	RET			;return with NZ flag
 MEG1	DB	10,'Write Fault FROM DRIVE !',0
 	OR	1
 	RET
 MEG2	DB	10,'DATA LOST during Track Write !',0
 	OR	1
 	RET
 CNTOTAL	LD	BC,(TRACKS)
 	LD	B,0		;BC = track count
 	OR	A		;get type
 	CALL	GETTYPE
 	PUSH	AF
 	BIT	5,A
 	LD	A,10
 	LD	HL,0
 	JR	Z,CNTLP
 	LD	A,18
 CNTLP	ADD	HL,BC		;add 'em
 	DEC	A		;go till sector count
 	JR	NZ,CNTLP
 	POP	AF
 	BIT	5,A
 	RET	Z
 	LD	BC,-8		;adjust for single tk 0
 	ADD	HL,BC
 	RET
 MVERIFY	PUSH	HL		;save count
 	LD	HL,SHOVERIFY	;routine address
 	JR	MCOMM		;go common routine
 MREAD	PUSH	HL
 	LD	HL,SHOREAD
 	JR	MCOMM
 MWRITE	PUSH	HL
 	LD	HL,SHOWRITE
 MCOMM	LD	(MLADD),HL	;put in call code
 	POP	HL		;restore counter
 	LD	IX,DAMBUFF	;Data Address Marks
 MCLP	PUSH	HL		;save from call
 	CALL	INITBAD		;allow key input if bad
 	LD	A,(IX)		;get DAM
 	CP	0A0H
 	CALL	C,BADLMD	;bad write byte
 	CP	0C0H
 	CALL	NC,BADLMD	;this way bad too
 	LD	(WRTYPE),A	;pass to write command
 	CALL	0		;call the read/write/ver
 MLADD	EQU	$-2
 	POP	HL		;restore count
 	EX	AF,AF'		;get write byte
 	LD	(IX),A		;put in buffer
 	INC	IX		;bump buffer
 	EX	AF,AF'		;get result back
 	RET	C		;c = cancel routine
 	CALL	NEXSEC		;advance DE
 	JR	NC,MALDD00	;continue
 	LD	HL,0		;else done with track
 	CCF
 	RET
 MALDD00	DEC	HL
 	LD	A,H
 	OR	L
 	RET	Z		;done if yes
 	CALL	BUFFEREND	;buffer at end of memory?
 	RET	Z		;at end of memory
 	JR	MCLP		;do some more
 SMOUNT	PUSH	HL		;mount source disk
 	LD	HL,MOUNTSRC
 	JR	MOUNTC
 DMOUNT	PUSH	HL		;mount dest disk
 	LD	HL,MOUNTDES
 MOUNTC	LD	(MOUNTJ),HL	;save jump vector
 	POP	HL
 	LD	A,(MFLAG)	;get mount flag
 	DEC	A		;-1 = no mount wait
 	RET	Z
 	JP	0		;else display prompt
 MOUNTJ	EQU	$-2
 DRVSAME	PUSH	BC		;save to use
 	LD	A,(SDRIVE)	;get source drive
 	LD	B,A
 	LD	A,(DDRIVE)	;dest drive
 	CP	B		;same?
 	POP	BC
 	RET			;that's all here
 WRITETR	PUSH	BC		;save load address
 	CALL	TRWRITE		;write the track
 	POP	BC		;load back
 	RET	Z		;done
 TRWRITE	CALL	SELECT		;try again
 	RET	NZ		;not ready
 	CALL	SELDEN		;select density
 	LD	HL,37ECH	;point to FDC
 	LD	DE,37EFH	;data address
 	DI			;disable
 	LD	(HL),0F4H	;write track code
 	CALL	WXFER		;write the data
 	AND	0E4H		;error status
 	RET			;done
 BUFFEREND	LD	A,(TOPMEM+1)	;get msb topmem
 	CP	B		;test for buffer end
 	SCF			;must clear carry
 	CCF
 	RET			;back with Z flag
 BADLMD	LD	A,0A8H
 	RET
 ;VIDKEY/ASM
 GETSTR	LD	HL,STRING
 	PUSH	DE
 	PUSH	IY
 	CALL	40H
 	POP	IY
 	POP	DE
 	LD	A,(HL)
 	CALL	UCASE
 	CP	'X'
 	JP	Z,ABORT
 	LD	A,B
 	OR	A
 	LD	A,(HL)
 	RET
 DISPLY	EX	(SP),HL
 	PUSH	AF
 DISLP	LD	A,(HL)
 	INC	HL
 	OR	A
 	JR	Z,DISDON
 	CP	20H
 	JR	C,DISCTL
 	PUSH	HL
 	LD	HL,(CURSOR)
 	LD	(HL),A
 	CP	(HL)
 	JR	Z,DOLOW
 	SUB	20H
 	LD	(HL),A
 DOLOW	INC	HL
 	LD	(CURSOR),HL
 	POP	HL
 	JR	DISLP
 DISCTL	PUSH	IY
 	PUSH	DE
 	CALL	33H
 	POP	DE
 	POP	IY
 	JR	DISLP
 DISDON	POP	AF
 	EX	(SP),HL
 	RET
 ;COPY/ASM
 COPY	CALL	ONEDRIVE
 	LD	A,(DRIV)	;get the drive
 	LD	(SDRIVE),A	;save it
 	LD	BC,BUFFER
 	LD	DE,0
 	CALL	SHOREAD
 	JP	C,TERMINATE
 	JR	Z,GOCPPYY
 	LD	A,17
 	JR	GOCYP
 GOCPPYY	LD	A,(BUFFER+2)
 	AND	7FH
 GOCYP	LD	D,A
 	LD	E,0
 	LD	BC,BUFFER
 	CALL	SHOREAD
 	JP	C,TERMINATE
 	JP	NZ,TERMINATE
 	LD	A,(RESULT)
 	BIT	5,A
 	JP	Z,NOTDIRECT
 	LD	HL,BUFFER+0BFH
 	LD	B,96
 CKTLP	INC	(HL)
 	DEC	HL
 	JR	NZ,CKTLP0
 	DJNZ	CKTLP
 	JP	TERMINATE
 CKTLP0	LD	A,B
 	LD	(TRACKS),A
 	CALL	ASCII
 	LD	(TKSTR),BC
 	CALL	DISPLY
 	DB	1DH,1EH
 TKSTR	DB	'xx Tracks Assumed.',10,0
 	CALL	GETDRIVES	;can use all 4
 	CALL	DISPLY
 	DB	10,0
 	XOR	A
 	LD	(POSA),A	;start position
 	LD	A,(SDRIVE)
 	LD	HL,DRVTBL
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	DEC	A
 	LD	(MFLAG),A	;save into mount flag
 ASKIFFMT	CALL	DISPLY
 	DB	1EH,'Format Destination Drives ? ',0
 	LD	A,1
 	LD	(IFBFMT),A
 	LD	B,3
 	CALL	GETSTR
 	JR	Z,SCOPYOLOOP
 	CALL	POSHL
 	JR	C,SCOPYOLOOP
 AKBAK	CALL	POSHL
 	JR	C,ANOBAK
 	CALL	UCASE
 	CP	'Y'
 	JR	Z,BAKFMT0
 	CP	'N'
 	JR	Z,BAKFMT1
 	JR	ASKIFFMT
 BAKVGO	INC	HL
 	JR	AKBAK
 BAKFMT0	LD	A,1
 	LD	(IFBFMT),A
 	JR	BAKVGO
 BAKFMT1	XOR	A
 	JR	BAKFMT0+2
 ANOBAK	LD	A,0
 IFBFMT	EQU	$-1
 	DEC	A
 	JR	NZ,SCOPYBAK
 SCOPYOLOOP	CALL	DISPLY
 	DB	'Mount DESTINATION diskettes. ',0
 	CALL	ONEKEY
 	CALL	DISPLY
 	DB	1DH,1EH,0
 	LD	DE,SCOPYO
 	LD	BC,SCOPYBAK	;return here
 	JP	DRVCOMM		;do all dest drives
 SCOPYO	CALL	DSTAT		;is drive ready?
 	JP	NZ,REMDRIVE
 	JP	C,REMDRIVE
 	CALL	RESTORE
 	JP	NZ,REMDRIVE
 	CALL	FORMAT
 	RET	Z
 	JP	REMDRIVE
 SCOPYBAK	LD	A,(SDRIVE)
 	CALL	SETDRV
 	CALL	CNTOTAL
 	LD	(TEMP2),HL
 	LD	HL,0
 	LD	(TEMP0),HL
 	CALL	INITBAD1
 	CALL	DISPLY
 	DB	10,0
 SCOPYLP	LD	HL,DRVTBL
 	LD	BC,0400H
 SCOPYCK	LD	A,(HL)
 	ADD	A,C
 	LD	C,A
 	INC	HL
 	DJNZ	SCOPYCK
 	OR	A
 	JR	NZ,SCOPYCK0
 	CALL	DISPLY
 	DB	10,'No Destination Drives !',0
 	RET
 SCOPYCK0	LD	HL,DRVTBL
 	LD	A,(SDRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	AND	1
 	LD	A,(SDRIVE)
 	JR	NZ,MUSMNT
 	INC	A
 MUSMNT	LD	(DDRIVE),A
 	LD	DE,(TEMP0)
 	LD	(TEMP1),DE
 	LD	HL,(TEMP2)
 	LD	BC,BUFFER
 	LD	A,(SDRIVE)
 	CALL	SETDRV
 	CALL	DRVSAME
 	CALL	Z,SMOUNT
 	PUSH	HL
 	CALL	MREAD
 	LD	(TEMP2),HL
 	LD	(TEMP0),DE
 	LD	B,H
 	LD	C,L
 	POP	HL
 	RET	C
 	SBC	HL,BC
 	LD	(TEMP3),HL
 	LD	DE,CPLP1
 	LD	BC,CPLP2
 	JP	DRVCOMM
 CPLP1	LD	A,(DRIV)
 	LD	(DDRIVE),A
 	CALL	DRVSAME
 	CALL	Z,DMOUNT
 	LD	HL,(TEMP3)
 	LD	DE,(TEMP1)
 	LD	BC,BUFFER
 	CALL	DSTAT
 	RET	NZ
 	JR	C,REMDRIVE
 	CALL	MWRITE
 	JR	NC,CPYVER
 REMDRIVE	LD	A,(DRIV)
 	LD	HL,DRVTBL
 	ADD	A,L
 	LD	L,A
 	LD	(HL),0
 	RET
 CPYVER	LD	HL,(TEMP3)
 	LD	DE,(TEMP1)
 CPYVER1	PUSH	HL
 	LD	BC,DAMBUFF
 	CALL	SHOVERIFY
 	POP	HL
 	JR	C,REMDRIVE
 	CALL	NEXSEC
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,CPYVER1
 	RET
 CPLP2	LD	HL,(TEMP2)
 	LD	A,H
 	OR	L
 	JP	NZ,SCOPYLP
 	RET
 NOTDIRECT	CALL	DISPLY
 	DB	10,'Cannot Locate Directory.',0
 	JP	TERMINATE
 ;DISK/ASM
 READ	LD	HL,READ1	;where to go
 	JR	READWRT		;go common routine
 WRITE	LD	HL,WRITE1
 READWRT	LD	(RWRTCALL),HL	;put into code
 	LD	(RWRTCALL2),HL	;here too
 	PUSH	BC		;save load address
 	CALL	SELDEN		;select density chip
 	CALL	0		;call read/write
 RWRTCALL	EQU	$-2
 	POP	HL		;get load address
 	RET	Z		;return if OK
 	LD	B,H		;restore load address
 	LD	C,L
 	PUSH	BC
 	CALL	0
 RWRTCALL2	EQU	$-2
 	POP	HL
 	RET	Z
 	LD	B,H
 	LD	C,L
 	RET
 READ1	CALL	SEEK		;move the head to track
 	RET	NZ		;bad
 READ1S	CALL	SELECT
 	RET	NZ
 	LD	HL,37ECH
 	DI
 	LD	(HL),88H	;give read command to FDC
 RDTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;data transfer address
 	CALL	RXFER		;transfer the data
 	POP	DE		;restore track/sector
 	PUSH	AF		;save result
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	3
 	OR	0A0H		;make it a write command
 	LD	L,A		;save it here
 	LD	A,(RDTYPE)	;get type of read
 	AND	8		;IBM or not?
 	OR	L		;now have a write command
 	LD	(WRTYPE),A	;that will produce the
 	EX	AF,AF'		;same as this read.
 	POP	AF		;put write byte in af'
 	AND	9CH		;check for error
 IOCOMM	PUSH	AF		;save it
 	LD	A,(37EDH)	;get FDC track
 	SCF			;carry = put in table
 	CALL	GETTRK		;save current track
 	POP	AF		;restore result
 	RET			;done
 WRITE1	CALL	SEEK		;move head
 	RET	NZ		;error occured
 WRITE1S	CALL	SELECT
 	RET	NZ
 	LD	HL,37ECH
 	DI
 	LD	(HL),0A8H
 WRTYPE	EQU	$-1
 	PUSH	DE
 	LD	DE,37EFH
 	CALL	WXFER		;write data to the disk
 	POP	DE
 	AND	0FCH		;error test
 	JR	IOCOMM		;put track in table
 SEEK	CALL	SELECT		;turn on drive
 	LD	HL,37ECH	;point to FDC
 	RET	NZ		;not ready
 	OR	A		;clear carry
 	CALL	GETTRK		;get track from table
 	JR	NZ,SEKCNT	;continue if not
 	CALL	RESTORE		;restore disk drive
 	RET	NZ		;not in system
 	XOR	A		;set track 0
 SEKCNT	LD	(37EEH),DE	;select track/sector
 	LD	(37EDH),A	;give to track register
 	CP	D		;same as request?
 	RET	Z		;return if yes
 	JP	DOSEEK		;seek the track
 SELECT	LD	A,(37ECH)	;read drive status
 	BIT	7,A		;motor on?
 	LD	A,0		;get drive bit pattern
 DRIVE	EQU	$-1
 	LD	(37E1H),A	;give to FDC
 	RET	Z		;return if motor on
 	PUSH	BC		;don't touch this
 	LD	BC,0
 	CALL	60H		;countdown till BC=0
 	POP	BC
 	LD	A,(37ECH)	;read status again
 	BIT	7,A		;bit 7 = ready if 0
 	RET			;return ready condition
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL		;FDC to deliver a
 	EX	(SP),HL		;valid status byte
 	EX	(SP),HL
 	RET
 GETTRK	PUSH	HL		;save all registers
 	LD	HL,TRACK
 	JR	GETCOMM
 GETTYPE	PUSH	HL
 	LD	HL,TYPES
 GETCOMM	PUSH	AF		;save carry flag
 	LD	A,0		;get binary drive
 DRIV	EQU	$-1
 	ADD	A,L		;point to right byte
 	LD	L,A
 	POP	AF		;restore it
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get it out
 PUTIN	LD	(HL),A		;put it right back
 	POP	HL		;stack is restored
 	OR	A		;set new flags
 	RET
 RESTORE	LD	A,8		;fast restore command
 MOVCOMM	LD	(SAVMOV),A	;save for later mask
 	LD	HL,37ECH	;point to FDC
 	CALL	SELECT		;turn on drive
 	RET	NZ		;back in error
 	OR	A		;clear carry
 	CALL	GETTYPE		;get drive type
 	AND	3		;set step speed
 	OR	0		;or with command mask
 SAVMOV	EQU	$-1
 	CALL	MOVEHEAD	;move the head to track
 	RET	NZ		;seek error
 	LD	A,(37EDH)	;get current track
 	SCF			;for put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET
 MOVEHEAD	LD	(HL),A	;command to FDC
 MOVWT	CALL	SELECT		;prevent time-out
 	RET	NZ		;quit if drops ready
 	BIT	0,(HL)		;command done ?
 	JR	NZ,MOVWT	;wait some more
 	RET			;done
 STEPIN	LD	A,58H		;fast step-in command
 	JR	MOVCOMM
 STEPOUT	LD	A,78H		;fast step-out command
 	JR	MOVCOMM
 DOSEEK	LD	A,18H		;fast seek command
 	JR	MOVCOMM
 SETDRV	LD	(DRIV),A	;a = binary drive #
 	PUSH	BC		;save this
 	LD	C,1		;start with bit 0
 SETDLP	OR	A		;binary 0?
 	JR	Z,SETDDN	;have bit if yes
 	SLA	C		;move drive bit left
 	DEC	A		;binary -1
 	JR	SETDLP+1	;zero now?
 SETDDN	LD	A,C		;get bit pattern
 	LD	(DRIVE),A	;save for select
 	POP	BC		;restore it
 DRVASC	LD	A,(DRIV)	;get binary drive
 	ADD	A,30H		;make it ascii
 	RET			;that's all
 ;STAT/ASM
 HEXCV	LD	B,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	C,A
 	LD	A,B
 	AND	0FH
 	CALL	HEXTST
 	LD	B,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 SHOWST	BIT	7,A
 	JR	Z,BIT6
 	CALL	DISPLY
 	DB	10,'Drive NOT READY !',10,0
 BIT6	JR	C,BIT4
 	BIT	6,A
 	JR	Z,BIT5
 	CALL	DISPLY
 	DB	10,'Diskette WRITE PROTECTED !',10,0
 BIT5	BIT	5,A
 	JR	Z,BIT4
 	CALL	DISPLY
 	DB	10,'Write Fault FROM DRIVE !',10,0
 BIT4	BIT	4,A
 	JR	Z,BIT3
 	CALL	DISPLY
 	DB	10,'Track or Sector NOT FOUND !',10,0
 BIT3	BIT	3,A
 	JR	Z,BIT2
 	BIT	4,A
 	JR	Z,DATERR
 	CALL	DISPLY
 	DB	10,'ERROR in ID FIELD !',10,0
 	JR	BIT2
 DATERR	CALL	DISPLY
 	DB	10,'ERROR in DATA FIELD !',10,0
 BIT2	BIT	2,A
 	RET	Z
 	CALL	DISPLY
 	DB	10,'DATA LOST during Disk I/O !',10,0
 	RET
 SHOWWH	PUSH	AF
 	PUSH	BC
 	CALL	DRVASC
 	LD	(WHDR),A
 	LD	A,E
 	CALL	ASCII
 	LD	(WHSC),A
 	LD	(WHSC+1),BC
 	LD	A,D
 	CALL	ASCII
 	LD	(WHTR),A
 	LD	(WHTR+1),BC
 	CALL	DISPLY
 	DB	'Drive '
 WHDR	DB	'x, Track '
 WHTR	DB	'xxx, Sector '
 WHSC	DB	'xxx.',0
 	POP	BC
 	POP	AF
 	RET
 BADRD	NOP			;can force return here
 	CALL	DISPLY
 	DB	10,10,'Disk READ ERROR !',10,0
 	SCF
 	JR	RWCNT1
 BADWRT	NOP
 	CALL	DISPLY
 	DB	10,10,'Disk WRITE ERROR !',10,0
 	OR	A
 RWCNT1	PUSH	AF
 	CALL	SHOWWH
 	POP	AF
 	CALL	SHOWST		;error message
 	LD	A,(3840H)	;check for clear key
 	AND	2
 	JR	Z,RWCNT
 	XOR	A
 	LD	(BWRTCPT),A
 	LD	(NONSTP),A
 RWCNT	OR	1
 BWRTCPT	NOP
 NONSTP	NOP
 RETRY	CALL	DISPLY
 	DB	1EH,'R>etry, S>kip, C>ontinuous, N>onstop, Q>uit ? ',0
 	PUSH	BC
 	LD	B,1
 	PUSH	HL
 	CALL	GETSTR
 	POP	HL
 	POP	BC
 	JR	NZ,RETRY1
 	LD	A,'R'		;default retry
 RETRY1	CALL	UCASE
 	CP	'S'
 	JR	Z,DOSKIP
 	CP	'R'
 	JR	Z,DORETRY
 	CP	'N'
 	JR	Z,NOSPT
 	CP	'Q'
 	JR	Z,DOQUIT
 	CP	'C'
 	JR	NZ,RETRY
 	LD	A,0C9H		;return opcode
 	LD	(BWRTCPT),A
 DORETRY	OR	1		;set nz
 	CALL	DISPLY
 	DB	10,0
 	RET
 DOQUIT	XOR	A
 	SCF
 	JR	DORETRY+2
 NOSPT	LD	A,0C9H
 	LD	(NONSTP),A
 	JR	DORETRY
 DOSKIP	INC	B		;bump buffer pointer
 	XOR	A		;set Z flag
 	JR	DORETRY+2
 INITBAD	XOR	A
 	LD	(BWRTCPT),A
 	RET
 INITBAD1	XOR	A
 	LD	(NONSTP),A
 INITBAD3	LD	(BADRD),A	;allow prompting
 	LD	(BADWRT),A
 	RET
 INITBAD2	LD	A,0C9H	;return instruction
 	JR	INITBAD3	;turn off prompting
 CKCONF	LD	B,0
 	CALL	UCASE
 	CP	'S'
 	RET	Z
 	LD	B,20H
 	CP	'D'
 	RET
 ;NEXSEC/ASM
 NEXSEC	CALL	TRKEND
 	INC	E
 	CP	E
 	JR	NC,NEXTUI
 	INC	D
 	LD	E,0
 NEXTUI	LD	A,(TRACKS)
 	CP	D
 	RET	C
 	SCF
 	RET	Z
 	CCF
 	RET
 RETSEC	LD	A,E
 	OR	A
 	JR	Z,DOWNSEC
 	DEC	E
 	RET
 DOWNSEC	LD	A,D
 	OR	A
 	RET	Z
 	DEC	D
 	CALL	TRKEND
 	LD	E,A
 	RET
 TRKEND	CALL	SETDEND
 	OR	A
 	CALL	GETTYPE
 	BIT	5,A
 	JR	Z,TKDNE
 	LD	A,17
 	JR	TKEND
 TKDNE	LD	A,9
 TKEND	LD	(BAKA),A
 	POP	AF
 	CALL	GETTYPE
 	LD	A,0
 BAKA	EQU	$-1
 	RET
 ASCII	PUSH	HL
 	CALL	ASCI
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI
 	LD	A,C
 	CP	'0'
 	JR	NZ,ASCIGO1
 	LD	A,20H
 ASCIGO1	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET
 ASCI	LD	C,'0'
 ASCII1	SUB	10
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 POSHL	LD	A,(HL)
 	INC	HL
 	CP	13
 	SCF
 	RET	Z
 	CP	20H
 	JR	Z,POSHL
 	CP	','
 	JR	Z,POSHL
 	OR	A
 	DEC	HL
 	RET
 MOUNTSYS	CALL	DISPLY
 	DB	10,'Mount SYSTEM',0
 MOCOMM	CALL	DRVASC
 	LD	(WDVV),A
 	CALL	DISPLY
 	DB	' Disk on Drive '
 WDVV	DB	'x. ',0
 ONEKEY	PUSH	HL
 	PUSH	BC
 	LD	B,1
 	CALL	GETSTR
 	POP	BC
 	POP	HL
 	CALL	DISPLY
 	DB	1EH,0
 	RET
 MOUNTSRC	CALL	DISPLY
 	DB	10,'Mount SOURCE',0
 	JR	MOCOMM
 MOUNTDES	CALL	DISPLY
 	DB	10,'Mount DESTINATION',0
 	JR	MOCOMM
 DRVCOMM	XOR	A
 	LD	(POSA),A
 	LD	(RETN1),DE
 	LD	(RETN2),BC
 DRVLP	LD	A,0
 POSA	EQU	$-1
 	CALL	SETDRV
 	PUSH	HL
 	LD	HL,DRVTBL
 	SUB	30H
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	DEC	A
 	POP	HL
 	CALL	Z,0
 RETN1	EQU	$-2
 	LD	A,(POSA)
 	INC	A
 	LD	(POSA),A
 	CP	4
 	JR	C,DRVLP
 	JP	0
 RETN2	EQU	$-2
 INITDRV	LD	HL,0
 	LD	(DRVTBL),HL
 	LD	(DRVTBL+2),HL
 	RET
 DSTAT	XOR	A
 	JR	STAT+2
 STAT	LD	A,0C9H
 	LD	(HFLG),A
 	CALL	DRVASC
 	LD	(E0),A
 	LD	(E5),A
 	LD	(E9),A
 	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET
 	PUSH	HL
 STAT2	CALL	SELECT
 	LD	HL,ERMSG5
 	JR	NZ,HOLDER
 	LD	BC,0CDH
 	LD	HL,ERMSG0
 TT1	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER
 	LD	A,(37ECH)
 	AND	2
 	JR	NZ,TT1
 	LD	BC,19A8H
 	LD	HL,ERMSG9
 TT2	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER
 	LD	A,(37ECH)
 	AND	2
 	JR	Z,TT2
 	LD	BC,0BAH
 	LD	HL,ERMSG0
 TT3	DEC	BC
 	LD	A,B
 	OR	C
 	JR	Z,HOLDER
 	LD	A,(37ECH)
 	AND	2
 	JR	NZ,TT3
 	XOR	A
 	RET
 HOLDER	OR	1
 	LD	(TEMP3),HL
 HFLG	NOP
 	PUSH	HL
 	CALL	DISPLY
 	DB	1CH,1FH,0
 	JP	DISPLY
 HOLDIN	NOP
 	CALL	DISPLY
 	DB	10,'<ENTER> when ready, or <S>kip this drive. ',0
 	CALL	ONEKEY
 	CALL	DISPLY
 	DB	1EH,11,1EH,11,0
 	CALL	UCASE
 	CP	'S'
 	JP	NZ,STAT2
 	OR	1
 	RET
 ERMSG5	DB	10,'Drive '
 E5	DB	'x NOT READY !',0
 	JR	HOLDIN
 ERMSG9	DB	10,'DOOR NOT CLOSED on Drive '
 E9	DB	'x !',0
 	JR	HOLDIN
 ERMSG0	DB	10,'NO DISKETTE in Drive '
 E0	DB	'x !',0
 	JP	HOLDIN
 SELDEN	OR	A
 	CALL	GETTYPE
 	BIT	5,A
 	LD	A,0FEH
 	JR	Z,SELDENOK
 	INC	A
 SELDENOK	EX	AF,AF'
 	LD	A,(37EDH)
 	EX	AF,AF'
 	LD	(37ECH),A
 	LD	A,0D0H
 	LD	(37ECH),A
 	EX	AF,AF'
 	LD	(37EDH),A
 	RET
 RXFER	CALL	DSKSLO
 RX0	LD	A,(HL)
 	AND	3
 	JP	PO,RX0
 RX1	LD	A,(DE)
 	LD	(BC),A
 	INC	BC
 RX2	BIT	1,(HL)
 	JR	NZ,RX1
 	BIT	1,(HL)
 	JR	NZ,RX1
 	BIT	1,(HL)
 	JR	NZ,RX1
 	BIT	0,(HL)
 	JR	NZ,RX2
 XFERET	LD	A,(HL)
 	LD	(HL),0D0H
 	LD	(RESULT),A
 	EI
 	RET
 XFERETB	LD	A,20H
 	JR	XFERET+1
 WXFER	CALL	DSKSLO
 	LD	A,(BC)
 WX1	BIT	0,(HL)
 	JR	Z,XFERETB
 	BIT	1,(HL)
 	JR	Z,WX1
 	LD	(DE),A
 	INC	BC
 	LD	A,(BC)
 WX2	BIT	1,(HL)
 	JP	Z,WX2
 WX3	LD	(DE),A
 	INC	BC
 	LD	A,(BC)
 WX4	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	0,(HL)
 	JR	NZ,WX4
 WX5	JR	XFERET
 UCASE	CP	60H
 	RET	C
 	AND	5FH
 	RET
 FIGDRV	XOR	A
 	EX	AF,AF'
 	LD	A,(HL)
 	SUB	30H
 	JR	C,CKDATD
 	CP	4
 	JR	NC,CKDATD
 	CALL	SETDRV
 	INC	HL
 	OR	1
 	EX	AF,AF'
 CKDATD	EX	AF,AF'
 	JR	NZ,CKDATJJ
 	EX	AF,AF'
 	XOR	A
 	CALL	SETDRV
 	EX	AF,AF'
 CKDATJJ	EX	AF,AF'
 	LD	A,(HL)
 	CALL	UCASE
 	CALL	CKCONF
 	JR	NZ,CKDATED
 	CALL	DENSELSET
 	INC	HL
 	OR	1
 	EX	AF,AF'
 CKDATED	RET	Z
 	EX	AF,AF'
 	SCF
 	CCF
 	RET	NZ
 	SCF
 	RET
 DENSELSET	OR	A
 	CALL	GETTYPE
 	AND	0C3H
 	OR	B
 	SCF
 	JP	GETTYPE
 GET	POP	BC
 	POP	DE
 	POP	HL
 	OR	A
 	RET
 ;ONEDRIVE/ASM
 ONEDRIVE	CALL	DISPLY
 	DB	10,0
 ONEDRI	CALL	DISPLY
 	DB	1EH,'Source Data Disk Drive ? ',0
 	XOR	A
 	CALL	SETDRV
 	LD	B,20
 	CALL	GETSTR		;get input
 	RET	Z		;default zero
 	CALL	POSHL		;anything?
 	RET	C
 	CALL	FIGDRV		;set it up
 	JR	C,ONEDRI	;continue if bad input
 	RET			;else return
 ;GETDRV/ASM
 GETDRIVES	CALL	DISPLY
 	DB	10,0
 	CALL	INITDRV
 GETDVB	CALL	DISPLY
 	DB	1EH,'Destination Data Disk Drive(s) ? ',0
 	LD	B,30
 	CALL	GETSTR
 	JR	Z,GETDVH
 	CALL	POSHL
 	JR	C,GETDVH
 GETDLP	CALL	POSHL
 	RET	C
 	CALL	FIGDRV
 	JR	C,GETDVB
 	PUSH	HL
 	LD	HL,DRVTBL
 	LD	A,(DRIV)
 	ADD	A,L
 	LD	L,A
 	LD	(HL),1
 	POP	HL
 	JR	GETDLP
 GETDVH	LD	A,1
 	LD	(DRVTBL),A
 	RET
 DBUFFF	EQU	$&0FF00H
 DAMBUFF	EQU	DBUFFF+100H
 BUFFER	EQU	DAMBUFF+100H
 	END	ENTRY
TBL
 	LD	A,(DRIV)
 	ADD	A,L
 	LD	L,A
 	LD	(HL),1
 	P