1 'DISASSEMBLER FOR Z-80 MACHINE CODE
2 'Modified from a program by Carl Wuebker
3 'Published in Aug 1981 Issue of 80 Microcomputing
4 'Modifications by Roy Beck, 1986
10 CLEAR 3000'Clear string space
20 GOSUB 2200'Read in data statements
30 HX$="0123456789ABCDEF"
40 L=0'Set L= to starting location in memory, decimal value
50 P=0'Set P= to one less than next page number to be printed
60 INPUT"Type S for output to screen or L for output to Printer,  followed by comma and N for non-stop operation or S for stop after current page. (Use upper case)";P$,S$
70 IFP$="L"THENGOSUB100 ELSEGOSUB200
80 IFS$="S"THEN60ELSE70
90 END
100 P=P+1'Print a disassembled page.
110 FORN=1TO58
120 GOSUB1000
130 LPRINTL$
140 NEXTN
150 LPRINT" "
160 LPRINTTAB(24);"-";P;"-"
165 LPRINT STRING$(5,10)
170 RETURN
200 FORN=1TO7'Display a disassembled screen, change 7 to appropriate number of lines for your screen
210 GOSUB1000
220 PRINTL$
230 NEXTN
240 RETURN
1000 I0=PEEK(L)'Main disassembly code begins here
1010 IFI0=203THEN1200
1020 IFI0=237THEN1300
1030 IFI0=221THEN1500
1040 IFI0=253THEN1520
1050 I1=PEEK(L+1):I2=PEEK(L+2)
1060 GOSUB2000'Reads instruction text from data array and formats it
1070 RN$="HL":RS$="(HL)"
1080 GOSUB1800
1090 GOSUB4000'Formats address, ASCII and hex interpretations
1100 L$=L$+M$
1110 RETURN
1200 I0=PEEK(L+1)+256
1210 GOSUB2000
1220 IFM$="???"THEN1090
1230 DL=2
1240 RN$="HL":RS$="(HL)"
1250 GOSUB1800
1260 GOSUB4000
1270 L$=L$+M$
1280 RETURN
1300 I0=PEEK(L+1)
1310 IFI0<64 OR(I0>127ANDI0<160)ORI0>191THENI0=191
1320 IFI0<128THENI0=I0+448ELSEI0=I0+416
1330 I1=PEEK(L+2):I2=PEEK(L+3)
1340 GOSUB2000
1350 IFM$="???"THEN1390
1360 DL=DL+1
1370 RN$="HL":RS$="(HL)"
1380 GOSUB1800
1390 GOSUB4000
1400 L$=L$+M$
1410 RETURN
1500 RN$="IX"
1510 GOTO1530
1520 RN$="IY"
1530 C=PEEK(L+2)
1540 GOSUB5000
1550 RS$="("+RN$+"+$"+C$+")"
1560 IFPEEK(L+1)=203THEN1660
1570 I0=PEEK(L+1):I1=PEEK(L+2):I2=PEEK(L+3)
1580 IFI0=54THENI1=PEEK(L+3):I2=0
1590 GOSUB 2000
1600 FM=0:FS=0
1610 IFM$<>"???"THENGOSUB1800
1620 DL=DL+(FMORFS)+FS
1630 GOSUB4000
1640 L$=L$+M$
1650 RETURN
1660 I0=PEEK(L+3)+256
1670 GOSUB2000
1680 FM=0:FS=0
1690 IFM$<>"???"THENGOSUB1800
1700 DL=DL+3*FS
1710 GOSUB4000
1720 L$=L$+M$
1730 RETURN
1800 FM=0:FS=0:I=5'Replaces # or * in opcode string from data array
1810 I=I+1:IFI>LEN(M$)THENRETURN
1820 R$=MID$(M$,I,1):IFR$<>"#"ANDR$<>"*"THEN1810
1830 IFR$="*"THEN1880
1840 FM=1
1850 M$=LEFT$(M$,I-1)+RN$+RIGHT$(M$,LEN(M$)-I)
1860 I=I+LEN(RN$)
1870 GOTO1810
1880 FS=1
1890 M$=LEFT$(M$,I-1)+RS$+RIGHT$(M$,LEN(M$)-I)
1900 RETURN
2000 IN$=OPC$(I0)'Selects string from data array corresponding to first byte of opcode
2005 T=ASC(IN$)-ASC("0")
2010 IFT<1ORT>9THENT=0ELSEIN$=RIGHT$(IN$,LEN(IN$)-1)
2015 FORI=1TOLEN(IN$)
2020 IFMID$(IN$,I,1)=" "THEN2045
2025 NEXTI
2030 I0$=IN$+STRING$(5-LEN(IN$)," ")
2035 I1$=""
2040 GOTO2055
2045 I0$=LEFT$(IN$,I)+STRING$(5-I," ")
2050 I1$=RIGHT$(IN$,LEN(IN$)-I)
2055 ONT+1GOTO3000,3100,3200,3300,3400,3500,3600,3700,3800,3900
2200 DIMOPC$(607),FLD$(7)'Reads in data statements to appropriate array locations
2205 RESTORE
2210 FORI=0TO7:READFLD$(I):NEXTI
2215 I=0
2220 READOPC$(I)
2225 IFLEFT$(OPC$(I),1)<>"1"THEN2240
2230 FORJ=1TO7:OPC$(I+J)=OPC$(I):NEXTJ
2235 I=I+7
2240 I=I+1:IFI<=607THEN2220
2250 RETURN
2300 DATA"B","C","D","E","H","L","*","A"
2400 DATA"NOP","3LD BC","LD (BC),A","INC BC","INC B"
2405 DATA"DEC B","2LD B","RLCA","EX AF,AF'","ADD #,BC"
2410 DATA"LD A,(BC)","DEC BC","INC C","DEC C","2LD C"
2415 DATA"RRCA","4DJNZ B","3LD DE","LD (DE),A","INC DE"
2420 DATA"INC D","DEC D","2LD D","RLA","4JR","ADD #,DE"
2425 DATA"LD A,(DE)","DEC DE","INC E","DEC E","2LD E"
2430 DATA"RRA","4JR NZ","3LD #","8LD #","INC #"
2435 DATA"INC H","DEC H","2LD H","DAA","4JR Z","ADD #,#"
2440 DATA"6LD #","DEC #","INC L","DEC L","2LD L","CPL"
2445 DATA"4JR NC","3LD SP","8LD A","INC SP","INC *"
2450 DATA"DEC *","2LD *","SCF","4JR C","ADD #,SP"
2455 DATA"6LD A","DEC SP","INC A","DEC A","2LD A","CCF"
2460 DATA"1LD B","1LD C","1LD D","1LD E","1LD H","1LD L"
2465 DATA"1LD *","1LD A","1ADD A","1ADC A","1SUB A"
2470 DATA"1SBC A","1AND","1XOR","1OR","1CP"
2475 DATA"RET NZ","POP BC","3JP NZ","3JP","3CALL NZ"
2480 DATA"PUSH BC","2ADD A","RST 0","RET Z","RET"
2485 DATA"3JP Z","9","3CALL Z","3CALL","2ADC A"
2490 DATA"RST $8","RET NC","POP DE","3JP NC"
2495 DATA"7OUT A","3CALL NC","PUSH DE","2SUB A"
2500 DATA"RST $10","RET C","EXX","3JP C","5IN A"
2505 DATA"3CALL C","9","2SBC A","RST $18"
2510 DATA"RET PO","POP #","3JP PO","EX (SP),#"
2515 DATA"3CALL PO","PUSH #","2AND","RST $20"
2520 DATA"RET PE","JP (#)","3JP PE","EX DE,HL"
2525 DATA"3CALL PE","9","2XOR","RST $28"
2530 DATA"RET P","POP AF","3JP P","DI","3CALL P"
2535 DATA"PUSH AF","2OR","RST $30","RET M"
2540 DATA"LD SP,#","3JP M","EI","3CALL M"
2545 DATA"9","2CP","RST $38"
2600 'CBXX Extended Z-80 instructions
2605 DATA"1RLC","1RRC","1RL","1RR"
2610 DATA"1SLA","1SRA","9","9","9","9","9","9","9","9","1SRL"
2615 DATA"1BIT 0","1BIT 1","1BIT 2","1BIT 3"
2620 DATA"1BIT 4","1BIT 5","1BIT 6","1BIT 7"
2625 DATA"1RES 0","1 RES 1","1RES 2","1RES 3"
2630 DATA"1RES 4","1RES 5","1RES 6","1RES 7"
2635 DATA"1SET 0","1SET 1","1SET 2","1SET 3"
2640 DATA"1SET 4","1SET 5","1SET 6","1SET 7"
2700 'ED40-ED7F extended Z-80 instructions
2705 DATA"IN B,(C)","OUT (C),B","SBC HL,BC"
2710 DATA"8LD BC","NEG","RETN","IM 0","LD I,A"
2715 DATA"IN C,(C)","OUT (C),C","ADC HL,BC"
2720 DATA"6LD BC","9","RETI","9","LD R,A"
2725 DATA"IN D,(C)","OUT (C),D","SBC HL,DE"
2730 DATA"8LD DE","9","9","IM 1","LD A,I"
2735 DATA"IN E,(C)","OUT (C),E","ADC HL,DE"
2740 DATA"6LD DE","9","9","IM 2","LD A,R"
2745 DATA"IN H,(C)","OUT (C),H","SBC HL,HL"
2750 DATA"8LD HL","9","9","9","RRD"
2755 DATA"IN L,(C)","OUT (C),L","ADC HL,HL"
2760 DATA"6LD HL","9","9","9","RLD"
2765 DATA"9","9","SBC HL,SP","8LD SP"
2770 DATA"9","9","9","9","IN A,(C)","OUT (C),A"
2775 DATA"ADC HL,SP","6LD SP","9","9","9","9"
2800 'EDA0-EDBF extended Z-80 instructions
2805 DATA"LDI","CPI","INI","OUTI","9","9","9","9"
2810 DATA"LDD","CPD","IND","OUTD","9","9","9","9"
2815 DATA"LDIR","CPIR","INIR","OTIR","9","9","9","9"
2820 DATA"LDDR","CPDR","INDR","OTDR","9","9","9","9"
3000 DL=1'Handles special cases prefixed in data array with numerals 1-9
3010 M$=I0$+I1$
3020 RETURN
3100 DL=1
3110 IFLEN(I1$)<>0THENI1$=I1$+","
3120 M$=I0$+I1$+FLD$(I0 AND7)
3130 IFI0=118THENM$="HALT"
3140 RETURN
3200 DL=2
3210 IFLEN(I1$)<>0THENI1$=I1$+","
3220 C=I1
3230 GOSUB5000
3240 M$=I0$+I1$+"$"+C$
3250 RETURN
3300 DL=3
3310 IFLEN(I1$)<>0THENI1$=I1$+","
3320 C=256*I2+I1
3330 GOSUB5020
3340 M$=I0$+I1$+"$"+C$
3350 RETURN
3400 DL=2
3410 IFLEN(I1$)<>0THENI1$=I1$+","
3420 IFI1<128THENC=L+2+I1ELSEC=L+2+I1-256
3430 GOSUB5020
3440 M$=I0$+I1$+"$"+C$
3450 RETURN
3500 DL=2
3510 C=I1
3520 GOSUB5000
3530 GOTO3630
3600 DL=3
3610 C=256*I2+I1
3620 GOSUB5020
3630 IFLEN(I1$)<>0THENI1$=I1$+","
3640 M$=I0$+I1$+"($"+C$+")"
3650 RETURN
3700 DL=2
3710 C=I1
3720 GOSUB5000
3730 GOTO3830
3800 DL=3
3810 C=256*I2+I1
3820 GOSUB5020
3830 IFLEN(I1$)<>0THENI1$=","+I1$
3840 M$=I0$+"($"+C$+")"+I1$
3850 RETURN
3900 DL=1
3910 M$="???"
3920 RETURN
4000 C=L'Formats line of text
4010 GOSUB5020
4020 L$=C$+"  "
4025 D$=""
4030 FORLT=LTOL+DL-1
4040 CT=(PEEK(LT)AND127)
4050 IFCT<32ORCT>126THENCT=46
4060 L$=L$+CHR$(CT)
4070 C=PEEK(LT)
4080 GOSUB5000
4090 D$=D$+C$+" "
4100 NEXTLT
4110 L$=L$+STRING$(6-DL," ")+D$+STRING$(3*(5-DL)," ")+" "
4120 L=L+DL
4130 RETURN
5000 C$=MID$(HX$,INT(C/16)+1,1)+MID$(HX$,(C AND15)+1,1)'Converts C into one-byte hex c$
5010 RETURN
5020 CT=INT(C/256)'Converts C into a two-byte C$
5030 C$=MID$(HX$,INT(CT/16)+1,1)+MID$(HX$,(CT AND15)+1,1)
5040 CT=C-256*CT
5050 C$=C$+MID$(HX$,INT(CT/16)+1,1)+MID$(HX$,(CT AND15)+1,1)
5060 RETURN
