EDBEEP ; #######################################################
 ; ADDING DEBOUNCE/BEEP/AUTOREPEAT TO EDITOR/ASSEMBLER 1.1
 ; #######################################################
 ; NEW EDTASM SCAN PATCH WILL USE ROM ROUTINE IN ITS PLACE
 ; #######################################################
 ;
 	ORG	4016H		; KEYBOARD PATCH POINT
 	DEFB	068H		; LSB OF NEW START
 	DEFB	05DH		; MSB OF NEW START
 	ORG	5D68H		; NEW PARTIAL KBD DRIVER
 	LD	HL,4016H	; FORMER KBD PATCH POINT
 	LD	(HL),0E3H	; LSB OF ADDRESS IN ROM
 	INC	HL		; GET NEXT POSITION READY
 	LD	(HL),03H	; MSB OF ADDRESS IN ROM
 	JP	468AH		; JUMP TO EDTASM PROGRAM
 ;
 ; #######################################################
 ; NEW KEYBOARD SCAN IS PLACED AT FORMER SOURCE CODE START
 ; #######################################################
 ;
 	ORG	5D00H		; NEW BLOCK OF CODE
 	LD	HL,4021H	; GET REPEAT STORAGE BYTE
 	LD	BC,3801H	; GET FIRST ROW OF KEYBRD
 	LD	D,0		; ROW COUNTER REGISTER
 LOOPX	LD	A,(BC)		; FIND KEY PRESSED IN ROW
 	LD	E,A		; SAVE VALUE IN E REG.
 	AND	E		; TEST FOR PRESSED KEY
 	JR	NZ,FOUND	; JUMP OUT IF KEY PRESSED
 	LD	(HL),A		; SAVE CURRENT KEY IN HL
 REDOIT	INC	D		; INCREMENT ROW COUNTER
 	INC	L		; INCREMENT KEY STORAGE
 	RLC	C		; GET NEXT ROW INTO BC
 	LD	A,C		; GET VALUE OF C FOR TEST
 	SUB	80H		; 80H IS SHIFT KEY ROW
 	JR	NZ,LOOPX	; LOOP BACK IF NOT SHIFT
 	LD	B,7		; NUMBER OF BUMPS TO DO
 LOOPY	DEC	L		; DECREMENT BYTE STORAGE
 	ADD	A,(HL)		; ADD TOTAL VALUE STORED
 	DJNZ	LOOPY		; LOOP BACK FOR 7 TIMES
 	CP	0		; WERE NO KEYS PRESSED?
 	LD	A,0		; CLEAR ACC., NOT FLAGS
 	RET	NZ		; BACK TO MAIN ROUTINE
 	LD	(401AH),A	; SAVE VALUE IF ZERO
 	RET			; BACK TO MAIN ROUTINE
 FOUND	AND	(HL)		; TEST IF SAME CHARACTER
 	JR	Z,SAME 		; IF SAME, JUMP OUT ...
 	LD	A,(401AH)	; GET COUNTER BYTE INTO A
 	INC	A		; INCREMENT IT EACH TIME
 	LD	(401AH),A	; SAVE IT AGAIN FOR NEXT
 	CP	0FFH		; IS IT PAST FULL DELAY?
 	JR	NZ,REDOIT	; IF NOT GO BACK FOR MORE
 	DEC	A		; DEC A TO 0FE FOR REPEAT
 	LD	(401AH),A	; SAVE THAT VALUE IN CNTR
 	LD	A,E		; GET ORIGINAL CHARACTER
 SAME	LD	(HL),E		; SAVE THAT VALUE IN HL
 	PUSH	BC		; SAVE ROW COUNTER
 	LD	BC,0200H	; GET DELAY VALUE READY
 	CALL	0060H		; CALL ROM DELAY SUBROUT.
 	POP	BC		; RESTORE ROW COUNTER
 	LD	A,(BC)		; GET VALUE AT ROW CNTR.
 	AND	E		; TEST IF STILL PRESSED
 	RET	Z		; IF NOT THEN IT'S BOUNCE
 	PUSH	BC		; SAVE ROW COUNTER AGAIN
 	PUSH	HL		; SAVE STORAGE AREA
 	PUSH	AF		; SAVE CURRENT KEYSTROKE
 	LD	B,40H		; GET DURATION VALUE
 	LD	A,(403DH)	; GET STATUS OF SCREEN
 	AND	0FDH		; CLEAR THE DATA OUTPUT
 	LD	H,A		; H BECOMES OUTPUT MASK
 	OR	02		; READY ACC. FOR BIT-SET
 	LD	L,A		; L BECOMES OUTPUT MASK
 SOUND	LD	A,L		; GET BIT-SET MASK 
 	OUT	(0FFH),A	; OUTPUT IT (WAVEFORM HI)
 	LD	A,H		; GET BIT-RESET MASK
 	OUT	(0FFH),A	; OUTPUT IT (WAVEFORM LO)
 	PUSH	BC		; SAVE DURATION VALUE
 	LD	B,40H		; GET PITCH VALUE
 	DJNZ	$		; DELAY FOR AUDIBLE TONE
 	POP	BC		; RESTORE BEEP DURATION
 	DJNZ	SOUND		; LOOP FOR FULL DURATION
 	POP	AF		; RESTORE KEYSTROKE VALUE
 	POP	HL		; RESTORE STORAGE VALUE
 	POP	BC		; RESTORE ROW COUNTER
 	JP	4407H		; JUMP INTO EDTASM...!
 ;
 ; #######################################################
 ; FOLLOWING PATCH NEW SOURCE CODE START & KEYBOARD SCAN
 ; #######################################################
 ;
 	ORG	468AH		; PLACE TO PATCH END
 	LD	HL,5E00H	; NEW END OF EDTASM
 	ORG	4710H		; PLACE TO PATCH END
 	LD	DE,5E00H	; NEW END OF EDTASM
 	ORG	4A07H		; PLACE TO PATCH END
 	LD	DE,5E00H	; NEW END OF EDTASM
 	ORG	4ADBH		; PLACE TO PATCH END
 	LD	HL,5E00H	; NEW END OF EDTASM
 	ORG	4B50H		; PLACE TO PATCH END
 	LD	HL,5E00H	; NEW END OF EDTASM
 	ORG	4D39H		; PLACE TO PLACE END
 	LD	HL,5E00H	; NEW END OF EDTASM
 	ORG	4D80H		; PLACE TO PATCH END
 	LD	HL,5E00H	; NEW END OF EDTASM
 	ORG	5227H		; PLACE TO PATCH END
 	LD	HL,5E00H	; NEW END OF EDTASM
 	ORG	43EFH		; PLACE TO PATCH KBD SCAN
 	JP	5D00H		; NEW KEYBOARD SCAN
 ;
 ; #######################################################
 	END	5D00H
