KBPFXF ; #######################################################
 ; DEBOUNCE, AUTO-REPEAT, AND BEEP KEYBOARD PATCH ROUTINE.
 ; THIS ROUTINE AS WRITTEN PATCHES INTO 4016.  TO USE
 ; OTHER DRIVERS SUCH AS LOWERCASE, GRAPHICS, ETC., THE
 ; RETURN ADDRESS (NORMALLY 03E3) MUST BE REPLACED BY THE
 ; ADDRESS OF THE OTHER DRIVER.  ALSO, TO USE THIS ROUTINE
 ; WITH THE CUSTOM INTERPRETER /ON AND /OUT COMMANDS BY
 ; PATCHING THIS DRIVER IN PLACE WITH /ON AND THE NORMAL
 ; (OR UPPER/LOWER, ETC.) DRIVER IN PLACE WITH /OUT.
 ; #######################################################
 ;
 	ORG	4016H		; KEYBOARD SCAN PATCH 
 	DEFW	ENTREE		; START OF DEBOUNCE ROUT.
 	ORG	3000H		; NOTE THAT THIS UTILITY
 				; IS CURRENTLY SET UP FOR
 				; USE WITH A MEMORY ADD'N
 				; AT 3000H.  IT CAN BE
 				; RE-ORGED AT ANY LOC'N.
 BASIC2	EQU	06CCH		; BASIC "READY" DISPLAY
 KEYHLD	EQU	4036H		; NORMAL KEYSTROKE STORE
 KEYBRD	EQU	3801H		; FIRST KEYBOARD ADDRESS
 HOLDER	EQU	401AH		; RESERVED BYTE FOR DELAY
 INKEYS	EQU	4099H		; INKEY$ STORAGE BYTE
 DELAYS	EQU	0060H		; ROM DELAY SUBROUTINE
 ;
 ; #######################################################
 ; ROUTINE BEGINS HERE, PATCHING ITSELF INTO PLACE AT 4016
 ; #######################################################
 ;
 ENTREE	PUSH 	HL		; SAVE HL IF TRANSPARENT
 	LD 	HL,START	; GET START OF ROUTINE
 	LD 	(4016H),HL	; PUT INTO KEYBOARD PATCH
 	POP 	HL		; RESTORE HL VALUE
 	JP 	BASIC2		; AND GO BACK TO "READY"
 ;
 ; #######################################################
 ; THIS AREA MAKES THE PRELIMINARY CHECK OF KEYBOARD ROWS
 ; #######################################################
 ;
 START	LD 	HL,KEYHLD	; SET UP STORAGE AREA
 	LD 	BC,KEYBRD	; SET UP FIRST KBD ROW
 	LD 	D,0		; SET UP COUNTER OF ROWS
 CHKKEY	LD 	A,(BC)		; FIND IF A KEY PRESSED
 	LD 	E,A		; SAVE VALUE IN E REG.
 	AND 	E		; TEST IF KEY WAS PRESSED
 	JR 	NZ,CKPREV	; IF YES, SEE IF SAME ONE
 	LD 	(HL),A		; SAVE VALUE IN STORAGE
 INCD	INC 	D		; INCREMENT ROW COUNTER
 	INC 	L		; INCREMENT STORAGE AREA
 	RLC 	C		; SHIFT TO NEXT KBD ROW
 	LD 	A,C		; GET VALUE OF KBD ROW
 	SUB 	80H		; CHECK IF SHIFT KEY ROW
 	JR 	NZ,CHKKEY	; IF NOT THEN CONTINUE
 ;
 ; #######################################################
 ; CHECKING IS DONE - NOW SEE IF PREVIOUS KEYS HELD DOWN
 ; #######################################################
 ;
 	LD 	B,7		; ELSE GET NUMBER OF ROWS
 DECL	DEC 	L		; MOVE BACK THRU STORAGE
 	ADD 	A,(HL)		; AND MAKE TOTAL OF KEYS
 	DJNZ 	DECL		; AND DO IT FOR ALL ROWS
 	AND 	A		; TEST IF ANY KEYS STORED
 	LD 	A,0		; A=0, FLAGS REMAIN SAME
 	RET 	NZ		; BACK IF KEY IN STORAGE
 	LD 	(HOLDER),A	; SAVE NEW VALUE IN CTR.
 	RET			; AND BACK TO MAIN ROUT.
 ;
 ; #######################################################
 ; NEXT TEST IS FOR STATUS OF INKEY$, IF IT IS IN USE
 ; #######################################################
 ;
 CKPREV	AND 	(HL)		; SEE IF VALUE IS SAME
 	JR 	Z,STORE		; STORE VALUE IF ZERO
 	LD 	A,(INKEYS)	; FIND VALUE AT INKEY$
 	AND 	A		; SEE IF SOMETHING THERE
 	JR 	NZ,INCD		; IF SO THEN GO AWAY
 	LD 	A,(HOLDER)	; GET DELAY COUNTER VALUE
 	INC 	A		; INCREMENT THE COUNTER
 	LD 	(HOLDER),A	; AND SAVE VALUE BACK
 	CP 	0FFH		; IS COUNTER AT END YET?
 	JR 	Z,DECA		; IF SO, THEN REPEAT
 ;
 ; #######################################################
 ; REPEATING-KEY TIME-WASTE VALUE (FF) MAY BE VARIED
 ; #######################################################
 ;
 	PUSH 	BC		; SAVE BC FOR LATER
 	LD 	B,0FFH		; GET DELAY VALUE
 TMWSTE	NOP			; WASTE SOME TIME
 	DJNZ 	TMWSTE		; AND DO IT FF TIMES
 	POP 	BC		; RESTORE BC VALUE
 	JR 	INCD		; AND GO BACK TO SCANNING
 DECA	DEC 	A		; MAKE A BECOME FE
 	LD 	(HOLDER),A	; AND SAVE IT IN DELAY
 	LD 	A,E		; GET KEYSTROKE FOUND
 STORE	LD 	(HL),E		; AND PUT IT IN STORAGE
 ;
 ; #######################################################
 ; DEBOUNCE BELOW MAY BE ELIMINATED BECAUSE BEEP USES TIME
 ; #######################################################
 ;
 	PUSH 	BC		; SAVE VALUE IN BC
 	LD 	BC,200H		; GET DEBOUNCE DELAY
 	CALL 	DELAYS		; AND CALL ROM DELAY
 	POP 	BC		; AND GET VALUE TO BC
 	LD 	A,(BC)		; GET VALUE AT KEYBOARD
 	AND 	E		; AND TEST IF IT'S THERE
 	RET 	Z		; IF NOT IT WAS BOUNCE
 ;
 ; #######################################################
 ; BEEP ROUTINE PRODUCES VERY SOFT (NOT ANNOYING) SOUND
 ; #######################################################
 ;
 	PUSH 	BC		; ELSE SAVE THE VALUE
 	PUSH 	HL		; AND SAVE THE LOCATION
 	PUSH 	AF		; AND SAVE THE KEYSTROKE
 	LD 	B,40H		; AND KEY BEEP DURATION
 	LD 	A,(403DH)	; AND GET SCREEN STATUS
 	AND 	0FDH		; AND MASK OUT ALL BITS
 	LD 	H,A		; SAVE WAVE "0" MASK IN H
 	OR 	2		; CREATE A WAVE "1" MASK
 	LD 	L,A		; SAVE WAVE "1" MASK IN L
 LOOP	LD 	A,L		; GET THE WAVE "1" MASK
 	OUT 	(0FFH),A	; AND CREATE WAVEFORM 1
 	LD 	A,H		; GET THE WAVE "0" MASK
 	OUT 	(0FFH),A	; AND CREATE WAVEFORM 0
 	PUSH 	BC		; SAVE THE DURATION VALUE
 	LD 	B,40H		; GET THE PITCH VALUE
 	DJNZ 	$+0		; AND WAIT THRU WAVEFORM
 	POP 	BC		; RESTORE THE DURATION
 	DJNZ 	LOOP		; AND DO FOR FULL BEEP
 	POP 	AF		; RESTORE KEYSTROKE VALUE
 	POP 	HL		; RESTORE STORAGE VALUE
 	POP 	BC		; RESTORE COUNTER VALUE
 	JP 	03FBH		; AND RETURN TO KEYSCAN
 ;
 ; #######################################################
 	END	BASIC2
