	ORG	5200H
; U2DVORAK/ASM
@DSP	EQU	33H
	PUSH	HL
	LD	(DCB),DE
	LD	HL,HELLO
	CALL	4467H
	LD	HL,4411H
	LD	A,(4)
	CP	30H
	JR	Z,HTOP
	LD	HL,4049H
HTOP	LD	(TOP1),HL
	LD	(TOP2),HL
	LD	(TOP3),HL
	LD	(TOP4),HL
	POP	HL
	LD	DE,(DCB)
	LD	A,(DE)
	AND	2
	JR	Z,ENTRY
	LD	HL,NOTOUT
	CALL	4467H
	JR	ABORT
ENTRY	LD	A,(HL)
	INC	HL		;look to next one
	CP	13
	JR	Z,NOTHIN
	CP	20H
	JR	Z,ENTRY
	CP	','
	JR	Z,ENTRY
	CP	60H
	JR	C,CHECK
	AND	5FH
CHECK	CP	'D'
	JR	Z,SETD
	CP	'Q'
	JR	Z,SETQ
	CP	'?'
	JR	NZ,ABORT
	PUSH	HL
	CALL	SHOWWHO
	POP	HL
	JR	ENTRY
ABORT	LD	HL,PARERR
	CALL	4467H
	JP	4030H
SETD	XOR	A
	JR	SETG
SETQ	LD	A,1
SETG	LD	(FLAG),A
NOTHIN
	LD	HL,(0)
TOP1	EQU	$-2
GOTNOT	LD	(TOPMEMO),HL	;save old topmem
	LD	BC,LAST-FIRST	;length
	OR	A
	SBC	HL,BC		;get length
	PUSH	HL		;save it
	DEC	HL		;reduce by 1
	LD	(0),HL
TOP2	EQU	$-2
	LD	(TOPMEMN),HL	;save for reclaim space
	POP	DE		;get where to move to
	LD	HL,DRIVER	;where driver is
	PUSH	BC		;save length
	PUSH	DE		;save dest
	PUSH	HL		;save start
	EX	DE,HL
	OR	A
	SBC	HL,DE
	EX	DE,HL
	LD	HL,(PASS1)
	ADD	HL,DE
	LD	(PASS1),HL	;pass to program
	LD	HL,(PASS2)
	ADD	HL,DE
	LD	(PASS2),HL
	LD	HL,(PASS3)
	ADD	HL,DE
	LD	(PASS3),HL
	LD	HL,(PASS4)
	ADD	HL,DE
	LD	(PASS4),HL
	LD	HL,(PASS5)
	ADD	HL,DE
	LD	(PASS5),HL
	LD	HL,(PASS6)
	ADD	HL,DE
	LD	(PASS6),HL
	LD	IX,0
DCB	EQU	$-2
	LD	L,(IX+1)
	LD	H,(IX+2)
	LD	(CALL),HL
	LD	HL,DRIVER
	ADD	HL,DE
	DI
	LD	(IX+1),L
	LD	(IX+2),H
	POP	HL
	POP	DE
	POP	BC
	LDIR
	EI
	RET
PARERR	DB	'Parameter Error !',13
NOTOUT	DB	'Cannot Filter OUTPUT Device !',13
HELLO	DB	1CH,1FH
	DB	'DVORAK - Dvorak/Qwerty Keyboard Filter for LDOS - Version 2.1',10
	DB	'by Kim Watt - (c)(p) Copyright 1982 Breeze/QSD, Inc.',10,10,13
WHOMSG
	DB	93H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,093H
	DB	0B3H,0B9H,0C9H,0EBH,0F6H,0FEH,0EBH,0F8H
;
	DB	0F4H,0B9H,0FBH,0E0H,0B9H,0D2H,0F0H,0F4H
	DB	0B9H,0CEH,0F8H,0EDH,0EDH,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B1H,0FAH
	DB	0B0H,0B1H,0E9H,0B0H,0B9H,0A8H,0A0H,0A1H
;
	DB	0ABH,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0DBH,0EBH,0FCH,0FCH
;
	DB	0E3H,0FCH,0B6H,0C8H,0CAH,0DDH,0B5H,0B9H
	DB	0D0H,0F7H,0FAH,0B7H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0A8H,0A8H,0ACH,0A9H,0A9H,0B9H
	DB	0CAH,0EDH,0FCH,0F4H,0F4H,0F6H,0F7H,0EAH
;
	DB	0B9H,0DFH,0EEH,0E0H,0B7H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0CAH
;
	DB	0ECH,0F0H,0EDH,0FCH,0B9H,0A8H,0ABH,0ACH
	DB	0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0DDH,0F8H,0F5H,0F5H,0F8H,0EAH
	DB	0B5H,0B9H,0CDH,0FCH,0E1H,0F8H,0EAH,0B9H
;
	DB	0AEH,0ACH,0ABH,0ABH,0A0H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0B1H,0ABH,0A8H,0ADH
;
	DB	0B0H,0B9H,0ADH,0A1H,0ADH,0B4H,0A0H,0ADH
	DB	0ABH,0A1H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,094H
	DB	93H
	DB	99H
SHOWWHO	LD	HL,WHOMSG
WHOLP	LD	A,(HL)
	INC	HL
	XOR	99H
	RET	Z
	CALL	@DSP
	JR	WHOLP
FIRST	DB	0
DRIVER	CALL	0		;call original
CALL	EQU	$-2
	PUSH	AF		;save the key
	CP	81H		;CLEAR BREAK?
	JR	Z,QUIT
	CP	95
	JR	Z,TOGGLE
	CP	0B0H
	JR	NZ,NOKEY
TOGGLE	LD	A,(FLAG)	;get type flag
PASS3	EQU	$-2
	XOR	1		;reverse bit 0
	LD	(FLAG),A	;re-save it
PASS4	EQU	$-2
BACK	POP	AF
	XOR	A
	RET
QUIT	LD	HL,MSG1
PASS1	EQU	$-2
	CALL	4467H
	LD	HL,(CALL)	;put old driver back
PASS6	EQU	$-2
	LD	(4016H),HL
	LD	DE,0
TOPMEMN	EQU	$-2
	LD	HL,(0)
TOP3	EQU	$-2
	OR	A
	SBC	HL,DE
	JR	NZ,DONE
	LD	HL,0
TOPMEMO	EQU	$-2		;old topmem pointer
	LD	(0),HL		;set it up
TOP4	EQU	$-2
	LD	HL,RECLAIM
PASS5	EQU	$-2
	CALL	4467H
DONE	JP	402DH
NOKEY	LD	A,0
FLAG	EQU	$-1		;on/off flag
	RRCA
	JR	C,DONT		;don't adjust it
	POP	AF		;get key back
	CP	20H		;control code ?
	RET	C
	CP	80H		;graphics ?
	RET	NC
	PUSH	BC		;save registers
	SUB	20H
	LD	C,A		;give to LSB
	LD	B,0
	PUSH	HL		;save all that's used
	LD	HL,TABLE	;lookup table
PASS2	EQU	$-2
	ADD	HL,BC		;point to new value
	LD	A,(HL)		;get the key
	POP	HL		;restore 'em
	POP	BC
	RET
DONT	POP	AF
	RET
TABLE	DB	' *"#$%&',27H,'()!Sw-vz6:753190248sW=VZ@'
	DB	'AXJE.UIDCHTNMBRL?POYGK,QF;'
	DB	5BH,5CH,5DH,5EH,5FH
	DB	60H
	DB	'axje>uidchtnmbrl/poygk<qf+'
	DB	7BH,7CH,7DH,7EH,7FH
MSG1	DB	10,'Cancelled.',3
RECLAIM	DB	'  Memory Reclaimed.',3
LAST	DB	0
	END	5200H
