DOSSYS ;dossys5/asm
 ;
 ; low overlay   1C00-21FF
 ; high overlay  2200-27FF
 ;
 	ORG	1C00H		;Low Overlay
 ;
 ;*TITLE	'SYSTEM 05 - System Error Messages'
 ;
 ; first 32 bytes is a vector tables of routines
 ;
 ;	(message text and numbers at end of file)
 ;
 VECTORS	EQU	$
 	DW	ERROR		;1
 	DW	ERRMSG		;2
 	DW	DUMMY		;3
 	DW	DUMMY		;4
 	DW	DUMMY		;5
 	DW	DUMMY		;6
 	DW	DUMMY		;7
 	DW	DUMMY		;8
 	DW	DUMMY		;9
 	DW	DUMMY		;10
 	DW	DUMMY		;11
 	DW	DUMMY		;12
 	DW	DUMMY		;13
 	DW	DUMMY		;14
 	DW	DUMMY		;15
 ;
 DUMMY	LD	A,1		;"bad function code"
 	OR	A		;set NZ flag
 	RET			;return in error
 ;
 ; ERROR
 ; ENTRY:  B = Error Number (0-98)
 ; EXIT:   Error message displayed to video
 ;         NZ = A = error code
 ;         Z  = OK
 ;
 ERROR	PUSH	BC		;save it
 	PUSH	HL		;save this too
 	LD	HL,SYS5BUF	;sys5 work buffer
 	RES	7,B		;force a return to here
 	CALL	ERRMSG		;load (HL) with message
 	LD	A,9		;SVC VIDLIN
 	LD	BC,5000H	;B=length, C=term char
 	RST	8		;via SVC call
 ERRET	POP	HL		;restore stack
 	POP	BC
 	LD	A,B		;get error code
 	AND	80H		;check bit 7
 	RET	Z		;Z flag for OK, return
 	RST	0		;else go "dos ready"
 ;
 ; ERRMSG
 ; ENTRY:   B  = Error Code (0-98)
 ;          HL => 80 char text buffer
 ; EXIT:    HL => 80 char error string
 ;          NZ = A = error code
 ;          Z  = OK
 ;
 ERRMSG	PUSH	BC		;save entry
 	PUSH	HL		;save string pointer
 	PUSH	DE		;need to use this
 	PUSH	HL		;again for work use
 	LD	A,B		;get the error
 	AND	7FH		;mask off command bit
 	LD	B,79		;string length -1
 ERRNUL	LD	(HL),20H	;put one
 	INC	HL		;bump pointer
 	DJNZ	ERRNUL		;do whole thing
 	LD	(HL),13		;put C/R at end
 	POP	DE		;get start back
 	LD	HL,TABLE2	;command lookup table
 	CP	99		;98 errors here
 	JR	C,FINDERR	;valid if <45
 	LD	A,99		;else force undefined
 	JR	FINDERR		;go, B = err # counter
 ERRDONE	DEC	DE		;strip off last space
 	LD	A,'.'		;and put period here
 	LD	(DE),A		;put in buffer
 	POP	DE		;restore DE
 	JR	ERRET		;pop stack and return
 FINDERR	BIT	7,(HL)		;high bit on ?
 	INC	HL		;bump pointer
 	JR	Z,FINDERR	;continue
 	CP	B		;correct one ?
 	JR	Z,SHOERR	;yes, display it
 	INC	B		;bump counter
 	JR	FINDERR		;continue through table
 SHOERR	DEC	HL		;point to start of line
 	JR	ERRGO		;go do error
 ERRLP	BIT	7,(HL)		;terminator?
 	JR	NZ,ERRDONE	;finished
 ERRGO	CALL	SHOW1		;show the word
 	INC	HL		;bump pointer
 	JR	ERRLP		;continue with sentence
 SHOW1	LD	A,(HL)		;get the byte
 	AND	7FH		;turn off high bit
 	LD	C,1		;counter
 	PUSH	HL		;save pointer
 	LD	HL,TABLE1	;word table
 FINDSHO	BIT	7,(HL)		;high bit on/word start?
 	INC	HL		;bump pointer
 	JR	Z,FINDSHO	;continue if not
 	CP	C		;one we want ?
 	JR	Z,PUTERR	;display the word
 	INC	C
 	JR	FINDSHO		;else continue
 PUTERR	DEC	HL		;word start
 	JR	PUTCONT		;print it
 PUTLOOP	BIT	7,(HL)		;end of word?
 	JR	NZ,WORDEND
 PUTCONT	LD	A,(HL)		;get char
 	AND	7FH		;remove high bit
 	LD	(DE),A		;put into buffer
 	INC	DE		;bump buffer
 	INC	HL		;bump word pointer
 	JR	PUTLOOP		;continue
 WORDEND	LD	A,20H		;display a space
 	LD	(DE),A		;put in buffer
 	INC	DE		;bump pointer
 	POP	HL		;restore table pointer
 	RET			;done
 ;
 ; table of words numbered 1-127
 ; high bit of first char in each word is set
 ; 80H is the table terminator
 ;
 TABLE1	EQU	$
 	DB	'N'+80H		;1 No
 	DB	'o'
 	DB	'E'+80H		;2 Error
 	DB	'rror'
 	DB	'B'+80H		;3 Bad
 	DB	'ad'
 	DB	'F'+80H		;4 Function
 	DB	'unction'
 	DB	'C'+80H		;5 Code
 	DB	'ode'
 	DB	'O'+80H		;6 On
 	DB	'n'
 	DB	'S'+80H		;7 SVC
 	DB	'VC'
 	DB	'C'+80H		;8 Call
 	DB	'all'
 	DB	'C'+80H		;9 Character
 	DB	'haracter'
 	DB	'N'+80H		;10 Not
 	DB	'ot'
 	DB	'A'+80H		;11 Avaliable
 	DB	'vailable'
 	DB	'P'+80H		;12 Parameter
 	DB	'arameter'
 	DB	'C'+80H		;13 CRC
 	DB	'RC'
 	DB	'D'+80H		;14 Disk
 	DB	'isk'
 	DB	'I'+80H		;15 I/O
 	DB	'/O'
 	DB	'O'+80H		;16 Operation
 	DB	'peration'
 	DB	'S'+80H		;17 Sector
 	DB	'ector'
 	DB	'F'+80H		;18 Found
 	DB	'ound'
 	DB	'I'+80H		;19 Illegal
 	DB	'llegal'
 	DB	'C'+80H		;20 Change
 	DB	'hange'
 	DB	'D'+80H		;21 Drive
 	DB	'rive'
 	DB	'R'+80H		;22 Ready
 	DB	'eady'
 	DB	'I'+80H		;23 Invalid
 	DB	'nvalid'
 	DB	'D'+80H		;24 Data
 	DB	'ata'
 	DB	'P'+80H		;25 Provided
 	DB	'rovided'
 	DB	'F'+80H		;26 File
 	DB	'ile'
 	DB	'A'+80H		;27 Already
 	DB	'lready'
 	DB	'E'+80H		;28 Exists
 	DB	'xists'
 	DB	'T'+80H		;29 To
 	DB	'o'
 	DB	'O'+80H		;30 Open
 	DB	'pen'
 	DB	'R'+80H		;31 Read
 	DB	'ead'
 	DB	'W'+80H		;32 Write
 	DB	'rite'
 	DB	'A'+80H		;33 Attempt
 	DB	'ttempt'
 	DB	'O'+80H		;34 Only
 	DB	'nly'
 	DB	'F'+80H		;35 Fault
 	DB	'ault'
 	DB	'P'+80H		;36 Protected
 	DB	'rotected'
 	DB	'D'+80H		;37 DCB
 	DB	'CB'
 	DB	'H'+80H		;38 Has
 	DB	'as'
 	DB	'B'+80H		;39 Been
 	DB	'een'
 	DB	'M'+80H		;40 Modified
 	DB	'odified'
 	DB	'D'+80H		;41 Directory
 	DB	'irectory'
 	DB	'F'+80H		;42 Filespec
 	DB	'ilespec'
 	DB	'G'+80H		;43 GAT
 	DB	'AT'
 	DB	'H'+80H		;44 HIT
 	DB	'IT'
 	DB	'A'+80H		;45 Access
 	DB	'ccess'
 	DB	'D'+80H		;46 Denied
 	DB	'enied'
 	DB	'S'+80H		;47 Space
 	DB	'pace'
 	DB	'F'+80H		;48 Full
 	DB	'ull'
 	DB	'E'+80H		;49 End
 	DB	'nd'
 	DB	'O'+80H		;50 Of
 	DB	'f'
 	DB	'E'+80H		;51 Encountered
 	DB	'ncountered'
 	DB	'R'+80H		;52 Record
 	DB	'ecord'
 	DB	'N'+80H		;53 Number
 	DB	'umber'
 	DB	'O'+80H		;54 Out
 	DB	'ut'
 	DB	'R'+80H		;55 Range
 	DB	'ange'
 	DB	'C'+80H		;56 Cannot
 	DB	'annot'
 	DB	'E'+80H		;57 Extend
 	DB	'xtend'
 	DB	'P'+80H		;58 Program
 	DB	'rogram'
 	DB	'D'+80H		;59 Drivespec
 	DB	'rivespec'
 	DB	'L'+80H		;60 Load
 	DB	'oad'
 	DB	'F'+80H		;61 Format
 	DB	'ormat'
 	DB	'M'+80H		;62 Memory
 	DB	'emory'
 	DB	'A'+80H		;63 An
 	DB	'n'
 	DB	'U'+80H		;64 Unopen
 	DB	'nopen'
 	DB	'S'+80H		;65 Seek
 	DB	'eek'
 	DB	'L'+80H		;66 Lost
 	DB	'ost'
 	DB	'P'+80H		;67 Printer
 	DB	'rinter'
 	DB	'P'+80H		;68 Paper
 	DB	'aper'
 	DB	'V'+80H		;69 VLR
 	DB	'LR'
 	DB	'T'+80H		;70 Type
 	DB	'ype'
 	DB	'R'+80H		;71 Required
 	DB	'equired'
 	DB	'C'+80H		;72 Command
 	DB	'ommand'
 	DB	'H'+80H		;73 Hardware
 	DB	'ardware'
 	DB	'H'+80H		;74 Header
 	DB	'eader'
 	DB	'P'+80H		;75 Parity
 	DB	'arity'
 	DB	'S'+80H		;76 System
 	DB	'ystem'
 	DB	'D'+80H		;77 Deleted
 	DB	'eleted'
 	DB	'D'+80H		;78 Device
 	DB	'evice'
 	DB	'E'+80H		;79 Exists
 	DB	'xists'
 	DB	'I'+80H		;80 In
 	DB	'n'
 	DB	'D'+80H		;81 Devicespec
 	DB	'evicespec'
 	DB	'U'+80H		;82 Use
 	DB	'se'
 	DB	'M'+80H		;83 Modem
 	DB	'odem'
 	DB	'C'+80H		;84 Carrier
 	DB	'arrier'
 	DB	'T'+80H		;85 Transmitter
 	DB	'ransmitter'
 	DB	'F'+80H		;86 Framing
 	DB	'raming'
 	DB	'S'+80H		;87 Serial
 	DB	'erial'
 	DB	'L'+80H		;88 Logical
 	DB	'ogical'
 	DB	'C'+80H		;89 Clear
 	DB	'lear'
 	DB	'S'+80H		;90 Send
 	DB	'end'
 	DB	'D'+80H		;91 Detected
 	DB	'etected'
 	DB	'C'+80H		;92 Channel
 	DB	'hannel'
 	DB	'I'+80H		;93 Input
 	DB	'nput'
 	DB	'O'+80H		;94 Output
 	DB	'utput'
 	DB	'I'+80H		;95 Insufficient
 	DB	'nsufficient'
 	DB	'S'+80H		;96 Set
 	DB	'et'
 	DB	'M'+80H		;97 Member
 	DB	'ember'
 	DB	'T'+80H		;98 Terminated
 	DB	'erminated'
 	DB	'M'+80H		;99 Mount
 	DB	'ount'
 	DB	'S'+80H		;100 Source
 	DB	'ource'
 	DB	'D'+80H		;101 Destination
 	DB	'estination'
 	DB	'T'+80H		;102 Target
 	DB	'arget'
 	DB	'T'+80H		;103 Table
 	DB	'able'
 	DB	'C'+80H		;104 Corrupt
 	DB	'orrupt'
 	DB	'E'+80H		;105 Extent
 	DB	'xtent'
 	DB	'T'+80H		;106 Terminator
 	DB	'erminator'
 	DB	'L'+80H		;107 Links
 	DB	'inks'
 	DB	'L'+80H		;108 Linking
 	DB	'inking'
 	DB	'B'+80H		;109 Back
 	DB	'ack'
 	DB	'I'+80H		;110 It
 	DB	't'
 	DB	'T'+80H		;111 Track
 	DB	'rack'
 	DB	'A'+80H		;112 Assigned
 	DB	'ssigned'
 	DB	'B'+80H		;113 Beyond
 	DB	'eyond'
 	DB	'B'+80H		;114 Boundary
 	DB	'oundary'
 	DB	'F'+80H		;115 Forward
 	DB	'orward'
 	DB	'L'+80H		;116 Link
 	DB	'ink'
 	DB	'I'+80H		;117 Inactive
 	DB	'nactive'
 	DB	'E'+80H		;118 Entry
 	DB	'ntry'
 	DB	'N'+80H		;119 Non-extension
 	DB	'on-extension'
 	DB	'E'+80H		;120 Establish
 	DB	'stablish'
 	DB	'T'+80H		;121 Type
 	DB	'ype'
 	DB	'U'+80H		;122 Unknown
 	DB	'nknown'
 	DB	'B'+80H		;123 By
 	DB	'y'
 	DB	'A'+80H		;124 And
 	DB	'nd'
 	DB	'B'+80H		;125 Breeze/QSD
 	DB	'reeze/QSD'
 	DB	'M'+80H		;126 Microsystem Software
 	DB	'icrosystem Software'
 	DB	'D'+80H		;127 Dosplus II
 	DB	'osplus II'
 	DB	80H
 ;
 ; following is the sentence table
 ; high bit of first word number in sentence is set
 ; 80H terminates the table
 ;
 TABLE2	EQU	$
 	DB	1+80H		;0
 	DB	2
 	DB	3+80H		;1
 	DB	4
 	DB	5
 	DB	6
 	DB	7
 	DB	8
 	DB	9+80H		;2
 	DB	10
 	DB	11
 	DB	12+80H		;3
 	DB	2
 	DB	13+80H		;4
 	DB	2
 	DB	6
 	DB	14
 	DB	15
 	DB	16
 	DB	14+80H		;5
 	DB	17
 	DB	10
 	DB	18
 	DB	122+80H		;6
 	DB	2
 	DB	19+80H		;7
 	DB	14
 	DB	20
 	DB	14+80H		;8
 	DB	21
 	DB	10
 	DB	22
 	DB	23+80H		;9
 	DB	24
 	DB	25
 	DB	122+80H		;10
 	DB	2
 	DB	26+80H		;11
 	DB	27
 	DB	28
 	DB	1+80H		;12
 	DB	21
 	DB	11
 	DB	29
 	DB	30
 	DB	26
 	DB	32+80H		;13
 	DB	33
 	DB	29
 	DB	31
 	DB	34
 	DB	26
 	DB	32+80H		;14
 	DB	35
 	DB	6
 	DB	14
 	DB	15
 	DB	32+80H		;15
 	DB	36
 	DB	14
 	DB	37+80H		;16
 	DB	38
 	DB	39
 	DB	40
 	DB	41+80H		;17
 	DB	31
 	DB	2
 	DB	41+80H		;18
 	DB	32
 	DB	2
 	DB	23+80H		;19
 	DB	42
 	DB	43+80H		;20
 	DB	31
 	DB	2
 	DB	43+80H		;21
 	DB	32
 	DB	2
 	DB	44+80H		;22
 	DB	31
 	DB	2
 	DB	44+80H		;23
 	DB	32
 	DB	2
 	DB	26+80H		;24
 	DB	10
 	DB	18
 	DB	26+80H		;25
 	DB	45
 	DB	46
 	DB	41+80H		;26
 	DB	47
 	DB	48
 	DB	14+80H		;27
 	DB	47
 	DB	48
 	DB	49+80H		;28
 	DB	50
 	DB	26
 	DB	51
 	DB	52+80H		;29
 	DB	53
 	DB	54
 	DB	50
 	DB	55
 	DB	41+80H		;30
 	DB	47
 	DB	48
 	DB	56
 	DB	57
 	DB	26
 	DB	58+80H		;31
 	DB	10
 	DB	18
 	DB	23+80H		;32
 	DB	59
 	DB	122+80H		;33
 	DB	2
 	DB	60+80H		;34
 	DB	26
 	DB	61
 	DB	2
 	DB	62+80H		;35
 	DB	35
 	DB	122+80H		;36
 	DB	2
 	DB	30+80H		;37
 	DB	33
 	DB	29
 	DB	63
 	DB	30
 	DB	26
 	DB	15+80H		;38
 	DB	33
 	DB	29
 	DB	63
 	DB	64
 	DB	26
 	DB	19+80H		;39
 	DB	15
 	DB	33
 	DB	65+80H		;40
 	DB	2
 	DB	66+80H		;41
 	DB	24
 	DB	6
 	DB	14
 	DB	15
 	DB	67+80H		;42
 	DB	10
 	DB	22
 	DB	67+80H		;43
 	DB	54
 	DB	50
 	DB	68
 	DB	67+80H		;44
 	DB	35
 	DB	67+80H		;45
 	DB	10
 	DB	11
 	DB	23+80H		;46
 	DB	15
 	DB	33
 	DB	29
 	DB	69
 	DB	70
 	DB	26
 	DB	71+80H		;47
 	DB	72
 	DB	12
 	DB	10
 	DB	18
 	DB	23+80H		;48
 	DB	72
 	DB	12
 	DB	73+80H		;49
 	DB	35
 	DB	6
 	DB	14
 	DB	15
 	DB	122+80H		;50
 	DB	2
 	DB	75+80H		;51
 	DB	2
 	DB	6
 	DB	74
 	DB	31
 	DB	65+80H		;52
 	DB	2
 	DB	6
 	DB	31
 	DB	66+80H		;53
 	DB	24
 	DB	6
 	DB	31
 	DB	75+80H		;54
 	DB	2
 	DB	6
 	DB	31
 	DB	24+80H		;55
 	DB	52
 	DB	10
 	DB	18
 	DB	6
 	DB	31
 	DB	33+80H		;56
 	DB	29
 	DB	31
 	DB	76
 	DB	24
 	DB	52
 	DB	33+80H		;57
 	DB	29
 	DB	31
 	DB	77
 	DB	24
 	DB	52
 	DB	78+80H		;58
 	DB	10
 	DB	11
 	DB	75+80H		;59
 	DB	2
 	DB	6
 	DB	74
 	DB	32
 	DB	65+80H		;60
 	DB	2
 	DB	6
 	DB	32
 	DB	66+80H		;61
 	DB	24
 	DB	6
 	DB	32
 	DB	75+80H		;62
 	DB	2
 	DB	6
 	DB	32
 	DB	24+80H		;63
 	DB	52
 	DB	10
 	DB	18
 	DB	6
 	DB	32
 	DB	32+80H		;64
 	DB	35
 	DB	6
 	DB	14
 	DB	21
 	DB	14+80H		;65
 	DB	32
 	DB	36
 	DB	1+80H		;66
 	DB	4
 	DB	79
 	DB	21+80H		;67
 	DB	10
 	DB	80
 	DB	76
 	DB	23+80H		;68
 	DB	81
 	DB	1+80H		;69
 	DB	78
 	DB	47
 	DB	11
 	DB	78+80H		;70
 	DB	10
 	DB	11
 	DB	78+80H		;71
 	DB	80
 	DB	82
 	DB	36+80H		;72
 	DB	76
 	DB	78
 	DB	83+80H		;73
 	DB	84
 	DB	66
 	DB	85+80H		;74
 	DB	10
 	DB	11
 	DB	86+80H		;75
 	DB	2
 	DB	87+80H		;76
 	DB	24
 	DB	66
 	DB	87+80H		;77
 	DB	75
 	DB	2
 	DB	89+80H		;78
 	DB	29
 	DB	90
 	DB	10
 	DB	91
 	DB	19+80H		;79
 	DB	88
 	DB	26
 	DB	53
 	DB	23+80H		;80
 	DB	93
 	DB	92
 	DB	23+80H		;81
 	DB	94
 	DB	92
 	DB	95+80H		;82
 	DB	62
 	DB	23+80H		;83
 	DB	24
 	DB	24+80H		;84
 	DB	96
 	DB	97
 	DB	10
 	DB	18
 	DB	98+80H		;85
 	DB	99+80H		;86
 	DB	100
 	DB	14
 	DB	99+80H		;87
 	DB	101
 	DB	14
 	DB	99+80H		;88
 	DB	102
 	DB	14
 	DB	99+80H		;89
 	DB	76
 	DB	14
 	DB	43+80H		;90
 	DB	103
 	DB	104
 	DB	44+80H		;91
 	DB	103
 	DB	104
 	DB	1+80H		;92
 	DB	105
 	DB	106
 	DB	6
 	DB	26
 	DB	41+80H		;93
 	DB	107
 	DB	29
 	DB	52
 	DB	10
 	DB	108
 	DB	109
 	DB	29
 	DB	110
 	DB	111+80H		;94
 	DB	112
 	DB	113
 	DB	14
 	DB	114
 	DB	115+80H		;95
 	DB	41
 	DB	116
 	DB	29
 	DB	117
 	DB	118
 	DB	115+80H		;96
 	DB	116
 	DB	29
 	DB	119
 	DB	118
 	DB	56+80H		;97
 	DB	120
 	DB	14
 	DB	121
 	DB	127+80H		;98
 	DB	58
 	DB	123
 	DB	125
 	DB	124
 	DB	126
 	DB	122+80H		;99
 	DB	2
 	DB	80H
 SYS5BUF	DS	80		;work area for messages
 	DB	0		;done, end of program
 ;
 ; message text for errors
 ;
 ;00 - No Error
 ;01 - Bad Function Code On SVC Call
 ;02 - Character Not Available
 ;03 - Parameter Error
 ;04 - CRC Error On Disk I/O Operation
 ;05 - Disk Sector Not Found
 ;06 - Unknown Error
 ;07 - Illegal Disk Change
 ;08 - Disk Drive Not Ready
 ;09 - Invalid Data Provided
 ;10 - Unknown Error
 ;11 - File Already Exists
 ;12 - No Drive Available To Open File
 ;13 - Write Attempt To Read Only File
 ;14 - Write Fault On Disk I/O
 ;15 - Write Protected Disk
 ;16 - DCB Has Been Modified
 ;17 - Directory Read Error
 ;18 - Directory Write Error
 ;19 - Invalid Filespec
 ;20 - GAT Read Error
 ;21 - GAT Write Error
 ;22 - HIT Read Error
 ;23 - HIT Write Error
 ;24 - File Not Found
 ;25 - File Access Denied
 ;26 - Directory Space Full
 ;27 - Disk Space Full
 ;28 - End Of File Encountered
 ;29 - Record Number Out Of Range
 ;30 - Directory Space Full Cannot Extend File
 ;31 - Program Not Found
 ;32 - Invalid Drivespec
 ;33 - Unknown Error
 ;34 - Load File Format Error
 ;35 - Memory Fault
 ;36 - Unknown Error
 ;37 - Open Attempt To An Open File
 ;38 - I/O Attempt To An Unopen File
 ;39 - Illegal I/O Attempt
 ;40 - Seek Error
 ;41 - Lost Data On Disk I/O
 ;42 - Printer Not Ready
 ;43 - Printer Out Of Paper
 ;44 - Printer Fault
 ;45 - Printer Not Available
 ;46 - Invalid I/O Attempt To VLR Type File
 ;47 - Required Command Parameter Not Found
 ;48 - Invalid Command Parameter
 ;49 - Hardware Fault On Disk I/O
 ;50 - Unknown Error
 ;51 - Parity Error On Header Read
 ;52 - Seek Error On Read
 ;53 - Lost Data On Read
 ;54 - Parity Error On Read
 ;55 - Data Record Not Found On Read
 ;56 - Attempt To Read System Data Record
 ;57 - Attempt To Read Deleted Data Record
 ;58 - Device Not Available
 ;59 - Parity Error On Header Write
 ;60 - Seek Error On Write
 ;61 - Lost Data On Write
 ;62 - Parity Error On Write
 ;63 - Data Record Not Found On Write
 ;64 - Write Fault On Disk Drive
 ;65 - Disk Write Protected
 ;66 - No Function Exists
 ;67 - Drive Not In System
 ;68 - Invalid Devicespec
 ;69 - No Device Space Available
 ;70 - Device Not Available
 ;71 - Device In Use
 ;72 - Protected System Device
 ;73 - Modem Carrier Lost
 ;74 - Transmitter Not Available
 ;75 - Framing Error
 ;76 - Serial Data Lost
 ;77 - Serial Parity Error
 ;78 - Clear To Send Not Detected
 ;79 - Illegal Logical File Number
 ;80 - Invalid Input Channel
 ;81 - Invalid Output Channel
 ;82 - Insufficient Memory
 ;83 - Invalid Data
 ;84 - Data Set Member Not Found;
 ;85 - Terminated
 ;86 - Mount Source Disk
 ;87 - Mount Destination Disk
 ;88 - Mount Target Disk
 ;89 - Mount System Disk
 ;90 - GAT Table Corrupt
 ;91 - HIT Table Corrupt
 ;92 - No Extent Terminator On File
 ;93 - Directory Links To Record Not Linking Back To It
 ;94 - Track Assigned Beyond Disk Boundary
 ;95 - Forward Directory Link To Inactive Entry
 ;96 - Forward Link To Non-extension Entry
 ;97 - Cannot Establish Disk Type
 ;98 - Dosplus II Program
 ;     By Breeze/QSD and Microsystem Software
 ;
 	END
