DOSDCB ; dosdcbk/asm
 ;
 ; definition of common DCB data
 ;
 ;+00	7 - File DCB - 1=YES, 0=NO
 ;	6 - DCT/DCB - 1=DCT, 0=DCB
 ;	5 - Linked - 1=YES, 0=NO
 ;	4 - Routed - 1=YES, 0=NO
 ;	3 - Nil - 1=YES, 0=NO
 ;	2 - @CTL support - 1=YES, 0=NO
 ;	1 - @GET support - 1=YES, 0=NO
 ;	0 - @PUT support - 1=YES, 0=NO
 ;+01,02	- DCB address
 ;+03,04	- linked/routed DCB address
 ;+05	7 - available
 ;	6 - available
 ;	5 - available
 ;	4 - available
 ;	3 - available
 ;	2 - available
 ;	1 - available
 ;	0 - Translation - 1=ON, 0=OFF
 ;+06,07	- Translation Table Address
 ;+08	- Translation Table Length
 ;+09,10	- Buffer Start Address
 ;+11,12	- Buffer Size
 ;+13,14	- Buffer Counter
 ;+15,16	- Add to Buffer Offset
 ;+17,18	- Take from Buffer Offset
 ;
 ; definition of SIO DCB (extensions of standard)
 ;
 ;+05	7 - @CTL call current - 1=YES, 0=NO
 ;	6 - unused
 ;	5 - unused
 ;	4 - unused
 ;	3 - unused
 ;	2 - unused
 ;	1 - channel initialized - 1=NO, 0=YES
 ;	0 - translation - 1=ON, 0=OFF
 ;+19	- Base Port SIO (command/status)
 ;+20	- CTC port #1
 ;+21	- CTC port #2
 ;+22	- Word Length Mask
 ;+23	- Error Mask
 ;+24	- CTC R5 Mask (for PRCTRL call)
 ;
 CADCB	DEFB	7		;input/output/ctl
 	DEFW	SIOCODE		;driver address
 	DEFW	0		;linking/routing DCB
 	DEFB	2		;+5, channel inactive
 	DEFW	0		;+6,7 translation
 	DEFB	0		;+8 translate length
 	DEFW	SIOABUF		;+9,10 input buffer
 	DEFW	20		;+11,12 buffer size
 	DEFW	0		;+13,14 buffer counter
 	DEFW	0		;+15,16 add offset
 	DEFW	0		;+17,18 take offset
 	DEFB	0F6H		;+19 base port
 	DEFB	0F0H		;+20 CTC #1
 	DEFB	0F1H		;+21 CTC #2
 	DEFB	0FFH		;+22 word length mask
 	DEFB	0		;+23 error mask
 	DEFB	0		;+24 CTC R5 mask
 ;
 CBDCB	DEFB	7		;input/output/ctl
 	DEFW	SIOCODE		;driver address
 	DEFW	0		;linker/router
 	DEFB	2		;inactive
 	DEFW	0		;translate address
 	DEFB	0		;translate length
 	DEFW	SIOBBUF		;buffer address
 	DEFW	20		;buffer length
 	DEFW	0		;buffer counter
 	DEFW	0		;add offset
 	DEFW	0		;take offset
 	DEFB	0F7H		;base port
 	DEFB	0F2H		;CTC #1
 	DEFB	0		;CTC #2 (dummy)
 	DEFB	0FFH		;word length mask
 	DEFB	0		;error mask
 	DEFB	0		;CTC R5 mask
 ;
 ; definition of printer DCB (additions)
 ;
 ;+05	7 - parallel/serial - 1=serial, 0=parallel
 ;	6 - LF on CR - 1=ON, 0=OFF
 ;	5 - graphic enable - 1=YES, 0=NO
 ;	4 - locase enable - 1=YES, 0=NO
 ;	3 - transparent mode - 1=ON, 0=OFF
 ;	2 - form feeds - 1=REAL, 0=TRANSLATED
 ;	1 - tabs - 1=REAL, 0=TRANSLATED
 ;	0 - tranlation - 1=ON, 0=OFF
 ;+19	- printed lines/page
 ;+20	- page length
 ;+21	- line counter
 ;+22	- max chars/line
 ;+23	- char counter
 ;
 PDCB	DEFB	6		;output/ctl
 	DEFW	PRTCODE		;driver address
 	DEFW	0		;linker/router DCB
 	DEFB	0		;+5, operation flag
 	DEFW	0		;+6,7 xlate table addr
 	DEFB	0		;+8 table length
 	DEFW	PRTBUFF		;+9,10 buffer pointer
 	DEFW	20		;+11,12 buffer length
 	DEFW	0		;+13,14 counter
 	DEFW	0		;+15,16 adder offset
 	DEFW	0		;+17,18 taker offset
 	DEFB	60		;+19 printed lines/page
 	DEFB	66		;+20 page length
 	DEFB	0		;+21 line counter
 	DEFB	132		;+22 max chars/line
 	DEFB	0		;+23 char counter
 ;
 ; definition of keyboard DCB (extensions)
 ;
 ;+05 -	7 - @CTL call current - 1=YES, 0=NO
 ;	6 - buffer overflow - 1=YES, 0=NO
 ;	5 - unused
 ;	4 - unused
 ;	3 - unused
 ;	2 - unused
 ;	1 - unused
 ;	0 - Translation - 1=ON, 0=OFF
 ;
 KDCB	DEFB	5		;input/ctrl
 	DEFW	KBDCODE		;driver address
 	DEFW	0		;linker/router
 	DEFB	0		;operation flag
 	DEFW	0		;translate table
 	DEFB	0		;table length
 	DEFW	KBDBUFF		;+9,10 type buffer
 	DEFW	80		;+11,12 buff size
 	DEFW	0		;+13,14 char counter
 	DEFW	0		;+15,16 add offset
 	DEFW	0		;+17,18 take offset
 ;
 	END
