DDSD3  ;************************************************
 ;*						*
 ;*	   ADR for NEWDOS-80 Version 1		*
 ;*						*
 ;*         	  TRS-80 Model III		*
 ;*						*
 ;*	 	        by			*
 ;*						*
 ;*		 Allan J. Domuret		*
 ;*						*
 ;*		  (916) 967-7331		*
 ;*						*
 ;*		     12/12/81			*
 ;*						*
 ;************************************************
 ;
 ;
 ;This segment sets up the ADR PDRIVE code blocks.
 ; Original PDRIVE settings are left unchanged except
 ; for those patches that affect DD/SD operation.
 ;
 ;If a drive was originally PDRIVE'd as SD by the user,
 ; it is assumed that TI=CK for DD operation for that
 ; drive.
 ;
 	ORG	5200H
 ;
 RESTOR	EQU	46F5H		;Mod III
 ;
 START	LD	HL,MATH		;Math patch
 	LD	DE,4080H
 	LD	BC,0EH
 	DI
 	LDIR
 ;
 	LD	IX,4291H	;Start DCT
 	LD	IY,DR0DD	;ADR Table for DD
 ;
 	LD	HL,4291H	;Move DOS PDRIVE codes
 	LD	DE,DR0DD
 	LD	BC,0028H	;40 BYTES = 4 DRIVES
 	PUSH	HL		; to DDSD areas
 	PUSH	BC
 	LDIR			;DD block
 	POP	BC
 	POP	HL
 	LDIR			;SD block
 ;
 ;For Model III. Check if DD; if so, convert to SD.
 ;SD track count is multiplied by 1.8 to get
 ; number of lumps as required by N82.
 ;
 	LD	A,(42BFH)	;-OFFSET Drives in system
 	LD	B,A		;Counter
 MAKDBL	PUSH	BC
 	BIT	0,(IY+07)	;Ck if already DD
 	JR	NZ,SKIP		;Leave as is if DD
 	LD	H,00
 	LD	L,(IY+03)	;TRUE TRACK COUNT
 	LD	DE,0008		;MULT BY 8/10 DECIMAL
 	CALL	0BF2H		;MULT IN ROM
 	PUSH	HL
 	POP	DE		;HL TO DE
 	LD	HL,000AH	;DIVIDE BY 10 DECIMAL
 	CALL	2490H		;DIVIDE IN ROM
 	CALL	0A8AH		;CONVERT (CINT)
 	XOR	A
 	LD	A,L
 	ADD	A,(IY+03)
 	LD	(IY+01),A	;-OFFSET LUMPS
 	LD	(IY+04),12H	;12H SECTORS/TRK
 	SET	1,(IY+06)
 	SET	0,(IY+07)	;BIT 0=1 for DD
 SKIP	POP	BC
 	LD	DE,000AH
 	ADD	IY,DE		;Point to next block
 	DJNZ	MAKDBL
 ;
 ;Next routine makes DD into SD.
 ;
 	LD	IY,DR0SD	;Redefine pointer
 	LD	A,(42BFH)	;-OFFSET Drives in system
 	LD	B,A		;Counter
 	LD	DE,000AH	;Pointer bumper
 	BIT	0,(IY+07)	;Ck if already SD
 	JR	Z,SKPSGL
 ;
 MAKSGL	LD	A,(IY+03)	;TRUE TRACKS
 	LD	(IY+01),A	;SAME WHEN SD
 	LD	(IY+04),0AH	;0AH SECTORS/TRK
 	RES	1,(IY+06)	;FC for SD
 	RES	0,(IY+07)	;BIT 0=0 for SD
 ;
 ;Assume DDGA=2 for SD only.
 ;
 	LD	(IY+09),02	;2 for DDGA=2, SD only
 SKPSGL	ADD	IY,DE		;Bump pointer
 	DJNZ	MAKSGL
 ;
 	LD	BC,HI-OFFSET+01
 	LD	DE,(4411H)
 	LD	HL,HI
 	LDDR
 	LD	(4411H),DE
 	INC	DE
 	LD	(48B2H),DE
 DIR	LD	A,0C3H		;Insert DOS patch
 	LD	(48B1H),A
 ;
 ;Insert label addresses.
 ;
 	LD	HL,0011H
 	CALL	REPLAC
 	LD	HL,0025H
 	CALL	REPLAC
 	LD	HL,0047H
 	CALL	REPLAC
 	LD	HL,0051H
 	CALL	REPLAC
 	LD	HL,0084H
 	CALL	REPLAC
 	LD	HL,0089H
 	CALL	REPLAC
 	LD	HL,00B2H
 	CALL	REPLAC
 ;
 	LD	HL,(4411H)
 	INC	HL
 	LD	DE,DDSD-OFFSET
 	ADD	HL,DE
 	LD	(46EDH),HL	;Patch DOS; DE=>DDSD
 	LD	A,0C2H		;Z80 code for JP NZ
 	LD	(46ECH),A
 	EI
 	JR	DSPLY
 ;
 REPLAC	ADD	HL,DE
 	LD	C,(HL)
 	INC	HL
 	LD	B,(HL)
 	DEC	HL
 	PUSH	DE
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	POP	DE
 	RET
 ;
 ;End of relocate
 ;
 ;
 DSPLY	CALL	01C9H
 	LD	HL,3C40H	;Set cursor
 	LD	(4020H),HL
 	LD	HL,TEXT
 	CALL	4467H
 ;
 	JP	402DH
 ;
 ;
 TEXT	DB	'DDSD/CMD - Double/Single Density - Version III.0 -- Feb. 1982',0AH
 	DB	'Automatic PDRIVE Utility For Use With NEWDOS-80 Version 2 (c)',0AH,0AH
 	DB	'  Distributed by: The Alternate Source, Lansing, Michigan.',0AH
 	DB	'                '	;18 blanks
 	DB	'Written by Allan J. Domuret',0AH,0AH,0AH
 ;
 	DB	'                           '	;28x20H
 	DB	'Model I',0AH
 	DB	'     '			;5 blanks
 	DB	'      Automatic Density Recognition Enabled ',0AH,0AH,0DH
 ;
 ;
 ;
 MATH	DB	0D6H,00,6FH,7CH,0DEH,00,67H
 	DB	78H,0DEH,00,47H,3EH,00,0C9H
 ;
 ;***************************************************
 ;
 ;Next is the actual DDSD working code which is to
 ; be automatically relocated to HIMEM and protected.
 ;
 ;	ORG	0001
 ;
 OFFSET	EQU	$
 ;
 	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	EXX
 	EX	AF,AF'
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 ;
 	CALL	48A2H
 	JP	Z,48C1H
 ;
 FLIP0	CALL	FLPTRK-OFFSET		;Flip track zero
 	EXX
 	EX	AF,AF'
 	CALL	48A2H
 	JP	Z,48C1H
 ;
 	LD	DE,0000H
 	CALL	45DBH
 	JP	Z,48BCH
 ;
 FLIP1	CALL	FLPTRK-OFFSET		;Flip track zero
 	LD	DE,0000H
 	CALL	45DBH
 	JP	48BCH		;Back to DOS
 ;
 ;
 FLPTRK	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	PUSH	IY
 	LD	IY,(42B9H)	;Adrs of current DCT
 	LD	A,(IY+07)
 	BIT	0,A		;00=>SD; 01=>DD
 	JR	Z,SKIPIT	;If 00, it is SD
 ;
 ;Bit 1 (IY+01) => Track zero reverse formatted.
 ;
 	XOR	02		;Flip track 00
 	LD	(IY+07),A
 SKIPIT	CALL	ZAP-OFFSET	;Call, Chk for ZAP
 	POP	IY
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 	RET
 ;
 ;The CALL  DDSDX allows another program to
 ; CALL DDSDX to alternate DD/SD
 ;
 DDSD	CALL	DDSDX-OFFSET
 	JP	460BH
 ;
 DDSDX	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	PUSH	IX
 ;
 	LD	IX,(42B9H)	;POINTER TO DCT Adrs
 	LD	A,(IX+07)	;Get density code
 	XOR	01		;FLIP DD - SD
 	LD	(IX+07),A
 	LD	A,(IX+06)
 	XOR	02		;Flip FC/FE (SD/DD)
 	LD	(IX+06),A
 ;
 ;In Mod II (427FH) contains current drive (Bits 0-3),
 ; Side Select (Bit 4), Write Precomp (Bit 5),
 ; Wait on DRQ (Bit 6), & SD/DD select (Bit 7 = 
 ; for DD; 0 for SD)
 ;
 	LD	A,(427FH)	;DD/SD code & drive
 	XOR	80H		;Flip BIT 7 for ADR
 	RES	5,A		;No write precomp
 	LD	(427FH),A
 ;
 	PUSH	BC
 	CALL	46F5H		;Restore
 	POP	BC
 ;
 ;
 ;Now all appropriate SD/DD bytes have been reversed.
 ; Move the DCT table as required.
 ;
 	LD	A,(IX+07)
 	BIT	0,A		;IF = 0, MAKE DD
 CONVDD	LD	HL,DR0DD-OFFSET		;Pointer setup
 	JR	NZ,ADR		;Make DD
 CONVSD	LD	HL,DR0SD-OFFSET	;Make SD
 ;
 ADR	LD	C,0AH		;Count 10 bytes
 	LD	DE,0000
 	LD	A,(427EH)	;Current drive
 	OR	A
 	JR	Z,DRV0
 	LD	B,A		;-OFFSET Drives (0 - 3)
 BUMP	LD	A,C		;C=0AH (10 count)
 	ADD	A,E
 	LD	E,A		;No carries; HL=42 alwys
 	DJNZ	BUMP
 	ADD	HL,DE		;Set HL as DCT pointer
 ;
 ;HL now points to current DCT block used by DDSD/CMD
 ;
 ;Change NEWDOS-82's PDRIVE DCTs in RAM
 ;
 DRV0	LD	BC,000AH	;Move 10 bytes
 	LD	DE,(42B9H)	;Replace DCT in RAM
 	PUSH	HL		;save pointer
 	DI
 	LDIR
 	LD	BC,0008H	;Move 8 bytes, DCT crnt
 	POP	HL		;Reset pointer
 	LD	DE,4280H	;Current DCT block
 	LDIR
 ;
 ZAPCK	CALL	ZAP-OFFSET		;Chk for ZAP & DIRCK
 ;
 	EI
 	POP	IX		;RESTORE REGS
 	POP	HL
 	POP	DE
 	POP	BC
 	RET
 ;
 ;
 ;CHECK FOR SUPERZAP PRESENCE
 ;
 ZAP	LD	A,(5EF9H)	;IF 4436H, ASSUME ZAP
 	CP	36H
 	JR	NZ,DIRCK
 	LD	A,(5EFAH)
 	CP	44H
 	JR	NZ,DIRCK
 	LD	HL,(4284H)	;Sectors/Trk
 	LD	(549BH),HL
 	RET
 ;
 ;CHECK FOR DIRCHECK PRESENCE
 ;
 DIRCK	PUSH	DE
 	LD	A,(5827H)
 	CP	36H
 	JR	NZ,OUTX
 	LD	A,(5828H)
 	CP	44H
 	JR	NZ,OUTX
 	LD	HL,(42B9H)	;Current DCT pointer
 	LD	DE,5260H
 	LD	BC,0008H
 	LDIR
 ;
 OUTX	POP	DE
 	RET
 ;
 ;
 SRCEND	NOP
 	DB	0ADH
 ;
 ;DR0DD TO DR3DD are DD PDRIVE code table values.
 ;
 DR0DD	DB	00,00,00,00,00,00,00,00,00,00
 DR1DD	DB	00,00,00,00,00,00,00,00,00,00
 DR2DD	DB	00,00,00,00,00,00,00,00,00,00
 DR3DD	DB	00,00,00,00,00,00,00,00,00,00
 ;
 ;DR0SD to DR3SD are SD PDRIVE code table values.
 ;
 DR0SD	DB	00,00,00,00,00,00,00,00,00,00
 DR1SD	DB	00,00,00,00,00,00,00,00,00,00
 DR2SD	DB	00,00,00,00,00,00,00,00,00,00
 DR3SD	DB	00,00,00,00,00,00,00,00,00,00
 ;
 HI	DB	0ADH
 ;
 	END	START
de table values.
 ;
 DR0SD	DB	00,00,00,00,00,00,00,00,00,00
 DR1SD	DB	00,00,00,00,00,00,00,00,00,00
