;COPYIT VERSION 1.5/48K MEM-SIZE.
; Assembled OK 30-Mar-85.
; ********************************************
; * COPYIT VERSION 1.5 (C) COPYRIGHT 19/4/82 *
; *      BY ZETA MICROCOMPUTER SOFTWARE      *
; *               NICK ANDREW.		     *
; ********************************************
;CHANGE LABELS TO CHANGE PROGRAM ORIGIN AND TABLE START.
;PROGST MUST BE AT LEAST 03E5 BYTES ABOVE START.
START	EQU	4400H	;START OF PROGRAM.
PROGST	EQU	4800H	;START OF PROGRAM TABLE.
;SUBSIDIARY LABELS...
TON	EQU	530	;TURN ON CASSETTE.
LEADER	EQU	662	;READ TAPE LEADER.
READ	EQU	565	;READ BYTE FROM TAPE.
TOFF	EQU	504	;TURN TAPE OFF.
WRLEDR	EQU	647	;WRITE TAPE LEADER.
WRITE	EQU	612	;WRITE BYTE TO TAPE.
GETKBD	EQU	0049H	;READ ONE KEY FROM KEYBOARD.
MESAGE	EQU	28A7H	;MESSAGE OUTPUT ROUTINE.
DELAY	EQU	0060H	;DELAY LOOP IN ROM.
VDUOUT	EQU	0033H	;PRINT CHARACTER TO DISPLAY.
KEYBUF	EQU	16444	;BUFFER USED BY GETKBD ROUTINE.
FLASH	EQU	022CH	;FLASH '*' TOP RIGHT OF SCREEN.
VIDEO	EQU	3C3DH	;NEAR TOP RIGHT OF SCREEN.
CR	EQU	0DH	;CARRIAGE RETURN CODE.
	ORG	15360
	DEFM	'SUPER COPIER (C) NICK ANDREW, 17/4/82'
	ORG	41E2H	;AUTO-START.
	JP	START
;COPYIT...
	ORG	START
	LD	SP,START-10	;SET UP STACK POINTER.
	LD	HL,06CCH
	PUSH	HL
	CALL	01C9H	;CLEAR SCREEN.
	LD	HL,TITLE
	PUSH	HL
	CALL	MESAGE	;PRINT TITLE.
	LD	HL,SOUR
	CALL	MESAGE	;PRINT 'SOURCE TAPE #'?
INPUT	CALL	GETKBD	;GET 1 KEY INPUT.
	CP	49
	JR	Z,TAPE2	;IF '1'
	CP	48
	JR	NZ,INPUT
	CALL	VDUOUT	;IF '0' THEN PRINT 0
	LD	A,15
	CALL	VDUOUT
	XOR	A
	LD	(START-1),A	;SET INPUT FROM TAPE 0.
	JR	PAST
TAPE2	CALL	VDUOUT	;IF '1' THEN PRINT 1
	LD	A,15
	CALL	VDUOUT
	LD	A,255
	LD	(START-1),A	;SET INPUT FROM TAPE 1.
PAST	LD	A,CR
	CALL	VDUOUT	;TO NEXT LINE.
	LD	HL,DEST
	CALL	MESAGE	;PRINT 'DESTINATION TAPE #'?
INPUT2	CALL	GETKBD
	CP	49
	JR	NZ,TAPE1	;IF NOT '1'
	CALL	VDUOUT
	LD	A,15
	CALL	VDUOUT
	LD	A,255
	LD	(START-2),A	;SET OUTPUT TO TAPE 1.
	JR	PASTA
TAPE1	CP	48
	JR	NZ,INPUT2
	CALL	VDUOUT
	LD	A,15
	CALL	VDUOUT
	XOR	A
	LD	(START-2),A	;SET OUTPUT TO TAPE 0.
PASTA	LD	A,CR
	CALL	VDUOUT
PAST2	LD	HL,MESS	;'HIT ANY KEY...'
	CALL	MESAGE
	XOR	A
	LD	(KEYBUF),A
	CALL	GETKBD
	CP	1
	JP	Z,06CCH	;IF 'BRK' THEN GO BACK TO BASIC.
	LD	A,(START-1)
	CALL	TON	;TURN ON APPROPRIATE CASSETTE.
	CALL	LEADER	;READ TAPE LEADER BYTES.
	CALL	READ	;READ 1 BYTE.
	CP	85
	JP	Z,SYSTEM	;IF A SYSTEM TAPE.
	CP	211
	JR	Z,HALF	;COULD BE EDTASM OR BASIC.
	CALL	TOFF	;BAD TAPE FORMAT: TURN OFF TAPE.
	LD	HL,NOTPR	;'BAD DATA ON TAPE...'
	CALL	MESAGE
	JR	PAST2	;START AGAIN.
HALF	CALL	READ
	CP	211
	JR	Z,BASIC	;BYTE 211 211 MEANS BASIC TAPE.
	LD	HL,VIDEO	;EDTASM TAPE.
	LD	(HL),'E'	;SHOW IT.
	LD	HL,PROGST
	LD	(HL),211
	LD	B,5
RNAME	INC	HL	;READ 6 CHAR NAME.
	LD	(HL),A
	CALL	READ
	DJNZ	RNAME
	INC	HL
	LD	(HL),A
NUMBA	LD	B,5
RNUMB	CALL	READ	;READ 5 CHAR LINE NUMBER.
	INC	HL
	LD	(HL),A
	CP	26
	JR	Z,FINIS1
	DJNZ	RNUMB
	CALL	FLASH	;FLASH '**'
TEXT	CALL	READ	;READ PROGRAM TEXT UNTIL CR.
	INC	HL
	LD	(HL),A
	CP	13
	JR	NZ,TEXT
	JR	NUMBA
FINIS1	LD	(START-4),HL	;SAVE DATA END IN MEMORY.
	LD	BC,0
	CALL	DELAY
	CALL	DELAY
	CALL	TOFF	;WAIT, TURN OFF TAPE.
	LD	HL,SOURCE	;'SOURCE TAPE...'
	CALL	MESAGE
XYZ	LD	HL,PROGST+1
	LD	B,6
PRINT	LD	A,(HL)	;PRINT NAME OF TAPE.
	INC	HL
	CALL	VDUOUT
	DJNZ	PRINT
	LD	HL,ENDNAM
	CALL	MESAGE
	JP	DECIDE
BASIC	LD	HL,VIDEO	;LOAD A BASIC TAPE.
	LD	(HL),'B'
	LD	HL,PROGST
	LD	(HL),211	;POKE IN TWO 211 BYTES.
	INC	HL
	LD	(HL),211
	INC	HL
	CALL	GETBYT	;READ LAST 211 BYTE.
	CALL	GETBYT	;READ 1 CHAR PROGRAM NAME.
TIXT	CALL	GETBYT
	CP	0
	JR	Z,ZERO	;IF 1 ZERO GO
GO2	CALL	GETBYT
LOOP2	CALL	GETBYT	;READ CHARS UNTIL 0 (END LINE).
	CP	0
	JR	NZ,LOOP2
	CALL	FLASH	;FLASH '**' NEXT LINE OF BASIC.
	JR	TIXT
ZERO	CALL	GETBYT
	CP	0
	JR	NZ,GO2	;IF NEXT BYTE NOT ZERO GO BACK.
	DEC	HL	;END OF PROGRAM.
	LD	(START-4),HL	;SAVE END PROGRAM
	LD	BC,0		;IN MEMORY.
	CALL	DELAY
	CALL	DELAY
	CALL	TOFF	;TURN OFF CASSETTE.
	LD	HL,BASICT
	CALL	MESAGE
	LD	A,(PROGST+3)
	CALL	VDUOUT
	LD	HL,ENDNAM
	CALL	MESAGE
	JR	DECIDE
SYSTEM	LD	HL,VIDEO	;LOAD A SYSTEM TAPE.
	LD	(HL),'S'
	LD	HL,PROGST
	LD	(HL),A
	INC	HL
	LD	B,6
LOOP4	CALL	GETBYT	;READ A 6 CHAR NAME.
	DJNZ	LOOP4
LOOP6	CALL	GETBYT	;READ FUNCTION KEY.
	CP	120
	JR	Z,GETOUT
	CALL	GETBYT	;READ BLOCK LENGTH.
	LD	B,A
	CALL	GETBYT	;READ LOW THEN HIGH BYTES
			;OF BLOCK START ADDRESS.
	CALL	GETBYT
LOOP5	CALL	GETBYT	;READ CONTENTS OF BLOCK.
	DJNZ	LOOP5
	CALL	GETBYT
	CALL	FLASH	;FLASH '**'
	JR	LOOP6
GETOUT	CALL	GETBYT	;READ LOW THEN HIGH BYTES
			;OF ENTRY ADDRESS.
	CALL	READ
	LD	(HL),A
	LD	(START-4),HL	;SAVE PROGRAM END
	LD	BC,0		;IN MEMORY.
	CALL	DELAY
	CALL	DELAY
	CALL	TOFF
	LD	HL,SYSTAP	;'SYSTEM TAPE...'
	CALL	MESAGE
	JP	XYZ
DECIDE	LD	HL,DEC	;'HIT SPACE TO COPY...'
	CALL	MESAGE
	XOR	A
	LD	(KEYBUF),A
	CALL	GETKBD
	CP	32
	JP	NZ,PAST2	;IF NOT SPACE THEN ABORT.
	LD	A,(START-2)
	CALL	TON	;TURN ON OUTPUT CASSETTE.
	LD	BC,0
	CALL	DELAY
	CALL	DELAY	;GET MOTOR UP TO SPEED.
	CALL	WRLEDR	;WRITE TAPE LEADER.
	LD	HL,(START-4)
	INC	HL
	LD	DE,PROGST
	OR	A
	SBC	HL,DE
	PUSH	HL
	POP	BC	;FIND OUT LENGTH OF PROGRAM
	LD	HL,PROGST
LOOP3	LD	A,(HL)	;OUTPUT PROGRAM TO TAPE.
	INC	HL
	DEC	BC
	CALL	WRITE
	LD	A,B
	OR	C
	JR	NZ,LOOP3
	XOR	A
	CALL	0261H	;WRITE 4 ZEROES TO TAPE.
	CALL	0261H
	LD	BC,0
	CALL	DELAY
	CALL	DELAY
	CALL	TOFF	;TURN OFF CASSETTE.
	LD	HL,WRITEN	;'WRITE COMPLETED...'
	CALL	MESAGE
	JP	PAST2
GETBYT	CALL	READ
	LD	(HL),A
	INC	HL
	RET
;MESSAGE TABLE START...
TITLE	DEFM	'<COPYIT> SUPER COPIER VERSION 1.5 COPYRIGHT 19/4/82'
	DEFB	CR
	DEFM	'BY NICK ANDREW.'
	DEFB	CR
	DEFB	CR
	DEFB	0
SOUR	DEFM	'SOURCE TAPE UNIT NO. (0 OR 1)? '
	DEFB	14
	DEFB	0
DEST	DEFM	'DESTINATION TAPE UNIT NO. (0 OR 1)? '
	DEFB	14
	DEFB	0
MESS	DEFB	CR
	DEFM	'HIT ANY KEY TO LOAD PROGRAM'
	DEFB	CR
	DEFM	'OR <BREAK> TO RETURN TO BASIC.'
	DEFB	CR
	DEFB	CR
	DEFB	0
NOTPR	DEFM	'** DATA ON TAPE NOT BASIC, SOURCE OR OBJECT CODE!! **'
	DEFB	CR
	DEFB	CR
	DEFB	0
SOURCE	DEFM	'EDTASM SOURCE TAPE: NAME IS <'
	DEFB	0
ENDNAM	DEFM	'>.'
	DEFB	CR
	DEFB	0
WRITEN	DEFM	'TAPE WRITE COMPLETED.'
	DEFB	CR
	DEFB	0
BASICT	DEFM	'BASIC TAPE: NAME IS <'
	DEFB	0
DEC	DEFM	'HIT <SPACEBAR> TO COPY PROGRAM'
	DEFB	CR
	DEFM	'OR ANY OTHER KEY TO ABORT WRITE.'
	DEFB	CR
	DEFB	0
SYSTAP	DEFM	'SYSTEM TAPE: NAME IS <'
	DEFB	0
	DEFB	0
	END	0674H
              