;ULCNVRT BY ROD STEVENSON 22ND MARCH, 1986
;TO CONVERT UPPER CASE TO LOWER CASE
;   LEAVING STAND ALONE I
;
	ORG	5200H
OPEN	EQU	4424H	;opens file
CLOSE	EQU	4428H	;closes file
READ	EQU	4436H	;reads file
CKEOF	EQU	4458H	;(MODEL1=444B) checks end of file
INBUF$	EQU	4225H	;(MODEL1=4318) keyboard input buffer
REW	EQU	443FH	;points to start of file
WRITE	EQU	4439H	;writes file
FSPEC	EQU	441CH	;transfers filename input
DSPLY	EQU	4467H	;displays message on screen
BUFFER	EQU	6000H	;memory for data read in
DOS	EQU	402DH	;DOS entry point
;
;get filename, create FCB, open file
	LD	HL,INBUF$+8	;keyboard input buffer
	LD	DE,FCB		;file area in memory
	CALL	FSPEC		;transfer filename
	JP	NZ,ERROR	;test for valid name
	LD	HL,BUFFER	;data area in memory
	LD	B,0		;zero counter
	PUSH	BC		;save counter
	CALL	OPEN
	JP	NZ,ERROR	;check it was opened
;
;read whole file into memory
LOOP	CALL	READ		;read one sector
	JP	NZ,ERROR	;check it was read
	POP	BC		;get counter and
	INC	B		;   increment it for
	PUSH	BC		;   each file read
	LD	DE,FCB		;check to see if any 
	CALL	CKEOF		;   more sectors to read
	PUSH	AF		;save flags from check
	LD	HL,(FCB+3)	;increment data memory
	INC	H		;   ready for next sector
	LD	(FCB+3),HL	;to be read from file
	POP	AF		;get flags from check
	LD	DE,FCB
	JR	Z,LOOP		;keep reading sectors
;
;calculate total amount of memory filled by reads
	POP	BC		;get count of sectors
	PUSH	BC		;save it again
	LD	HL,BUFFER	;add number of sectors
	ADD	HL,BC		;   of 256 bytes to start
	LD	A,H		;   of data buffer 
	LD	(ENDBUF),A	;   and save it
;
;************************** END OF READ-IN *******************
;
	LD	HL,BUFFER	;start of file in memory
REPT	CALL	CKFIN		;check if at end of file
;
CHEKCR	CP	13		;check for CR 
	JR	NZ,SPACE	
CRSKIP	CALL	CKFIN		;skip past CR till next
	CP	5BH		;    ASCII character A-Z
	JR	NC,CRSKIP	;    & don't change it
	CP	40H
	JR	C,CRSKIP
	JR	REPT
;
SPACE	CP	' '		;check for space
	JR	NZ,STOP
	CALL	CKFIN
TSTI	CP	'I'		;check for I after space
	JR	NZ,SPACE
	CALL	CKFIN
	CP	' '		;    but don't change if
	JR	Z,SPACE		;    it is in a word
	CP	'.'
	JR	Z,STOP
	DEC	HL
	LD	A,(HL)
	JR	CHANGE
;
STOP	CP	'.'		;check for full stop
	JR	NZ,GENRAL
STOPSP	CALL	CKFIN
	CP	' '		;    & skip spaces after
	JR	Z,STOPSP
	CP	13		;    & check for CR
	JR	Z,CHEKCR
	JR	REPT
;
GENRAL	CP	5BH		;check for ASCII A-Z
	JR	NC,REPT
	CP	40H
	JR	C,REPT
CHANGE	ADD	A,20H		;    & change to l/c
	LD	(HL),A		;    & write to file
	JR	REPT
;
CKFIN	INC	HL		;get next character
	LD	A,(HL)
	CP	0		;    & check if end
	RET	NZ
	POP	HL		;equalise stack at end
;
;*************************** END OF SPECIFICS **************
;
;when whole file is done, re-write to disk
FINISH	POP	BC		;get sector count
	LD	DE,FCB
	CALL	REW		;start from first sector
	LD	HL,BUFFER	;   and write it to disk
	JP	NZ,ERROR	;check it was written
	LD	DE,FCB		;   and continue till all
	LD	(FCB+3),HL	;   sectors written
WRTLP	CALL	WRITE
	JP	NZ,ERROR
	LD	DE,FCB
	LD	HL,(FCB+3)
	INC	H
	LD	(FCB+3),HL
	LD	DE,FCB
	DJNZ	WRTLP
;
;when re-written, close file and return to DOS
	LD	DE,FCB
	CALL	CLOSE
	JP	NZ,ERROR
	JP	DOS
;
ERROR	LD	HL,ERRMSG	;gives same error message
	CALL	DSPLY		;   whatever the cause,
	JP	4030H		;   likely bad name
;
ERRMSG	DEFM	10,10,10,'YOU HAVE MADE AN ERROR!!!!!!!!!!!!',10,10
	DEFM	'Correct syntax is:',10,'ULCNVRT xxxxxxxx/xxx where xxxxxxxx/xxx is filename to change',10,10,13
;
FCB	DS	32		;space allocated for FCB
ENDBUF	DS	1		;store total memory used
	END	5200H
  