TIMEQM ; #######################################################
 ; MACHINE LANGUAGE CLOCK PROGRAM FOR MSM5832 CLOCK BOARD
 ; ATTACHED TO THE TRS-80 AT ADDRESS 14288 TO 14300, USING
 ; THE "TIME$" FUNCTION.  THIS ROUTINE IS TRANSPARENT TO
 ; BUT IS NOT CALLED BY THE CUSTOM INTERPRETER.  HENCE,
 ; IT OPERATES INDEPENDENTLY FROM THE INTERPRETER PATCH.
 ; #######################################################
 ;
 	ORG	7E00H		; CHANGE TO RELOCATE
 ;
 ; #######################################################
 ; PATCH INTO DOS TIME$ ERROR LOCATION AND CHANGE IT
 ; #######################################################
 ;
 ENTRY	LD	HL,START1	; START OF TIME$ PROGRAM
 	LD	(4177H),HL	; PATCH TIME$ ?L3 ERROR
 	LD	HL,START2	; START OF "CMD" PROGRAM
 	LD	(4174H),HL	; PATCH CMD ?L3 ERROR
 	JP	06CCH		; BACK TO A BASIC "READY"
 ;
 ; #######################################################
 ; THIS IS THE BEGINNING OF TH "TIME$" PATCH TO READ TIME.
 ; ROUTINE INTERCEPTS ?L3 ERROR AND CHECKS LINE'S SYNTAX.
 ; #######################################################
 ;
 START1	RST	10H		; BASIC HOUSEKEEPING
 	PUSH	HL		; SAVE BASIC LINE POINTER
 	LD	A,18H		; LENGTH OF TIME$
 	CALL	2857H		; ROM STRING SPACE SETUP
 ;
 ; #######################################################
 ; SET UP RAM SPACE AND GET CLOCK CHIP READY TO READ TIME
 ; #######################################################
 ;
 	LD	HL,(40D4H)	; LOCATION TO STORE TIME$
 	LD	IY,37D0H	; CLOCK MEMORY ADDRESS
 	LD	(IY+3),90H	; SET UP 8255 CHIP PORTS
 	CALL	DELAY		; WAIT FOR SLOW MSM5832
 	LD	(IY+2),20H	; SET UP CLOCK TO READ
 	CALL	DELAY		; WAIT FOR SLOW MSM5832
 ;
 ; #######################################################
 ; CLOCK IS READY TO READ ... NOW READ AND CREATE STRING.
 ; DAY OF THE WEEK IS ALPHABETIC AND WILL BE DONE FIRST.
 ; #######################################################
 ;
 	LD	(IY+1),6	; POINT TO DAY OF WEEK
 	CALL	DELAY		; WAIT FOR SLOW MSM5832
 	LD	A,(IY+0)	; GET DUMMY VALUE INTO A
 	CALL	DELAY		; WAIT FOR SLOW CHIP (!)
 	LD	A,(IY+0)	; GET DAY OF WEEK VALUE
 	AND	07H		; MASK OFF UNUSED BITS
 	LD	DE,TABLE	; POINT DE TO DAY TABLE
 	INC	A		; IT MUST BE AT LEAST 1
 LOOP1	DEC	A		; IS ACCUMULATOR ZERO?
 	JR	Z,XLOOP		; GO OUT OF TABLE LOOP
 	LD	B,3		; NUMBER OF CHARS PER DAY
 LOOP2	INC	DE		; MOVE PAST EACH CHAR
 	DJNZ	LOOP2		; DO IT TILL AT NEXT DAY
 	JR	LOOP1		; CHECK FOR NEXT DAY
 ;
 ; #######################################################
 ; VALUE FOR DAY IS FOUND ... NOW TURN IT INTO LETTERS
 ; #######################################################
 ;
 XLOOP	LD	B,3		; NUMBER OF CHARS TO GET
 YLOOP	LD	A,(DE)		; CHARACTER TO TRANSFER
 	LD	(HL),A		; XFER DAY NAME TO TIME$
 	INC	HL		; NEXT LOCATION IN TIME$
 	INC	DE		; NEXT LOCATION IN TABLE
 	DJNZ	YLOOP		; LOOP BACK FOR NEXT CHAR
 	LD	(HL),20H	; PUT SPACE AFTER DAY
 	INC	HL		; BUMP TIME BUFFER AGAIN
 ;
 ; #######################################################
 ; DAY OF WEEK IS DONE ... NOW GET MONTH, DAY, AND YEAR
 ; #######################################################
 ;
 	LD	E,30H		; HEX TO ASCII DIFFERENCE
 	LD	D,11		; MONTH HI PORT + 1
 	LD	B,2FH		; SLASH ("/") CHARACTER
 	LD	C,0FH		; MASK UNUSED PORT BITS
 	CALL	FILLER		; GET MONTH HIGH VALUE
 	CALL	FILLER		; GET MONTH LOW VALUE
 	LD	(HL),B		; LOAD SLASH INTO TIME$
 	INC	HL		; BUMP TIME BUFFER BY ONE
 	LD	C,3		; MASK UNUSED CLOCK BITS
 	CALL	FILLER		; GET DAY HIGH VALUE
 	LD	C,0FH		; MASK UNUSED CLOCK BITS
 	CALL	FILLER		; GET DAY LOW VALUE
 	LD	(HL),B		; PUT SLASH INTO TIME$
 	INC	HL		; BUMP TIME BUFFER BY ONE
 	LD	D,13		; YEAR HIGH VALUE + 1
 	CALL	FILLER		; GET YEAR HIGH VALUE
 	CALL	FILLER		; GET YEAR LOW VALUE
 	LD	(HL),20H	; VALUE FOR A SPACE
 	INC	HL		; BUMP TIME BUFFER BY ONE
 ;
 ; #######################################################
 ; MONTH, DAY, YEAR DONE - NOW GET HOURS, MINUTES, SECONDS
 ; #######################################################
 ;
 	LD	D,5		; HOURS HIGH VALUE
 	LD	(IY+1),D	; SET UP CLOCK CHIP PORT
 	CALL	DELAY		; DELAY FOR 8255 CHIP
 	LD	A,(IY+0)	; DUMMY VALUE INTO ACC.
 	CALL	DELAY		; DELAY AGAIN FOR CHIP!
 	LD	A,(IY+0)	; GET HOURS HIGH VALUE
 	PUSH	AF		; SAVE THIS FOR AM/PM
 	INC	D		; ACCOMMODATE SUBROUTINE
 	LD	C,3		; MASK UNUSED CLOCK BITS
 	CALL	FILLER		; GET HOURS HIGH VALUE
 	LD	C,0FH		; MASK UNUSED CLOCK BITS
 	CALL	FILLER		; GET HOURS LOW VALUE
 	LD	(HL),3AH	; PUT A COLON IN TIME$
 	INC	HL		; BUMP THE STRING ALONG
 	LD	B,2		; NUMBER MINUTE/SEC LOOPS
 MINSEC	CALL	FILLER		; GET,CONVERT,SAVE VALUE
 	CALL	FILLER		; GET,CONVERT,SAVE VALUE
 	LD	(HL),3AH	; VALUE FOR A COLON
 	INC	HL		; BUMP TIME BUFFER BY ONE
 	DJNZ	MINSEC		; GO BACK FOR MIN/SEC
 	DEC	HL		; BACK UP TO LAST COLON
 	LD	(HL),20H	; CHANGE TO STRING END
 ;
 ; #######################################################
 ; HOURS, MINUTES, SECONDS ARE DONE ... NOW FIGURE AM/PM
 ; #######################################################
 ;
 	INC	HL		; BUMP TIME BUFFER BY ONE
 	POP	AF		; GET BACK HOUR HI VALUE
 	BIT	2,A		; CHECK AM/PM INDICATOR
 	JR	Z,MORNNG	; MORNING IF BIT 2 = 0
 	LD	(HL),50H	; PUT LETTER "P" IN PLACE
 	JR	NEXT		; JUMP PAST LETTER A
 MORNNG	LD	(HL),41H	; PUT LETTER "A" IN PLACE
 NEXT	INC	HL		; BUMP TIME BUFFER BY ONE
 	LD	(HL),4DH	; PUT LETTER "M" IN PLACE
 	JP	2884H		; BACK TO BASIC ACTIVITY
 ;
 ; #######################################################
 ; THIS IS THE BEGINNING OF THE "CMD" PATCH TO SET TIME
 ; CHECK FOR TIME SETTING PARAMETERS AND SYNTAX
 ; #######################################################
 ;
 START2	LD	A,(HL)		; CHAR AT LINE POINTER
 	CP	22H		; IS IT A QUOTE MARK?
 	JP	NZ,1997H	; ?SN ERROR IF NO QUOTE
 	INC	HL		; BUMP LINE PTR. BY ONE
 	PUSH	HL		; SAVE THE LINE POINTER
 	LD	DE,TABLE	; GET TABLE OF DAY NAMES
 	LD	C,0		; THIS WILL BE COUNTER
 DYLOOP	LD	B,3		; NUMBER OF CHARS IN DAY
 	POP	HL		; GET LINE POINTER BACK
 	PUSH	HL		; SAVE AGAIN FOR LOOP USE
 FINDIT	LD	A,(DE)		; GET 1ST CHAR OF STRING
 	AND	A		; EASY WAY TO SET A FLAG
 	JR	Z,ERROR1	; VALUE = 0 ... ?SN ERROR
 	CP	(HL)		; CHECK IT AGAINST TABLE
 	JR	Z,GOTONE	; GET READY FOR NEXT CHAR
 LOOP4	INC	DE		; RUN PAST VALUES FOR DAY
 	DJNZ	LOOP4		; BY RUNNING B TO ZERO
 	INC	C		; NEXT DAY - BUMP COUNTER
 	JR	DYLOOP		; BACK TO NEXT DAY LOOP
 ERROR1	POP	HL		; CLEAR STACK OF HL REG.
 ERROR2	JP	1997H		; GO TO ?SN ERROR MESSAGE
 GOTONE	INC	HL		; GET NEXT CHAR FROM LINE
 	INC	DE		; BUMP TABLE VALUE ALONG
 	DJNZ	FINDIT		; KEEP GOING TILL DONE
 ;
 ; #######################################################
 ; NUMERICAL VALUE FOR DAY IS IN C - PUT IT IN MSM5832
 ; #######################################################
 ;
 	POP	AF		; CLEAR STACK OF HL VALUE
 	LD	(IY+3),80H	; SET UP 8255 TO WRITE
 	CALL	DELAY		; THAT #&!*% SLOW MSM5832
 	LD	(IY+2),50H	; CLOCK CHIP WRITE VALUE
 	CALL	DELAY		; HOW SLOW IS IT?!?
 	LD	A,C		; GET DAY OF WEEK VALUE
 	LD	(IY+1),6	; READY TO WRITE DAY
 	CALL	DELAY		; WAIT (YAWN) TO WRITE
 	LD	(IY+0),A	; WRITE DAY TO CLOCK
 ;
 ; #######################################################
 ; DAY IS WRITTEN - FIND MONTH, DAY, YEAR AND WRITE THEM
 ; #######################################################
 ;
 	LD	D,11		; VALUE FOR MONTH + 1
 	CALL	TIMSET		; WRITE MONTH TO CLOCK
 	CALL	TIMSET		; WRITE DAY TO CLOCK
 	LD	D,13		; VALUE FOR YEAR +1
 	CALL	TIMSET		; WRITE YEAR TO CLOCK
 	LD	D,5		; SET TO HOURS HIGH VALUE
 	CALL	AMORPM		; WRITE HOURS TO CLOCK
 	CALL	TIMSET		; WRITE MINUTES TO CLOCK
 	LD	B,4		; NUMBER OF CHARS LEFT
 SNEAK	INC	HL		; BUMP LINE POINTER
 	DJNZ	SNEAK		; LOOP PAST "PM" & QUOTES
 	RET			; BACK TO BASIC PROGRAM
 ;
 ; #######################################################
 ; CHECK FOR AM OR PM INDICATION AND WRITE THAT VALUE
 ; #######################################################
 ;
 AMORPM	INC	HL		; BUMP LINE TO NEXT CHAR.
 	PUSH	HL		; SAVE CURRENT LINE PTR.
 	PUSH	DE		; SAVE OTHER VALUES IN DE
 	LD	DE,6		; HOW MANY SPACES TO MOVE
 	ADD	HL,DE		; FIND AM OR PM IN LINE
 	LD	A,(HL)		; GET CHARACTER FROM LINE
 	CP	41H		; SET FLAG IF CHAR. = "A"
 	LD	A,4		; GET PM INDICATOR READY
 	JR	NZ,EVENNG	; ZERO FLAG NOT SET IF PM
 	XOR	A		; CLEAR PM INDICATOR 
 EVENNG	POP	DE		; RESTORE VALUES TO DE
 	POP	HL		; GET ORIGINAL LINE PTR.
 	LD	B,2		; SET UP B AS TIMSET LOOP
 	LD	C,A		; SAVE AM/PM INDICATOR
 	LD	A,(HL)		; GET VALUE FROM LINE
 	SUB	30H		; STRIP ASCII MASK
 	JR	C,ERROR1	; ERROR IF LESS THAN 0
 	ADD	A,C		; ADD AM/PM BIT TO VALUE
 	JP	MIDDLE		; SUBROUTINE FINISHES JOB
 ;
 ; #######################################################
 ; TIME SETTING SUBROUTINE CHECKS LINE FOR SYNTAX
 ; #######################################################
 ;
 TIMSET	LD	E,30H		; CONVERTS ASCII TO HEX
 	LD	B,2		; LOOP TWICE FOR 2 DIGITS
 ZLOOP	DEC	D		; BUMP CLOCK ADDRESS PORT
 	INC	HL		; GET NEXT CHAR FROM LINE
 	LD	A,(HL)		; MOVE IT TO ACC. TO TEST
 	SUB	E		; STRIP OFF ASCII VALUE
 	JR	C,ERROR1	; ERROR IF LESS THAN 0
 MIDDLE	CP	0AH		; CHECK IF GREATER THAN 9
 	JR	NC,ERROR1	; ERROR IF GREATER THAN 9
 	LD	(IY+1),D	; OPEN PORT TO CLOCK
 	CALL	DELAY		; THE USUAL CMOS WAIT
 	LD	(IY+0),A	; WRITE VALUE TO CLOCK
 	CALL	DELAY		; WAIT! WAIT! WAIT!!!!!
 	DJNZ	ZLOOP		; DO IT FOR 2 DIGITS
 	INC	HL		; BUMP PAST / : OR SPACE
 	RET			; BACK TO MAIN PROGRAM
 ;
 ; #######################################################
 ; GET VALUE, CONVERT TO ASCII, AND SAVE IN TIME$ BUFFER
 ; #######################################################
 ;
 FILLER	DEC	D		; BUMP CLOCK PORT ADDRESS
 	LD	(IY+1),D	; POINT TO VALUE WANTED
 	CALL	DELAY		; THAT OL' SLOW MSM5832
 	LD	A,(IY+0)	; GET DUMMY VALUE INTO A
 	CALL	DELAY		; WAIT AGAIN! SLOW CHIP
 	LD	A,(IY+0)	; NOW GET VALID VALUE
 	AND	C		; MASK UNUSED BITS
 	ADD	A,E		; MAKE IT AN ASCII VALUE
 	LD	(HL),A		; PUT VALUE INTO BUFFER
 	INC	HL		; NEXT BUFFER POSITION
 	RET			; BACK TO MAIN PROGRAM
 ;
 ; #######################################################
 ; THIS IS A SETUP WHICH CALLS A DELAY SUBROUTINE IN ROM
 ; #######################################################
 ;
 DELAY	PUSH	BC		; SAVE BC REGISTER PAIR
 	PUSH	AF		; SAVE AF REGISTER PAIR
 	LD	BC,1		; DELAY FOR MSM5832 CHIP
 	CALL	0060H		; HERE IS ROUTINE IN ROM
 	POP	AF		; GET AF REGISTERS BACK
 	POP	BC		; GET BC REGISTERS BACK
 	RET			; BACK TO MAIN PROGRAM
 ;
 ; #######################################################
 ; THIS IS THE LOOKUP TABLE OF DAYS OF THE WEEK
 ; #######################################################
 ;
 TABLE	DEFM	'MON'
 ;
 	DEFM	'TUE'
 ;
 	DEFM	'WED'
 ;
 	DEFM	'THU'
 ;
 	DEFM	'FRI'
 ;
 	DEFM	'SAT'
 ;
 	DEFM	'SUN'
 ;
 	DEFB	0
 ;
 ; #######################################################
 	END	ENTRY
 ; #######################################################
