TIMEQI ; #######################################################
 ; THIS ROUTINE WILL USE THE ONE-SECOND INTERRUPT CREATED
 ; BY A HARDWARE ADDITION TO DO TIMEKEEPING.  THIS IS
 ; TRANSPARENT TO BASIC.  NOTE THAT THIS IS NOT INCLUDED
 ; IN THE SLASH (/) FUNCTIONS CALLED BY THE CUSTOM
 ; INTERPRETER, AND THUS RETURNS ON ITS OWN TO BASIC ROM.
 ; #######################################################
 ;
 	ORG	7EC0H		; CHANGE TO RELOCATE
 ;
 ; #######################################################
 ; PATCH INTO DOS TIME$ ERROR LOCATION AND CHANGE IT
 ; #######################################################
 ;
 ENTRY	DI			; DISABLE ACTIVE INTRPTS.
 	LD	HL,START1	; ENTRY OF TIME$ PROGRAM
 	LD	(4177H),HL	; REPLACE ?L3 ERROR MSG.
 	LD	HL,START2	; START OF "CMD" PROGRAM
 	LD	(4174H),HL	; REPLACE ?L3 ERROR MSG.
 	LD	A,0C3H		; GET "JUMP" COMMAND 
 	LD	(4012H),A	; INSERT INT. PATCH POINT
 	LD	HL,SERVE	; INTERRUPT SERV. ROUTINE
 	LD	(4013H),HL	; INT. PATCH FROM 0038H
 	IM	1		; SET INTERRUPT MODE #1
 	EI			; ENABLE INTERRUPT LINE
 	JP	06CCH		; RETURN TO BASIC "READY"
 ;
 ; #######################################################
 ; PATCH TO INTERCEPT ?L3 ERROR AND CHECK LINE'S SYNTAX
 ; #######################################################
 ;
 START1	RST	10H		; HOUSEKEEP SPACE, ETC.
 	PUSH	HL		; SAVE BASIC LINE POINTER
 	LD	A,11H		; LENGTH OF TIME$ ITSELF
 	CALL	2857H		; ROM STRING SPACE SETUP
 	LD	HL,(40D4H)	; LOCATION TO FIND TIME$
 	LD	DE,SECOND+2	; POINT DE TO HOURS POS'N
 	CALL	DISPLY		; CONVERT, PLACE IN TIME$
 	LD	(HL),3AH	; PUT COLON INTO TIME$
 	INC	HL		; BUMP TIME$ POINTER
 	DEC	DE		; SET DE TO MINS. POS'N
 	CALL	DISPLY		; CONVERT, PLACE IN TIME$
 	LD	(HL),3AH	; PUT COLON INTO TIME$
 	INC	HL		; BUMP TIME$ POINTER
 	DEC	DE		; SET DE TO SECS. POS'N
 	CALL	DISPLY		; CONVERT, PLACE IN TIME$
 	LD	(HL),20H	; PUT SPACE INTO TIME$
 	INC	HL		; BUMP TIME$ POINTER
 	LD	DE,SECOND+4	; POINT DE TO MON. POS'N
 	CALL	DISPLY		; CONVERT, PLACE IN TIME$
 	LD	(HL),2FH	; PUT SLASH INTO TIME$
 	INC	HL		; BUMP TIME$ POINTER
 	DEC	DE		; SET DE TO DAYS POS'N
 	CALL	DISPLY		; CONVERT, PLACE IN TIME$
 	LD	(HL),2FH	; PUT SLASH INTO TIME$
 	INC	HL		; BUMP TIME$ POINTER
 	LD	DE,SECOND+5	; POINT DE TO YEARS POS'N
 	CALL	DISPLY		; CONVERT, PLACE IN TIME$
 	JP	2884H		; FINISH DISPLAY IN ROM
 ;
 ; #######################################################
 ; FIND VALUES IN TIME LOCATIONS AND CONVERT TO ASCII
 ; #######################################################
 ;
 DISPLY	LD	A,(DE)		; GET VALUE INTO ACCUM.
 	CALL	NIBBLE		; SEPARATE INTO 4 BITS
 	LD	B,A		; VALUE INTO B FOR TEST
 	XOR	A		; CLEAR A FOR USE IN LOOP
 	INC	B		; DUMMY INCREMENT ...
 LOOP	DEC	B		; DECREMENT TO TEST FOR 0
 	JR	Z,LEAVE		; UPPER NIBBLE NOW AT 0
 	ADD	A,16H		; A=A+16 ...HEX-DEC CONV.
 	DAA			; DEC.ADJ.: 16 BECOMES 10
 	JR	LOOP		; LOOP TILL CONV. DONE
 LEAVE	LD	B,A		; SAVE VALUE BACK IN B
 	LD	A,C		; GET LOW NIBBLE BACK
 	CP	0AH		; IS IT GREATER THAN 10?
 	JR	C,CLEAN		; NO WORK IF LESS THAN 10
 	SUB	0AH		; REDUCE IT TO 0 THRU 5
 	ADD	A,10H		; NOW ADD CARRY BIT
 CLEAN	ADD	A,B		; CREATE A DECIMAL RESULT
 	DAA			; DEC. ADJ. THE TOTAL
 	CALL	NIBBLE		; SEPARATE INTO 4 BITS
 	ADD	A,30H		; CONVERT NIBBLE TO ASCII
 	LD	(HL),A		; PLACE VALUE INTO TIME$
 	INC	HL		; BUMP TIME$ PTR. BY ONE
 	LD	A,C		; GET VALUE SAVED IN C
 	ADD	A,30H		; CONVERT NIBBLE TO ASCII
 	LD	(HL),A		; PLACE VALUE INTO TIME$
 	INC	HL		; BUMP TIME$ PTR. BY ONE
 	RET			; BACK TO DO PUNCTUATION
 ;
 ; #######################################################
 ; SUBROUTINE TO CONVERT A BYTE AND SAVE IT AS TWO NIBBLES
 ; #######################################################
 ;
 NIBBLE	PUSH	AF		; SAVE THE BYTE BRIEFLY
 	AND	0FH		; MASK OUT THE HIGH BITS
 	LD	C,A		; SAVE LOW NIBBLE IN C
 	POP	AF		; GET THE WHOLE BYTE BACK
 	RRA			; MOVE THE BYTE RIGHT...
 	RRA			; ... TWO PLACES ...
 	RRA			; ... THREE PLACES ...
 	RRA			; UNTIL MSB BECOMES LSB
 	AND	0FH		; MASK OUT THE HIGH BITS
 	RET			; NIBBLES NOW IN A & C
 ;
 ; #######################################################
 ; INTERRUPT SERVICE ROUTINE IS ENTERED AT 1-S CLOCK PULSE
 ; #######################################################
 ;
 SECOND	EQU	4041H		; LOCATION TO STORE TIME$
 SERVE	DI			; DON'T BOTHER ME NOW!
 	PUSH	AF		; SAVE ACCUM. & FLAGS
 	PUSH	HL		; SAVE HL REGISTER PAIR
 	PUSH	DE		; SAVE DE REGISTER PAIR
 	LD	A,(SECOND+4)	; GET CURRENT MONTH VALUE
 	LD	E,A		; SAVE MONTH VALUE IN E
 	LD	D,0		; LET D=0. REASON FOLLOWS
 	LD	HL,SECOND	; START AT SECONDS POS'N.
 	INC	(HL)		; SECONDS = SECONDS + 1
 	LD	A,(HL)		; GET READY TO COMPARE
 	CP	60D		; IS IT 60 SECONDS?
 	JR	C,OUT		; DONE IF NOT 60 SECONDS
 	CALL	TICTOC		; ADVANCE TIME SUBROUTINE
 	CP	60D		; IS IT 60 MINUTES?
 	JR	C,OUT		; DONE IF NOT 60 MINUTES
 	CALL	TICTOC		; ADVANCE TIME SUBROUTINE
 	CP	24D		; IS IT 24 HOURS?
 	JR	C,OUT		; DONE IF NOT 24 HOURS
 	CALL	TICTOC		; ADVANCE TIME SUBROUTINE
 	PUSH	HL		; SAVE REGISTER BRIEFLY
 	LD	HL,LOOKUP	; DAYS-IN-MONTH TABLE
 	ADD	HL,DE		; REMEMBER DE?  SEE ABOVE
 	CP	(HL)		; IS IT LAST DAY OF MONTH
 	POP	HL		; GET REGISTER BACK NOW
 	JR	C,OUT		; DONE IF NOT LAST DAY
 	CALL	TIKTOK		; ADVANCE DATE SUBROUTINE
 	CP	13D		; IS IT 12 MONTHS?
 	JR	C,OUT		; DONE IF NOT 12 MONTHS
 	CALL	TIKTOK		; ADVANCE DATE SUBROUTINE
 OUT	POP	DE		; RESTORE DE REGISTERS
 	POP	HL		; RESTORE HL REGISTERS
 	POP	AF		; RESTORE ACCUM. & FLAGS
 	EI			; GET CLOCK TICKING AGAIN
 	RETI			; BACK FROM THE INTERRUPT
 ;
 ; #######################################################
 ; ADVANCE TIME/DATE & RETRIEVE NEW VALUE SUBROUTINES
 ; #######################################################
 ;
 TICTOC	XOR	A		; CLEAR ACCUM. TO ZERO
 FINISH	LD	(HL),A		; HRS, MIN, OR SEC = 0
 	INC	HL		; MOVE TO NEXT POSITION
 	INC	(HL)		; TIME = TIME + 1 (CARRY)
 	LD	A,(HL)		; SET UP TO TEST VALUE
 	RET			; BACK TO COMPLETE TEST
 TIKTOK	LD	A,1		; A = 1 FOR DAY OR MONTH
 	JR	FINISH		; OTHER ROUTINE DOES WORK
 ;
 ; #######################################################
 ; THIS IS THE DAYS-IN-A-MONTH LOOKUP TABLE - NO LEAP YEAR
 ; #######################################################
 ;
 LOOKUP	DEFB	00		; DUMMY BYTE, BUT THEN...
 	DEFB	32D		; THIRTY DAYS HATH
 	DEFB	29D		;	SEPTEMBER,
 	DEFB	32D		; APRIL, JUNE, AND
 	DEFB	31D		;	NOVEMBER;
 	DEFB	32D		; ALL THE REST HAVE
 	DEFB	31D		;	THIRTY-ONE,
 	DEFB	32D		; 'CEPT FEBRUARY, AND
 	DEFB	32D		;	THERE'S BEEN ALL
 	DEFB	31D		;	TOO MUCH TALK
 	DEFB	32D		;	ABOUT THE MYRIAD
 	DEFB	31D		;	PRETIDIGITATIONS
 	DEFB	32D		;	USING THAT MONTH
 ;
 ; #######################################################
 ; "CMD" PATCH CHECKS PARAMETERS, SYNTAX, AND SETS TIME
 ; #######################################################
 ;
 START2	LD	DE,SECOND+2	; POINT DE TO HOURS POS'N
 	LD	A,(HL)		; CHAR AT LINE POINTER
 	CP	22H		; IS IT A QUOTE MARK?
 	JR	NZ,OTHERS	; CHECK FOR CMDT OR CMDR
 	CALL	CONVRT		; READ/CONV. ASCII HR.
 	CP	3AH		; IS IT A COLON?
 SYNERR	JP	NZ,1997H	; GO TO ?SN ERROR ROUTINE
 	CALL	CONVRT		; READ/CONV. ASCII MIN.
 	CP	3AH		; IS IT A COLON?
 	JR	NZ,SYNERR	; SYNTAX ERROR IF NOT :
 	CALL	CONVRT		; READ/CONV. ASCII SEC.
 	CP	20H		; IS IT A SPACE?
 	JR	NZ,SYNERR	; SYNTAX ERROR IF NOT 
 	LD	DE,SECOND+4	; POINT DE TO MONTH POS'N
 	CALL	CONVRT		; READ/CONV. ASCII MON.
 	CP	2FH		; IS IT A SLASH?
 	JR	NZ,SYNERR	; SYNTAX ERROR IF NOT /
 	CALL	CONVRT		; READ/CONV. ASCII DAY
 	CP	2FH		; IS IT A SLASH?
 	JR	NZ,SYNERR	; SYNTAX ERROR IF NOT /
 	LD	DE,SECOND+5	; POINT DE TO YEARS POS'N
 	CALL	CONVRT		; READ/CONV. ASCII YEAR
 	CP	22H		; IS IT A QUOTE MARK?
 	JR	NZ,EXIT		; DONE IF A QUOTE MARK
 	INC	HL		; BUMP POINTER PAST QUOTE
 EXIT	RET			; BACK TO BASIC
 ;
 ; #######################################################
 ; CONVERT ASCII TO HEX AND POKE INTO CLOCK TIME$ LOCATION
 ; #######################################################
 ;
 CONVRT	INC	HL		; BUMP LINE PTR. BY ONE
 	LD	A,(HL)		; GET CHARACTER IN LINE
 	SUB	30H		; CONVERT ASCII TO HEX
 	INC	A		; MAKE A BE AT LEAST 1
 	LD	B,A		; SAVE THAT VALUE IN B
 	LD	A,0F6H		; A= 100 HEX MINUS 10 DEC
 MULT	ADD	A,0AH		; MULTIPLY BY ADDITION
 	DJNZ	MULT		; I.E., A = B TIMES 10
 	LD	B,A		; SAVE THAT VALUE IN B
 	INC	HL		; BUMP LINE PTR. BY ONE
 	LD 	A,(HL)		; GET CHARACTER IN LINE
 	SUB	30H		; CONVERT ASCII TO HEX
 	ADD	A,B		; A = (B * 10) + A
 	LD	(DE),A		; TIME IS SET, PUT IN DE
 	DEC	DE		; BUMP DE TO NEXT PLACE
 	INC	HL		; BUMP LINE PTR. BY ONE
 	LD	A,(HL)		; GET CHARACTER IN LINE
 	RET			; RETURN FOR FURTHER TEST
 OTHERS	CP	52H		; IS IT CMDR (CLOCK OFF)?
 	JR	NZ,NEXT		; NOPE, TRY FOR CMDT
 	DI			; TURN OFF THE CLOCK
 	INC	HL		; BUMP LINE PTR. BY ONE
 	RET			; BACK TO BASIC PROGRAM
 NEXT	CP	54H		; IS IT CMDT (CLOCK ON)?
 	JR	NZ,SYNERR	; NOPE, MUST BE ERROR
 	EI			; TURN ON THE CLOCK
 	INC	HL		; BUMP LINE PTR. BY ONE
 	RET			; BACK TO BASIC PROGRAM
 ;
 ; #######################################################
 	END	ENTRY
