;chopfile : Chop a file into regular lengths (20k)
; For newdos.
;
LENGTH	EQU	20
SECTOR	EQU	1024	;Must be mult of 128 for xmodem!
;
	COM	'<Chopfile 1.0  04-Feb-88>'
*GET	DOSCALLS
CR	EQU	0DH
;
	ORG	5200H
START
	LD	A,(HL)
	CP	CR
	JP	Z,USAGE
	LD	DE,FCB_IN
	CALL	DOS_EXTRACT
	JP	NZ,USAGE
;
	LD	HL,BUF_IN
	LD	DE,FCB_IN
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	XOR	A
	LD	(FILENUM),A
;
LOOP	CALL	READBUF
	PUSH	AF
	CALL	FLUSHBUF
	POP	AF
	CP	0
	JR	Z,LOOP
	JP	DOS
;
READBUF
	LD	HL,BUFFER
	LD	(TOPBUF),HL
	LD	BC,LENGTH*SECTOR
	LD	DE,FCB_IN
;
RB_01	CALL	$GET
	JR	NZ,RB_02
	LD	(HL),A
	INC	HL
	LD	(TOPBUF),HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,RB_01
;
	LD	A,0
	RET
;
RB_02
	CP	1CH
	JR	Z,RB_03
	CP	1DH
	JR	Z,RB_03
	JP	ERROR
RB_03
	LD	A,1
	RET
;
FLUSHBUF
	LD	HL,BUFFER
	LD	BC,(TOPBUF)
	OR	A
	SBC	HL,DE
	RET	Z
	CALL	MAKEFN
;
	LD	BC,(TOPBUF)
	LD	HL,BUFFER
	LD	DE,FCB_OUT
FB_01
	PUSH	HL
	OR	A
	SBC	HL,BC
	POP	HL
	JR	Z,FB_02
;
	LD	A,(HL)
	CALL	$PUT
	JP	NZ,ERROR
	INC	HL
	JR	FB_01
;
FB_02
	CALL	DOS_CLOSE
	JP	NZ,ERROR
	RET
;
MAKEFN
	LD	A,(FILENUM)
	INC	A
	LD	(FILENUM),A
;
	PUSH	AF
	AND	0FH
	LD	HL,FNNUM2
	CALL	PUTHEX
	POP	AF
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	AND	0FH
	LD	HL,FNNUM1
	CALL	PUTHEX
;
	LD	HL,FN
	LD	DE,FCB_OUT
	CALL	DOS_EXTRACT
	JP	NZ,ERROR
;
	LD	HL,BUF_OUT
	LD	DE,FCB_OUT
	LD	B,0
	CALL	DOS_OPEN_NEW
	JP	NZ,ERROR
;
	LD	HL,FN
	CALL	0033H
	RET
;
PUTHEX
	AND	0FH
	ADD	A,'0'
	LD	(HL),A
	CP	'9'+1
	RET	C
	ADD	A,7
	LD	(HL),A
	RET
;
ERROR
	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
	POP	AF
	JP	DOS
;
USAGE
	LD	HL,M_USAGE
	CALL	0033H
	JP	DOS
;
FILENUM	DEFB	0
TOPBUF	DEFW	0
FCB_IN	DEFS	32
FCB_OUT	DEFS	32
BUF_IN	DEFS	256
BUF_OUT	DEFS	256
;
FN
	DEFM	'chop'
FNNUM1	DEFM	'x'
FNNUM2	DEFM	'x'
	DEFM	CR,0
;
M_USAGE
	DEFM	'Usage: chopfile filename',CR,0
;
BUFFER	DEFS	LENGTH*SECTOR
;
	END	START
                                         