DYNTST ; Test for dynamic RAM loss, to test RESET switch.
 
 ; Start program, then set switch to CP/M mode.
 ; Operate RESET switch. A checksum of all dynamic RAM will be displayed.
 ; Repeat several times, holding switch in for various lengths of time.
 ; If checksum changes, RESET pulse is too long, & refresh is stopped
 ;   for too long.
 
 	ORG	0C000H	; Becomes location 0 in CP/M mode
 	JP	CHKSUM
 
 	ORG	8000H
 CHKSUM	DI
 	LD	HL,0FC00H	; Clear screen
 	LD	DE,0FC01H
 	LD	BC,1023
 	LD	(HL),' '
 	LDIR
 LOOP1	LD	HL,0	; Find 16 bit checksum
 	LD	DE,-0C000H
 	XOR	A
 	LD	B,A
 LOOP	ADD	A,(HL)
 	JR	NC,SKIP
 	INC	B
 SKIP	INC	HL
 	INC	E
 	JR	NZ,LOOP
 	INC	D
 	JR	NZ,LOOP
 	LD	L,A	; Display checksum
 	LD	H,B
 	LD	DE,0FC00H
 	LD	B,4
 V	XOR	A
 	ADD	HL,HL
 	ADC	A,A
 	ADD	HL,HL
 	ADC	A,A
 	ADD	HL,HL
 	ADC	A,A
 	ADD	HL,HL
 	ADC	A,A
 	DAA
 	CP	10
 	SBC	A,-'0'-1
 	LD	(DE),A
 	INC	DE
 	DJNZ	V
 	JR	LOOP1
 
 	END	CHKSUM
 	ADD	HL,HL
 	ADC	A,A
 	ADD	HL,HL
 	ADC	A,A
 	ADD	HL,HL
 	ADC	A,A
 	ADD