CPMBIO ;CPM BIOS FOR TRS-80 MODEL 1.
 ;    VERSION 3.3
 ;    LAST UPDATE 21 AUG 83
 ;
 ;    COPYRIGHT (C) 1983
 ;
 ;BY  BRUCE ORR  VK2BFO
 ;    8 GLENSIDE STREET,
 ;    BALGOWLAH, 2093.
 ;    AUSTRALIA.  	PH: (02) 94 6520
 ;
 ;    PERSONAL NON-PROFIT USE OF THIS SOFTWARE
 ;    IS AUTHORISED. 
 ;
 ;THIS PROGRAM FORMS THE BIOS (BASIC INPUT/OUTPUT SYSTEM)
 ;REQUIRED TO INTERFACE THE TRS-80 MODEL 1 COMPUTER TO
 ;THE CP/M OPERATING SYSTEM. BOTH SINGLE AND DOUBLE
 ;DENSITY DISKS ARE SUPPORTED WITH AUTOMATIC DENSITY
 ;RECOGNITION. THE SINGLE DENSITY FORMAT IS COMPATABLE
 ;WITH THE OSBORNE (TM) SINGLE DENSITY FORMAT WHILE THE
 ;DOUBLE DENSITY FORMAT IS BASED ON THE TRS-80 MODEL 3/4
 ;FORMAT.
 ;
 ;USE OF THIS PROGRAM REQUIRES THE FOLLOWING :-
 ;
 ;STANDARD EXPANSION INTERFACE WITH 48K MEMORY.
 ;MEMORY MAPPING MODIFICATION WHICH EXCHANGES FIRST AND
 ;LAST 16K MEMORY BLOCKS UNDER SWITCH CONTROL.
 ;LICENCED COPY OF CP/M 2.2 48K ON ABOVE DISK FORMAT.
 ;
 ;THANKS TO TIM BULLUSS, NEIL TREMBLE, AND HORST LEYKAM
 ;FOR THEIR COMMENTS AND SUGGESTIONS.
 ;
 CDISK	EQU	0004H		;LAST LOGGED DISK
 IOBYTE	EQU	0003H		;I/O CONTROL BYTE
 ;
 SEKDSK	EQU	40H		;SEEK DISK NUMBER
 SEKTRK	EQU	41H		;SEEK TRACK NUMBER
 SEKSEC	EQU	42H		;SEEK SECTOR NUMBER
 ;
 HSTDSK	EQU	43H		;HOST DISK NUMBER
 HSTTRK	EQU	44H		;HOST TRACK NUMBER
 HSTSEC	EQU	45H		;HOST SECTOR NUMBER
 ;
 SEKHST	EQU	46H		;SEEK SHR SECSHF
 HSTACT	EQU	47H		;HOST ACTIVE FLAG
 HSTWRT	EQU	48H		;HOST WRITTEN FLAG
 ;
 UNACNT	EQU	49H		;UNALLOC REC COUNT
 UNADSK	EQU	4AH		;LAST UNALLOC DISK
 UNATRK	EQU	4BH		;LAST UNALLOC TRACK
 UNASEC	EQU	4CH		;LAST UNALLOC SECTOR
 ;
 ERFLAG	EQU	4DH		;ERROR REPORTING FLAG
 RSFLAG	EQU	4EH		;READ SECTOR FLAG
 READOP	EQU	4FH		;1 IF READ OPERATION
 ;
 KBD	EQU	2BH		;ROM KEYBOARD ROUTINE
 DSP	EQU	33H		;ROM DISPLAY ROUTINE
 DOS	EQU	402DH		;TRSDOS RETURN ADD
 ;
 RSCTRL	EQU	0E8H		;RS232 CONTROL
 RSBAUD	EQU	0E9H		;RS232 BAUD RATE
 RSSTAT	EQU	0EAH		;RS232 STATUS
 RSDATA	EQU	0EBH		;RS232 DATA
 ;
 PRTREG	EQU	0F7E8H		;PRINTER REGISTER
 DCSREG	EQU	0F7ECH		;DISK COMMAND/STATUS REG
 TRKREG	EQU	0F7EDH		;DISK TRACK REG
 SECREG	EQU	0F7EEH		;DISK SECTOR REG
 DATREG	EQU	0F7EFH		;DISK DATA REG
 DRVREG	EQU	0F7E0H		;DISK DRIVE REG
 ;
 NDISKS	EQU	3		;NUMBER OF DISK DRIVES
 NSECTS	EQU	44		;NUMBER OF SECS TO LOAD
 BLKSIZ	EQU	2048		;CP/M ALLOC SIZE
 HSTSIZ	EQU	256		;HOST SECTOR SIZE
 HSTBLK	EQU	2		;CP/M SECTS/HOST BUFF
 CPMSPB	EQU	16		;CPM SECTORS PER BLOCK
 SECMSK	EQU	1		;SECT MASK (HSTBLK-1)
 ;
 WRALL	EQU	0		;WRITE TO ALLOCATED
 WRDIR	EQU	1		;WRITE TO DIRECTORY
 WRUAL	EQU	2		;WRITE TO UNALLOCATED
 ;
 CPMB	EQU	09F00H		;CPM LOAD BASE ADDRESS
 BDOS	EQU	0A706H		;BDOS ENTRY POINT
 ;
 	ORG	0B500H		;SET BIOS ORIGIN
 ORIGIN	JP	BOOT		;COLD START
 WBOOTE	JP	WBOOT		;WARM START
 	JP	CONST		;CONSOLE STATUS
 	JP	CONIN		;CONSOLE CHAR IN
 	JP	CONOUT		;CONSOLE CHAR OUT
 	JP	LIST		;LIST CHAR OUT
 	JP	PUNCH		;PUNCH OUT
 	JP	READER		;READER IN
 	JP	HOME		;RESTORE DISK HEAD POS
 	JP	SELDSK		;SELECT DISK
 	JP	SETTRK		;SET TRACK NUMBER
 	JP	SETSEC		;SET SECTOR NUMBER
 	JP	SETDMA		;SET DMA ADDRESS
 	JP	READ		;READ DISK
 	JP	WRITE		;WRITE DISK
 	JP	LISTST		;LIST DEVICE STATUS
 	JP	SECTRN		;SECTOR TRANSLATION
 	JP	NU		;NOT USED
 	JP	NU		;
 ;
 NU	RET			;RETURN
 ;
 START	DI			;DISABLE INTERRUPTS
 	LD	HL,MESS2	;DISPLAY MESSAGE 2
 	CALL	SDSP		;
 ;
 	CALL	CHECK		;CALC CHECKSUM
 	LD	(CKSUM),A	;SAVE IT
 ;
 MAPTST	LD	HL,0		;FIRST RAM LOCATION
 	LD	A,55H		;
 	LD	(HL),A		;ATTEMPT WRITE
 	CP	(HL)		;WRITE SUCCESSFUL?
 	JR	NZ,MAPTST	;IF NOT WAIT
 ;
 	LD	B,5		;500MS DEBOUNCE DELAY
 	CALL	DELAY		;
 ;
 	LD	A,0		;SELECT DISK A
 	LD	(CDISK),A	;
 	LD	A,81H		;
 	LD	(IOBYTE),A	;INITIALISE I/O BYTE
 	LD	HL,MESS1	;
 	CALL	SDISP		;DISPLAY CP/M MESSAGE
 	JP	WBOOT		;LOAD SYSTEM
 ;
 BOOT	LD	SP,0080H	;RESET STACK POINTER
 	LD	A,0		;SELECT DISK A INITIALLY
 	LD	(CDISK),A	;
 	JP	GOCPM		;INITIALIZE AND GOTO CP/M
 ;
 WBOOT	CALL	BLINIT		;INIT BLOCKING
 	LD	SP,0080H	;INITIALISE STACK POINTER
 	LD	C,0		;SELECT DISK 0
 	CALL	SELDSK		;
 	CALL	HOME		;GO TO TRACK 00
 	LD	B,NSECTS	;NUMBER OF SECS TO LOAD
 	LD	C,0		;SET START TRACK
 	CALL	SETTRK		;
 	LD	D,0		;SET START SECTOR
 	LD	HL,CPMB		;SET CPM LOAD BASE
 ;
 LOAD1	PUSH	BC		;SAVE SEC CNT, TRACK
 	PUSH	DE		;SAVE NEXT SEC TO READ
 	PUSH	HL		;SAVE DMA ADDRESS
 	LD	C,D		;GET SEC ADD TO REG C
 	CALL	SETSEC		;SET SEC ADD FROM REG C
 	POP	BC		;RECALL DMA ADD TO BC
 	PUSH	BC		;PLACE BACK ON STACK
 	CALL	SETDMA		;SET DMA ADDRESS FROM BC
 ;
 ;	DRIVE SET TO 0, TRACK SET, SECTOR SET, DMA SET
 	CALL	READ		;READ LOGICAL SECTOR
 	CP	0		;ANY ERRORS?
 	JP	NZ,WBOOT	;IF SO RE-BOOT
 ;
 ;	NO ERROR, MOVE TO NEXT SECTOR
 	POP	HL		;RECALL DMA ADD
 	LD	DE,128		;DMA=DMA+128
 	ADD	HL,DE		;NEW DMA ADD IN HL
 	POP	DE		;RECALL	SEC ADD
 	POP	BC		;RECALL SECS REMAINING
 	DEC	B		;SECS=SECS-1
 	JP	Z,GOCPM		;GOTO CP/M WHEN COMPLETE
 ;
 ;	MORE SECTORS TO LOAD, CHECK FOR TRACK CHANGE
 	INC	D		;INCREMENT SECTOR COUNT
 	LD	A,D		;
 	CP	20		;IF SEC>19 CHANGE TRACK
 	JP	C,LOAD1		;ELSE CONTINUE
 ;
 ;	END OF CURRENT TRACK, GO TO NEXT
 	LD	D,0		;BEGIN WITH FIRST SEC
 	INC	C		;TRACK=TRACK+1
 ;
 ;	SAVE REG STATES AND CHANGE TRACKS
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	CALL	SETTRK
 	POP	HL
 	POP	DE
 	POP	BC
 	JP	LOAD1		;GET NEXT SECTOR
 ;
 ;	END OF LOAD, SET PARAMETERS AND GO TO CP/M
 GOCPM	CALL	RSINIT		;INITIALISE RS232 PORT
 	CALL	BLINIT		;INITIALISE BLOCKING
 ;
 	LD	A,0C3H		;JUMP INSTRUCTION
 	LD	(0),A		;FOR JUMP TO WBOOT
 	LD	HL,WBOOTE	;WBOOT ENTRY POINT
 	LD	(1),HL		;
 ;
 	LD	(5),A		;FOR JUMP TO BDOS
 	LD	HL,BDOS		;BDOS ENTRY POINT
 	LD	(6),HL		;
 ;
 	LD	A,0C9H		;RETURN INSTRUCTION CODE
 	LD	(08H),A		;STORE AT INTERRUPTS 1-7
 	LD	(10H),A		;
 	LD	(18H),A		;
 	LD	(20H),A		;
 	LD	(28H),A		;
 	LD	(30H),A		;
 	LD	(38H),A		;
 ;
 	LD	BC,80H		;SET DEFAULT DMA ADD
 	CALL	SETDMA		;
 ;
 	DI			;DISABLE INTERRUPTS
 	LD	A,(CDISK)	;GET CURRENT DRIVE
 	LD	C,A		;SEND TO THE CCP
 	JP	CPMB		;GO TO CP/M
 ;
 CHECK	LD	HL,(TRNFER)	;SAVE TRNFER WORD
 	PUSH	HL		;
 	LD	HL,0		;
 	LD	(TRNFER),HL	;ZERO IT
 	LD	HL,ORIGIN	;LOAD START ADD
 	LD	DE,CKEND+1	;LOAD END ADD
 	LD	C,0		;ZERO SUM
 CHECKL	LD	A,C		;GET SUM
 	ADD	A,(HL)		;ADD NEXT BYTE
 	LD	C,A		;SAVE SUM
 	INC	HL		;POINT TO NEXT BYTE
 	LD	A,H		;END REACHED ?
 	CP	D		;
 	JR	NZ,CHECKL	;
 	LD	A,L		;
 	CP	E		;
 	JR	NZ,CHECKL	;
 	LD	A,C		;YES, PUT RESULT IN A
 	POP	HL		;RESTORE TRNFER WORD
 	LD	(TRNFER),HL	;
 	RET			;RETURN
 ;
 VERCHK	CALL	CHECK		;CALCULATE CHECKSUM
 	LD	HL,CKSUM	;
 	CP	(HL)		;SAME AS STORED VALUE?
 	RET	Z		;RETURN IF SO
 	LD	HL,MESS5	;
 	CALL	SDISP		;DISPLAY MESSAGE 5
 	RET			;RETURN
 ;
 ;	I/O HANDLER SECTION BEGINS HERE
 ;
 CONST	CALL	KEYF		;CHECK KEYBOARD
 	LD	(CHAR),A	;SAVE RESULT
 	AND	A		;SET FLAGS
 	JR	NZ,CONRDY	;JUMP IF READY
 	LD	A,(IOBYTE)	;GET I/O BYTE
 	AND	1		;
 	JR	NZ,CONIDL	;EXIT ON CON MODES 1,3
 	IN	A,(RSSTAT)	;GET RS232 STATUS
 	BIT	7,A		;HAS CHAR ARRIVED ?
 	JR	Z,CONIDL	;JUMP IF NOT
 	IN	A,(RSDATA)	;GET CHAR
 	LD	(CHAR),A	;SAVE IT
 CONRDY	LD	A,0FFH		;SET READY INDICATION
 	RET			;RETURN
 CONIDL	LD	A,0		;SET NOT READY INDICATION
 	RET			;RETURN
 ;
 ;	CONSOLE CHARACTER INTO REGISTER A
 CONIN	LD	A,(CHAR)	;GET CHARACTER
 	AND	7FH		;RESET HIGH BIT
 	JR	Z,WAITK		;JUMP IF NO CHAR
 	LD	C,A		;SAVE CHAR
 	LD	A,0		;
 	LD	(CHAR),A	;CLEAR CHAR REG
 	LD	A,C		;GET CHAR
 	RET			;RETURN
 ;
 WAITK	CALL	KEYF		;CHECK KEYBOARD
 	AND	7FH		;RESET HIGH BIT
 	AND	A		;
 	RET	NZ		;RETURN IF KEY PRESSED
 	LD	A,(IOBYTE)	;GET I/O BYTE
 	AND	1		;
 	JR	NZ,WAITK	;WAIT FOR KEY IF MODE 1,3
 	IN	A,(RSSTAT)	;ELSE GET RS232 STATUS
 	BIT	7,A		;
 	JR	Z,WAITK		;WAIT IF NO CHAR READY
 	IN	A,(RSDATA)	;GET CHAR
 	AND	7FH		;RESET HIGH BIT
 	RET			;RETURN
 ;
 KEYF	LD	A,(0F802H)	;IF JKL PRESSED
 	CP	1CH		;
 	CALL	Z,PRTSCR	;THEN PRINT SCREEN
 	LD	A,(0F810H)	;IF 123 PRESSED
 	CP	0EH		;
 	CALL	Z,TERMIN	;THEN TERMINAL MODE
 	CALL	KEY		;SCAN KEYBOARD
 	RET			;
 ;
 ;	CONSOLE CHARACTER OUTPUT FROM REGISTER C
 CONOUT	LD	A,C		;PUT CHAR IN A
 	PUSH	BC		;
 	CALL	DISP		;DISPLAY IT
 	POP	BC		;
 	LD	A,(IOBYTE)	;GET I/O BYTE
 	AND	03H		;MASK CONSOLE FIELD
 	JP	Z,RS232O	;0 - SEND TO RS232 PORT
 	CP	2		;
 	JP	Z,LIST		;2 - SEND TO LIST DEVICE
 	RET			;1,3 - CRT DISP ONLY
 ;
 ;	LIST CHARACTER FROM REGISTER C
 LIST	LD	A,(IOBYTE)	;GET I/O BYTE
 	RLCA			;EXTRACT LIST DEV NUMBER
 	RLCA			;
 	AND	03H		;
 	JP	Z,RS232O	;0 - SEND TO RS232
 	CP	2		;
 	JP	Z,PRINT		;2 - SEND TO PRINTER
 	LD	A,C		;
 	JP	DISP		;1,3 - SEND TO CRT DISP
 ;
 ;	PRINT CHARACTER FROM REGISTER C
 PRINT	LD	A,(PRTREG)	;GET PRINTER STATUS
 	BIT	7,A		;IS IT BUSY ?
 	JR	NZ,LIST		;IF SO WAIT
 	LD	A,C		;ELSE GET CHAR
 	CP	0AH		;FILTER OUT LF
 	RET	Z		;
 	LD	(PRTREG),A	;PRINT CHAR
 	RET			;RETURN
 ;
 ;	SCREEN PRINT ROUTINE
 PRTSCR	LD	HL,0FC00H	;START OF SCREEN
 PRTLIN	LD	B,64		;SET LINE LENGTH
 PRTCHR	LD	C,(HL)		;GET CHAR
 	CALL	PRINT		;PRINT IT
 	INC	HL		;ADVANCE POINTER
 	DJNZ	PRTCHR		;LOOP TILL EOL
 	LD	C,0DH		;
 	CALL	PRINT		;SEND CARR RETURN
 	LD	A,H		;
 	AND	A		;END OF SCREEN?
 	JR	NZ,PRTLIN	;LOOP IF NOT
 	RET			;RETURN
 ;
 ;	PUNCH CHARACTER OUT
 PUNCH	JP	RS232O		;SEND TO RS232 PORT
 ;
 ;	READER CHARACTER IN
 READER	JP	RS232I		;GET FROM RS232 PORT
 ;
 ;	SEND CHARACTER TO RS232 PORT
 RS232O	IN	A,(RSSTAT)	;GET UART STATUS
 	BIT	6,A		;IS TX REG EMPTY ?
 	JR	Z,RS232O	;IF NOT WAIT
 	LD	A,C		;GET CHARACTER
 	OUT	(RSDATA),A	;SEND IT
 	RET			;RETURN
 ;
 ;	READ CHARACTER FROM RS232 PORT
 RS232I	IN	A,(RSSTAT)	;GET UART STATUS
 	BIT	7,A		;HAS CHAR ARRIVED ?
 	JR	Z,RS232I	;IF NOT WAIT
 	IN	A,(RSDATA)	;LOAD CHAR TO A
 	RET			;RETURN
 ;
 ;	INITIALISE RS232 PORT
 RSINIT	OUT	(RSCTRL),A	;RESET UART
 	LD	A,55H		;SELECT 300 BAUD
 	OUT	(RSBAUD),A	;
 	LD	A,6FH		;8 BITS,1 STOP,NO PAR
 	OUT	(RSSTAT),A	;
 	RET			;RETURN
 ;
 ;
 ;
 ;	DISK I/O DRIVER SECTION FOLLOWS
 ;
 ;	MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
 HOME	LD	A,(SEKDSK)	;GET SELECTED DISK
 	CALL	DSKRDY		;WAIT TILL DISK READY
 HOME1	LD	A,02		;RESTORE COMMAND
 	LD	(DCSREG),A	;SEND TO CONTROLLER
 	CALL	SDELAY		;
 HOMEW	LD	A,(DCSREG)	;GET DISK STATUS
 	BIT	0,A		;
 	JR	NZ,HOMEW	;WAIT IF BUSY
 	RET			;ELSE RETURN
 ;
 ;	SELECT DISK GIVEN BY REGISTER C
 SELDSK	LD	HL,0		;ERROR CODE
 	LD	A,C		;GET DRIVE NUMBER
 	CP	NDISKS		;TOO LARGE?
 	RET	NC		;RETURN WITH HL=0 IF SO
 	LD	(SEKDSK),A	;SEEK DISK NUMBER
 	LD	L,C		;HL=DRIVE NUMBER
 	LD	H,0		;
 	ADD	HL,HL		;HL=HL*16
 	ADD	HL,HL		;
 	ADD	HL,HL		;
 	ADD	HL,HL		;
 	LD	DE,DCB1		;DE=DISK CONT BLOCK ADD.
 	ADD	HL,DE		;ADD DRIVE OFFSET
 	LD	(CURDCB),HL	;SAVE CURRENT DCB ADD
 	RET			;RETURN
 ;
 ;	SET TRACK GIVEN BY REGISTER C
 SETTRK	LD	A,C		;
 	LD	(SEKTRK),A	;SAVE TRACK TO SEEK
 	RET			;RETURN
 ;
 SEEK	LD	A,(HSTDSK)	;get current disk
 	CALL	DSKRDY		;READY DISK
 	LD	A,(HSTTRK)	;GET TRACK TO SEEK
 	LD	(DATREG),A	;SEND TO DISK
 	LD	A,12H		;
 	LD	(DCSREG),A	;PERFORM TRACK SEEK
 	CALL	SDELAY		;SHORT DELAY
 SEEKW	LD	A,(DCSREG)	;GET DISK STATUS
 	BIT	0,A		;
 	JR	NZ,SEEKW	;WAIT TILL FINISHED
 	LD	A,(HSTSEC)	;GET SECTOR TO SEEK
 	LD	(SECREG),A	;SEND TO DISK
 	RET			;THEN RETURN
 ;
 ;	SET SECTOR GIVEN BY REGISTER C
 SETSEC	LD	A,C		;
 	LD	(SEKSEC),A	;SAVE SECTOR TO SEEK
 	RET			;RETURN
 ;
 ;	SET DMA ADDRESS GIVEN BY REGISTER BC
 SETDMA	LD	(DMAADR),BC	;SAVE DMA ADDRESS
 	RET			;RETURN
 ;
 ;	READ THE SELECTED SECTOR
 READ	LD	A,1		;
 	LD	(READOP),A	;FLAG READ OPERATION
 	LD	A,WRUAL		;
 	LD	(WRTYPE),A	;TREAT AS UNALLOC
 	JP	ALLOC		;TO PERFORM THE READ
 ;
 WRITE	LD	A,0		;
 	LD	(READOP),A	;NOT A READ OPERATION
 	LD	A,C		;LOAD WRITE TYPE
 	LD	(WRTYPE),A	;STORE IT
 	CP	WRUAL		;WRITE UNALLOCATED ?
 	JR	NZ,CHKUNA	;CHECK FOR UNALLOC
 ;
 ;	WRITE TO UNALLOCATED, SET PARAMETERS
 	LD	A,CPMSPB	;CPM SECTORS PER BLOCK
 	LD	(UNACNT),A	;NEXT UNALLOC RECS
 	LD	A,(SEKDSK)	;DISK TO SEEK
 	LD	(UNADSK),A	;UNADSK = SEKDSK
 	LD	A,(SEKTRK)	;
 	LD	(UNATRK),A	;UNATRK = SEKTRK
 	LD	A,(LOGSEC)	;
 	LD	(UNASEC),A	;UNASEC = LOGSEC
 ;
 ;	CHECK FOR WRITE TO UNALLOCATED SECTOR
 CHKUNA	LD	A,(UNACNT)	;ANY UNALLOC REMAIN ?
 	OR	A		;
 	JP	Z,ALLOC		;SKIP IF NOT
 ;
 ;	MORE UNALLOCATED RECORDS REMAIN
 	DEC	A		;UNACNT = UNACNT-1
 	LD	(UNACNT),A	;
 	LD	A,(SEKDSK)	;SAME DISK ?
 	LD	HL,UNADSK	;
 	CP	(HL)		;SEKDSK = UNADSK ?
 	JP	NZ,ALLOC	;SKIP IF NOT
 ;
 ;	DISKS ARE THE SAME
 	LD	A,(SEKTRK)	;
 	LD	HL,UNATRK	;
 	CP	(HL)		;SEKTRK = UNATRK ?
 	JP	NZ,ALLOC	;SKIP IF NOT
 ;
 ;	TRACKS ARE THE SAME
 	LD	A,(LOGSEC)	;
 	LD	HL,UNASEC	;
 	CP	(HL)		;LOGSEC = UNASEC ?
 	JP	NZ,ALLOC	
 ;
 ;	MATCH, MOVE TO NEXT SECTOR FOR FUTURE REF
 	INC	(HL)		;UNASEC = UNASEC+1
 	LD	B,(HL)		;END OF TRACK ?
 	LD	A,(CPMSPT)	;GET SECTORS PER TRACK
 	DEC	A		;
 	CP	B		;
 	JP	NC,NOOVF	;SKIP IF NO OVERFLOW
 ;
 ;	OVERFLOW TO NEXT TRACK
 	LD	(HL),0		;UNASEC = 0
 	LD	HL,UNATRK	;
 	INC	(HL)		;UNATRK = UNATRK+1
 ;
 ;	MATCH FOUND, MARK AS UNNECESSARY READ
 NOOVF	LD	A,0		;
 	LD	(RSFLAG),A	;RSFLAG = 0
 	JP	RWOPER		;TO PERFORM THE WRITE
 ;
 ;	NOT UNALLOCATED RECORD, REQUIRES PRE-READ
 ALLOC	LD	A,0		;
 	LD	(UNACNT),A	;UNACNT = 0
 	INC	A		;
 	LD	(RSFLAG),A	;RSFLAG = 1
 ;
 ;	ENTER HERE TO PERFORM THE READ/WRITE
 RWOPER	LD	A,0		;
 	LD	(ERFLAG),A	;NO ERRORS (YET)
 	LD	A,(SEKSEC)	;GET SECTOR TO SEEK
 	SRL	A		;COMPUTE HOST SECTOR ***
 	INC	A		;
 	LD	(SEKHST),A	;HOST SECTOR TO SEEK
 ;
 ;	ACTIVE HOST SECTOR ?
 	LD	HL,HSTACT	;HOST ACTIVE FLAG
 	LD	A,(HL)		;
 	LD	(HL),1		;ALWAYS BECOMES 1
 	OR	A		;WAS IT ACTIVE ALREADY ?
 	JP	Z,FILHST	;FILL HOST IF NOT
 ;
 ;	HOST BUFFER ACTIVE, SAME AS SEEK BUFFER ?
 	LD	A,(SEKDSK)	;
 	LD	HL,HSTDSK	;SAME DISK ?
 	CP	(HL)		;SEKDSK = HSTDSK ?
 	JP	NZ,NOMTCH	;
 ;
 ;	SAME DISK, SAME TRACK ?
 	LD	A,(SEKTRK)	;
 	LD	HL,HSTTRK	;
 	CP	(HL)		;SEKTRK = HSTTRK ?
 	JP	NZ,NOMTCH	;
 ;
 ;	SAME DISK, SAME TRACK, SAME BUFFER ?
 	LD	A,(SEKHST)	;
 	LD	HL,HSTSEC	;SECHST = HSTSEC ?
 	CP	(HL)		;
 	JP	NZ,NOMTCH	;
 ;
 	LD	A,(SEKSEC)	;
 	LD	HL,LSTSEC	;SEKSEC = LSTSEC ?
 	CP	(HL)		;
 	JP	NZ,MATCH	;REDO IF EXACT MATCH
 ;
 ;	CORRECT DISK, BUT INCORRECT SECTOR
 NOMTCH	LD	A,(HSTWRT)	;HOST WRITTEN ?
 	OR	A		;
 	CALL	NZ,WRTHST	;CLEAR HOST BUFFER
 ;
 ;	MAY HAVE TO FILL HOST BUFFER
 FILHST	LD	A,(SEKDSK)	;
 	LD	(HSTDSK),A	;
 	LD	A,(SEKTRK)	;
 	LD	(HSTTRK),A	;
 	LD	A,(SEKHST)	;
 	LD	(HSTSEC),A	;
 	LD	A,(SEKSEC)	;
 	LD	(LSTSEC),A	;
 	LD	A,(RSFLAG)	;NEED TO READ ?
 	OR	A		;
 	CALL	NZ,RDHST	;YES, IF 1
 	LD	A,0		
 	LD	(HSTWRT),A	;NO PENDING WRITE
 ;
 ;	COPY DATA TO OR FROM BUFFER
 MATCH	LD	A,(SEKSEC)	;MASK BUFFER NUMBER
 	AND	SECMSK		;LEAST SIG BITS
 	LD	L,A		;READY TO SHIFT
 	LD	H,0		;
 	ADD	HL,HL		;SHIFT LEFT 7
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	LD	DE,HSTBUF	;HOST BUFFER BASE
 	ADD	HL,DE		;ADD OFFSET
 	EX	DE,HL		;PUT RESULT IN DE
 	LD	HL,(DMAADR)	;CPM DATA ADDRESS
 	LD	C,128		;
 	LD	B,0		;128 BYTES TO MOVE
 	LD	A,(READOP)	;WHICH WAY ?
 	OR	A		;
 	JP	NZ,RWMOVE	;SKIP IF READ
 ;
 ;	WRITE OPERATION, MARK AND SWITCH DIRECTION
 	LD	A,1		;
 	LD	(HSTWRT),A	;HSTWRT = 1
 	EX	DE,HL		;SOURCE/DEST SWAP
 ;
 ;	MOVE 128 BYTES FROM DE TO HL
 RWMOVE	EX	DE,HL		;
 	LDIR			;MOVE DATA BLOCK
 ;
 ;	DATA HAS BEEN MOVED TO/FROM HOST BUFFER
 	LD	A,(WRTYPE)	;WRITE TYPE
 	CP	WRDIR		;TO DIRECTORY ?
 	LD	A,(ERFLAG)	;IN CASE OF ERRORS
 	RET	NZ		;NO FURTHER PROCESSING
 ;
 ;	CLEAR HOST BUFFER FOR DIRECTORY WRITE
 	OR	A		;ERRORS ?
 	RET	NZ		;SKIP IF SO
 	LD	A,0		;
 	LD	(HSTWRT),A	;BUFFER WRITTEN
 	CALL	WRTHST		;
 	LD	A,(ERFLAG)	;
 	RET			;RETURN
 ;
 ;	INITIALISE BLOCKING FLAGS
 BLINIT	LD	A,0		;
 	LD	(HSTACT),A	;HOST BUFFER INACTIVE
 	LD	(UNACNT),A	;CLEAR	UNALLOC COUNT
 	RET			;RETURN
 ;
 ;
 ;	READ PHYSICAL SECTOR INTO SECBUF
 RDHST	LD	A,1CH		;SET ERROR MASK
 	LD	(ERMASK),A	;
 	LD	HL,021AH	;SET TRANSFER DIRECTION
 	LD	(TRNFER),HL	;
 	LD	A,8CH		;SECTOR READ COMMAND
 	JP	DISKRW		;PERFORM READ
 ;
 ;	WRITE PHYSICAL SECTOR FROM SECBUF
 WRTHST	LD	A,7CH		;SET ERROR MASK
 	LD	(ERMASK),A	;
 	LD	HL,0A12H	;SET TRANSFER DIRECTION
 	LD	(TRNFER),HL	;
 	LD	A,0ACH		;SECTOR WRITE COMMAND
 	JP	DISKRW		;PERFORM WRITE
 ;
 ;	DISK SECTOR READ/WRITE
 DISKRW	LD	(DSKCOM),A	;SAVE DISK COMMAND
 	CALL	SEEK		;SEEK DISK
 	LD	A,6		;MAX RETRY COUNT
 	LD	(TRYCNT),A	;
 	LD	HL,DENTAB	;DENSITY TABLE BASE
 	LD	A,(HSTDSK)	;CURRENT DISK NUMBER - corrected
 	LD	E,A		;
 	LD	D,0		;
 	ADD	HL,DE		;ADD TO BASE ADD
 	LD	(DENPT),HL	;SAVE POINTER TO DENSITY
 RETRY	LD	A,(HSTDSK)	;get current disk
 	CALL	DSKRDY		;READY DISK
 	LD	HL,(DENPT)	;GET DENSITY POINTER
 	LD	A,(HL)		;GET DENSITY MODE
 	OR	0FEH		;SET BITS 1-7
 	LD	HL,DCSREG	;DISK COMMAND/STAT REG
 	LD	(HL),A		;SET DENSITY
 	LD	(HL),0D0H	;FORCE INTERRUPT
 	LD	A,(HSTSEC)	;TRANSFER CURRENT SECTOR
 	LD	(SECREG),A	;
 	LD	A,(HSTTRK)	;TRANSFER CURRENT TRACK
 	LD	(TRKREG),A	;
 	LD	DE,DATREG	;DISK DATA REGISTER
 	LD	BC,HSTBUF	;DISK BUFFER BASE ADD
 	LD	A,(DSKCOM)	;GET COMMAND
 	LD	(HL),A		;ISSUE COMMAND
 	CALL	SDELAY		;SHORT DELAY
 	BIT	5,A		;
 	JP	Z,WAIT2		;JUMP IF READ
 WAIT1	LD	A,(HL)		;WAIT FOR DATA REQUEST
 	AND	83H		;
 	JP	PO,WAIT1	;
 	LD	A,(BC)		;GET FIRST BYTE TO WRT
 	INC	BC		;INCREMENT POINTER
 	JP	TRNFER		;BEGIN TRANSFER
 WAIT2	LD	A,(HL)		;GET DISK STATUS
 	AND	83H		;READY FOR FIRST BYTE ?
 	JP	PO,WAIT2	;WAIT IF NOT
 TRNFER	LD	A,(BC)		;N.B. READ CASE SHOWN
 	LD	(DE),A		;INSTUCTS CHANGED FOR WRT
 	INC	BC		;INC BUFFER POINTER
 WAIT3	BIT	1,(HL)		;READY FOR NEXT BYTE?
 	JR	NZ,TRNFER	;IF SO JUMP
 	BIT	1,(HL)		;
 	JR	NZ,TRNFER	;
 	BIT	1,(HL)		;
 	JR	NZ,TRNFER	;
 	BIT	0,(HL)		;OPERATION COMPLETE ?
 	JR	Z,RWCOMP	;
 	BIT	1,(HL)		;
 	JR	NZ,TRNFER	;
 	BIT	7,(HL)		;TIMED OUT ?
 	JR	Z,WAIT3		;LOOP IF NOT
 	LD	(HL),0D0H	;FORCE INTERRUPT
 	LD	HL,MESS3	;
 	CALL	SDISP		;
 	JR	RWERR		;
 RWCOMP	LD	A,(HL)		;GET STATUS
 	LD	(ERCODE),A	;SAVE ERROR CODE
 	LD	E,A		;
 	LD	A,(ERMASK)	;
 	AND	E		;MASK CODE
 	LD	(ERFLAG),A	;
 	RET	Z		;RETURN IF NO ERROR
 	LD	A,(TRYCNT)	;GET RETRY COUNT
 	DEC	A		;DECREMENT IT
 	LD	(TRYCNT),A	;SAVE IT
 	JR	Z,RWERR		;ERROR IF COUNT = 0
 	LD	A,(DSKCOM)	;GET DISK COMMAND
 	BIT	5,A		;
 	JP	NZ,RETRY	;JUMP IF WRITE
 	LD	HL,(DENPT)	;LOAD DENSITY POINTER
 	LD	A,(HL)		;GET DENSITY MODE
 	CPL			;COMPLEMENT IT
 	AND	1		;MASK IT
 	LD	(HL),A		;SAVE NEW DENSITY
 	JR	NZ,DOUBLE	;
 SINGLE	LD	BC,SECTN1	;SECTOR TRANSLATE TAB 1
 	LD	DE,DPB1		;DISK PARAM BLOCK 1
 	JR	SETDEN		;SET NEW DENSITY
 DOUBLE	LD	BC,SECTN2	;SECTOR TRANSLATE TAB 2
 	LD	DE,DPB2		;DISK PARAM BLOCK 2
 SETDEN 	LD	IX,(CURDCB)	;CURRENT DCB ADDRESS
 	LD	(IX+0),C	;INSERT NEW TRANSLATE
 	LD	(IX+1),B	;TABLE ADDRESS
 	LD	(IX+0AH),E	;INSERT NEW DISK
 	LD	(IX+0BH),D	;PARAMETER BLOCK ADDRESS
 	LD	(0B4D0H),BC	;GIVE BDOS NEW SECTRAN
 	LD	(0B4BBH),DE	;GIVE BDOS NEW DPB
 	LD	A,(DE)		;GET NEW SECTS PER TRACK
 	LD	(CPMSPT),A	;SAVE IT
 	LD	HL,0B4C1H	;BDOS WORKING DPB ADD
 	EX	DE,HL		;PUT LOCAL DPB ADD IN HL
 	LD	BC,0FH		;
 	LDIR			;TRANSFER 15 BYTES
 	JP	RETRY		;RETRY SECTOR READ
 RWERR	LD	A,1		;ELSE SET ERROR FLAG
 	LD	(ERFLAG),A	;
 	RET			;AND RETURN
 ;
 DSKRDY	LD	C,A
 	LD	A,1		;INITIALISE A
 	INC	C		;
 SEL1	DEC	C		;
 	JR	Z,SEL2		;
 	ADD	A,A		;SHIFT ACCUM LEFT
 	JR	SEL1		;
 SEL2	LD	(DRVCOD),A	;SAVE DRIVE SELECT CODE
 	LD	A,(DCSREG)	;GET DISK STATUS
 	BIT	7,A		;IS MOTOR ON?
 	LD	A,(DRVCOD)	;GET DRIVE SELECT CODE
 	LD	(DRVREG),A	;SELECT DRIVE
 	JR	Z,MOTON		;JUMP IF MOTOR ON
 	LD	B,5		;500MS MOTOR ON DELAY
 	CALL	DELAY		;
 	CALL	VERCHK		;PERFORM CHECKSUM TEST
 MOTON	LD	A,(DRVCOD)	;GET DRIVE CODE
 	LD	B,A		;
 	LD	A,(LSTCOD)	;GET LAST CODE
 	CP	B		;SAME AS NEW CODE?
 	JR	Z,READY		;
 	CALL	HOME1		;HOME HEAD IF NOT
 	LD	B,1		;AND DELAY 100MS
 	CALL	DELAY		;
 READY	LD	A,(DRVCOD)	;SELECT DRIVE
 	LD	(LSTCOD),A	;UPDATE LAST DRIVE CODE
 	LD	(DRVREG),A	;
 	DI			;DISABLE INTERRUPTS
 	RET			;RETURN
 ;
 DELAY	LD	DE,1AA3H	;SET CORE TIME
 LOOP	DEC	DE		;DECREMENT CORE TIME
 	LD	A,E		;DE=0 ?
 	OR	D		;
 	JR	NZ,LOOP		;LOOP IF NOT
 	DJNZ	DELAY		;DECREMENT TIME
 	RET			;AND RETURN
 ;
 SDELAY	PUSH	BC		;SHORT DELAY
 	POP	BC		;
 	RET			;RETURN
 ;
 ;	GET LIST DEVICE STATUS
 LISTST	LD	A,(PRTREG)	;GET PRINTER STATUS
 	AND	80H		;MASK BUSY BIT
 	LD	A,0		;
 	RET	NZ		;RETURN WITH 0 IF BUSY
 	LD	A,0FFH		;ELSE RETURN FFH
 	RET			;
 ;
 ;	SECTOR TRANSLATION ROUTINE
 SECTRN	LD	A,C		;
 	LD	(LOGSEC),A	;SAVE LOGICAL SECTOR
 	LD	L,C		;HL=LOGICAL SECTOR
 	LD	H,B		;
 	ADD	HL,DE		;ADD MAP ADDRESS
 	LD	L,(HL)		;HL=PHYSICAL SECTOR
 	LD	H,0		;
 	RET			;RETURN
 ;
 ;	VIDEO CONSOLE DISPLAY ROUTINE
 DISP	CP	80H		;
 	RET	NC		;RETURN IF CHAR>80H
 	LD	HL,(CURPOS)	;GET CURSOR POSITION
 	CP	20H		;
 	JP	C,CONT		;JUMP IF CONTROL CHAR
 	CP	5BH		;IF CHR=5B,5C,5D,5E
 	JR	C,DSPCHR	;
 	CP	5FH		;
 	JR	NC,DSPCHR	;THEN
 	EX	DE,HL		;LOAD CHAR FROM TABLE
 	LD	HL,CHRTAB-5BH	;
 	LD	B,0		;
 	LD	C,A		;
 	ADD	HL,BC		;
 	LD	A,(HL)		;
 	EX	DE,HL		;
 DSPCHR	LD	(HL),A		;DISPLAY CHARACTER
 	INC	HL		;ADVANCE CURSOR
 CURSET	LD	A,H		;
 	AND	A		;SEE IF OFF SCREEN
 	CALL	Z,SCROLL	;IF SO SCROLL DISPLAY
 	LD	(HL),5FH	;WRITE CURSOR
 	LD	(CURPOS),HL	;SAVE CURSOR POSITION
 	RET			;RETURN
 ;
 SCROLL	LD	DE,0FC00H	;POINT TO TOP OF DISP
 	LD	HL,0FC40H	;POINT TO ROW 2
 	LD	BC,03C0H	;15 ROWS TO MOVE
 	LDIR			;PERFORM SCROLL
 	LD	A,20H		;LOAD BLANK
 	LD	(0FFC0H),A	;STORE AT BEG. ROW 16
 	LD	HL,0FFC0H	;POINT TO FIRST CHAR
 	LD	DE,0FFC1H	;POINT TO SECOND CHAR
 	LD	BC,63		;63 CHARS TO MOVE
 	LDIR			;BLANK ROW 16
 	LD	HL,0FFC0H	;SET CURSOR POSITION
 	RET			;RETURN
 ;
 CONT	CP	08H		;
 	JP	Z,BACKSP	;BACKSPACE
 	CP	0AH		;
 	JP	Z,LINEFD	;LINE FEED
 	CP	0DH		;
 	JP	Z,CARRET	;CARRIAGE RETURN
 	CP	0CH		;
 	JP	Z,CLEAR		;CLEAR SCREEN (FF)
 	CP	07H		;
 	JP	BELL		;BELL
 	RET			;RETURN
 ;
 CLEAR	LD	A,20H		;BLANK CHAR. AT
 	LD	(0FC00H),A	;FIRST SCREEN POS.
 	LD	HL,0FC00H	;
 	LD	DE,0FC01H	;
 	LD	BC,03FFH	;
 	LDIR			;BLANK SCREEN OUT
 	LD	HL,0FC00H	;HOME CURSOR
 	JP	CURSET		;SET CURSOR
 ;
 CARRET	CALL	CURDEL		;DELETE CURSOR
 	LD	A,L		;LOAD LOW BYTE
 	AND	0C0H		;GO TO BEG. OF LINE
 	LD	L,A		;
 	LD	(CURPOS),HL	;SAVE CURSOR POSITION
 	RET			;RETURN
 ;
 CURDEL	LD	A,(HL)		;GET CHAR AT CURSOR
 	CP	5FH		;CURSOR CHAR?
 	RET	NZ		;RETURN IF NOT
 	LD	(HL),20H	;IF SO BLANK IT
 	RET			;RETURN
 ;
 LINEFD	CALL	CURDEL		;DELETE CURSOR
 	LD	DE,40H		;
 	ADD	HL,DE		;MOVE DOWN ONE LINE
 	JP	CURSET		;SET CURSOR
 ;
 BACKSP	LD	A,H		;SEE IF CURSOR
 	SUB	0FCH		;AT HOME POSITION
 	OR	L		;
 	RET	Z		;IF SO ABORT BACKSP
 	LD	(HL),20H	;ERASE CURSOR
 	DEC	HL		;MOVE CUR. BACK ONE
 	JP	CURSET		;SET CURSOR
 ;
 BELL	LD	HL,200		;200MS LENGTH
 BELL1	LD	B,68		;1KHZ FREQ
 BELL2	DJNZ	BELL2		;TIME 1/2 CYCLE
 	LD	A,0		;
 	OUT	(255),A		;OUTPUT IT
 	LD	B,68		;
 BELL3	DJNZ	BELL3		;TIME 1/2 CYCLE
 	LD	A,1		;
 	OUT	(255),A		;OUTPUT IT
 	DEC	HL		;DEC CYCLE COUNT
 	LD	A,H		;
 	OR	L		;IS IT ZERO?
 	JR	NZ,BELL1	;LOOP IF NOT
 	RET			;
 ;
 ;	STRING DISPLAY ROUTINES
 SDSP	LD	A,(HL)		;GET CHAR TO DISPLAY
 	AND	A		;TERMINATOR?
 	RET	Z		;RETURN IF SO
 	CALL	DSP		;ELSE DISPLAY IT
 	INC	HL		;INC STRING POINTER
 	JR	SDSP		;LOOP TILL DONE
 ;
 SDISP	LD	A,(HL)		;GET CHAR TO DISPLAY
 	AND	A		;TERMINATOR?
 	RET	Z		;RETURN IF SO
 	PUSH	HL		;SAVE POINTER
 	CALL	DISP		;DISPLAY CHAR
 	POP	HL		;RESTORE POINTER
 	INC	HL		;INC STRING POINTER
 	JR	SDISP		;LOOP TILL DONE
 ;
 ;	KEYBOARD SCAN ROUTINE
 KEY	LD	A,(DRVREG)	;AUTO REPEAT FUNCTION
 	BIT	7,A		;CHECK FOR 25MS PULSE
 	JR	Z,KEY1		;
 	LD	A,(KEYACT)	;CHECK FOR ACTIVE KEY
 	AND	A		;
 	JR	Z,KEY1		;
 	LD	A,(RPTLAG)	;GET REPEAT LAG
 	AND	A		;
 	JR	Z,REPEAT	;REPEAT IF EXPIRED
 	DEC	A		;ELSE COUNTDOWN
 	LD	(RPTLAG),A	;AND SAVE
 	JR	NZ,KEY1		;
 REPEAT	LD	A,(RPTRAT)	;GET REPEAT RATE
 	DEC	A		;COUNTDOWN
 	LD	(RPTRAT),A	;SAVE IT
 	JR	NZ,KEY1		;
 	LD	A,3		;RESET RATE
 	LD	(RPTRAT),A	;SAVE IT
 	LD	A,(LSTKEY)	;GET LAST KEY PRESSED
 	RET			;AND RETURN
 KEY1	LD	HL,KEYBUF	;KEYBOARD BUFFER ADD
 	LD	BC,0F801H	;BC=ROW ADD POINT
 	LD	D,0		;D=ROW COUNTER
 NXTROW	LD	A,(BC)		;GET ROW
 	LD	E,A		;SAVE IN E
 	XOR	(HL)		;CHANGE IN ROW ?
 	JR	Z,NOCHNG	;SKIP IF NO CHANGE
 	PUSH	AF		;
 	XOR	A		;
 	LD	(KEYACT),A	;CANCEL ACTIVE FLAG
 	POP	AF		;
 	LD	(HL),E		;SAVE BYTE
 	AND	E		;IS KEY PRESSED?
 	JR	NZ,PRESS	;
 NOCHNG	INC	D		;INC ROW COUNTER
 	INC	HL		;INC BUFF POINTER
 	RLC	C		;POINT TO NEXT ROW
 	JP	P,NXTROW	;LOOP TILL DONE
 	RET			;RET IF NO KEY PRESSED
 ;
 PRESS	LD	E,A		;SAVE ROW BYTE
 	LD	A,1		;
 	LD	(KEYACT),A	;SET KEY ACTIVE FLAG
 	LD	A,30		;
 	LD	(RPTLAG),A	;SET DELAY BEFORE REPEAT
 	LD	A,D		;GET ROW COUNT
 	RLCA			;
 	RLCA			;
 	RLCA			;
 	LD	D,A		;D=ROW COUNT * 8
 	LD	C,1		;SET TESTING MASK
 NXTCOL	LD	A,C		;LOAD MASK
 	AND	E		;TEST FOR KEY
 	JR	NZ,FOUND	;JUMP IF FOUND
 	INC	D		;INC COLUMN COUNT
 	RLC	C		;SHIFT TEST BIT LEFT
 	JR	NXTCOL		;TEST NEXT COLUMN
 ;
 FOUND	LD	A,(0F880H)	;GET SHIFT BIT
 	LD	B,A		;SAVE IN B
 	LD	A,D		;A=(ROW*8)+COL
 	ADD	A,40H		;ADD 40H (FOR ASCII LETS)
 	CP	60H		;TEST FOR NON-LETTER
 	JR	NC,NONLET	;JUMP IF NON-LETTER
 	LD	D,A		;SAVE CHAR IN D
 	LD	A,(0F840H)	;GET ROW 6 BITS
 	AND	10H		;TEST FOR DOWN ARROW
 	JR	NZ,CONTRL	;IF SO CONVERT TO CONTROL
 	LD	A,(SHFLOC)	;GET SHIFT LOCK STATUS
 	CP	B		;DOES IT MATCH SHIFT KEY?
 	JR	Z,KDEL		;IF SO GO TO DELAY ROUT
 	LD	A,D		;RETRIEVE CHAR
 	ADD	A,20H		;CONVERT TO LOWER CASE
 	JR	KDELAY		;GO TO DELAY ROUT
 CONTRL	LD	A,D		;RETRIEVE CHAR
 	SUB	40H		;TURN INTO CONTROL CHAR
 	JR	KDELAY		;GO TO DELAY ROUTINE
 ;
 NONLET	SUB	70H		;TEST FOR LAST ROW
 	JR	NC,LASTRW	;JUMP IF LAST ROW
 	ADD	A,40H		;ADJUST FOR ROWS 4,5
 	LD	HL,0F840H	;CHECK FOR CTRL
 	BIT	4,(HL)		;
 	JR	NZ,EXCONT	;
 	CP	3CH		;IF CHAR < = > ?
 	JR	C,NON1		;
 	XOR	10H		;THEN TOGGLE SHIFT
 NON1	RRC	B		;GET SHIFT BIT
 	JR	NC,KDELAY	;JUMP IF NO SHIFT
 	XOR	10H		;ADJUST ASCII
 	JR	KDELAY		;GO TO DELAY ROUTINE
 ;
 EXCONT	LD	E,A		;GENERATE POINTER
 	LD	D,0		;
 	LD	HL,CONTAB-30H	;RELATIVE TABLE BASE
 	ADD	HL,DE		;
 	LD	A,(HL)		;GET CHAR FROM TABLE
 	JR	KDELAY		;
 ;
 LASTRW	RLCA			;A=(ROW*8+COL-48)*2
 	RRC	B		;GET SHIFT BIT
 	JR	NC,LAST1	;JUMP IF NO SHIFT
 	INC	A		;A=COL*2 + 1
 LAST1	LD	HL,KEYTAB	;POINT TO KEY TABLE
 	LD	C,A		;GET DISPLACEMENT
 	LD	B,0		;
 	ADD	HL,BC		;COMPUTE TABLE POSITION
 	LD	A,(HL)		;GET ASCII CODE
 ;
 KDELAY	LD	D,A		;SAVE CHARACTER
 KDEL	LD	BC,1500H	;LOAD DELAY COUNT
 KLOOP	DEC	BC		;DEC DELAY COUNTER
 	LD	A,B		;SEE IF ZERO
 	OR	C		;
 	JR	NZ,KLOOP	;LOOP IF NOT
 	LD	A,D		;RETRIEVE CHARACTER
 	LD	(LSTKEY),A	;SAVE IT
 	CP	0FFH		;SHIFT LOCK CHAR?
 	RET	NZ		;RETURN IF NOT
 	LD	A,(SHFLOC)	;GET SHIFT LOCK STATUS
 	CPL			;COMPLEMENT IT
 	AND	1		;MASK IT
 	LD	(SHFLOC),A	;SAVE IT
 	LD	A,0		;ZERO ACC
 	RET			;RETURN
 ;
 ;	DATA TERMINAL MODE DRIVER
 TERMIN	LD	HL,MESS4	;
 	CALL	SDISP		;DISPLAY MESSAGE 4
 TERMI	CALL	KEY		;SCAN KEYBOARD
 	AND	7FH		;
 	JR	Z,TERMO		;
 	CP	5		;CTRL-E PRESSED?
 	RET	Z		;EXIT IF SO
 	LD	C,A		;
 	CALL	RS232O		;ELSE SEND CHAR
 TERMO	IN	A,(RSSTAT)	;GET RS232 STATUS
 	BIT	7,A		;CHAR RECEIVED?
 	JR	Z,TERMI		;LOOP IF NOT
 	IN	A,(RSDATA)	;GET CHAR
 	AND	7FH		;RESET HIGH BIT
 	CALL	DISP		;DISPLAY CHARACTER
 	JR	TERMI		;AND LOOP
 ;
 KEYTAB	DEFW	0D0DH		;ENTER
 	DEFW	0FF7FH		;CLEAR
 	DEFW	0303H		;BREAK
 	DEFW	1B5EH		;UP ARROW
 	DEFW	0000H		;DOWN ARROW
 	DEFW	1808H		;LEFT ARROW
 	DEFW	1909H		;RIGHT ARROW
 	DEFW	2020H		;SPACE BAR
 ;
 CONTAB	DEFB	1BH		;CTRL 0
 	DEFB	1CH		;CTRL 1
 	DEFB	1DH		;CTRL 2
 	DEFB	1EH		;CTRL 3
 	DEFB	1FH		;CTRL 4
 	DEFB	7CH		;CTRL 5
 	DEFB	7EH		;CTRL 6
 	DEFB	7FH		;CTRL 7
 	DEFB	5BH		;CTRL 8
 	DEFB	5DH		;CTRL 9
 	DEFB	0		;CTRL :
 	DEFB	0		;CTRL ;
 	DEFB	7BH		;CTRL <
 	DEFB	5FH		;CTRL =
 	DEFB	7DH		;CTRL >
 	DEFB	5CH		;CTRL ?
 ;
 CHRTAB	DEFB	183		;LEFT SQ BRACKET
 	DEFB	89H		;BACKSLASH
 	DEFB	187		;RIGHT SQ BRACKET
 	DEFB	5BH		;CARET
 ;
 ;	SECTOR TRANSLATION TABLE
 SECTN1	DEFW	0100H
 	DEFW	0504H
 	DEFW	0908H
 	DEFW	0D0CH
 	DEFW	1110H
 	DEFW	0302H
 	DEFW	0706H
 	DEFW	0B0AH
 	DEFW	0F0EH
 	DEFW	1312H
 ;
 SECTN2	DEFW	0100H
 	DEFW	0504H
 	DEFW	0908H
 	DEFW	0D0CH
 	DEFW	1110H
 	DEFW	1514H
 	DEFW	1918H
 	DEFW	1D1CH
 	DEFW	2120H
 	DEFW	0302H
 	DEFW	0706H
 	DEFW	0B0AH
 	DEFW	0F0EH
 	DEFW	1312H
 	DEFW	1716H
 	DEFW	1B1AH
 	DEFW	1F1EH
 	DEFW	2322H
 ;
 ;	SINGLE DENSITY (OSBORNE) DISK PARAMETER BLOCK
 DPB1	DEFW	0014H		;SECTORS/TRACK
 	DEFB	04H		;BLOCK SHIFT
 	DEFB	0FH		;BLOCK MASK
 	DEFB	01H		;EXTENT MASK
 	DEFW	002CH		;DISK SIZE (2K LUMPS)
 				;26H=35T, 2CH=40T
 	DEFW	003FH		;MAX DIR ENTRIES
 	DEFB	80H		;ALLOCATION 0
 	DEFB	00H		;ALLOCATION 1
 	DEFW	0010H		;CHECKSIZE
 	DEFW	0003H		;TRACK OFFSET
 ;
 ;	DOUBLE DENSITY DISK PARAMETER BLOCK
 DPB2	DEFW	0024H		;SECTORS/TRACK
 	DEFB	04H		;BLOCK SHIFT
 	DEFB	0FH		;BLOCK MASK
 	DEFB	01H		;EXTENT MASK
 	DEFW	0051H		;DISK SIZE (2K LUMPS)
 				;46H=35T, 51H=40T
 	DEFW	003FH		;MAX DIR ENTRIES
 	DEFB	80H		;ALLOCATION 0
 	DEFB	00H		;ALLOCATION 1
 	DEFW	0010H		;CHECKSIZE
 	DEFW	0003H		;TRACK OFFSET
 ;
 CKEND	NOP			;CHECKSUM FINISHES HERE
 ;
 ;	DISK CONTROL BLOCKS
 DCB1	DEFW	SECTN1		;SEC TABLE POINTER
 	DEFW	0		;ZEROS
 	DEFW	0		;
 	DEFW	0		;
 	DEFW	DIRBUF		;DIRECTORY BUFF ADD
 	DEFW	DPB1		;DISK PARAM BLOCK ADD
 	DEFW	DCS1		;DIR CHECK SCATCH 1
 	DEFW	AVA1		;ALLOC VECT AREA 1
 ;
 DCB2	DEFW	SECTN1		;SEC TABLE POINTER
 	DEFW	0		;ZEROS
 	DEFW	0		;
 	DEFW	0		;
 	DEFW	DIRBUF		;DIRECTORY BUFF ADD
 	DEFW	DPB1		;DISK PARAM BLOCK ADD
 	DEFW	DCS2		;DIR CHECK SCRATCH 2
 	DEFW	AVA2		;ALLOC VECT AREA 2
 ;
 DCB3	DEFW	SECTN1		;
 	DEFW	0		;
 	DEFW	0		;
 	DEFW	0		;
 	DEFW	DIRBUF		;
 	DEFW	DPB1		;
 	DEFW	DCS3		;
 	DEFW	AVA3		;
 ;
 ;	VARIABLE STORAGE AREA
 DMAADR	DEFW	80H		;DMA ADDRESS
 DRVCOD	DEFB	0		;DRIVE SELECT CODE
 LSTCOD	DEFB	0		;LAST DRIVE SELECT CODE
 CURPOS	DEFW	0FC00H		;CURSOR POSITION
 CHAR	DEFB	0		;CHARACTER BUFFER
 SHFLOC	DEFB	1		;SHIFT LOCK STATUS
 WRTYPE	DEFB	0		;WRITE OPERATION TYPE
 ERMASK	DEFB	0		;ERROR MASK
 CPMSPT	DEFB	20		;CP/M SECTORS PER TRACK
 DSKCOM	DEFB	0		;DISK COMMAND
 TRYCNT	DEFB	0		;RETRY COUNT
 ERCODE	DEFB	0		;DISK ERROR CODE
 DENPT	DEFW	0		;DENSITY POINTER
 CURDCB	DEFW	0		;CURRENT DCB ADDRESS
 CKSUM	DEFB	0		;CHECKSUM
 LOGSEC	DEFB	0		;LOGICAL SECTOR NUMBER
 LSTSEC	DEFB	0		;LAST SECTOR
 KEYACT	DEFB	0		;KEY ACTIVE FLAG
 LSTKEY	DEFB	0		;LAST KEY PRESSED
 RPTLAG	DEFB	0		;KEY REPEAT LAG
 RPTRAT	DEFB	3		;KEY REPEAT RATE
 ;
 ;	DISK DRIVE DENSITY TABLE
 DENTAB	DEFB	0		;DRIVE A
 	DEFB	0		;DRIVE B
 	DEFB	0		;DRIVE C
 ;
 ;	BUFFERS AND SCRATCH AREAS
 HSTBUF	DEFS	256		;SECTOR BUFFER
 DIRBUF	DEFS	128		;DIRECTORY BUFFER
 KEYBUF	DEFS	8		;KEYBOARD BUFFER
 DCS1	DEFS	16		;DIR CHECK SCRATCH
 DCS2	DEFS	16		;
 DCS3	DEFS	16		;
 AVA1	DEFS	31		;ALLOC VECTORS AREA
 AVA2	DEFS	31		;
 AVA3	DEFS	31		;
 ;
 ;
 ;	CONSOLE MESSAGE STORAGE AREA
 MESS1	DEFB	0CH
 	DEFM	'CP/M VERS 2.2A 48K'
 	DEFW	0A0DH
 	DEFM	'COPYRIGHT (C), 1981'
 	DEFW	0A0DH
 	DEFM	'DIGITAL RESEARCH'
 	DEFW	0A0AH
 	DEFW	0A0DH
 	DEFB	0
 ;
 MESS2	DEFW	1F1CH
 	DEFM	'TRS-80 CP/M BIOS 48K VER 3.3'
 	DEFB	0DH
 	DEFM	'COPYRIGHT (C) BRUCE ORR 1983'
 	DEFW	0D0DH
 	DEFW	0D0DH
 	DEFM	'INSERT CP/M SYSTEM DISK IN DRIVE 0'
 	DEFB	0DH
 	DEFM	'THEN SWITCH MAPPING TO CP/M MODE.'
 	DEFB	0
 ;
 MESS3	DEFW	0A0DH
 	DEFM	'DISK OFFLINE'
 	DEFB	0
 ;
 MESS4	DEFW	0A0DH
 	DEFM	'DATA TERMINAL MODE - PRESS CTRL-E TO EXIT'
 	DEFW	0A0DH
 	DEFB	0
 ;
 MESS5	DEFW	0A0DH
 	DEFM	'BIOS CORRUPTED - RESTART SYSTEM'
 	DEFW	0A0DH
 	DEFB	0
 ;
 	END	START	;END OF BIOS
                                                                           