OOOO   ; TRS-80 BULLETIN BOARD DEMONSTRATION PROGRAM - OOOO/P
 ;
 W6TNS	EQU	32000		;= 7D00H FOR 16 FINGERS
 	ORG	W6TNS		;START THE PROGRAM HERE
 	OUT	(232),A		;MASTER RESET LATCH
 	CALL	01C9H		;CLS ROM SUBROUTINE
 	LD	SP,32760	;MOVE STACK HERE IN MEM
 	LD	A,55H		;55H = 300 BAUD RATE
 	OUT	(233),A		;SET BAUD VIA PORT 233
 	LD	HL,MESS1        ;STRING MEM ADDRESS
 	CALL	28A7H		;DISPLAY STRING ROUTINE
 MESS1	DEFM	'A = SEVEN BITS & B = EIGHT BITS ? '
 	DEFB	00		;END OF MESSAGE DELIMITER
 	CALL	049H		;AWAIT KEYBOARD INPUT 'A'
 	CALL	032AH		;DISPLAY INPUT ON VIDEO
 	CP	66		;B=66 SUBTRACT FROM 'A'
 	JP	Z,LOAD		;GOTO 8 BIT LOAD IF ZERO
 	LD	A,13		;13 = CONTROL SKIP A LINE
 	CALL	033H		;DO IT ON VIDEO
 	LD	A,165		;7 BITS, 1 STOP, PAR 'ON'
 	OUT	(234),A		;INITIALIZE VIA PORT 234
 LOOK	LD	A,(14400)	;= KEYBOARD CLEAR KEY ROW
 	CP	2		;2 = CLEAR KEY PRESSED
 	JP	Z,W6TNS		;CHANGE BITS TO 7 OR 8
 	LD	A,14		;CONTROL 14 = CURSOR 'ON'
 	CALL	033H		;DISPLAY CURSOR ON VIDEO
  	CALL	RECV		;GOSUB RECEIVE SUBROUTINE
 	CALL	XMIT1		;GOSUB TRANSMIT SUBRUTINE
 	JP	LOOK		;TAKE ANOTHER LOOK AGAIN
 RECV 	IN	A,(234)		;RECEIVED BYTE CONVERTED?
 	BIT	7,A		;TEST BIT 7 SET 'Z'
 	RET	Z		;GOTO XMIT 'IF' NOT READY
 	IN	A,(235)		;INCOMING CONVERTED BYTE
 	JP	Z,RECV 		;IF ZERO, LOOK AGAIN
 	CALL	033H 		;IF NOT ZERO, DISPLAY IT
 	JP	RECV 		;LOOK AGAIN AT INCOMING
 XMIT1  	CALL	02BH		;ANY KEYBOARD OUTPUT ?
 	OR	A		;SET 'Z' FLAG IF 'NOT'
 	RET	Z		;GOTO LOOK AGAIN IF ZERO
 	PUSH	AF		;SAVE AF TO TEST UART RDY
 XMIT2	IN	A,(234)		;HOLDING REGISTER EMPTY?
 	BIT	6,A		;TEST BIT 6 SET 'Z' FLAG
 	JP	Z,XMIT2		;NOT EMPTY? TEST AGAIN
 	POP	AF		;EMPTY! RESTORE 'A' REG
 	OUT	(235),A		;BYTE TO HOLDING REGISTER
 	RET			;RETURN TO 'LOOK' AGAIN
 LOAD	LD	A,13		;13 = CONTROL SKIP A LINE
 	CALL	033H 		;DO IT ON VIDEO
 	LD	A,229		;8 BITS, 1 STOP, PAR 'ON'
 	OUT 	(234),A		;INITIALIZE VIA PORT 234
 	JP	LOOK		;GOTO LOOK AGAIN
 	END	W6TNS		;EL FIN = EL BEGUINE
