BINCLO 	ORG	7000H
 START	EI			;Enable Interrupts
 	CALL	01C9H		;Clear Screen
 QUERY	LD	HL,MSG		;Point to question
 	CALL	4467H		;Display it on video
 	CALL	0049H		;Wait for user response
 	AND	0DFH		;Change lower to uprcase
 	CP	'Y'		;"Y" or "y" response?
 	JR	Z,YES		;Go if so
 	CP	'N'		;"N" or "n" response?
 	JR	Z,NO		;Go is so
 	CP	1		;<BREAK> key pressed?
 	JR	NZ,QUERY	;Get another key if not
 EXIT	JP	402DH		;Exit to DOS READY
 NO	SCF			;Set carry flag = NO
 YES	PUSH	AF		;Save carry flag status
 	CALL	01C9H		;Clear Screen
 	CALL	BORDER		;Put top & bottom borders
 RESTRT	CALL	002BH		;Check for key depressed
 	DEC	A		;If it was <BREAK>, A=0
 	JR	Z,EXIT		;Exit if <BREAK>
 	LD	HL,4041H	;"Seconds" byte in Mod I
 	LD	A,(54H)		;Get Mod I/III test byte
 	DEC	A		;A=0 if Model I
 	JR	Z,MOD1		;Go if Model I
 	LD	HL,4217H	;"Seconds" byte in Mod 3
 MOD1	LD	C,(HL)		;Get initial seconds val
 LOOPA	LD	A,(HL)		;Get new seconds value
 	CP	C		;Has value changed?
 	JR	Z,LOOPA		;Wait for change if not
 	POP	AF		;Get Carry flag status
 	PUSH	AF		;Also re-save it
 	JR	C,NODSP		;Go if no date/time disp
 	PUSH	HL		;Save "seconds" pointer
 	LD	HL,3FD7H	;Point to video location
 	CALL	4470H		;Display date
 	INC	HL		;Skip a space
 	CALL	446DH		;Display time
 	POP	HL		;Restore "seconds" pntr
 NODSP	EX	DE,HL		;"Seconds" byte ptr in DE
 	LD	HL,3CBDH	;Top of last time bar
 	LD	B,3		;# of time storage bytes
 LOOPB	PUSH	BC		;Save storage byte count
 	LD	B,2		;# nybbles per time byte
 	LD	A,(DE)		;Get current time byte
 LOOPC	PUSH	BC		;Save nybble count
 	LD	B,4		;# time bars per nybble
 LOOPD	LD	C,0BFH		;C = Graphics block char
 	RRA			;Get bit from time byte
 	JR	C,SET		;Go if bit was set (ON)
 	LD	C,20H		;C = Space char (bar OFF)
 SET	PUSH	HL		;Save video loc pointer
 	PUSH	DE		;Save time byte pointer
 	PUSH	BC		;Save time bar counter
 	LD	B,0CH		;# vertical graphic blcks
 	LD	DE,40H		;Length one video line
 LOOPE	LD	(HL),C		;Put character on video
 	ADD	HL,DE		;Move down one line
 	DJNZ	LOOPE		;Do til vertical bar done
 	PUSH	AF		;Save time byte
 	LD	BC,0400H	;Time delay counter
 	CALL	0060H		;Call ROM delay routine
 	POP	AF		;Restore time byte
 	POP	BC		;Restore time bar counter
 	POP	DE		;Restore time byte pntr
 	POP	HL		;Restore video loc pntr
 	DEC	HL		;Backup two spaces to top
 	DEC	HL		;  of next vertical bar
 	DJNZ	LOOPD		;If more bits this nybble
 	DEC	HL		;Backup two extra spaces
 	DEC	HL		;  between nybbles
 	POP	BC		;Restore nybble count
 	DJNZ	LOOPC		;If only 1st nybble done
 	DEC	HL		;Backup two extra spaces
 	DEC	HL		;  for hours-mins-secnds
 	INC	DE		;Bump time byte pointer
 	POP	BC		;Restore time byte count
 	DJNZ	LOOPB		;Do remaining byte if any
 	JR	RESTRT		;Else wait for nxt second
 BORDER	LD	HL,3C01H	;Point to top border loc
 	CALL	TBORD		;Put top border on video
 	LD	HL,3FC1H	;Pnt to lower border loc
 TBORD	LD	A,3		;# of bytes to display
 BLOOPA	LD	C,2		;# of nybbles per byte
 BLOOPB	LD	B,4		;# of bits (bars)/nybble
 BLOOPC	LD	(HL),0BFH	;Put graphic blk on video
 	INC	HL		;Bump video location pntr
 	INC	HL		;Skip space between blcks
 	DJNZ	BLOOPC		;Do all 4 bits of nybble
 	INC	HL		;Skip two extra spaces
 	INC	HL		;  between nybbles
 	DEC	C		;Decrement nybble count
 	JR	NZ,BLOOPB	;Go if only 1 nybble done
 	INC	HL		;Skip two more extra spcs
 	INC	HL		;  between hrs-mins-secs
 	DEC	A		;Decrement byte count
 	JR	NZ,BLOOPA	;Go if more to display
 	RET			;(Routine calls itself!)
 MSG	DEFW	0A0AH		;Two line feeds
 	DEFM	'Display time and date at bottom of video display (Y/N)?'
 	DEFB	0DH		;<CR> message terminator
 	END	START
