BABYRO ; #######################################################
 ; RAM CHECKING PROGRAM - FIRST VERSION WITHOUT DISPLAY -
 ; EXHAUSTIVELY CHECKS EACH TRIO OF RAM LOCATIONS WITHOUT
 ; DISPLAYING CURRENT ADDRESS; BAD ADDRESSES ONLY SHOWN.
 ; #######################################################
 ; NOTE THAT THIS PROGRAM IS * SELF-RELOCATING * AND MUST
 ; BE ASSEMBLED AT THE ORIGIN ADDRESS SPECIFIED BELOW.
 ; #######################################################
 ;
 	ORG	5000H		; DO NOT CHANGE ORIGIN!
 ;
 ; #######################################################
 ; SUBROUTINE TO CLEAR THE SCREEN WITH NORMAL SPACES
 ; #######################################################
 ;
 	LD	HL,3C00H	; BEGINNING OF VIDEO
 	LD	DE,3C01H	; DESTINATION OF SPACE
 	LD	BC,03FFH	; SPACES ON SCREEN
 	LD	(HL),20H	; DISPLAY BLANK SPACE
 	LDIR			; CLEAR THE SCREEN
 ;
 ; #######################################################
 ; SET UP MIDDLE OF PROGRAM POINTER, DISPLAY STAR TO SHOW
 ; PROGRAM IS WORKING, SET UP THE STACK POINTER IN RELA-
 ; TIONSHIP TO THE IX REGISTER, AND SPECIFY START OF TEST
 ; #######################################################
 ;
 	LD	IX,5080H	; MIDDLE OF TEST PROGRAM
 	LD	A,(3FFEH)	; BOTTOM RIGHT OF SCREEN
 	XOR	0AH		; ALTERNATE SPACE & STAR
 	LD	(3FFEH),A	; DISPLAY IT ON SCREEN
 	LD	SP,IX		; START STACK POINTER
 	LD	B,7FH		; NUMBER OF MOVES FOR SP
 	INC	SP		; SP = SP + 1 
 	DJNZ	$-1		; DO IT 127 TIMES
 	LD	HL,6000H	; BEGINNING OF TEST AREA
 ;
 ; #######################################################
 ; TEST BEGINS WITH THE VALUE OF ZERO, AND PROCEEDS TO
 ; VALUE FF.  EACH VALUE IS WRITTEN IN TURN TO EACH OF A
 ; TRIO OF MEMORY LOCATIONS IN ORDER TO DETERMINE THEIR
 ; EFFECT ON EACH OTHER AS VALID ELECTRONIC STORAGE CELLS.
 ; #######################################################
 ;
 	XOR	A		; CLEAR ACCUMULATOR
 	LD	(HL),A		; PLACE VALUE IN MEMORY
 	LD	C,A		; PLACE VALUE IN C
 	PUSH	AF		; SAVE VALUE IN ACCUM.
 	LD	A,C		; GET VALUE FROM C
 	LD	(HL),A		; PLACE VALUE IN MEMORY
 	INC	HL		; INCREMENT TO NEXT MEM
 	LD	A,H		; GET MSB OF ADDRESS
 	CP	80H		; IS MEM AT 8000 YET?
 				; NOTE THAT THE VALUE
 				; ABOVE IS FOR 16K; USE
 				; C0 FOR 32K, 00 FOR 48K
 	JR	Z,$+32H		; IF SO, THEN RELOCATE
 	PUSH	HL		; SAVE MEMORY VALUE
 	PUSH	IX		; SAVE MIDDLE OF PROGRAM
 	POP	HL		; GET POSITION INTO HL
 	CP	H		; CHECK AGAINST 80 VALUE
 	JR	Z,$+2BH		; RELOCATE IF DONE
 	POP	HL		; RESTORE ORIGINAL VALUE
 	POP	AF		; RESTORE ORIGINAL TEST
 	LD	(HL),A		; PUT VALUE INTO MEMORY
 	DEC	HL		; BACK TO ORIGINAL LOC'N
 	DEC	HL		; BACK TO ONE BEFORE IT
 	LD	(HL),A		; PUT VALUE INTO MEMORY
 	LD	B,A		; SAVE VALUE IN B REG.
 	LD	A,(HL)		; GET VALUE AT LOC'N HL
 	CP	B		; CHECK AGAINST B VALUE
 	JR	Z,$+7		; GO ON IF IT CHECKS OKAY
 	LD	D,1BH		; GET VALUE OF REL. SUB.
 	PUSH	DE		; SAVE VALUE ON STACK
 	JR	$+1DH		; JUMP TO SUBROUTINE
 	INC	HL		; GET ORIGINAL TEST POS'N
 	INC	HL		; GO ONE BEYOND IT
 	LD	A,(HL)		; GET VALUE AT THAT POS'N
 	CP	B		; CHECK AGAINST B REG.
 	JR	Z,$+7		; GO ON IF MEMORY OKAY
 	LD	D,10H		; GET JUMP FOR REL. SUB.
 	PUSH	DE		; SAVE VALUE ON STACK
 	JR	$+12H		; JUMP TO SUBROUTINE
 	DEC	HL		; BACK TO ORIGINAL POS'N
 	INC	(HL)		; INCREMENT VALUE IN MEM
 	INC	C		; INCREMENT TEST VALUE
 	LD	A,(HL)		; GET VALUE IN MEMORY
 	LD	B,A		; SAVE VALUE IN B REG.
 	CP	00		; CHECK IF 256 BYTES DONE
 	JR	NZ,$-32H	; LOOP BACK AND CONTINUE
 	INC	HL		; GET NEXT MEMORY VALUE
 	LD	C,0		; RESET TEST VALUE TO 0
 	JR	$-37H		; LOOP BACK FOR NEXT TEST
 	JR	$+66H		; REL.SUB. STEPPING STONE
 ;
 ; #######################################################
 ; SUBROUTINE BELOW IS ENTERED WHEN A BAD MEMORY LOCATION
 ; HAS BEEN DETERMINED.  IT CONVERTS HEX VALUES TO ASCII
 ; AND DISPLAYS THEM ON THE SCREEN.  NOTE THE RELATIVE
 ; SUBROUTINE ENTRY AND EXIT METHOD USING THE D REGISTER.
 ; #######################################################
 ;
 	LD	A,H		; GET VALUE FROM H REG.
 	AND	0F0H		; MASK OFF LOW BITS
 	RRCA			; ROTATE RIGHT FOR CONV.
 	RRCA			; .... SOME MORE ....
 	RRCA			; .... AND SOME MORE ....
 	RRCA			; .... UNTIL IT'S DONE.
 	LD	D,22H		; GET VALUE FOR REL. SUB.
 	JR	$+24H		; AND JUMP TO SUBROUTINE
 	LD	A,H		; GET VALUE FROM H REG.
 	AND	0FH		; MASK OUT HIGH BITS
 	LD	D,1BH		; GET VALUE FOR REL. SUB.
 	JR	$+1DH		; AND JUMP TO SUBROUTINE
 	LD	A,L		; GET VALUE FROM L. REG.
 	AND	0F0H		; MASK OUT LOW BITS
 	RRCA			; ROTATE FOR CONVERSION
 	RRCA			; .... SOME MORE ....
 	RRCA			; .... SOME MORE ....
 	RRCA			; .... AND IT'S DONE.
 	LD	D,10H		; GET VALUE FOR REL. SUB.
 	JR	$+12H		; AND JUMP TO SUBROUTINE
 	LD	A,L		; GET VALUE FROM L REG.
 	AND	0FH		; MASK OUT HIGH BITS
 	LD	D,9		; GET VALUE FOR REL. SUB.
 	JR	$+0BH		; AND JUMP TO SUBROUTINE
 	POP	DE		; RESTORE VALUE TO DE
 	LD	A,0D3H		; GET RETURN POS'N VALUE
 	SUB	D		; SUBTRACT RETURN DIFF.
 	LD	(IX+0DH),A	; AND MAKE JR OPERAND
 	JR	$+1		; IRRELEVANT OPERAND
 	PUSH	DE		; SAVE VALUE ON STACK
 	PUSH	AF		; SAVE VALUE ON STACK
 	LD	DE,3C00H	; GET TOP LEFT OF SCREEN
 	LD	A,(DE)		; GET VALUE ON SCREEN
 	CP	20H		; IS IT A SPACE NOW?
 	JR	Z,$+5		; IF SO, GO AHEAD SOME
 	INC	DE		; INCREMENT SCREEN POS'N
 	JR	$-6		; AND GO AHEAD PAST TEST
 	LD	A,E		; GET VALUE OF SCREEN
 	CP	04		; IS IT 4 POS'NS OVER?
 	JR	NZ,$+0CH	; IF NOT, GO ON AHEAD
 	LD	A,20H		; IF SO GET A SPACE READY
 	DEC	DE		; GO BACK SOME....
 	LD	(DE),A		; AND FILL WITH A SPACE
 	DEC	DE		; AND BACK SOME MORE....
 	LD	(DE),A		; AND INSERT ANOTHER ONE
 	DEC	DE		; AND BACK A BIT MORE....
 	LD	(DE),A		; AND STASH ANOTHER SPACE
 	DEC	DE		; AND BACK ONE MORE TIME
 	LD	(DE),A		; AND STUFF A SPACE THERE
 	POP	AF		; RESTORE VALUE TO AF
 	CP	0AH		; IS VALUE LESS THAN 10?
 	JR	NC,$+6		; IF LESSER, THEN JUMP
 	ADD	A,30H		; CONVERT HEX TO ASCII
 	JR	$+4		; AND GO ON PAST THE REST
 	ADD	A,37H		; CONVERT HEX TO ASCII
 	LD	(DE),A		; AND STASH ON THE SCREEN
 ;
 ; #######################################################
 ; SHORT ROUTINE BELOW USED AS DELAY AFTER LOC'N DISPLAY.
 ; #######################################################
 ;
 	PUSH	BC		; SAVE VALUE IN BC REG
 	LD	B,0FFH		; GET DELAY VALUE
 	DJNZ	$-0		; AND DELAY JUST A LITTLE
 	POP	BC		; RESTORE BC VALUE
 	POP	DE		; RESTORE DE VALUE
 	LD	A,0C9H		; GET VALUE TO RETURN
 	SUB	D		; SUBTRACT JUMP OFFSET
 	LD	(IX+44H),A	; PLACE AS JR OPERAND
 	JR	$+1		; IRRELEVANT OPERAND
 ;
 ; #######################################################
 ; PROGRAM RELOCATION ROUTINE.  HL AND DE REGISTERS ARE
 ; LOADED FROM THE IX REGISTER, AND MODIFIED BY EXCLUSIVE-
 ; ORING WITH A KNOWN VALUE IN A.  THUS, A NEW PROGRAM
 ; BEGINNING CAN BE DETERMINED, INTERNAL TEST POSITIONS 
 ; CAN BE MODIFIED, AND THE IX AND SP POINTERS RESET.
 ; #######################################################
 ;
 	PUSH	IX		; SAVE PROGRAM POSITION
 	PUSH	IX		; SAVE PROGRAM POSITION
 	POP	HL		; TRANSFER TO HL REG.
 	POP	DE		; TRANSFER TO DE REG.
 	LD	A,D		; GET VALUE FROM D REG.
 	XOR	20H		; TRANSFER TO HIGH MEM.
 	LD	D,A		; PUT BACK IN D REG.
 	PUSH	DE		; AND STASH ON STACK
 	LD	B,80H		; DEC. TO PROGRAM START
 	DEC	HL		; AND BEGIN DECREMENTING
 	DEC	DE		; FOR BOTH THE REGISTERS
 	DJNZ	$-2		; UNTIL IT'S ALL DONE
 	LD	BC,00FFH	; AND GET READY TRANSFER
 	LDIR			; AND THEN DO IT!
 	POP	IX		; RESTORE NEW VALUE
 	LD	A,20H		; VALUE TO MOD. ADDRESSES
 	XOR	(IX+0A2H)	; MODIFY IX+A2 ADDRESS
 	LD	(IX+0A2H),A	; AND STORE IT IN PLACE
 	LD	A,0F0H		; VALUE TO MOD. ADDRESSES
 				; CHANGE OPERAND ABOVE TO
 				; B0 FOR 32K MEM TEST AND
 				; TO 70 FOR 48K MEM TEST
 	XOR	(IX+0ACH)	; MODIFY IX+AC ADDRESS
 	LD	(IX+0ACH),A	; AND STORE IT IN PLACE
 	PUSH	IX		; STORE THE PROGRAM PTR.
 	POP	HL		; AND TRANSFER IT TO HL
 	LD	L,11H		; SET LSB OF HL REGISTER
 	JP	(HL)		; JUMP TO PROGRAM START!
 ;
 ; #######################################################
 	END	5000H
